/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkChart;
import org.lwjgl.nuklear.NkCommandBuffer;
import org.lwjgl.nuklear.NkMenuState;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkRowLayout;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkPanel
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int BOUNDS;
    public static final int OFFSET_X;
    public static final int OFFSET_Y;
    public static final int AT_X;
    public static final int AT_Y;
    public static final int MAX_X;
    public static final int FOOTER_HEIGHT;
    public static final int HEADER_HEIGHT;
    public static final int BORDER;
    public static final int HAS_SCROLLING;
    public static final int CLIP;
    public static final int MENU;
    public static final int ROW;
    public static final int CHART;
    public static final int BUFFER;
    public static final int PARENT;

    NkPanel(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkPanel(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkPanel.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return NkPanel.ntype(this.address());
    }

    public int flags() {
        return NkPanel.nflags(this.address());
    }

    public NkRect bounds() {
        return NkPanel.nbounds(this.address());
    }

    public IntBuffer offset_x(int capacity) {
        return NkPanel.noffset_x(this.address(), capacity);
    }

    public IntBuffer offset_y(int capacity) {
        return NkPanel.noffset_y(this.address(), capacity);
    }

    public float at_x() {
        return NkPanel.nat_x(this.address());
    }

    public float at_y() {
        return NkPanel.nat_y(this.address());
    }

    public float max_x() {
        return NkPanel.nmax_x(this.address());
    }

    public float footer_height() {
        return NkPanel.nfooter_height(this.address());
    }

    public float header_height() {
        return NkPanel.nheader_height(this.address());
    }

    public float border() {
        return NkPanel.nborder(this.address());
    }

    public int has_scrolling() {
        return NkPanel.nhas_scrolling(this.address());
    }

    public NkRect clip() {
        return NkPanel.nclip(this.address());
    }

    public NkMenuState menu() {
        return NkPanel.nmenu(this.address());
    }

    public NkRowLayout row() {
        return NkPanel.nrow(this.address());
    }

    public NkChart chart() {
        return NkPanel.nchart(this.address());
    }

    public NkCommandBuffer buffer() {
        return NkPanel.nbuffer(this.address());
    }

    public NkPanel parent() {
        return NkPanel.nparent(this.address());
    }

    public static NkPanel malloc() {
        return NkPanel.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkPanel calloc() {
        return NkPanel.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkPanel create() {
        return new NkPanel(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkPanel create(long address) {
        return address == 0L ? null : new NkPanel(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkPanel.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkPanel.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkPanel mallocStack() {
        return NkPanel.mallocStack(MemoryStack.stackGet());
    }

    public static NkPanel callocStack() {
        return NkPanel.callocStack(MemoryStack.stackGet());
    }

    public static NkPanel mallocStack(MemoryStack stack) {
        return NkPanel.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkPanel callocStack(MemoryStack stack) {
        return NkPanel.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkPanel.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkPanel.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkPanel.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkPanel.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static NkRect nbounds(long struct) {
        return NkRect.create(struct + (long)BOUNDS);
    }

    public static IntBuffer noffset_x(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)OFFSET_X), capacity);
    }

    public static IntBuffer noffset_y(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)OFFSET_Y), capacity);
    }

    public static float nat_x(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)AT_X);
    }

    public static float nat_y(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)AT_Y);
    }

    public static float nmax_x(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAX_X);
    }

    public static float nfooter_height(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FOOTER_HEIGHT);
    }

    public static float nheader_height(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEADER_HEIGHT);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static int nhas_scrolling(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HAS_SCROLLING);
    }

    public static NkRect nclip(long struct) {
        return NkRect.create(struct + (long)CLIP);
    }

    public static NkMenuState nmenu(long struct) {
        return NkMenuState.create(struct + (long)MENU);
    }

    public static NkRowLayout nrow(long struct) {
        return NkRowLayout.create(struct + (long)ROW);
    }

    public static NkChart nchart(long struct) {
        return NkChart.create(struct + (long)CHART);
    }

    public static NkCommandBuffer nbuffer(long struct) {
        return NkCommandBuffer.create(MemoryUtil.memGetAddress(struct + (long)BUFFER));
    }

    public static NkPanel nparent(long struct) {
        return NkPanel.create(MemoryUtil.memGetAddress(struct + (long)PARENT));
    }

    static {
        Struct.Layout layout = NkPanel.__struct(NkPanel.__member(4), NkPanel.__member(4), NkPanel.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkPanel.__member(POINTER_SIZE), NkPanel.__member(POINTER_SIZE), NkPanel.__member(4), NkPanel.__member(4), NkPanel.__member(4), NkPanel.__member(4), NkPanel.__member(4), NkPanel.__member(4), NkPanel.__member(4), NkPanel.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkPanel.__member(NkMenuState.SIZEOF, NkMenuState.ALIGNOF), NkPanel.__member(NkRowLayout.SIZEOF, NkRowLayout.ALIGNOF), NkPanel.__member(NkChart.SIZEOF, NkChart.ALIGNOF), NkPanel.__member(POINTER_SIZE), NkPanel.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        BOUNDS = layout.offsetof(2);
        OFFSET_X = layout.offsetof(3);
        OFFSET_Y = layout.offsetof(4);
        AT_X = layout.offsetof(5);
        AT_Y = layout.offsetof(6);
        MAX_X = layout.offsetof(7);
        FOOTER_HEIGHT = layout.offsetof(8);
        HEADER_HEIGHT = layout.offsetof(9);
        BORDER = layout.offsetof(10);
        HAS_SCROLLING = layout.offsetof(11);
        CLIP = layout.offsetof(12);
        MENU = layout.offsetof(13);
        ROW = layout.offsetof(14);
        CHART = layout.offsetof(15);
        BUFFER = layout.offsetof(16);
        PARENT = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<NkPanel, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkPanel newInstance(long address) {
            return new NkPanel(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int type() {
            return NkPanel.ntype(this.address());
        }

        public int flags() {
            return NkPanel.nflags(this.address());
        }

        public NkRect bounds() {
            return NkPanel.nbounds(this.address());
        }

        public IntBuffer offset_x(int capacity) {
            return NkPanel.noffset_x(this.address(), capacity);
        }

        public IntBuffer offset_y(int capacity) {
            return NkPanel.noffset_y(this.address(), capacity);
        }

        public float at_x() {
            return NkPanel.nat_x(this.address());
        }

        public float at_y() {
            return NkPanel.nat_y(this.address());
        }

        public float max_x() {
            return NkPanel.nmax_x(this.address());
        }

        public float footer_height() {
            return NkPanel.nfooter_height(this.address());
        }

        public float header_height() {
            return NkPanel.nheader_height(this.address());
        }

        public float border() {
            return NkPanel.nborder(this.address());
        }

        public int has_scrolling() {
            return NkPanel.nhas_scrolling(this.address());
        }

        public NkRect clip() {
            return NkPanel.nclip(this.address());
        }

        public NkMenuState menu() {
            return NkPanel.nmenu(this.address());
        }

        public NkRowLayout row() {
            return NkPanel.nrow(this.address());
        }

        public NkChart chart() {
            return NkPanel.nchart(this.address());
        }

        public NkCommandBuffer buffer() {
            return NkPanel.nbuffer(this.address());
        }

        public NkPanel parent() {
            return NkPanel.nparent(this.address());
        }
    }
}

