/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkAllocator;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkPool
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOC;
    public static final int TYPE;
    public static final int PAGE_COUNT;
    public static final int PAGES;
    public static final int FREELIST;
    public static final int CAPACITY;
    public static final int SIZE;
    public static final int CAP;

    NkPool(long address, ByteBuffer container) {
        super(address, container);
    }

    NkPool(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkPool.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkAllocator alloc() {
        return NkPool.nalloc(this.address());
    }

    public int type() {
        return NkPool.ntype(this.address());
    }

    public int page_count() {
        return NkPool.npage_count(this.address());
    }

    public long pages() {
        return NkPool.npages(this.address());
    }

    public long freelist() {
        return NkPool.nfreelist(this.address());
    }

    public int capacity() {
        return NkPool.ncapacity(this.address());
    }

    public long size() {
        return NkPool.nsize(this.address());
    }

    public long cap() {
        return NkPool.ncap(this.address());
    }

    public static NkPool create(long address) {
        return address == 0L ? null : new NkPool(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkAllocator nalloc(long struct) {
        return NkAllocator.create(struct + (long)ALLOC);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int npage_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PAGE_COUNT);
    }

    public static long npages(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PAGES);
    }

    public static long nfreelist(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FREELIST);
    }

    public static int ncapacity(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CAPACITY);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static long ncap(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CAP);
    }

    static {
        Struct.Layout layout = NkPool.__struct(NkPool.__member(NkAllocator.SIZEOF, NkAllocator.ALIGNOF), NkPool.__member(4), NkPool.__member(4), NkPool.__member(POINTER_SIZE), NkPool.__member(POINTER_SIZE), NkPool.__member(4), NkPool.__member(POINTER_SIZE), NkPool.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOC = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        PAGE_COUNT = layout.offsetof(2);
        PAGES = layout.offsetof(3);
        FREELIST = layout.offsetof(4);
        CAPACITY = layout.offsetof(5);
        SIZE = layout.offsetof(6);
        CAP = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<NkPool, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkPool newInstance(long address) {
            return new NkPool(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkAllocator alloc() {
            return NkPool.nalloc(this.address());
        }

        public int type() {
            return NkPool.ntype(this.address());
        }

        public int page_count() {
            return NkPool.npage_count(this.address());
        }

        public long pages() {
            return NkPool.npages(this.address());
        }

        public long freelist() {
            return NkPool.nfreelist(this.address());
        }

        @Override
        public int capacity() {
            return NkPool.ncapacity(this.address());
        }

        public long size() {
            return NkPool.nsize(this.address());
        }

        public long cap() {
            return NkPool.ncap(this.address());
        }
    }
}

