/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkPopupBuffer;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkWindow;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkPopupState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIN;
    public static final int TYPE;
    public static final int BUF;
    public static final int NAME;
    public static final int ACTIVE;
    public static final int COMBO_COUNT;
    public static final int CON_COUNT;
    public static final int CON_OLD;
    public static final int ACTIVE_CON;
    public static final int HEADER;

    NkPopupState(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkPopupState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkPopupState.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkWindow win() {
        return NkPopupState.nwin(this.address());
    }

    public int type() {
        return NkPopupState.ntype(this.address());
    }

    public NkPopupBuffer buf() {
        return NkPopupState.nbuf(this.address());
    }

    public int name() {
        return NkPopupState.nname(this.address());
    }

    public int active() {
        return NkPopupState.nactive(this.address());
    }

    public int combo_count() {
        return NkPopupState.ncombo_count(this.address());
    }

    public int con_count() {
        return NkPopupState.ncon_count(this.address());
    }

    public int con_old() {
        return NkPopupState.ncon_old(this.address());
    }

    public int active_con() {
        return NkPopupState.nactive_con(this.address());
    }

    public NkRect header() {
        return NkPopupState.nheader(this.address());
    }

    public static NkPopupState create(long address) {
        return address == 0L ? null : new NkPopupState(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkWindow nwin(long struct) {
        return NkWindow.create(MemoryUtil.memGetAddress(struct + (long)WIN));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static NkPopupBuffer nbuf(long struct) {
        return NkPopupBuffer.create(struct + (long)BUF);
    }

    public static int nname(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NAME);
    }

    public static int nactive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIVE);
    }

    public static int ncombo_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMBO_COUNT);
    }

    public static int ncon_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CON_COUNT);
    }

    public static int ncon_old(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CON_OLD);
    }

    public static int nactive_con(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIVE_CON);
    }

    public static NkRect nheader(long struct) {
        return NkRect.create(struct + (long)HEADER);
    }

    static {
        Struct.Layout layout = NkPopupState.__struct(NkPopupState.__member(POINTER_SIZE), NkPopupState.__member(4), NkPopupState.__member(NkPopupBuffer.SIZEOF, NkPopupBuffer.ALIGNOF), NkPopupState.__member(4), NkPopupState.__member(4), NkPopupState.__member(4), NkPopupState.__member(4), NkPopupState.__member(4), NkPopupState.__member(4), NkPopupState.__member(NkRect.SIZEOF, NkRect.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIN = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        BUF = layout.offsetof(2);
        NAME = layout.offsetof(3);
        ACTIVE = layout.offsetof(4);
        COMBO_COUNT = layout.offsetof(5);
        CON_COUNT = layout.offsetof(6);
        CON_OLD = layout.offsetof(7);
        ACTIVE_CON = layout.offsetof(8);
        HEADER = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<NkPopupState, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkPopupState newInstance(long address) {
            return new NkPopupState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkWindow win() {
            return NkPopupState.nwin(this.address());
        }

        public int type() {
            return NkPopupState.ntype(this.address());
        }

        public NkPopupBuffer buf() {
            return NkPopupState.nbuf(this.address());
        }

        public int name() {
            return NkPopupState.nname(this.address());
        }

        public int active() {
            return NkPopupState.nactive(this.address());
        }

        public int combo_count() {
            return NkPopupState.ncombo_count(this.address());
        }

        public int con_count() {
            return NkPopupState.ncon_count(this.address());
        }

        public int con_old() {
            return NkPopupState.ncon_old(this.address());
        }

        public int active_con() {
            return NkPopupState.nactive_con(this.address());
        }

        public NkRect header() {
            return NkPopupState.nheader(this.address());
        }
    }
}

