/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkPropertyState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIVE;
    public static final int PREV;
    public static final int BUFFER;
    public static final int LENGTH;
    public static final int CURSOR;
    public static final int SELECT_START;
    public static final int SELECT_END;
    public static final int NAME;
    public static final int SEQ;
    public static final int OLD;
    public static final int STATE;

    NkPropertyState(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkPropertyState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkPropertyState.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int active() {
        return NkPropertyState.nactive(this.address());
    }

    public int prev() {
        return NkPropertyState.nprev(this.address());
    }

    public ByteBuffer buffer() {
        return NkPropertyState.nbuffer(this.address());
    }

    public byte buffer(int index) {
        return NkPropertyState.nbuffer(this.address(), index);
    }

    public int length() {
        return NkPropertyState.nlength(this.address());
    }

    public int cursor() {
        return NkPropertyState.ncursor(this.address());
    }

    public int select_start() {
        return NkPropertyState.nselect_start(this.address());
    }

    public int select_end() {
        return NkPropertyState.nselect_end(this.address());
    }

    public int name() {
        return NkPropertyState.nname(this.address());
    }

    public int seq() {
        return NkPropertyState.nseq(this.address());
    }

    public int old() {
        return NkPropertyState.nold(this.address());
    }

    public int state() {
        return NkPropertyState.nstate(this.address());
    }

    public static NkPropertyState create(long address) {
        return address == 0L ? null : new NkPropertyState(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nactive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIVE);
    }

    public static int nprev(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PREV);
    }

    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)BUFFER, 64);
    }

    public static byte nbuffer(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 64);
        }
        return MemoryUtil.memGetByte(struct + (long)BUFFER + (long)(index * 1));
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LENGTH);
    }

    public static int ncursor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURSOR);
    }

    public static int nselect_start(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SELECT_START);
    }

    public static int nselect_end(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SELECT_END);
    }

    public static int nname(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NAME);
    }

    public static int nseq(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SEQ);
    }

    public static int nold(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLD);
    }

    public static int nstate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STATE);
    }

    static {
        Struct.Layout layout = NkPropertyState.__struct(NkPropertyState.__member(4), NkPropertyState.__member(4), NkPropertyState.__array(1, 64), NkPropertyState.__member(4), NkPropertyState.__member(4), NkPropertyState.__member(4), NkPropertyState.__member(4), NkPropertyState.__member(4), NkPropertyState.__member(4), NkPropertyState.__member(4), NkPropertyState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIVE = layout.offsetof(0);
        PREV = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
        LENGTH = layout.offsetof(3);
        CURSOR = layout.offsetof(4);
        SELECT_START = layout.offsetof(5);
        SELECT_END = layout.offsetof(6);
        NAME = layout.offsetof(7);
        SEQ = layout.offsetof(8);
        OLD = layout.offsetof(9);
        STATE = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<NkPropertyState, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkPropertyState newInstance(long address) {
            return new NkPropertyState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int active() {
            return NkPropertyState.nactive(this.address());
        }

        public int prev() {
            return NkPropertyState.nprev(this.address());
        }

        public ByteBuffer buffer() {
            return NkPropertyState.nbuffer(this.address());
        }

        public byte buffer(int index) {
            return NkPropertyState.nbuffer(this.address(), index);
        }

        public int length() {
            return NkPropertyState.nlength(this.address());
        }

        public int cursor() {
            return NkPropertyState.ncursor(this.address());
        }

        public int select_start() {
            return NkPropertyState.nselect_start(this.address());
        }

        public int select_end() {
            return NkPropertyState.nselect_end(this.address());
        }

        public int name() {
            return NkPropertyState.nname(this.address());
        }

        public int seq() {
            return NkPropertyState.nseq(this.address());
        }

        public int old() {
            return NkPropertyState.nold(this.address());
        }

        public int state() {
            return NkPropertyState.nstate(this.address());
        }
    }
}

