/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkRowLayout
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int INDEX;
    public static final int HEIGHT;
    public static final int COLUMNS;
    public static final int RATIO;
    public static final int ITEM_WIDTH;
    public static final int ITEM_HEIGHT;
    public static final int ITEM_OFFSET;
    public static final int FILLED;
    public static final int ITEM;
    public static final int TREE_DEPTH;
    public static final int TEMPLATES;

    NkRowLayout(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkRowLayout(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkRowLayout.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return NkRowLayout.ntype(this.address());
    }

    public int index() {
        return NkRowLayout.nindex(this.address());
    }

    public float height() {
        return NkRowLayout.nheight(this.address());
    }

    public int columns() {
        return NkRowLayout.ncolumns(this.address());
    }

    public FloatBuffer ratio(int capacity) {
        return NkRowLayout.nratio(this.address(), capacity);
    }

    public float item_width() {
        return NkRowLayout.nitem_width(this.address());
    }

    public float item_height() {
        return NkRowLayout.nitem_height(this.address());
    }

    public float item_offset() {
        return NkRowLayout.nitem_offset(this.address());
    }

    public float filled() {
        return NkRowLayout.nfilled(this.address());
    }

    public NkRect item() {
        return NkRowLayout.nitem(this.address());
    }

    public int tree_depth() {
        return NkRowLayout.ntree_depth(this.address());
    }

    public FloatBuffer templates() {
        return NkRowLayout.ntemplates(this.address());
    }

    public float templates(int index) {
        return NkRowLayout.ntemplates(this.address(), index);
    }

    public static NkRowLayout create(long address) {
        return address == 0L ? null : new NkRowLayout(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nindex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEX);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static int ncolumns(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLUMNS);
    }

    public static FloatBuffer nratio(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)RATIO), capacity);
    }

    public static float nitem_width(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ITEM_WIDTH);
    }

    public static float nitem_height(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ITEM_HEIGHT);
    }

    public static float nitem_offset(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ITEM_OFFSET);
    }

    public static float nfilled(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FILLED);
    }

    public static NkRect nitem(long struct) {
        return NkRect.create(struct + (long)ITEM);
    }

    public static int ntree_depth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TREE_DEPTH);
    }

    public static FloatBuffer ntemplates(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)TEMPLATES, 16);
    }

    public static float ntemplates(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return MemoryUtil.memGetFloat(struct + (long)TEMPLATES + (long)(index * 4));
    }

    static {
        Struct.Layout layout = NkRowLayout.__struct(NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(POINTER_SIZE), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkRowLayout.__member(4), NkRowLayout.__array(4, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        INDEX = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        COLUMNS = layout.offsetof(3);
        RATIO = layout.offsetof(4);
        ITEM_WIDTH = layout.offsetof(5);
        ITEM_HEIGHT = layout.offsetof(6);
        ITEM_OFFSET = layout.offsetof(7);
        FILLED = layout.offsetof(8);
        ITEM = layout.offsetof(9);
        TREE_DEPTH = layout.offsetof(10);
        TEMPLATES = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<NkRowLayout, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkRowLayout newInstance(long address) {
            return new NkRowLayout(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int type() {
            return NkRowLayout.ntype(this.address());
        }

        public int index() {
            return NkRowLayout.nindex(this.address());
        }

        public float height() {
            return NkRowLayout.nheight(this.address());
        }

        public int columns() {
            return NkRowLayout.ncolumns(this.address());
        }

        public FloatBuffer ratio(int capacity) {
            return NkRowLayout.nratio(this.address(), capacity);
        }

        public float item_width() {
            return NkRowLayout.nitem_width(this.address());
        }

        public float item_height() {
            return NkRowLayout.nitem_height(this.address());
        }

        public float item_offset() {
            return NkRowLayout.nitem_offset(this.address());
        }

        public float filled() {
            return NkRowLayout.nfilled(this.address());
        }

        public NkRect item() {
            return NkRowLayout.nitem(this.address());
        }

        public int tree_depth() {
            return NkRowLayout.ntree_depth(this.address());
        }

        public FloatBuffer templates() {
            return NkRowLayout.ntemplates(this.address());
        }

        public float templates(int index) {
            return NkRowLayout.ntemplates(this.address(), index);
        }
    }
}

