/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkScroll
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    NkScroll(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkScroll(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkScroll.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return NkScroll.nx(this.address());
    }

    public int y() {
        return NkScroll.ny(this.address());
    }

    public static NkScroll malloc() {
        return NkScroll.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkScroll calloc() {
        return NkScroll.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkScroll create() {
        return new NkScroll(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkScroll create(long address) {
        return address == 0L ? null : new NkScroll(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkScroll.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkScroll.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkScroll mallocStack() {
        return NkScroll.mallocStack(MemoryStack.stackGet());
    }

    public static NkScroll callocStack() {
        return NkScroll.callocStack(MemoryStack.stackGet());
    }

    public static NkScroll mallocStack(MemoryStack stack) {
        return NkScroll.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkScroll callocStack(MemoryStack stack) {
        return NkScroll.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkScroll.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkScroll.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkScroll.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkScroll.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    static {
        Struct.Layout layout = NkScroll.__struct(NkScroll.__member(4), NkScroll.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkScroll, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkScroll newInstance(long address) {
            return new NkScroll(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int x() {
            return NkScroll.nx(this.address());
        }

        public int y() {
            return NkScroll.ny(this.address());
        }
    }
}

