/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStr
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int LEN;

    NkStr(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStr(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStr.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkBuffer buffer() {
        return NkStr.nbuffer(this.address());
    }

    public int len() {
        return NkStr.nlen(this.address());
    }

    public static NkStr malloc() {
        return NkStr.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStr calloc() {
        return NkStr.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStr create() {
        return new NkStr(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStr create(long address) {
        return address == 0L ? null : new NkStr(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStr.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStr.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStr mallocStack() {
        return NkStr.mallocStack(MemoryStack.stackGet());
    }

    public static NkStr callocStack() {
        return NkStr.callocStack(MemoryStack.stackGet());
    }

    public static NkStr mallocStack(MemoryStack stack) {
        return NkStr.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStr callocStack(MemoryStack stack) {
        return NkStr.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStr.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStr.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStr.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStr.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkBuffer nbuffer(long struct) {
        return NkBuffer.create(struct + (long)BUFFER);
    }

    public static int nlen(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEN);
    }

    static {
        Struct.Layout layout = NkStr.__struct(NkStr.__member(NkBuffer.SIZEOF, NkBuffer.ALIGNOF), NkStr.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        LEN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStr, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStr newInstance(long address) {
            return new NkStr(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkBuffer buffer() {
            return NkStr.nbuffer(this.address());
        }

        public int len() {
            return NkStr.nlen(this.address());
        }
    }
}

