/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.nuklear.NkCursor;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleChart;
import org.lwjgl.nuklear.NkStyleCombo;
import org.lwjgl.nuklear.NkStyleEdit;
import org.lwjgl.nuklear.NkStyleProgress;
import org.lwjgl.nuklear.NkStyleProperty;
import org.lwjgl.nuklear.NkStyleScrollbar;
import org.lwjgl.nuklear.NkStyleSelectable;
import org.lwjgl.nuklear.NkStyleSlider;
import org.lwjgl.nuklear.NkStyleTab;
import org.lwjgl.nuklear.NkStyleText;
import org.lwjgl.nuklear.NkStyleToggle;
import org.lwjgl.nuklear.NkStyleWindow;
import org.lwjgl.nuklear.NkUserFont;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyle
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FONT;
    public static final int CURSORS;
    public static final int CURSOR_ACTIVE;
    public static final int CURSOR_LAST;
    public static final int CURSOR_VISIBLE;
    public static final int TEXT;
    public static final int BUTTON;
    public static final int CONTEXTUAL_BUTTON;
    public static final int MENU_BUTTON;
    public static final int OPTION;
    public static final int CHECKBOX;
    public static final int SELECTABLE;
    public static final int SLIDER;
    public static final int PROGRESS;
    public static final int PROPERTY;
    public static final int EDIT;
    public static final int CHART;
    public static final int SCROLLH;
    public static final int SCROLLV;
    public static final int TAB;
    public static final int COMBO;
    public static final int WINDOW;

    NkStyle(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyle(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyle.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkUserFont font() {
        return NkStyle.nfont(this.address());
    }

    public PointerBuffer cursors() {
        return NkStyle.ncursors(this.address());
    }

    public NkCursor cursors(int index) {
        return NkStyle.ncursors(this.address(), index);
    }

    public NkCursor cursor_active() {
        return NkStyle.ncursor_active(this.address());
    }

    public NkCursor cursor_last() {
        return NkStyle.ncursor_last(this.address());
    }

    public boolean cursor_visible() {
        return NkStyle.ncursor_visible(this.address()) != 0;
    }

    public NkStyleText text() {
        return NkStyle.ntext(this.address());
    }

    public NkStyleButton button() {
        return NkStyle.nbutton(this.address());
    }

    public NkStyleButton contextual_button() {
        return NkStyle.ncontextual_button(this.address());
    }

    public NkStyleButton menu_button() {
        return NkStyle.nmenu_button(this.address());
    }

    public NkStyleToggle option() {
        return NkStyle.noption(this.address());
    }

    public NkStyleToggle checkbox() {
        return NkStyle.ncheckbox(this.address());
    }

    public NkStyleSelectable selectable() {
        return NkStyle.nselectable(this.address());
    }

    public NkStyleSlider slider() {
        return NkStyle.nslider(this.address());
    }

    public NkStyleProgress progress() {
        return NkStyle.nprogress(this.address());
    }

    public NkStyleProperty property() {
        return NkStyle.nproperty(this.address());
    }

    public NkStyleEdit edit() {
        return NkStyle.nedit(this.address());
    }

    public NkStyleChart chart() {
        return NkStyle.nchart(this.address());
    }

    public NkStyleScrollbar scrollh() {
        return NkStyle.nscrollh(this.address());
    }

    public NkStyleScrollbar scrollv() {
        return NkStyle.nscrollv(this.address());
    }

    public NkStyleTab tab() {
        return NkStyle.ntab(this.address());
    }

    public NkStyleCombo combo() {
        return NkStyle.ncombo(this.address());
    }

    public NkStyleWindow window() {
        return NkStyle.nwindow(this.address());
    }

    public NkStyle font(NkUserFont value) {
        NkStyle.nfont(this.address(), value);
        return this;
    }

    public NkStyle cursors(PointerBuffer value) {
        NkStyle.ncursors(this.address(), value);
        return this;
    }

    public NkStyle cursors(int index, NkCursor value) {
        NkStyle.ncursors(this.address(), index, value);
        return this;
    }

    public NkStyle cursor_active(NkCursor value) {
        NkStyle.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyle cursor_last(NkCursor value) {
        NkStyle.ncursor_last(this.address(), value);
        return this;
    }

    public NkStyle cursor_visible(boolean value) {
        NkStyle.ncursor_visible(this.address(), value ? 1 : 0);
        return this;
    }

    public NkStyle text(NkStyleText value) {
        NkStyle.ntext(this.address(), value);
        return this;
    }

    public NkStyle button(NkStyleButton value) {
        NkStyle.nbutton(this.address(), value);
        return this;
    }

    public NkStyle contextual_button(NkStyleButton value) {
        NkStyle.ncontextual_button(this.address(), value);
        return this;
    }

    public NkStyle menu_button(NkStyleButton value) {
        NkStyle.nmenu_button(this.address(), value);
        return this;
    }

    public NkStyle option(NkStyleToggle value) {
        NkStyle.noption(this.address(), value);
        return this;
    }

    public NkStyle checkbox(NkStyleToggle value) {
        NkStyle.ncheckbox(this.address(), value);
        return this;
    }

    public NkStyle selectable(NkStyleSelectable value) {
        NkStyle.nselectable(this.address(), value);
        return this;
    }

    public NkStyle slider(NkStyleSlider value) {
        NkStyle.nslider(this.address(), value);
        return this;
    }

    public NkStyle progress(NkStyleProgress value) {
        NkStyle.nprogress(this.address(), value);
        return this;
    }

    public NkStyle property(NkStyleProperty value) {
        NkStyle.nproperty(this.address(), value);
        return this;
    }

    public NkStyle edit(NkStyleEdit value) {
        NkStyle.nedit(this.address(), value);
        return this;
    }

    public NkStyle chart(NkStyleChart value) {
        NkStyle.nchart(this.address(), value);
        return this;
    }

    public NkStyle scrollh(NkStyleScrollbar value) {
        NkStyle.nscrollh(this.address(), value);
        return this;
    }

    public NkStyle scrollv(NkStyleScrollbar value) {
        NkStyle.nscrollv(this.address(), value);
        return this;
    }

    public NkStyle tab(NkStyleTab value) {
        NkStyle.ntab(this.address(), value);
        return this;
    }

    public NkStyle combo(NkStyleCombo value) {
        NkStyle.ncombo(this.address(), value);
        return this;
    }

    public NkStyle window(NkStyleWindow value) {
        NkStyle.nwindow(this.address(), value);
        return this;
    }

    public NkStyle set(NkUserFont font, PointerBuffer cursors, NkCursor cursor_active, NkCursor cursor_last, boolean cursor_visible, NkStyleText text, NkStyleButton button, NkStyleButton contextual_button, NkStyleButton menu_button, NkStyleToggle option, NkStyleToggle checkbox, NkStyleSelectable selectable, NkStyleSlider slider, NkStyleProgress progress, NkStyleProperty property, NkStyleEdit edit, NkStyleChart chart, NkStyleScrollbar scrollh, NkStyleScrollbar scrollv, NkStyleTab tab, NkStyleCombo combo, NkStyleWindow window) {
        this.font(font);
        this.cursors(cursors);
        this.cursor_active(cursor_active);
        this.cursor_last(cursor_last);
        this.cursor_visible(cursor_visible);
        this.text(text);
        this.button(button);
        this.contextual_button(contextual_button);
        this.menu_button(menu_button);
        this.option(option);
        this.checkbox(checkbox);
        this.selectable(selectable);
        this.slider(slider);
        this.progress(progress);
        this.property(property);
        this.edit(edit);
        this.chart(chart);
        this.scrollh(scrollh);
        this.scrollv(scrollv);
        this.tab(tab);
        this.combo(combo);
        this.window(window);
        return this;
    }

    public NkStyle set(NkStyle src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyle malloc() {
        return NkStyle.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyle calloc() {
        return NkStyle.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyle create() {
        return new NkStyle(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyle create(long address) {
        return address == 0L ? null : new NkStyle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyle.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyle.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyle mallocStack() {
        return NkStyle.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyle callocStack() {
        return NkStyle.callocStack(MemoryStack.stackGet());
    }

    public static NkStyle mallocStack(MemoryStack stack) {
        return NkStyle.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyle callocStack(MemoryStack stack) {
        return NkStyle.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyle.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyle.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyle.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyle.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkUserFont nfont(long struct) {
        return NkUserFont.create(MemoryUtil.memGetAddress(struct + (long)FONT));
    }

    public static PointerBuffer ncursors(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)CURSORS, 7);
    }

    public static NkCursor ncursors(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 7);
        }
        return NkCursor.create(MemoryUtil.memGetAddress(struct + (long)CURSORS + (long)(index * POINTER_SIZE)));
    }

    public static NkCursor ncursor_active(long struct) {
        return NkCursor.create(MemoryUtil.memGetAddress(struct + (long)CURSOR_ACTIVE));
    }

    public static NkCursor ncursor_last(long struct) {
        return NkCursor.create(MemoryUtil.memGetAddress(struct + (long)CURSOR_LAST));
    }

    public static int ncursor_visible(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURSOR_VISIBLE);
    }

    public static NkStyleText ntext(long struct) {
        return NkStyleText.create(struct + (long)TEXT);
    }

    public static NkStyleButton nbutton(long struct) {
        return NkStyleButton.create(struct + (long)BUTTON);
    }

    public static NkStyleButton ncontextual_button(long struct) {
        return NkStyleButton.create(struct + (long)CONTEXTUAL_BUTTON);
    }

    public static NkStyleButton nmenu_button(long struct) {
        return NkStyleButton.create(struct + (long)MENU_BUTTON);
    }

    public static NkStyleToggle noption(long struct) {
        return NkStyleToggle.create(struct + (long)OPTION);
    }

    public static NkStyleToggle ncheckbox(long struct) {
        return NkStyleToggle.create(struct + (long)CHECKBOX);
    }

    public static NkStyleSelectable nselectable(long struct) {
        return NkStyleSelectable.create(struct + (long)SELECTABLE);
    }

    public static NkStyleSlider nslider(long struct) {
        return NkStyleSlider.create(struct + (long)SLIDER);
    }

    public static NkStyleProgress nprogress(long struct) {
        return NkStyleProgress.create(struct + (long)PROGRESS);
    }

    public static NkStyleProperty nproperty(long struct) {
        return NkStyleProperty.create(struct + (long)PROPERTY);
    }

    public static NkStyleEdit nedit(long struct) {
        return NkStyleEdit.create(struct + (long)EDIT);
    }

    public static NkStyleChart nchart(long struct) {
        return NkStyleChart.create(struct + (long)CHART);
    }

    public static NkStyleScrollbar nscrollh(long struct) {
        return NkStyleScrollbar.create(struct + (long)SCROLLH);
    }

    public static NkStyleScrollbar nscrollv(long struct) {
        return NkStyleScrollbar.create(struct + (long)SCROLLV);
    }

    public static NkStyleTab ntab(long struct) {
        return NkStyleTab.create(struct + (long)TAB);
    }

    public static NkStyleCombo ncombo(long struct) {
        return NkStyleCombo.create(struct + (long)COMBO);
    }

    public static NkStyleWindow nwindow(long struct) {
        return NkStyleWindow.create(struct + (long)WINDOW);
    }

    public static void nfont(long struct, NkUserFont value) {
        MemoryUtil.memPutAddress(struct + (long)FONT, value.address());
    }

    public static void ncursors(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 7);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)CURSORS, value.remaining() * POINTER_SIZE);
    }

    public static void ncursors(long struct, int index, NkCursor value) {
        if (Checks.CHECKS) {
            Checks.check(index, 7);
        }
        MemoryUtil.memPutAddress(struct + (long)CURSORS + (long)(index * POINTER_SIZE), NkStyle.addressSafe(value));
    }

    public static void ncursor_active(long struct, NkCursor value) {
        MemoryUtil.memPutAddress(struct + (long)CURSOR_ACTIVE, NkStyle.addressSafe(value));
    }

    public static void ncursor_last(long struct, NkCursor value) {
        MemoryUtil.memPutAddress(struct + (long)CURSOR_LAST, NkStyle.addressSafe(value));
    }

    public static void ncursor_visible(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CURSOR_VISIBLE, value);
    }

    public static void ntext(long struct, NkStyleText value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT, NkStyleText.SIZEOF);
    }

    public static void nbutton(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ncontextual_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CONTEXTUAL_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nmenu_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MENU_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void noption(long struct, NkStyleToggle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OPTION, NkStyleToggle.SIZEOF);
    }

    public static void ncheckbox(long struct, NkStyleToggle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CHECKBOX, NkStyleToggle.SIZEOF);
    }

    public static void nselectable(long struct, NkStyleSelectable value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SELECTABLE, NkStyleSelectable.SIZEOF);
    }

    public static void nslider(long struct, NkStyleSlider value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SLIDER, NkStyleSlider.SIZEOF);
    }

    public static void nprogress(long struct, NkStyleProgress value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PROGRESS, NkStyleProgress.SIZEOF);
    }

    public static void nproperty(long struct, NkStyleProperty value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PROPERTY, NkStyleProperty.SIZEOF);
    }

    public static void nedit(long struct, NkStyleEdit value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EDIT, NkStyleEdit.SIZEOF);
    }

    public static void nchart(long struct, NkStyleChart value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CHART, NkStyleChart.SIZEOF);
    }

    public static void nscrollh(long struct, NkStyleScrollbar value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCROLLH, NkStyleScrollbar.SIZEOF);
    }

    public static void nscrollv(long struct, NkStyleScrollbar value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCROLLV, NkStyleScrollbar.SIZEOF);
    }

    public static void ntab(long struct, NkStyleTab value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TAB, NkStyleTab.SIZEOF);
    }

    public static void ncombo(long struct, NkStyleCombo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COMBO, NkStyleCombo.SIZEOF);
    }

    public static void nwindow(long struct, NkStyleWindow value) {
        MemoryUtil.memCopy(value.address(), struct + (long)WINDOW, NkStyleWindow.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FONT));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            NkStyle.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = NkStyle.__struct(NkStyle.__member(POINTER_SIZE), NkStyle.__array(POINTER_SIZE, 7), NkStyle.__member(POINTER_SIZE), NkStyle.__member(POINTER_SIZE), NkStyle.__member(4), NkStyle.__member(NkStyleText.SIZEOF, NkStyleText.ALIGNOF), NkStyle.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyle.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyle.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyle.__member(NkStyleToggle.SIZEOF, NkStyleToggle.ALIGNOF), NkStyle.__member(NkStyleToggle.SIZEOF, NkStyleToggle.ALIGNOF), NkStyle.__member(NkStyleSelectable.SIZEOF, NkStyleSelectable.ALIGNOF), NkStyle.__member(NkStyleSlider.SIZEOF, NkStyleSlider.ALIGNOF), NkStyle.__member(NkStyleProgress.SIZEOF, NkStyleProgress.ALIGNOF), NkStyle.__member(NkStyleProperty.SIZEOF, NkStyleProperty.ALIGNOF), NkStyle.__member(NkStyleEdit.SIZEOF, NkStyleEdit.ALIGNOF), NkStyle.__member(NkStyleChart.SIZEOF, NkStyleChart.ALIGNOF), NkStyle.__member(NkStyleScrollbar.SIZEOF, NkStyleScrollbar.ALIGNOF), NkStyle.__member(NkStyleScrollbar.SIZEOF, NkStyleScrollbar.ALIGNOF), NkStyle.__member(NkStyleTab.SIZEOF, NkStyleTab.ALIGNOF), NkStyle.__member(NkStyleCombo.SIZEOF, NkStyleCombo.ALIGNOF), NkStyle.__member(NkStyleWindow.SIZEOF, NkStyleWindow.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FONT = layout.offsetof(0);
        CURSORS = layout.offsetof(1);
        CURSOR_ACTIVE = layout.offsetof(2);
        CURSOR_LAST = layout.offsetof(3);
        CURSOR_VISIBLE = layout.offsetof(4);
        TEXT = layout.offsetof(5);
        BUTTON = layout.offsetof(6);
        CONTEXTUAL_BUTTON = layout.offsetof(7);
        MENU_BUTTON = layout.offsetof(8);
        OPTION = layout.offsetof(9);
        CHECKBOX = layout.offsetof(10);
        SELECTABLE = layout.offsetof(11);
        SLIDER = layout.offsetof(12);
        PROGRESS = layout.offsetof(13);
        PROPERTY = layout.offsetof(14);
        EDIT = layout.offsetof(15);
        CHART = layout.offsetof(16);
        SCROLLH = layout.offsetof(17);
        SCROLLV = layout.offsetof(18);
        TAB = layout.offsetof(19);
        COMBO = layout.offsetof(20);
        WINDOW = layout.offsetof(21);
    }

    public static class Buffer
    extends StructBuffer<NkStyle, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyle newInstance(long address) {
            return new NkStyle(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkUserFont font() {
            return NkStyle.nfont(this.address());
        }

        public PointerBuffer cursors() {
            return NkStyle.ncursors(this.address());
        }

        public NkCursor cursors(int index) {
            return NkStyle.ncursors(this.address(), index);
        }

        public NkCursor cursor_active() {
            return NkStyle.ncursor_active(this.address());
        }

        public NkCursor cursor_last() {
            return NkStyle.ncursor_last(this.address());
        }

        public boolean cursor_visible() {
            return NkStyle.ncursor_visible(this.address()) != 0;
        }

        public NkStyleText text() {
            return NkStyle.ntext(this.address());
        }

        public NkStyleButton button() {
            return NkStyle.nbutton(this.address());
        }

        public NkStyleButton contextual_button() {
            return NkStyle.ncontextual_button(this.address());
        }

        public NkStyleButton menu_button() {
            return NkStyle.nmenu_button(this.address());
        }

        public NkStyleToggle option() {
            return NkStyle.noption(this.address());
        }

        public NkStyleToggle checkbox() {
            return NkStyle.ncheckbox(this.address());
        }

        public NkStyleSelectable selectable() {
            return NkStyle.nselectable(this.address());
        }

        public NkStyleSlider slider() {
            return NkStyle.nslider(this.address());
        }

        public NkStyleProgress progress() {
            return NkStyle.nprogress(this.address());
        }

        public NkStyleProperty property() {
            return NkStyle.nproperty(this.address());
        }

        public NkStyleEdit edit() {
            return NkStyle.nedit(this.address());
        }

        public NkStyleChart chart() {
            return NkStyle.nchart(this.address());
        }

        public NkStyleScrollbar scrollh() {
            return NkStyle.nscrollh(this.address());
        }

        public NkStyleScrollbar scrollv() {
            return NkStyle.nscrollv(this.address());
        }

        public NkStyleTab tab() {
            return NkStyle.ntab(this.address());
        }

        public NkStyleCombo combo() {
            return NkStyle.ncombo(this.address());
        }

        public NkStyleWindow window() {
            return NkStyle.nwindow(this.address());
        }

        public Buffer font(NkUserFont value) {
            NkStyle.nfont(this.address(), value);
            return this;
        }

        public Buffer cursors(PointerBuffer value) {
            NkStyle.ncursors(this.address(), value);
            return this;
        }

        public Buffer cursors(int index, NkCursor value) {
            NkStyle.ncursors(this.address(), index, value);
            return this;
        }

        public Buffer cursor_active(NkCursor value) {
            NkStyle.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_last(NkCursor value) {
            NkStyle.ncursor_last(this.address(), value);
            return this;
        }

        public Buffer cursor_visible(boolean value) {
            NkStyle.ncursor_visible(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer text(NkStyleText value) {
            NkStyle.ntext(this.address(), value);
            return this;
        }

        public Buffer button(NkStyleButton value) {
            NkStyle.nbutton(this.address(), value);
            return this;
        }

        public Buffer contextual_button(NkStyleButton value) {
            NkStyle.ncontextual_button(this.address(), value);
            return this;
        }

        public Buffer menu_button(NkStyleButton value) {
            NkStyle.nmenu_button(this.address(), value);
            return this;
        }

        public Buffer option(NkStyleToggle value) {
            NkStyle.noption(this.address(), value);
            return this;
        }

        public Buffer checkbox(NkStyleToggle value) {
            NkStyle.ncheckbox(this.address(), value);
            return this;
        }

        public Buffer selectable(NkStyleSelectable value) {
            NkStyle.nselectable(this.address(), value);
            return this;
        }

        public Buffer slider(NkStyleSlider value) {
            NkStyle.nslider(this.address(), value);
            return this;
        }

        public Buffer progress(NkStyleProgress value) {
            NkStyle.nprogress(this.address(), value);
            return this;
        }

        public Buffer property(NkStyleProperty value) {
            NkStyle.nproperty(this.address(), value);
            return this;
        }

        public Buffer edit(NkStyleEdit value) {
            NkStyle.nedit(this.address(), value);
            return this;
        }

        public Buffer chart(NkStyleChart value) {
            NkStyle.nchart(this.address(), value);
            return this;
        }

        public Buffer scrollh(NkStyleScrollbar value) {
            NkStyle.nscrollh(this.address(), value);
            return this;
        }

        public Buffer scrollv(NkStyleScrollbar value) {
            NkStyle.nscrollv(this.address(), value);
            return this;
        }

        public Buffer tab(NkStyleTab value) {
            NkStyle.ntab(this.address(), value);
            return this;
        }

        public Buffer combo(NkStyleCombo value) {
            NkStyle.ncombo(this.address(), value);
            return this;
        }

        public Buffer window(NkStyleWindow value) {
            NkStyle.nwindow(this.address(), value);
            return this;
        }
    }
}

