/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleButton
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int TEXT_BACKGROUND;
    public static final int TEXT_NORMAL;
    public static final int TEXT_HOVER;
    public static final int TEXT_ACTIVE;
    public static final int TEXT_ALIGNMENT;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int PADDING;
    public static final int IMAGE_PADDING;
    public static final int TOUCH_PADDING;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    NkStyleButton(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleButton(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleButton.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleButton.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleButton.nhover(this.address());
    }

    public NkStyleItem active() {
        return NkStyleButton.nactive(this.address());
    }

    public NkColor border_color() {
        return NkStyleButton.nborder_color(this.address());
    }

    public NkColor text_background() {
        return NkStyleButton.ntext_background(this.address());
    }

    public NkColor text_normal() {
        return NkStyleButton.ntext_normal(this.address());
    }

    public NkColor text_hover() {
        return NkStyleButton.ntext_hover(this.address());
    }

    public NkColor text_active() {
        return NkStyleButton.ntext_active(this.address());
    }

    public int text_alignment() {
        return NkStyleButton.ntext_alignment(this.address());
    }

    public float border() {
        return NkStyleButton.nborder(this.address());
    }

    public float rounding() {
        return NkStyleButton.nrounding(this.address());
    }

    public NkVec2 padding() {
        return NkStyleButton.npadding(this.address());
    }

    public NkVec2 image_padding() {
        return NkStyleButton.nimage_padding(this.address());
    }

    public NkVec2 touch_padding() {
        return NkStyleButton.ntouch_padding(this.address());
    }

    public NkHandle userdata() {
        return NkStyleButton.nuserdata(this.address());
    }

    public NkDrawBeginCallback draw_begin() {
        return NkStyleButton.ndraw_begin(this.address());
    }

    public NkDrawEndCallback draw_end() {
        return NkStyleButton.ndraw_end(this.address());
    }

    public NkStyleButton normal(NkStyleItem value) {
        NkStyleButton.nnormal(this.address(), value);
        return this;
    }

    public NkStyleButton hover(NkStyleItem value) {
        NkStyleButton.nhover(this.address(), value);
        return this;
    }

    public NkStyleButton active(NkStyleItem value) {
        NkStyleButton.nactive(this.address(), value);
        return this;
    }

    public NkStyleButton border_color(NkColor value) {
        NkStyleButton.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleButton text_background(NkColor value) {
        NkStyleButton.ntext_background(this.address(), value);
        return this;
    }

    public NkStyleButton text_normal(NkColor value) {
        NkStyleButton.ntext_normal(this.address(), value);
        return this;
    }

    public NkStyleButton text_hover(NkColor value) {
        NkStyleButton.ntext_hover(this.address(), value);
        return this;
    }

    public NkStyleButton text_active(NkColor value) {
        NkStyleButton.ntext_active(this.address(), value);
        return this;
    }

    public NkStyleButton text_alignment(int value) {
        NkStyleButton.ntext_alignment(this.address(), value);
        return this;
    }

    public NkStyleButton border(float value) {
        NkStyleButton.nborder(this.address(), value);
        return this;
    }

    public NkStyleButton rounding(float value) {
        NkStyleButton.nrounding(this.address(), value);
        return this;
    }

    public NkStyleButton padding(NkVec2 value) {
        NkStyleButton.npadding(this.address(), value);
        return this;
    }

    public NkStyleButton image_padding(NkVec2 value) {
        NkStyleButton.nimage_padding(this.address(), value);
        return this;
    }

    public NkStyleButton touch_padding(NkVec2 value) {
        NkStyleButton.ntouch_padding(this.address(), value);
        return this;
    }

    public NkStyleButton userdata(NkHandle value) {
        NkStyleButton.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleButton draw_begin(NkDrawBeginCallbackI value) {
        NkStyleButton.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleButton draw_end(NkDrawEndCallbackI value) {
        NkStyleButton.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleButton set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkColor text_background, NkColor text_normal, NkColor text_hover, NkColor text_active, int text_alignment, float border, float rounding, NkVec2 padding, NkVec2 image_padding, NkVec2 touch_padding, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.text_background(text_background);
        this.text_normal(text_normal);
        this.text_hover(text_hover);
        this.text_active(text_active);
        this.text_alignment(text_alignment);
        this.border(border);
        this.rounding(rounding);
        this.padding(padding);
        this.image_padding(image_padding);
        this.touch_padding(touch_padding);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleButton set(NkStyleButton src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleButton malloc() {
        return NkStyleButton.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleButton calloc() {
        return NkStyleButton.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleButton create() {
        return new NkStyleButton(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleButton create(long address) {
        return address == 0L ? null : new NkStyleButton(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleButton.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleButton.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleButton mallocStack() {
        return NkStyleButton.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleButton callocStack() {
        return NkStyleButton.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleButton mallocStack(MemoryStack stack) {
        return NkStyleButton.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleButton callocStack(MemoryStack stack) {
        return NkStyleButton.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleButton.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleButton.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleButton.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleButton.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor ntext_background(long struct) {
        return NkColor.create(struct + (long)TEXT_BACKGROUND);
    }

    public static NkColor ntext_normal(long struct) {
        return NkColor.create(struct + (long)TEXT_NORMAL);
    }

    public static NkColor ntext_hover(long struct) {
        return NkColor.create(struct + (long)TEXT_HOVER);
    }

    public static NkColor ntext_active(long struct) {
        return NkColor.create(struct + (long)TEXT_ACTIVE);
    }

    public static int ntext_alignment(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXT_ALIGNMENT);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 nimage_padding(long struct) {
        return NkVec2.create(struct + (long)IMAGE_PADDING);
    }

    public static NkVec2 ntouch_padding(long struct) {
        return NkVec2.create(struct + (long)TOUCH_PADDING);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ntext_background(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_BACKGROUND, NkColor.SIZEOF);
    }

    public static void ntext_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_NORMAL, NkColor.SIZEOF);
    }

    public static void ntext_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_HOVER, NkColor.SIZEOF);
    }

    public static void ntext_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_ACTIVE, NkColor.SIZEOF);
    }

    public static void ntext_alignment(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXT_ALIGNMENT, value);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nimage_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGE_PADDING, NkVec2.SIZEOF);
    }

    public static void ntouch_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TOUCH_PADDING, NkVec2.SIZEOF);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, NkStyleButton.addressSafe(value));
    }

    public static void ndraw_end(long struct, NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, NkStyleButton.addressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleButton.__struct(NkStyleButton.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleButton.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleButton.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(4), NkStyleButton.__member(4), NkStyleButton.__member(4), NkStyleButton.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleButton.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleButton.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleButton.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleButton.__member(POINTER_SIZE), NkStyleButton.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        TEXT_BACKGROUND = layout.offsetof(4);
        TEXT_NORMAL = layout.offsetof(5);
        TEXT_HOVER = layout.offsetof(6);
        TEXT_ACTIVE = layout.offsetof(7);
        TEXT_ALIGNMENT = layout.offsetof(8);
        BORDER = layout.offsetof(9);
        ROUNDING = layout.offsetof(10);
        PADDING = layout.offsetof(11);
        IMAGE_PADDING = layout.offsetof(12);
        TOUCH_PADDING = layout.offsetof(13);
        USERDATA = layout.offsetof(14);
        DRAW_BEGIN = layout.offsetof(15);
        DRAW_END = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<NkStyleButton, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleButton newInstance(long address) {
            return new NkStyleButton(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleButton.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleButton.nhover(this.address());
        }

        public NkStyleItem active() {
            return NkStyleButton.nactive(this.address());
        }

        public NkColor border_color() {
            return NkStyleButton.nborder_color(this.address());
        }

        public NkColor text_background() {
            return NkStyleButton.ntext_background(this.address());
        }

        public NkColor text_normal() {
            return NkStyleButton.ntext_normal(this.address());
        }

        public NkColor text_hover() {
            return NkStyleButton.ntext_hover(this.address());
        }

        public NkColor text_active() {
            return NkStyleButton.ntext_active(this.address());
        }

        public int text_alignment() {
            return NkStyleButton.ntext_alignment(this.address());
        }

        public float border() {
            return NkStyleButton.nborder(this.address());
        }

        public float rounding() {
            return NkStyleButton.nrounding(this.address());
        }

        public NkVec2 padding() {
            return NkStyleButton.npadding(this.address());
        }

        public NkVec2 image_padding() {
            return NkStyleButton.nimage_padding(this.address());
        }

        public NkVec2 touch_padding() {
            return NkStyleButton.ntouch_padding(this.address());
        }

        public NkHandle userdata() {
            return NkStyleButton.nuserdata(this.address());
        }

        public NkDrawBeginCallback draw_begin() {
            return NkStyleButton.ndraw_begin(this.address());
        }

        public NkDrawEndCallback draw_end() {
            return NkStyleButton.ndraw_end(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleButton.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleButton.nhover(this.address(), value);
            return this;
        }

        public Buffer active(NkStyleItem value) {
            NkStyleButton.nactive(this.address(), value);
            return this;
        }

        public Buffer border_color(NkColor value) {
            NkStyleButton.nborder_color(this.address(), value);
            return this;
        }

        public Buffer text_background(NkColor value) {
            NkStyleButton.ntext_background(this.address(), value);
            return this;
        }

        public Buffer text_normal(NkColor value) {
            NkStyleButton.ntext_normal(this.address(), value);
            return this;
        }

        public Buffer text_hover(NkColor value) {
            NkStyleButton.ntext_hover(this.address(), value);
            return this;
        }

        public Buffer text_active(NkColor value) {
            NkStyleButton.ntext_active(this.address(), value);
            return this;
        }

        public Buffer text_alignment(int value) {
            NkStyleButton.ntext_alignment(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleButton.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleButton.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(NkVec2 value) {
            NkStyleButton.npadding(this.address(), value);
            return this;
        }

        public Buffer image_padding(NkVec2 value) {
            NkStyleButton.nimage_padding(this.address(), value);
            return this;
        }

        public Buffer touch_padding(NkVec2 value) {
            NkStyleButton.ntouch_padding(this.address(), value);
            return this;
        }

        public Buffer userdata(NkHandle value) {
            NkStyleButton.nuserdata(this.address(), value);
            return this;
        }

        public Buffer draw_begin(NkDrawBeginCallbackI value) {
            NkStyleButton.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(NkDrawEndCallbackI value) {
            NkStyleButton.ndraw_end(this.address(), value);
            return this;
        }
    }
}

