/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleCombo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int LABEL_NORMAL;
    public static final int LABEL_HOVER;
    public static final int LABEL_ACTIVE;
    public static final int SYMBOL_NORMAL;
    public static final int SYMBOL_HOVER;
    public static final int SYMBOL_ACTIVE;
    public static final int BUTTON;
    public static final int SYM_NORMAL;
    public static final int SYM_HOVER;
    public static final int SYM_ACTIVE;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int CONTENT_PADDING;
    public static final int BUTTON_PADDING;
    public static final int SPACING;

    NkStyleCombo(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleCombo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleCombo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleCombo.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleCombo.nhover(this.address());
    }

    public NkStyleItem active() {
        return NkStyleCombo.nactive(this.address());
    }

    public NkColor border_color() {
        return NkStyleCombo.nborder_color(this.address());
    }

    public NkColor label_normal() {
        return NkStyleCombo.nlabel_normal(this.address());
    }

    public NkColor label_hover() {
        return NkStyleCombo.nlabel_hover(this.address());
    }

    public NkColor label_active() {
        return NkStyleCombo.nlabel_active(this.address());
    }

    public NkColor symbol_normal() {
        return NkStyleCombo.nsymbol_normal(this.address());
    }

    public NkColor symbol_hover() {
        return NkStyleCombo.nsymbol_hover(this.address());
    }

    public NkColor symbol_active() {
        return NkStyleCombo.nsymbol_active(this.address());
    }

    public NkStyleButton button() {
        return NkStyleCombo.nbutton(this.address());
    }

    public int sym_normal() {
        return NkStyleCombo.nsym_normal(this.address());
    }

    public int sym_hover() {
        return NkStyleCombo.nsym_hover(this.address());
    }

    public int sym_active() {
        return NkStyleCombo.nsym_active(this.address());
    }

    public float border() {
        return NkStyleCombo.nborder(this.address());
    }

    public float rounding() {
        return NkStyleCombo.nrounding(this.address());
    }

    public NkVec2 content_padding() {
        return NkStyleCombo.ncontent_padding(this.address());
    }

    public NkVec2 button_padding() {
        return NkStyleCombo.nbutton_padding(this.address());
    }

    public NkVec2 spacing() {
        return NkStyleCombo.nspacing(this.address());
    }

    public NkStyleCombo normal(NkStyleItem value) {
        NkStyleCombo.nnormal(this.address(), value);
        return this;
    }

    public NkStyleCombo hover(NkStyleItem value) {
        NkStyleCombo.nhover(this.address(), value);
        return this;
    }

    public NkStyleCombo active(NkStyleItem value) {
        NkStyleCombo.nactive(this.address(), value);
        return this;
    }

    public NkStyleCombo border_color(NkColor value) {
        NkStyleCombo.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleCombo label_normal(NkColor value) {
        NkStyleCombo.nlabel_normal(this.address(), value);
        return this;
    }

    public NkStyleCombo label_hover(NkColor value) {
        NkStyleCombo.nlabel_hover(this.address(), value);
        return this;
    }

    public NkStyleCombo label_active(NkColor value) {
        NkStyleCombo.nlabel_active(this.address(), value);
        return this;
    }

    public NkStyleCombo symbol_normal(NkColor value) {
        NkStyleCombo.nsymbol_normal(this.address(), value);
        return this;
    }

    public NkStyleCombo symbol_hover(NkColor value) {
        NkStyleCombo.nsymbol_hover(this.address(), value);
        return this;
    }

    public NkStyleCombo symbol_active(NkColor value) {
        NkStyleCombo.nsymbol_active(this.address(), value);
        return this;
    }

    public NkStyleCombo button(NkStyleButton value) {
        NkStyleCombo.nbutton(this.address(), value);
        return this;
    }

    public NkStyleCombo sym_normal(int value) {
        NkStyleCombo.nsym_normal(this.address(), value);
        return this;
    }

    public NkStyleCombo sym_hover(int value) {
        NkStyleCombo.nsym_hover(this.address(), value);
        return this;
    }

    public NkStyleCombo sym_active(int value) {
        NkStyleCombo.nsym_active(this.address(), value);
        return this;
    }

    public NkStyleCombo border(float value) {
        NkStyleCombo.nborder(this.address(), value);
        return this;
    }

    public NkStyleCombo rounding(float value) {
        NkStyleCombo.nrounding(this.address(), value);
        return this;
    }

    public NkStyleCombo content_padding(NkVec2 value) {
        NkStyleCombo.ncontent_padding(this.address(), value);
        return this;
    }

    public NkStyleCombo button_padding(NkVec2 value) {
        NkStyleCombo.nbutton_padding(this.address(), value);
        return this;
    }

    public NkStyleCombo spacing(NkVec2 value) {
        NkStyleCombo.nspacing(this.address(), value);
        return this;
    }

    public NkStyleCombo set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkColor label_normal, NkColor label_hover, NkColor label_active, NkColor symbol_normal, NkColor symbol_hover, NkColor symbol_active, NkStyleButton button, int sym_normal, int sym_hover, int sym_active, float border, float rounding, NkVec2 content_padding, NkVec2 button_padding, NkVec2 spacing) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.label_normal(label_normal);
        this.label_hover(label_hover);
        this.label_active(label_active);
        this.symbol_normal(symbol_normal);
        this.symbol_hover(symbol_hover);
        this.symbol_active(symbol_active);
        this.button(button);
        this.sym_normal(sym_normal);
        this.sym_hover(sym_hover);
        this.sym_active(sym_active);
        this.border(border);
        this.rounding(rounding);
        this.content_padding(content_padding);
        this.button_padding(button_padding);
        this.spacing(spacing);
        return this;
    }

    public NkStyleCombo set(NkStyleCombo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleCombo malloc() {
        return NkStyleCombo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleCombo calloc() {
        return NkStyleCombo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleCombo create() {
        return new NkStyleCombo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleCombo create(long address) {
        return address == 0L ? null : new NkStyleCombo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleCombo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleCombo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleCombo mallocStack() {
        return NkStyleCombo.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleCombo callocStack() {
        return NkStyleCombo.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleCombo mallocStack(MemoryStack stack) {
        return NkStyleCombo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleCombo callocStack(MemoryStack stack) {
        return NkStyleCombo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleCombo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleCombo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleCombo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleCombo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nlabel_normal(long struct) {
        return NkColor.create(struct + (long)LABEL_NORMAL);
    }

    public static NkColor nlabel_hover(long struct) {
        return NkColor.create(struct + (long)LABEL_HOVER);
    }

    public static NkColor nlabel_active(long struct) {
        return NkColor.create(struct + (long)LABEL_ACTIVE);
    }

    public static NkColor nsymbol_normal(long struct) {
        return NkColor.create(struct + (long)SYMBOL_NORMAL);
    }

    public static NkColor nsymbol_hover(long struct) {
        return NkColor.create(struct + (long)SYMBOL_HOVER);
    }

    public static NkColor nsymbol_active(long struct) {
        return NkColor.create(struct + (long)SYMBOL_ACTIVE);
    }

    public static NkStyleButton nbutton(long struct) {
        return NkStyleButton.create(struct + (long)BUTTON);
    }

    public static int nsym_normal(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SYM_NORMAL);
    }

    public static int nsym_hover(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SYM_HOVER);
    }

    public static int nsym_active(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SYM_ACTIVE);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 ncontent_padding(long struct) {
        return NkVec2.create(struct + (long)CONTENT_PADDING);
    }

    public static NkVec2 nbutton_padding(long struct) {
        return NkVec2.create(struct + (long)BUTTON_PADDING);
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nlabel_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_NORMAL, NkColor.SIZEOF);
    }

    public static void nlabel_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_HOVER, NkColor.SIZEOF);
    }

    public static void nlabel_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_ACTIVE, NkColor.SIZEOF);
    }

    public static void nsymbol_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SYMBOL_NORMAL, NkColor.SIZEOF);
    }

    public static void nsymbol_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SYMBOL_HOVER, NkColor.SIZEOF);
    }

    public static void nsymbol_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SYMBOL_ACTIVE, NkColor.SIZEOF);
    }

    public static void nbutton(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nsym_normal(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SYM_NORMAL, value);
    }

    public static void nsym_hover(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SYM_HOVER, value);
    }

    public static void nsym_active(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SYM_ACTIVE, value);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void ncontent_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CONTENT_PADDING, NkVec2.SIZEOF);
    }

    public static void nbutton_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BUTTON_PADDING, NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SPACING, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleCombo.__struct(NkStyleCombo.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleCombo.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleCombo.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleCombo.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleCombo.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleCombo.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleCombo.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleCombo.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleCombo.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleCombo.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleCombo.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleCombo.__member(4), NkStyleCombo.__member(4), NkStyleCombo.__member(4), NkStyleCombo.__member(4), NkStyleCombo.__member(4), NkStyleCombo.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleCombo.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleCombo.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        LABEL_NORMAL = layout.offsetof(4);
        LABEL_HOVER = layout.offsetof(5);
        LABEL_ACTIVE = layout.offsetof(6);
        SYMBOL_NORMAL = layout.offsetof(7);
        SYMBOL_HOVER = layout.offsetof(8);
        SYMBOL_ACTIVE = layout.offsetof(9);
        BUTTON = layout.offsetof(10);
        SYM_NORMAL = layout.offsetof(11);
        SYM_HOVER = layout.offsetof(12);
        SYM_ACTIVE = layout.offsetof(13);
        BORDER = layout.offsetof(14);
        ROUNDING = layout.offsetof(15);
        CONTENT_PADDING = layout.offsetof(16);
        BUTTON_PADDING = layout.offsetof(17);
        SPACING = layout.offsetof(18);
    }

    public static class Buffer
    extends StructBuffer<NkStyleCombo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleCombo newInstance(long address) {
            return new NkStyleCombo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleCombo.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleCombo.nhover(this.address());
        }

        public NkStyleItem active() {
            return NkStyleCombo.nactive(this.address());
        }

        public NkColor border_color() {
            return NkStyleCombo.nborder_color(this.address());
        }

        public NkColor label_normal() {
            return NkStyleCombo.nlabel_normal(this.address());
        }

        public NkColor label_hover() {
            return NkStyleCombo.nlabel_hover(this.address());
        }

        public NkColor label_active() {
            return NkStyleCombo.nlabel_active(this.address());
        }

        public NkColor symbol_normal() {
            return NkStyleCombo.nsymbol_normal(this.address());
        }

        public NkColor symbol_hover() {
            return NkStyleCombo.nsymbol_hover(this.address());
        }

        public NkColor symbol_active() {
            return NkStyleCombo.nsymbol_active(this.address());
        }

        public NkStyleButton button() {
            return NkStyleCombo.nbutton(this.address());
        }

        public int sym_normal() {
            return NkStyleCombo.nsym_normal(this.address());
        }

        public int sym_hover() {
            return NkStyleCombo.nsym_hover(this.address());
        }

        public int sym_active() {
            return NkStyleCombo.nsym_active(this.address());
        }

        public float border() {
            return NkStyleCombo.nborder(this.address());
        }

        public float rounding() {
            return NkStyleCombo.nrounding(this.address());
        }

        public NkVec2 content_padding() {
            return NkStyleCombo.ncontent_padding(this.address());
        }

        public NkVec2 button_padding() {
            return NkStyleCombo.nbutton_padding(this.address());
        }

        public NkVec2 spacing() {
            return NkStyleCombo.nspacing(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleCombo.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleCombo.nhover(this.address(), value);
            return this;
        }

        public Buffer active(NkStyleItem value) {
            NkStyleCombo.nactive(this.address(), value);
            return this;
        }

        public Buffer border_color(NkColor value) {
            NkStyleCombo.nborder_color(this.address(), value);
            return this;
        }

        public Buffer label_normal(NkColor value) {
            NkStyleCombo.nlabel_normal(this.address(), value);
            return this;
        }

        public Buffer label_hover(NkColor value) {
            NkStyleCombo.nlabel_hover(this.address(), value);
            return this;
        }

        public Buffer label_active(NkColor value) {
            NkStyleCombo.nlabel_active(this.address(), value);
            return this;
        }

        public Buffer symbol_normal(NkColor value) {
            NkStyleCombo.nsymbol_normal(this.address(), value);
            return this;
        }

        public Buffer symbol_hover(NkColor value) {
            NkStyleCombo.nsymbol_hover(this.address(), value);
            return this;
        }

        public Buffer symbol_active(NkColor value) {
            NkStyleCombo.nsymbol_active(this.address(), value);
            return this;
        }

        public Buffer button(NkStyleButton value) {
            NkStyleCombo.nbutton(this.address(), value);
            return this;
        }

        public Buffer sym_normal(int value) {
            NkStyleCombo.nsym_normal(this.address(), value);
            return this;
        }

        public Buffer sym_hover(int value) {
            NkStyleCombo.nsym_hover(this.address(), value);
            return this;
        }

        public Buffer sym_active(int value) {
            NkStyleCombo.nsym_active(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleCombo.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleCombo.nrounding(this.address(), value);
            return this;
        }

        public Buffer content_padding(NkVec2 value) {
            NkStyleCombo.ncontent_padding(this.address(), value);
            return this;
        }

        public Buffer button_padding(NkVec2 value) {
            NkStyleCombo.nbutton_padding(this.address(), value);
            return this;
        }

        public Buffer spacing(NkVec2 value) {
            NkStyleCombo.nspacing(this.address(), value);
            return this;
        }
    }
}

