/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkStyleItemData;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleItem
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DATA;

    NkStyleItem(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleItem(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleItem.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return NkStyleItem.ntype(this.address());
    }

    public NkStyleItemData data() {
        return NkStyleItem.ndata(this.address());
    }

    public NkStyleItem type(int value) {
        NkStyleItem.ntype(this.address(), value);
        return this;
    }

    public NkStyleItem data(NkStyleItemData value) {
        NkStyleItem.ndata(this.address(), value);
        return this;
    }

    public NkStyleItem set(int type, NkStyleItemData data) {
        this.type(type);
        this.data(data);
        return this;
    }

    public NkStyleItem set(NkStyleItem src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleItem malloc() {
        return NkStyleItem.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleItem calloc() {
        return NkStyleItem.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleItem create() {
        return new NkStyleItem(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleItem create(long address) {
        return address == 0L ? null : new NkStyleItem(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleItem.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleItem.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleItem mallocStack() {
        return NkStyleItem.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleItem callocStack() {
        return NkStyleItem.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleItem mallocStack(MemoryStack stack) {
        return NkStyleItem.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleItem callocStack(MemoryStack stack) {
        return NkStyleItem.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleItem.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleItem.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleItem.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleItem.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static NkStyleItemData ndata(long struct) {
        return NkStyleItemData.create(struct + (long)DATA);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void ndata(long struct, NkStyleItemData value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DATA, NkStyleItemData.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleItem.__struct(NkStyleItem.__member(4), NkStyleItem.__member(NkStyleItemData.SIZEOF, NkStyleItemData.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStyleItem, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleItem newInstance(long address) {
            return new NkStyleItem(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int type() {
            return NkStyleItem.ntype(this.address());
        }

        public NkStyleItemData data() {
            return NkStyleItem.ndata(this.address());
        }

        public Buffer type(int value) {
            NkStyleItem.ntype(this.address(), value);
            return this;
        }

        public Buffer data(NkStyleItemData value) {
            NkStyleItem.ndata(this.address(), value);
            return this;
        }
    }
}

