/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleProgress
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_ACTIVE;
    public static final int CURSOR_BORDER_COLOR;
    public static final int ROUNDING;
    public static final int BORDER;
    public static final int CURSOR_BORDER;
    public static final int CURSOR_ROUNDING;
    public static final int PADDING;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    NkStyleProgress(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleProgress(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleProgress.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleProgress.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleProgress.nhover(this.address());
    }

    public NkStyleItem active() {
        return NkStyleProgress.nactive(this.address());
    }

    public NkColor border_color() {
        return NkStyleProgress.nborder_color(this.address());
    }

    public NkStyleItem cursor_normal() {
        return NkStyleProgress.ncursor_normal(this.address());
    }

    public NkStyleItem cursor_hover() {
        return NkStyleProgress.ncursor_hover(this.address());
    }

    public NkStyleItem cursor_active() {
        return NkStyleProgress.ncursor_active(this.address());
    }

    public NkColor cursor_border_color() {
        return NkStyleProgress.ncursor_border_color(this.address());
    }

    public float rounding() {
        return NkStyleProgress.nrounding(this.address());
    }

    public float border() {
        return NkStyleProgress.nborder(this.address());
    }

    public float cursor_border() {
        return NkStyleProgress.ncursor_border(this.address());
    }

    public float cursor_rounding() {
        return NkStyleProgress.ncursor_rounding(this.address());
    }

    public NkVec2 padding() {
        return NkStyleProgress.npadding(this.address());
    }

    public NkHandle userdata() {
        return NkStyleProgress.nuserdata(this.address());
    }

    public NkDrawBeginCallback draw_begin() {
        return NkStyleProgress.ndraw_begin(this.address());
    }

    public NkDrawEndCallback draw_end() {
        return NkStyleProgress.ndraw_end(this.address());
    }

    public NkStyleProgress normal(NkStyleItem value) {
        NkStyleProgress.nnormal(this.address(), value);
        return this;
    }

    public NkStyleProgress hover(NkStyleItem value) {
        NkStyleProgress.nhover(this.address(), value);
        return this;
    }

    public NkStyleProgress active(NkStyleItem value) {
        NkStyleProgress.nactive(this.address(), value);
        return this;
    }

    public NkStyleProgress border_color(NkColor value) {
        NkStyleProgress.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_normal(NkStyleItem value) {
        NkStyleProgress.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_hover(NkStyleItem value) {
        NkStyleProgress.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_active(NkStyleItem value) {
        NkStyleProgress.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_border_color(NkColor value) {
        NkStyleProgress.ncursor_border_color(this.address(), value);
        return this;
    }

    public NkStyleProgress rounding(float value) {
        NkStyleProgress.nrounding(this.address(), value);
        return this;
    }

    public NkStyleProgress border(float value) {
        NkStyleProgress.nborder(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_border(float value) {
        NkStyleProgress.ncursor_border(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_rounding(float value) {
        NkStyleProgress.ncursor_rounding(this.address(), value);
        return this;
    }

    public NkStyleProgress padding(NkVec2 value) {
        NkStyleProgress.npadding(this.address(), value);
        return this;
    }

    public NkStyleProgress userdata(NkHandle value) {
        NkStyleProgress.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleProgress draw_begin(NkDrawBeginCallbackI value) {
        NkStyleProgress.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleProgress draw_end(NkDrawEndCallbackI value) {
        NkStyleProgress.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleProgress set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkStyleItem cursor_active, NkColor cursor_border_color, float rounding, float border, float cursor_border, float cursor_rounding, NkVec2 padding, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_active(cursor_active);
        this.cursor_border_color(cursor_border_color);
        this.rounding(rounding);
        this.border(border);
        this.cursor_border(cursor_border);
        this.cursor_rounding(cursor_rounding);
        this.padding(padding);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleProgress set(NkStyleProgress src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleProgress malloc() {
        return NkStyleProgress.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleProgress calloc() {
        return NkStyleProgress.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleProgress create() {
        return new NkStyleProgress(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleProgress create(long address) {
        return address == 0L ? null : new NkStyleProgress(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleProgress.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleProgress.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleProgress mallocStack() {
        return NkStyleProgress.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleProgress callocStack() {
        return NkStyleProgress.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleProgress mallocStack(MemoryStack stack) {
        return NkStyleProgress.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleProgress callocStack(MemoryStack stack) {
        return NkStyleProgress.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleProgress.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleProgress.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleProgress.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleProgress.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkStyleItem ncursor_active(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_ACTIVE);
    }

    public static NkColor ncursor_border_color(long struct) {
        return NkColor.create(struct + (long)CURSOR_BORDER_COLOR);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float ncursor_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CURSOR_BORDER);
    }

    public static float ncursor_rounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CURSOR_ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_NORMAL, NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_HOVER, NkStyleItem.SIZEOF);
    }

    public static void ncursor_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void ncursor_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void ncursor_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CURSOR_BORDER, value);
    }

    public static void ncursor_rounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CURSOR_ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, NkStyleProgress.addressSafe(value));
    }

    public static void ndraw_end(long struct, NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, NkStyleProgress.addressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleProgress.__struct(NkStyleProgress.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProgress.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProgress.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProgress.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProgress.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProgress.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProgress.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProgress.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProgress.__member(4), NkStyleProgress.__member(4), NkStyleProgress.__member(4), NkStyleProgress.__member(4), NkStyleProgress.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleProgress.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleProgress.__member(POINTER_SIZE), NkStyleProgress.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        CURSOR_NORMAL = layout.offsetof(4);
        CURSOR_HOVER = layout.offsetof(5);
        CURSOR_ACTIVE = layout.offsetof(6);
        CURSOR_BORDER_COLOR = layout.offsetof(7);
        ROUNDING = layout.offsetof(8);
        BORDER = layout.offsetof(9);
        CURSOR_BORDER = layout.offsetof(10);
        CURSOR_ROUNDING = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        USERDATA = layout.offsetof(13);
        DRAW_BEGIN = layout.offsetof(14);
        DRAW_END = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<NkStyleProgress, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleProgress newInstance(long address) {
            return new NkStyleProgress(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleProgress.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleProgress.nhover(this.address());
        }

        public NkStyleItem active() {
            return NkStyleProgress.nactive(this.address());
        }

        public NkColor border_color() {
            return NkStyleProgress.nborder_color(this.address());
        }

        public NkStyleItem cursor_normal() {
            return NkStyleProgress.ncursor_normal(this.address());
        }

        public NkStyleItem cursor_hover() {
            return NkStyleProgress.ncursor_hover(this.address());
        }

        public NkStyleItem cursor_active() {
            return NkStyleProgress.ncursor_active(this.address());
        }

        public NkColor cursor_border_color() {
            return NkStyleProgress.ncursor_border_color(this.address());
        }

        public float rounding() {
            return NkStyleProgress.nrounding(this.address());
        }

        public float border() {
            return NkStyleProgress.nborder(this.address());
        }

        public float cursor_border() {
            return NkStyleProgress.ncursor_border(this.address());
        }

        public float cursor_rounding() {
            return NkStyleProgress.ncursor_rounding(this.address());
        }

        public NkVec2 padding() {
            return NkStyleProgress.npadding(this.address());
        }

        public NkHandle userdata() {
            return NkStyleProgress.nuserdata(this.address());
        }

        public NkDrawBeginCallback draw_begin() {
            return NkStyleProgress.ndraw_begin(this.address());
        }

        public NkDrawEndCallback draw_end() {
            return NkStyleProgress.ndraw_end(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleProgress.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleProgress.nhover(this.address(), value);
            return this;
        }

        public Buffer active(NkStyleItem value) {
            NkStyleProgress.nactive(this.address(), value);
            return this;
        }

        public Buffer border_color(NkColor value) {
            NkStyleProgress.nborder_color(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(NkStyleItem value) {
            NkStyleProgress.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(NkStyleItem value) {
            NkStyleProgress.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_active(NkStyleItem value) {
            NkStyleProgress.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_border_color(NkColor value) {
            NkStyleProgress.ncursor_border_color(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleProgress.nrounding(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleProgress.nborder(this.address(), value);
            return this;
        }

        public Buffer cursor_border(float value) {
            NkStyleProgress.ncursor_border(this.address(), value);
            return this;
        }

        public Buffer cursor_rounding(float value) {
            NkStyleProgress.ncursor_rounding(this.address(), value);
            return this;
        }

        public Buffer padding(NkVec2 value) {
            NkStyleProgress.npadding(this.address(), value);
            return this;
        }

        public Buffer userdata(NkHandle value) {
            NkStyleProgress.nuserdata(this.address(), value);
            return this;
        }

        public Buffer draw_begin(NkDrawBeginCallbackI value) {
            NkStyleProgress.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(NkDrawEndCallbackI value) {
            NkStyleProgress.ndraw_end(this.address(), value);
            return this;
        }
    }
}

