/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleEdit;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleProperty
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int LABEL_NORMAL;
    public static final int LABEL_HOVER;
    public static final int LABEL_ACTIVE;
    public static final int SYM_LEFT;
    public static final int SYM_RIGHT;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int PADDING;
    public static final int EDIT;
    public static final int INC_BUTTON;
    public static final int DEC_BUTTON;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    NkStyleProperty(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleProperty(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleProperty.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleProperty.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleProperty.nhover(this.address());
    }

    public NkStyleItem active() {
        return NkStyleProperty.nactive(this.address());
    }

    public NkColor border_color() {
        return NkStyleProperty.nborder_color(this.address());
    }

    public NkColor label_normal() {
        return NkStyleProperty.nlabel_normal(this.address());
    }

    public NkColor label_hover() {
        return NkStyleProperty.nlabel_hover(this.address());
    }

    public NkColor label_active() {
        return NkStyleProperty.nlabel_active(this.address());
    }

    public int sym_left() {
        return NkStyleProperty.nsym_left(this.address());
    }

    public int sym_right() {
        return NkStyleProperty.nsym_right(this.address());
    }

    public float border() {
        return NkStyleProperty.nborder(this.address());
    }

    public float rounding() {
        return NkStyleProperty.nrounding(this.address());
    }

    public NkVec2 padding() {
        return NkStyleProperty.npadding(this.address());
    }

    public NkStyleEdit edit() {
        return NkStyleProperty.nedit(this.address());
    }

    public NkStyleButton inc_button() {
        return NkStyleProperty.ninc_button(this.address());
    }

    public NkStyleButton dec_button() {
        return NkStyleProperty.ndec_button(this.address());
    }

    public NkHandle userdata() {
        return NkStyleProperty.nuserdata(this.address());
    }

    public NkDrawBeginCallback draw_begin() {
        return NkStyleProperty.ndraw_begin(this.address());
    }

    public NkDrawEndCallback draw_end() {
        return NkStyleProperty.ndraw_end(this.address());
    }

    public NkStyleProperty normal(NkStyleItem value) {
        NkStyleProperty.nnormal(this.address(), value);
        return this;
    }

    public NkStyleProperty hover(NkStyleItem value) {
        NkStyleProperty.nhover(this.address(), value);
        return this;
    }

    public NkStyleProperty active(NkStyleItem value) {
        NkStyleProperty.nactive(this.address(), value);
        return this;
    }

    public NkStyleProperty border_color(NkColor value) {
        NkStyleProperty.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleProperty label_normal(NkColor value) {
        NkStyleProperty.nlabel_normal(this.address(), value);
        return this;
    }

    public NkStyleProperty label_hover(NkColor value) {
        NkStyleProperty.nlabel_hover(this.address(), value);
        return this;
    }

    public NkStyleProperty label_active(NkColor value) {
        NkStyleProperty.nlabel_active(this.address(), value);
        return this;
    }

    public NkStyleProperty sym_left(int value) {
        NkStyleProperty.nsym_left(this.address(), value);
        return this;
    }

    public NkStyleProperty sym_right(int value) {
        NkStyleProperty.nsym_right(this.address(), value);
        return this;
    }

    public NkStyleProperty border(float value) {
        NkStyleProperty.nborder(this.address(), value);
        return this;
    }

    public NkStyleProperty rounding(float value) {
        NkStyleProperty.nrounding(this.address(), value);
        return this;
    }

    public NkStyleProperty padding(NkVec2 value) {
        NkStyleProperty.npadding(this.address(), value);
        return this;
    }

    public NkStyleProperty edit(NkStyleEdit value) {
        NkStyleProperty.nedit(this.address(), value);
        return this;
    }

    public NkStyleProperty inc_button(NkStyleButton value) {
        NkStyleProperty.ninc_button(this.address(), value);
        return this;
    }

    public NkStyleProperty dec_button(NkStyleButton value) {
        NkStyleProperty.ndec_button(this.address(), value);
        return this;
    }

    public NkStyleProperty userdata(NkHandle value) {
        NkStyleProperty.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleProperty draw_begin(NkDrawBeginCallbackI value) {
        NkStyleProperty.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleProperty draw_end(NkDrawEndCallbackI value) {
        NkStyleProperty.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleProperty set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkColor label_normal, NkColor label_hover, NkColor label_active, int sym_left, int sym_right, float border, float rounding, NkVec2 padding, NkStyleEdit edit, NkStyleButton inc_button, NkStyleButton dec_button, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.label_normal(label_normal);
        this.label_hover(label_hover);
        this.label_active(label_active);
        this.sym_left(sym_left);
        this.sym_right(sym_right);
        this.border(border);
        this.rounding(rounding);
        this.padding(padding);
        this.edit(edit);
        this.inc_button(inc_button);
        this.dec_button(dec_button);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleProperty set(NkStyleProperty src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleProperty malloc() {
        return NkStyleProperty.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleProperty calloc() {
        return NkStyleProperty.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleProperty create() {
        return new NkStyleProperty(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleProperty create(long address) {
        return address == 0L ? null : new NkStyleProperty(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleProperty.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleProperty.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleProperty mallocStack() {
        return NkStyleProperty.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleProperty callocStack() {
        return NkStyleProperty.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleProperty mallocStack(MemoryStack stack) {
        return NkStyleProperty.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleProperty callocStack(MemoryStack stack) {
        return NkStyleProperty.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleProperty.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleProperty.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleProperty.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleProperty.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nlabel_normal(long struct) {
        return NkColor.create(struct + (long)LABEL_NORMAL);
    }

    public static NkColor nlabel_hover(long struct) {
        return NkColor.create(struct + (long)LABEL_HOVER);
    }

    public static NkColor nlabel_active(long struct) {
        return NkColor.create(struct + (long)LABEL_ACTIVE);
    }

    public static int nsym_left(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SYM_LEFT);
    }

    public static int nsym_right(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SYM_RIGHT);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkStyleEdit nedit(long struct) {
        return NkStyleEdit.create(struct + (long)EDIT);
    }

    public static NkStyleButton ninc_button(long struct) {
        return NkStyleButton.create(struct + (long)INC_BUTTON);
    }

    public static NkStyleButton ndec_button(long struct) {
        return NkStyleButton.create(struct + (long)DEC_BUTTON);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nlabel_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_NORMAL, NkColor.SIZEOF);
    }

    public static void nlabel_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_HOVER, NkColor.SIZEOF);
    }

    public static void nlabel_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_ACTIVE, NkColor.SIZEOF);
    }

    public static void nsym_left(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SYM_LEFT, value);
    }

    public static void nsym_right(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SYM_RIGHT, value);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nedit(long struct, NkStyleEdit value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EDIT, NkStyleEdit.SIZEOF);
    }

    public static void ninc_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ndec_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, NkStyleProperty.addressSafe(value));
    }

    public static void ndraw_end(long struct, NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, NkStyleProperty.addressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleProperty.__struct(NkStyleProperty.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProperty.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProperty.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(4), NkStyleProperty.__member(4), NkStyleProperty.__member(4), NkStyleProperty.__member(4), NkStyleProperty.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleProperty.__member(NkStyleEdit.SIZEOF, NkStyleEdit.ALIGNOF), NkStyleProperty.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleProperty.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleProperty.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleProperty.__member(POINTER_SIZE), NkStyleProperty.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        LABEL_NORMAL = layout.offsetof(4);
        LABEL_HOVER = layout.offsetof(5);
        LABEL_ACTIVE = layout.offsetof(6);
        SYM_LEFT = layout.offsetof(7);
        SYM_RIGHT = layout.offsetof(8);
        BORDER = layout.offsetof(9);
        ROUNDING = layout.offsetof(10);
        PADDING = layout.offsetof(11);
        EDIT = layout.offsetof(12);
        INC_BUTTON = layout.offsetof(13);
        DEC_BUTTON = layout.offsetof(14);
        USERDATA = layout.offsetof(15);
        DRAW_BEGIN = layout.offsetof(16);
        DRAW_END = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<NkStyleProperty, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleProperty newInstance(long address) {
            return new NkStyleProperty(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleProperty.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleProperty.nhover(this.address());
        }

        public NkStyleItem active() {
            return NkStyleProperty.nactive(this.address());
        }

        public NkColor border_color() {
            return NkStyleProperty.nborder_color(this.address());
        }

        public NkColor label_normal() {
            return NkStyleProperty.nlabel_normal(this.address());
        }

        public NkColor label_hover() {
            return NkStyleProperty.nlabel_hover(this.address());
        }

        public NkColor label_active() {
            return NkStyleProperty.nlabel_active(this.address());
        }

        public int sym_left() {
            return NkStyleProperty.nsym_left(this.address());
        }

        public int sym_right() {
            return NkStyleProperty.nsym_right(this.address());
        }

        public float border() {
            return NkStyleProperty.nborder(this.address());
        }

        public float rounding() {
            return NkStyleProperty.nrounding(this.address());
        }

        public NkVec2 padding() {
            return NkStyleProperty.npadding(this.address());
        }

        public NkStyleEdit edit() {
            return NkStyleProperty.nedit(this.address());
        }

        public NkStyleButton inc_button() {
            return NkStyleProperty.ninc_button(this.address());
        }

        public NkStyleButton dec_button() {
            return NkStyleProperty.ndec_button(this.address());
        }

        public NkHandle userdata() {
            return NkStyleProperty.nuserdata(this.address());
        }

        public NkDrawBeginCallback draw_begin() {
            return NkStyleProperty.ndraw_begin(this.address());
        }

        public NkDrawEndCallback draw_end() {
            return NkStyleProperty.ndraw_end(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleProperty.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleProperty.nhover(this.address(), value);
            return this;
        }

        public Buffer active(NkStyleItem value) {
            NkStyleProperty.nactive(this.address(), value);
            return this;
        }

        public Buffer border_color(NkColor value) {
            NkStyleProperty.nborder_color(this.address(), value);
            return this;
        }

        public Buffer label_normal(NkColor value) {
            NkStyleProperty.nlabel_normal(this.address(), value);
            return this;
        }

        public Buffer label_hover(NkColor value) {
            NkStyleProperty.nlabel_hover(this.address(), value);
            return this;
        }

        public Buffer label_active(NkColor value) {
            NkStyleProperty.nlabel_active(this.address(), value);
            return this;
        }

        public Buffer sym_left(int value) {
            NkStyleProperty.nsym_left(this.address(), value);
            return this;
        }

        public Buffer sym_right(int value) {
            NkStyleProperty.nsym_right(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleProperty.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleProperty.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(NkVec2 value) {
            NkStyleProperty.npadding(this.address(), value);
            return this;
        }

        public Buffer edit(NkStyleEdit value) {
            NkStyleProperty.nedit(this.address(), value);
            return this;
        }

        public Buffer inc_button(NkStyleButton value) {
            NkStyleProperty.ninc_button(this.address(), value);
            return this;
        }

        public Buffer dec_button(NkStyleButton value) {
            NkStyleProperty.ndec_button(this.address(), value);
            return this;
        }

        public Buffer userdata(NkHandle value) {
            NkStyleProperty.nuserdata(this.address(), value);
            return this;
        }

        public Buffer draw_begin(NkDrawBeginCallbackI value) {
            NkStyleProperty.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(NkDrawEndCallbackI value) {
            NkStyleProperty.ndraw_end(this.address(), value);
            return this;
        }
    }
}

