/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleScrollbar
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_ACTIVE;
    public static final int CURSOR_BORDER_COLOR;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int BORDER_CURSOR;
    public static final int ROUNDING_CURSOR;
    public static final int PADDING;
    public static final int SHOW_BUTTONS;
    public static final int INC_BUTTON;
    public static final int DEC_BUTTON;
    public static final int INC_SYMBOL;
    public static final int DEC_SYMBOL;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    NkStyleScrollbar(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleScrollbar(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleScrollbar.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleScrollbar.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleScrollbar.nhover(this.address());
    }

    public NkStyleItem active() {
        return NkStyleScrollbar.nactive(this.address());
    }

    public NkColor border_color() {
        return NkStyleScrollbar.nborder_color(this.address());
    }

    public NkStyleItem cursor_normal() {
        return NkStyleScrollbar.ncursor_normal(this.address());
    }

    public NkStyleItem cursor_hover() {
        return NkStyleScrollbar.ncursor_hover(this.address());
    }

    public NkStyleItem cursor_active() {
        return NkStyleScrollbar.ncursor_active(this.address());
    }

    public NkColor cursor_border_color() {
        return NkStyleScrollbar.ncursor_border_color(this.address());
    }

    public float border() {
        return NkStyleScrollbar.nborder(this.address());
    }

    public float rounding() {
        return NkStyleScrollbar.nrounding(this.address());
    }

    public float border_cursor() {
        return NkStyleScrollbar.nborder_cursor(this.address());
    }

    public float rounding_cursor() {
        return NkStyleScrollbar.nrounding_cursor(this.address());
    }

    public NkVec2 padding() {
        return NkStyleScrollbar.npadding(this.address());
    }

    public int show_buttons() {
        return NkStyleScrollbar.nshow_buttons(this.address());
    }

    public NkStyleButton inc_button() {
        return NkStyleScrollbar.ninc_button(this.address());
    }

    public NkStyleButton dec_button() {
        return NkStyleScrollbar.ndec_button(this.address());
    }

    public int inc_symbol() {
        return NkStyleScrollbar.ninc_symbol(this.address());
    }

    public int dec_symbol() {
        return NkStyleScrollbar.ndec_symbol(this.address());
    }

    public NkHandle userdata() {
        return NkStyleScrollbar.nuserdata(this.address());
    }

    public NkDrawBeginCallback draw_begin() {
        return NkStyleScrollbar.ndraw_begin(this.address());
    }

    public NkDrawEndCallback draw_end() {
        return NkStyleScrollbar.ndraw_end(this.address());
    }

    public NkStyleScrollbar normal(NkStyleItem value) {
        NkStyleScrollbar.nnormal(this.address(), value);
        return this;
    }

    public NkStyleScrollbar hover(NkStyleItem value) {
        NkStyleScrollbar.nhover(this.address(), value);
        return this;
    }

    public NkStyleScrollbar active(NkStyleItem value) {
        NkStyleScrollbar.nactive(this.address(), value);
        return this;
    }

    public NkStyleScrollbar border_color(NkColor value) {
        NkStyleScrollbar.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_normal(NkStyleItem value) {
        NkStyleScrollbar.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_hover(NkStyleItem value) {
        NkStyleScrollbar.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_active(NkStyleItem value) {
        NkStyleScrollbar.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_border_color(NkColor value) {
        NkStyleScrollbar.ncursor_border_color(this.address(), value);
        return this;
    }

    public NkStyleScrollbar border(float value) {
        NkStyleScrollbar.nborder(this.address(), value);
        return this;
    }

    public NkStyleScrollbar rounding(float value) {
        NkStyleScrollbar.nrounding(this.address(), value);
        return this;
    }

    public NkStyleScrollbar border_cursor(float value) {
        NkStyleScrollbar.nborder_cursor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar rounding_cursor(float value) {
        NkStyleScrollbar.nrounding_cursor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar padding(NkVec2 value) {
        NkStyleScrollbar.npadding(this.address(), value);
        return this;
    }

    public NkStyleScrollbar show_buttons(int value) {
        NkStyleScrollbar.nshow_buttons(this.address(), value);
        return this;
    }

    public NkStyleScrollbar inc_button(NkStyleButton value) {
        NkStyleScrollbar.ninc_button(this.address(), value);
        return this;
    }

    public NkStyleScrollbar dec_button(NkStyleButton value) {
        NkStyleScrollbar.ndec_button(this.address(), value);
        return this;
    }

    public NkStyleScrollbar inc_symbol(int value) {
        NkStyleScrollbar.ninc_symbol(this.address(), value);
        return this;
    }

    public NkStyleScrollbar dec_symbol(int value) {
        NkStyleScrollbar.ndec_symbol(this.address(), value);
        return this;
    }

    public NkStyleScrollbar userdata(NkHandle value) {
        NkStyleScrollbar.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleScrollbar draw_begin(NkDrawBeginCallbackI value) {
        NkStyleScrollbar.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleScrollbar draw_end(NkDrawEndCallbackI value) {
        NkStyleScrollbar.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleScrollbar set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkStyleItem cursor_active, NkColor cursor_border_color, float border, float rounding, float border_cursor, float rounding_cursor, NkVec2 padding, int show_buttons, NkStyleButton inc_button, NkStyleButton dec_button, int inc_symbol, int dec_symbol, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_active(cursor_active);
        this.cursor_border_color(cursor_border_color);
        this.border(border);
        this.rounding(rounding);
        this.border_cursor(border_cursor);
        this.rounding_cursor(rounding_cursor);
        this.padding(padding);
        this.show_buttons(show_buttons);
        this.inc_button(inc_button);
        this.dec_button(dec_button);
        this.inc_symbol(inc_symbol);
        this.dec_symbol(dec_symbol);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleScrollbar set(NkStyleScrollbar src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleScrollbar malloc() {
        return NkStyleScrollbar.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleScrollbar calloc() {
        return NkStyleScrollbar.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleScrollbar create() {
        return new NkStyleScrollbar(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleScrollbar create(long address) {
        return address == 0L ? null : new NkStyleScrollbar(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleScrollbar.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleScrollbar.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleScrollbar mallocStack() {
        return NkStyleScrollbar.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleScrollbar callocStack() {
        return NkStyleScrollbar.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleScrollbar mallocStack(MemoryStack stack) {
        return NkStyleScrollbar.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleScrollbar callocStack(MemoryStack stack) {
        return NkStyleScrollbar.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleScrollbar.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleScrollbar.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleScrollbar.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleScrollbar.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkStyleItem ncursor_active(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_ACTIVE);
    }

    public static NkColor ncursor_border_color(long struct) {
        return NkColor.create(struct + (long)CURSOR_BORDER_COLOR);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static float nborder_cursor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER_CURSOR);
    }

    public static float nrounding_cursor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING_CURSOR);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static int nshow_buttons(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHOW_BUTTONS);
    }

    public static NkStyleButton ninc_button(long struct) {
        return NkStyleButton.create(struct + (long)INC_BUTTON);
    }

    public static NkStyleButton ndec_button(long struct) {
        return NkStyleButton.create(struct + (long)DEC_BUTTON);
    }

    public static int ninc_symbol(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INC_SYMBOL);
    }

    public static int ndec_symbol(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEC_SYMBOL);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_NORMAL, NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_HOVER, NkStyleItem.SIZEOF);
    }

    public static void ncursor_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void ncursor_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void nborder_cursor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER_CURSOR, value);
    }

    public static void nrounding_cursor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING_CURSOR, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nshow_buttons(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHOW_BUTTONS, value);
    }

    public static void ninc_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ndec_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ninc_symbol(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INC_SYMBOL, value);
    }

    public static void ndec_symbol(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEC_SYMBOL, value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, NkStyleScrollbar.addressSafe(value));
    }

    public static void ndraw_end(long struct, NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, NkStyleScrollbar.addressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleScrollbar.__struct(NkStyleScrollbar.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleScrollbar.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleScrollbar.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleScrollbar.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleScrollbar.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleScrollbar.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleScrollbar.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleScrollbar.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleScrollbar.__member(4), NkStyleScrollbar.__member(4), NkStyleScrollbar.__member(4), NkStyleScrollbar.__member(4), NkStyleScrollbar.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleScrollbar.__member(4), NkStyleScrollbar.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleScrollbar.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleScrollbar.__member(4), NkStyleScrollbar.__member(4), NkStyleScrollbar.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleScrollbar.__member(POINTER_SIZE), NkStyleScrollbar.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        CURSOR_NORMAL = layout.offsetof(4);
        CURSOR_HOVER = layout.offsetof(5);
        CURSOR_ACTIVE = layout.offsetof(6);
        CURSOR_BORDER_COLOR = layout.offsetof(7);
        BORDER = layout.offsetof(8);
        ROUNDING = layout.offsetof(9);
        BORDER_CURSOR = layout.offsetof(10);
        ROUNDING_CURSOR = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        SHOW_BUTTONS = layout.offsetof(13);
        INC_BUTTON = layout.offsetof(14);
        DEC_BUTTON = layout.offsetof(15);
        INC_SYMBOL = layout.offsetof(16);
        DEC_SYMBOL = layout.offsetof(17);
        USERDATA = layout.offsetof(18);
        DRAW_BEGIN = layout.offsetof(19);
        DRAW_END = layout.offsetof(20);
    }

    public static class Buffer
    extends StructBuffer<NkStyleScrollbar, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleScrollbar newInstance(long address) {
            return new NkStyleScrollbar(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleScrollbar.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleScrollbar.nhover(this.address());
        }

        public NkStyleItem active() {
            return NkStyleScrollbar.nactive(this.address());
        }

        public NkColor border_color() {
            return NkStyleScrollbar.nborder_color(this.address());
        }

        public NkStyleItem cursor_normal() {
            return NkStyleScrollbar.ncursor_normal(this.address());
        }

        public NkStyleItem cursor_hover() {
            return NkStyleScrollbar.ncursor_hover(this.address());
        }

        public NkStyleItem cursor_active() {
            return NkStyleScrollbar.ncursor_active(this.address());
        }

        public NkColor cursor_border_color() {
            return NkStyleScrollbar.ncursor_border_color(this.address());
        }

        public float border() {
            return NkStyleScrollbar.nborder(this.address());
        }

        public float rounding() {
            return NkStyleScrollbar.nrounding(this.address());
        }

        public float border_cursor() {
            return NkStyleScrollbar.nborder_cursor(this.address());
        }

        public float rounding_cursor() {
            return NkStyleScrollbar.nrounding_cursor(this.address());
        }

        public NkVec2 padding() {
            return NkStyleScrollbar.npadding(this.address());
        }

        public int show_buttons() {
            return NkStyleScrollbar.nshow_buttons(this.address());
        }

        public NkStyleButton inc_button() {
            return NkStyleScrollbar.ninc_button(this.address());
        }

        public NkStyleButton dec_button() {
            return NkStyleScrollbar.ndec_button(this.address());
        }

        public int inc_symbol() {
            return NkStyleScrollbar.ninc_symbol(this.address());
        }

        public int dec_symbol() {
            return NkStyleScrollbar.ndec_symbol(this.address());
        }

        public NkHandle userdata() {
            return NkStyleScrollbar.nuserdata(this.address());
        }

        public NkDrawBeginCallback draw_begin() {
            return NkStyleScrollbar.ndraw_begin(this.address());
        }

        public NkDrawEndCallback draw_end() {
            return NkStyleScrollbar.ndraw_end(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleScrollbar.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleScrollbar.nhover(this.address(), value);
            return this;
        }

        public Buffer active(NkStyleItem value) {
            NkStyleScrollbar.nactive(this.address(), value);
            return this;
        }

        public Buffer border_color(NkColor value) {
            NkStyleScrollbar.nborder_color(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(NkStyleItem value) {
            NkStyleScrollbar.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(NkStyleItem value) {
            NkStyleScrollbar.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_active(NkStyleItem value) {
            NkStyleScrollbar.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_border_color(NkColor value) {
            NkStyleScrollbar.ncursor_border_color(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleScrollbar.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleScrollbar.nrounding(this.address(), value);
            return this;
        }

        public Buffer border_cursor(float value) {
            NkStyleScrollbar.nborder_cursor(this.address(), value);
            return this;
        }

        public Buffer rounding_cursor(float value) {
            NkStyleScrollbar.nrounding_cursor(this.address(), value);
            return this;
        }

        public Buffer padding(NkVec2 value) {
            NkStyleScrollbar.npadding(this.address(), value);
            return this;
        }

        public Buffer show_buttons(int value) {
            NkStyleScrollbar.nshow_buttons(this.address(), value);
            return this;
        }

        public Buffer inc_button(NkStyleButton value) {
            NkStyleScrollbar.ninc_button(this.address(), value);
            return this;
        }

        public Buffer dec_button(NkStyleButton value) {
            NkStyleScrollbar.ndec_button(this.address(), value);
            return this;
        }

        public Buffer inc_symbol(int value) {
            NkStyleScrollbar.ninc_symbol(this.address(), value);
            return this;
        }

        public Buffer dec_symbol(int value) {
            NkStyleScrollbar.ndec_symbol(this.address(), value);
            return this;
        }

        public Buffer userdata(NkHandle value) {
            NkStyleScrollbar.nuserdata(this.address(), value);
            return this;
        }

        public Buffer draw_begin(NkDrawBeginCallbackI value) {
            NkStyleScrollbar.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(NkDrawEndCallbackI value) {
            NkStyleScrollbar.ndraw_end(this.address(), value);
            return this;
        }
    }
}

