/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleSelectable
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int PRESSED;
    public static final int NORMAL_ACTIVE;
    public static final int HOVER_ACTIVE;
    public static final int PRESSED_ACTIVE;
    public static final int TEXT_NORMAL;
    public static final int TEXT_HOVER;
    public static final int TEXT_PRESSED;
    public static final int TEXT_NORMAL_ACTIVE;
    public static final int TEXT_HOVER_ACTIVE;
    public static final int TEXT_PRESSED_ACTIVE;
    public static final int TEXT_BACKGROUND;
    public static final int TEXT_ALIGNMENT;
    public static final int ROUNDING;
    public static final int PADDING;
    public static final int TOUCH_PADDING;
    public static final int IMAGE_PADDING;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    NkStyleSelectable(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleSelectable(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleSelectable.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleSelectable.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleSelectable.nhover(this.address());
    }

    public NkStyleItem pressed() {
        return NkStyleSelectable.npressed(this.address());
    }

    public NkStyleItem normal_active() {
        return NkStyleSelectable.nnormal_active(this.address());
    }

    public NkStyleItem hover_active() {
        return NkStyleSelectable.nhover_active(this.address());
    }

    public NkStyleItem pressed_active() {
        return NkStyleSelectable.npressed_active(this.address());
    }

    public NkColor text_normal() {
        return NkStyleSelectable.ntext_normal(this.address());
    }

    public NkColor text_hover() {
        return NkStyleSelectable.ntext_hover(this.address());
    }

    public NkColor text_pressed() {
        return NkStyleSelectable.ntext_pressed(this.address());
    }

    public NkColor text_normal_active() {
        return NkStyleSelectable.ntext_normal_active(this.address());
    }

    public NkColor text_hover_active() {
        return NkStyleSelectable.ntext_hover_active(this.address());
    }

    public NkColor text_pressed_active() {
        return NkStyleSelectable.ntext_pressed_active(this.address());
    }

    public NkColor text_background() {
        return NkStyleSelectable.ntext_background(this.address());
    }

    public int text_alignment() {
        return NkStyleSelectable.ntext_alignment(this.address());
    }

    public float rounding() {
        return NkStyleSelectable.nrounding(this.address());
    }

    public NkVec2 padding() {
        return NkStyleSelectable.npadding(this.address());
    }

    public NkVec2 touch_padding() {
        return NkStyleSelectable.ntouch_padding(this.address());
    }

    public NkVec2 image_padding() {
        return NkStyleSelectable.nimage_padding(this.address());
    }

    public NkHandle userdata() {
        return NkStyleSelectable.nuserdata(this.address());
    }

    public NkDrawBeginCallback draw_begin() {
        return NkStyleSelectable.ndraw_begin(this.address());
    }

    public NkDrawEndCallback draw_end() {
        return NkStyleSelectable.ndraw_end(this.address());
    }

    public NkStyleSelectable normal(NkStyleItem value) {
        NkStyleSelectable.nnormal(this.address(), value);
        return this;
    }

    public NkStyleSelectable hover(NkStyleItem value) {
        NkStyleSelectable.nhover(this.address(), value);
        return this;
    }

    public NkStyleSelectable pressed(NkStyleItem value) {
        NkStyleSelectable.npressed(this.address(), value);
        return this;
    }

    public NkStyleSelectable normal_active(NkStyleItem value) {
        NkStyleSelectable.nnormal_active(this.address(), value);
        return this;
    }

    public NkStyleSelectable hover_active(NkStyleItem value) {
        NkStyleSelectable.nhover_active(this.address(), value);
        return this;
    }

    public NkStyleSelectable pressed_active(NkStyleItem value) {
        NkStyleSelectable.npressed_active(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_normal(NkColor value) {
        NkStyleSelectable.ntext_normal(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_hover(NkColor value) {
        NkStyleSelectable.ntext_hover(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_pressed(NkColor value) {
        NkStyleSelectable.ntext_pressed(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_normal_active(NkColor value) {
        NkStyleSelectable.ntext_normal_active(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_hover_active(NkColor value) {
        NkStyleSelectable.ntext_hover_active(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_pressed_active(NkColor value) {
        NkStyleSelectable.ntext_pressed_active(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_background(NkColor value) {
        NkStyleSelectable.ntext_background(this.address(), value);
        return this;
    }

    public NkStyleSelectable text_alignment(int value) {
        NkStyleSelectable.ntext_alignment(this.address(), value);
        return this;
    }

    public NkStyleSelectable rounding(float value) {
        NkStyleSelectable.nrounding(this.address(), value);
        return this;
    }

    public NkStyleSelectable padding(NkVec2 value) {
        NkStyleSelectable.npadding(this.address(), value);
        return this;
    }

    public NkStyleSelectable touch_padding(NkVec2 value) {
        NkStyleSelectable.ntouch_padding(this.address(), value);
        return this;
    }

    public NkStyleSelectable image_padding(NkVec2 value) {
        NkStyleSelectable.nimage_padding(this.address(), value);
        return this;
    }

    public NkStyleSelectable userdata(NkHandle value) {
        NkStyleSelectable.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleSelectable draw_begin(NkDrawBeginCallbackI value) {
        NkStyleSelectable.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleSelectable draw_end(NkDrawEndCallbackI value) {
        NkStyleSelectable.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleSelectable set(NkStyleItem normal, NkStyleItem hover, NkStyleItem pressed, NkStyleItem normal_active, NkStyleItem hover_active, NkStyleItem pressed_active, NkColor text_normal, NkColor text_hover, NkColor text_pressed, NkColor text_normal_active, NkColor text_hover_active, NkColor text_pressed_active, NkColor text_background, int text_alignment, float rounding, NkVec2 padding, NkVec2 touch_padding, NkVec2 image_padding, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.pressed(pressed);
        this.normal_active(normal_active);
        this.hover_active(hover_active);
        this.pressed_active(pressed_active);
        this.text_normal(text_normal);
        this.text_hover(text_hover);
        this.text_pressed(text_pressed);
        this.text_normal_active(text_normal_active);
        this.text_hover_active(text_hover_active);
        this.text_pressed_active(text_pressed_active);
        this.text_background(text_background);
        this.text_alignment(text_alignment);
        this.rounding(rounding);
        this.padding(padding);
        this.touch_padding(touch_padding);
        this.image_padding(image_padding);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleSelectable set(NkStyleSelectable src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleSelectable malloc() {
        return NkStyleSelectable.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleSelectable calloc() {
        return NkStyleSelectable.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleSelectable create() {
        return new NkStyleSelectable(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleSelectable create(long address) {
        return address == 0L ? null : new NkStyleSelectable(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleSelectable.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleSelectable.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleSelectable mallocStack() {
        return NkStyleSelectable.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleSelectable callocStack() {
        return NkStyleSelectable.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleSelectable mallocStack(MemoryStack stack) {
        return NkStyleSelectable.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleSelectable callocStack(MemoryStack stack) {
        return NkStyleSelectable.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleSelectable.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleSelectable.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleSelectable.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleSelectable.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem npressed(long struct) {
        return NkStyleItem.create(struct + (long)PRESSED);
    }

    public static NkStyleItem nnormal_active(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL_ACTIVE);
    }

    public static NkStyleItem nhover_active(long struct) {
        return NkStyleItem.create(struct + (long)HOVER_ACTIVE);
    }

    public static NkStyleItem npressed_active(long struct) {
        return NkStyleItem.create(struct + (long)PRESSED_ACTIVE);
    }

    public static NkColor ntext_normal(long struct) {
        return NkColor.create(struct + (long)TEXT_NORMAL);
    }

    public static NkColor ntext_hover(long struct) {
        return NkColor.create(struct + (long)TEXT_HOVER);
    }

    public static NkColor ntext_pressed(long struct) {
        return NkColor.create(struct + (long)TEXT_PRESSED);
    }

    public static NkColor ntext_normal_active(long struct) {
        return NkColor.create(struct + (long)TEXT_NORMAL_ACTIVE);
    }

    public static NkColor ntext_hover_active(long struct) {
        return NkColor.create(struct + (long)TEXT_HOVER_ACTIVE);
    }

    public static NkColor ntext_pressed_active(long struct) {
        return NkColor.create(struct + (long)TEXT_PRESSED_ACTIVE);
    }

    public static NkColor ntext_background(long struct) {
        return NkColor.create(struct + (long)TEXT_BACKGROUND);
    }

    public static int ntext_alignment(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXT_ALIGNMENT);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 ntouch_padding(long struct) {
        return NkVec2.create(struct + (long)TOUCH_PADDING);
    }

    public static NkVec2 nimage_padding(long struct) {
        return NkVec2.create(struct + (long)IMAGE_PADDING);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void npressed(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PRESSED, NkStyleItem.SIZEOF);
    }

    public static void nnormal_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL_ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nhover_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER_ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void npressed_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PRESSED_ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void ntext_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_NORMAL, NkColor.SIZEOF);
    }

    public static void ntext_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_HOVER, NkColor.SIZEOF);
    }

    public static void ntext_pressed(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_PRESSED, NkColor.SIZEOF);
    }

    public static void ntext_normal_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_NORMAL_ACTIVE, NkColor.SIZEOF);
    }

    public static void ntext_hover_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_HOVER_ACTIVE, NkColor.SIZEOF);
    }

    public static void ntext_pressed_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_PRESSED_ACTIVE, NkColor.SIZEOF);
    }

    public static void ntext_background(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_BACKGROUND, NkColor.SIZEOF);
    }

    public static void ntext_alignment(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXT_ALIGNMENT, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void ntouch_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TOUCH_PADDING, NkVec2.SIZEOF);
    }

    public static void nimage_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGE_PADDING, NkVec2.SIZEOF);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, NkStyleSelectable.addressSafe(value));
    }

    public static void ndraw_end(long struct, NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, NkStyleSelectable.addressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleSelectable.__struct(NkStyleSelectable.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSelectable.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSelectable.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSelectable.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSelectable.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSelectable.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSelectable.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSelectable.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSelectable.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSelectable.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSelectable.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSelectable.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSelectable.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSelectable.__member(4), NkStyleSelectable.__member(4), NkStyleSelectable.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleSelectable.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleSelectable.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleSelectable.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleSelectable.__member(POINTER_SIZE), NkStyleSelectable.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        PRESSED = layout.offsetof(2);
        NORMAL_ACTIVE = layout.offsetof(3);
        HOVER_ACTIVE = layout.offsetof(4);
        PRESSED_ACTIVE = layout.offsetof(5);
        TEXT_NORMAL = layout.offsetof(6);
        TEXT_HOVER = layout.offsetof(7);
        TEXT_PRESSED = layout.offsetof(8);
        TEXT_NORMAL_ACTIVE = layout.offsetof(9);
        TEXT_HOVER_ACTIVE = layout.offsetof(10);
        TEXT_PRESSED_ACTIVE = layout.offsetof(11);
        TEXT_BACKGROUND = layout.offsetof(12);
        TEXT_ALIGNMENT = layout.offsetof(13);
        ROUNDING = layout.offsetof(14);
        PADDING = layout.offsetof(15);
        TOUCH_PADDING = layout.offsetof(16);
        IMAGE_PADDING = layout.offsetof(17);
        USERDATA = layout.offsetof(18);
        DRAW_BEGIN = layout.offsetof(19);
        DRAW_END = layout.offsetof(20);
    }

    public static class Buffer
    extends StructBuffer<NkStyleSelectable, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleSelectable newInstance(long address) {
            return new NkStyleSelectable(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleSelectable.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleSelectable.nhover(this.address());
        }

        public NkStyleItem pressed() {
            return NkStyleSelectable.npressed(this.address());
        }

        public NkStyleItem normal_active() {
            return NkStyleSelectable.nnormal_active(this.address());
        }

        public NkStyleItem hover_active() {
            return NkStyleSelectable.nhover_active(this.address());
        }

        public NkStyleItem pressed_active() {
            return NkStyleSelectable.npressed_active(this.address());
        }

        public NkColor text_normal() {
            return NkStyleSelectable.ntext_normal(this.address());
        }

        public NkColor text_hover() {
            return NkStyleSelectable.ntext_hover(this.address());
        }

        public NkColor text_pressed() {
            return NkStyleSelectable.ntext_pressed(this.address());
        }

        public NkColor text_normal_active() {
            return NkStyleSelectable.ntext_normal_active(this.address());
        }

        public NkColor text_hover_active() {
            return NkStyleSelectable.ntext_hover_active(this.address());
        }

        public NkColor text_pressed_active() {
            return NkStyleSelectable.ntext_pressed_active(this.address());
        }

        public NkColor text_background() {
            return NkStyleSelectable.ntext_background(this.address());
        }

        public int text_alignment() {
            return NkStyleSelectable.ntext_alignment(this.address());
        }

        public float rounding() {
            return NkStyleSelectable.nrounding(this.address());
        }

        public NkVec2 padding() {
            return NkStyleSelectable.npadding(this.address());
        }

        public NkVec2 touch_padding() {
            return NkStyleSelectable.ntouch_padding(this.address());
        }

        public NkVec2 image_padding() {
            return NkStyleSelectable.nimage_padding(this.address());
        }

        public NkHandle userdata() {
            return NkStyleSelectable.nuserdata(this.address());
        }

        public NkDrawBeginCallback draw_begin() {
            return NkStyleSelectable.ndraw_begin(this.address());
        }

        public NkDrawEndCallback draw_end() {
            return NkStyleSelectable.ndraw_end(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleSelectable.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleSelectable.nhover(this.address(), value);
            return this;
        }

        public Buffer pressed(NkStyleItem value) {
            NkStyleSelectable.npressed(this.address(), value);
            return this;
        }

        public Buffer normal_active(NkStyleItem value) {
            NkStyleSelectable.nnormal_active(this.address(), value);
            return this;
        }

        public Buffer hover_active(NkStyleItem value) {
            NkStyleSelectable.nhover_active(this.address(), value);
            return this;
        }

        public Buffer pressed_active(NkStyleItem value) {
            NkStyleSelectable.npressed_active(this.address(), value);
            return this;
        }

        public Buffer text_normal(NkColor value) {
            NkStyleSelectable.ntext_normal(this.address(), value);
            return this;
        }

        public Buffer text_hover(NkColor value) {
            NkStyleSelectable.ntext_hover(this.address(), value);
            return this;
        }

        public Buffer text_pressed(NkColor value) {
            NkStyleSelectable.ntext_pressed(this.address(), value);
            return this;
        }

        public Buffer text_normal_active(NkColor value) {
            NkStyleSelectable.ntext_normal_active(this.address(), value);
            return this;
        }

        public Buffer text_hover_active(NkColor value) {
            NkStyleSelectable.ntext_hover_active(this.address(), value);
            return this;
        }

        public Buffer text_pressed_active(NkColor value) {
            NkStyleSelectable.ntext_pressed_active(this.address(), value);
            return this;
        }

        public Buffer text_background(NkColor value) {
            NkStyleSelectable.ntext_background(this.address(), value);
            return this;
        }

        public Buffer text_alignment(int value) {
            NkStyleSelectable.ntext_alignment(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleSelectable.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(NkVec2 value) {
            NkStyleSelectable.npadding(this.address(), value);
            return this;
        }

        public Buffer touch_padding(NkVec2 value) {
            NkStyleSelectable.ntouch_padding(this.address(), value);
            return this;
        }

        public Buffer image_padding(NkVec2 value) {
            NkStyleSelectable.nimage_padding(this.address(), value);
            return this;
        }

        public Buffer userdata(NkHandle value) {
            NkStyleSelectable.nuserdata(this.address(), value);
            return this;
        }

        public Buffer draw_begin(NkDrawBeginCallbackI value) {
            NkStyleSelectable.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(NkDrawEndCallbackI value) {
            NkStyleSelectable.ndraw_end(this.address(), value);
            return this;
        }
    }
}

