/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleSlider
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int BAR_NORMAL;
    public static final int BAR_HOVER;
    public static final int BAR_ACTIVE;
    public static final int BAR_FILLED;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_ACTIVE;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int BAR_HEIGHT;
    public static final int PADDING;
    public static final int SPACING;
    public static final int CURSOR_SIZE;
    public static final int SHOW_BUTTONS;
    public static final int INC_BUTTON;
    public static final int DEC_BUTTON;
    public static final int INC_SYMBOL;
    public static final int DEC_SYMBOL;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    NkStyleSlider(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleSlider(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleSlider.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleSlider.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleSlider.nhover(this.address());
    }

    public NkStyleItem active() {
        return NkStyleSlider.nactive(this.address());
    }

    public NkColor border_color() {
        return NkStyleSlider.nborder_color(this.address());
    }

    public NkColor bar_normal() {
        return NkStyleSlider.nbar_normal(this.address());
    }

    public NkColor bar_hover() {
        return NkStyleSlider.nbar_hover(this.address());
    }

    public NkColor bar_active() {
        return NkStyleSlider.nbar_active(this.address());
    }

    public NkColor bar_filled() {
        return NkStyleSlider.nbar_filled(this.address());
    }

    public NkStyleItem cursor_normal() {
        return NkStyleSlider.ncursor_normal(this.address());
    }

    public NkStyleItem cursor_hover() {
        return NkStyleSlider.ncursor_hover(this.address());
    }

    public NkStyleItem cursor_active() {
        return NkStyleSlider.ncursor_active(this.address());
    }

    public float border() {
        return NkStyleSlider.nborder(this.address());
    }

    public float rounding() {
        return NkStyleSlider.nrounding(this.address());
    }

    public float bar_height() {
        return NkStyleSlider.nbar_height(this.address());
    }

    public NkVec2 padding() {
        return NkStyleSlider.npadding(this.address());
    }

    public NkVec2 spacing() {
        return NkStyleSlider.nspacing(this.address());
    }

    public NkVec2 cursor_size() {
        return NkStyleSlider.ncursor_size(this.address());
    }

    public int show_buttons() {
        return NkStyleSlider.nshow_buttons(this.address());
    }

    public NkStyleButton inc_button() {
        return NkStyleSlider.ninc_button(this.address());
    }

    public NkStyleButton dec_button() {
        return NkStyleSlider.ndec_button(this.address());
    }

    public int inc_symbol() {
        return NkStyleSlider.ninc_symbol(this.address());
    }

    public int dec_symbol() {
        return NkStyleSlider.ndec_symbol(this.address());
    }

    public NkHandle userdata() {
        return NkStyleSlider.nuserdata(this.address());
    }

    public NkDrawBeginCallback draw_begin() {
        return NkStyleSlider.ndraw_begin(this.address());
    }

    public NkDrawEndCallback draw_end() {
        return NkStyleSlider.ndraw_end(this.address());
    }

    public NkStyleSlider normal(NkStyleItem value) {
        NkStyleSlider.nnormal(this.address(), value);
        return this;
    }

    public NkStyleSlider hover(NkStyleItem value) {
        NkStyleSlider.nhover(this.address(), value);
        return this;
    }

    public NkStyleSlider active(NkStyleItem value) {
        NkStyleSlider.nactive(this.address(), value);
        return this;
    }

    public NkStyleSlider border_color(NkColor value) {
        NkStyleSlider.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleSlider bar_normal(NkColor value) {
        NkStyleSlider.nbar_normal(this.address(), value);
        return this;
    }

    public NkStyleSlider bar_hover(NkColor value) {
        NkStyleSlider.nbar_hover(this.address(), value);
        return this;
    }

    public NkStyleSlider bar_active(NkColor value) {
        NkStyleSlider.nbar_active(this.address(), value);
        return this;
    }

    public NkStyleSlider bar_filled(NkColor value) {
        NkStyleSlider.nbar_filled(this.address(), value);
        return this;
    }

    public NkStyleSlider cursor_normal(NkStyleItem value) {
        NkStyleSlider.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleSlider cursor_hover(NkStyleItem value) {
        NkStyleSlider.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleSlider cursor_active(NkStyleItem value) {
        NkStyleSlider.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyleSlider border(float value) {
        NkStyleSlider.nborder(this.address(), value);
        return this;
    }

    public NkStyleSlider rounding(float value) {
        NkStyleSlider.nrounding(this.address(), value);
        return this;
    }

    public NkStyleSlider bar_height(float value) {
        NkStyleSlider.nbar_height(this.address(), value);
        return this;
    }

    public NkStyleSlider padding(NkVec2 value) {
        NkStyleSlider.npadding(this.address(), value);
        return this;
    }

    public NkStyleSlider spacing(NkVec2 value) {
        NkStyleSlider.nspacing(this.address(), value);
        return this;
    }

    public NkStyleSlider cursor_size(NkVec2 value) {
        NkStyleSlider.ncursor_size(this.address(), value);
        return this;
    }

    public NkStyleSlider show_buttons(int value) {
        NkStyleSlider.nshow_buttons(this.address(), value);
        return this;
    }

    public NkStyleSlider inc_button(NkStyleButton value) {
        NkStyleSlider.ninc_button(this.address(), value);
        return this;
    }

    public NkStyleSlider dec_button(NkStyleButton value) {
        NkStyleSlider.ndec_button(this.address(), value);
        return this;
    }

    public NkStyleSlider inc_symbol(int value) {
        NkStyleSlider.ninc_symbol(this.address(), value);
        return this;
    }

    public NkStyleSlider dec_symbol(int value) {
        NkStyleSlider.ndec_symbol(this.address(), value);
        return this;
    }

    public NkStyleSlider userdata(NkHandle value) {
        NkStyleSlider.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleSlider draw_begin(NkDrawBeginCallbackI value) {
        NkStyleSlider.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleSlider draw_end(NkDrawEndCallbackI value) {
        NkStyleSlider.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleSlider set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkColor bar_normal, NkColor bar_hover, NkColor bar_active, NkColor bar_filled, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkStyleItem cursor_active, float border, float rounding, float bar_height, NkVec2 padding, NkVec2 spacing, NkVec2 cursor_size, int show_buttons, NkStyleButton inc_button, NkStyleButton dec_button, int inc_symbol, int dec_symbol, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.bar_normal(bar_normal);
        this.bar_hover(bar_hover);
        this.bar_active(bar_active);
        this.bar_filled(bar_filled);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_active(cursor_active);
        this.border(border);
        this.rounding(rounding);
        this.bar_height(bar_height);
        this.padding(padding);
        this.spacing(spacing);
        this.cursor_size(cursor_size);
        this.show_buttons(show_buttons);
        this.inc_button(inc_button);
        this.dec_button(dec_button);
        this.inc_symbol(inc_symbol);
        this.dec_symbol(dec_symbol);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleSlider set(NkStyleSlider src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleSlider malloc() {
        return NkStyleSlider.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleSlider calloc() {
        return NkStyleSlider.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleSlider create() {
        return new NkStyleSlider(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleSlider create(long address) {
        return address == 0L ? null : new NkStyleSlider(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleSlider.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleSlider.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleSlider mallocStack() {
        return NkStyleSlider.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleSlider callocStack() {
        return NkStyleSlider.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleSlider mallocStack(MemoryStack stack) {
        return NkStyleSlider.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleSlider callocStack(MemoryStack stack) {
        return NkStyleSlider.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleSlider.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleSlider.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleSlider.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleSlider.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nbar_normal(long struct) {
        return NkColor.create(struct + (long)BAR_NORMAL);
    }

    public static NkColor nbar_hover(long struct) {
        return NkColor.create(struct + (long)BAR_HOVER);
    }

    public static NkColor nbar_active(long struct) {
        return NkColor.create(struct + (long)BAR_ACTIVE);
    }

    public static NkColor nbar_filled(long struct) {
        return NkColor.create(struct + (long)BAR_FILLED);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkStyleItem ncursor_active(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_ACTIVE);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static float nbar_height(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BAR_HEIGHT);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static NkVec2 ncursor_size(long struct) {
        return NkVec2.create(struct + (long)CURSOR_SIZE);
    }

    public static int nshow_buttons(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHOW_BUTTONS);
    }

    public static NkStyleButton ninc_button(long struct) {
        return NkStyleButton.create(struct + (long)INC_BUTTON);
    }

    public static NkStyleButton ndec_button(long struct) {
        return NkStyleButton.create(struct + (long)DEC_BUTTON);
    }

    public static int ninc_symbol(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INC_SYMBOL);
    }

    public static int ndec_symbol(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEC_SYMBOL);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.create(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nbar_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BAR_NORMAL, NkColor.SIZEOF);
    }

    public static void nbar_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BAR_HOVER, NkColor.SIZEOF);
    }

    public static void nbar_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BAR_ACTIVE, NkColor.SIZEOF);
    }

    public static void nbar_filled(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BAR_FILLED, NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_NORMAL, NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_HOVER, NkStyleItem.SIZEOF);
    }

    public static void ncursor_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void nbar_height(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BAR_HEIGHT, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SPACING, NkVec2.SIZEOF);
    }

    public static void ncursor_size(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_SIZE, NkVec2.SIZEOF);
    }

    public static void nshow_buttons(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHOW_BUTTONS, value);
    }

    public static void ninc_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ndec_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ninc_symbol(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INC_SYMBOL, value);
    }

    public static void ndec_symbol(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEC_SYMBOL, value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, NkStyleSlider.addressSafe(value));
    }

    public static void ndraw_end(long struct, NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, NkStyleSlider.addressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleSlider.__struct(NkStyleSlider.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSlider.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSlider.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSlider.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSlider.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSlider.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSlider.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSlider.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleSlider.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSlider.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSlider.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleSlider.__member(4), NkStyleSlider.__member(4), NkStyleSlider.__member(4), NkStyleSlider.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleSlider.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleSlider.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleSlider.__member(4), NkStyleSlider.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleSlider.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleSlider.__member(4), NkStyleSlider.__member(4), NkStyleSlider.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleSlider.__member(POINTER_SIZE), NkStyleSlider.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        BAR_NORMAL = layout.offsetof(4);
        BAR_HOVER = layout.offsetof(5);
        BAR_ACTIVE = layout.offsetof(6);
        BAR_FILLED = layout.offsetof(7);
        CURSOR_NORMAL = layout.offsetof(8);
        CURSOR_HOVER = layout.offsetof(9);
        CURSOR_ACTIVE = layout.offsetof(10);
        BORDER = layout.offsetof(11);
        ROUNDING = layout.offsetof(12);
        BAR_HEIGHT = layout.offsetof(13);
        PADDING = layout.offsetof(14);
        SPACING = layout.offsetof(15);
        CURSOR_SIZE = layout.offsetof(16);
        SHOW_BUTTONS = layout.offsetof(17);
        INC_BUTTON = layout.offsetof(18);
        DEC_BUTTON = layout.offsetof(19);
        INC_SYMBOL = layout.offsetof(20);
        DEC_SYMBOL = layout.offsetof(21);
        USERDATA = layout.offsetof(22);
        DRAW_BEGIN = layout.offsetof(23);
        DRAW_END = layout.offsetof(24);
    }

    public static class Buffer
    extends StructBuffer<NkStyleSlider, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleSlider newInstance(long address) {
            return new NkStyleSlider(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleSlider.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleSlider.nhover(this.address());
        }

        public NkStyleItem active() {
            return NkStyleSlider.nactive(this.address());
        }

        public NkColor border_color() {
            return NkStyleSlider.nborder_color(this.address());
        }

        public NkColor bar_normal() {
            return NkStyleSlider.nbar_normal(this.address());
        }

        public NkColor bar_hover() {
            return NkStyleSlider.nbar_hover(this.address());
        }

        public NkColor bar_active() {
            return NkStyleSlider.nbar_active(this.address());
        }

        public NkColor bar_filled() {
            return NkStyleSlider.nbar_filled(this.address());
        }

        public NkStyleItem cursor_normal() {
            return NkStyleSlider.ncursor_normal(this.address());
        }

        public NkStyleItem cursor_hover() {
            return NkStyleSlider.ncursor_hover(this.address());
        }

        public NkStyleItem cursor_active() {
            return NkStyleSlider.ncursor_active(this.address());
        }

        public float border() {
            return NkStyleSlider.nborder(this.address());
        }

        public float rounding() {
            return NkStyleSlider.nrounding(this.address());
        }

        public float bar_height() {
            return NkStyleSlider.nbar_height(this.address());
        }

        public NkVec2 padding() {
            return NkStyleSlider.npadding(this.address());
        }

        public NkVec2 spacing() {
            return NkStyleSlider.nspacing(this.address());
        }

        public NkVec2 cursor_size() {
            return NkStyleSlider.ncursor_size(this.address());
        }

        public int show_buttons() {
            return NkStyleSlider.nshow_buttons(this.address());
        }

        public NkStyleButton inc_button() {
            return NkStyleSlider.ninc_button(this.address());
        }

        public NkStyleButton dec_button() {
            return NkStyleSlider.ndec_button(this.address());
        }

        public int inc_symbol() {
            return NkStyleSlider.ninc_symbol(this.address());
        }

        public int dec_symbol() {
            return NkStyleSlider.ndec_symbol(this.address());
        }

        public NkHandle userdata() {
            return NkStyleSlider.nuserdata(this.address());
        }

        public NkDrawBeginCallback draw_begin() {
            return NkStyleSlider.ndraw_begin(this.address());
        }

        public NkDrawEndCallback draw_end() {
            return NkStyleSlider.ndraw_end(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleSlider.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleSlider.nhover(this.address(), value);
            return this;
        }

        public Buffer active(NkStyleItem value) {
            NkStyleSlider.nactive(this.address(), value);
            return this;
        }

        public Buffer border_color(NkColor value) {
            NkStyleSlider.nborder_color(this.address(), value);
            return this;
        }

        public Buffer bar_normal(NkColor value) {
            NkStyleSlider.nbar_normal(this.address(), value);
            return this;
        }

        public Buffer bar_hover(NkColor value) {
            NkStyleSlider.nbar_hover(this.address(), value);
            return this;
        }

        public Buffer bar_active(NkColor value) {
            NkStyleSlider.nbar_active(this.address(), value);
            return this;
        }

        public Buffer bar_filled(NkColor value) {
            NkStyleSlider.nbar_filled(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(NkStyleItem value) {
            NkStyleSlider.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(NkStyleItem value) {
            NkStyleSlider.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_active(NkStyleItem value) {
            NkStyleSlider.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleSlider.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleSlider.nrounding(this.address(), value);
            return this;
        }

        public Buffer bar_height(float value) {
            NkStyleSlider.nbar_height(this.address(), value);
            return this;
        }

        public Buffer padding(NkVec2 value) {
            NkStyleSlider.npadding(this.address(), value);
            return this;
        }

        public Buffer spacing(NkVec2 value) {
            NkStyleSlider.nspacing(this.address(), value);
            return this;
        }

        public Buffer cursor_size(NkVec2 value) {
            NkStyleSlider.ncursor_size(this.address(), value);
            return this;
        }

        public Buffer show_buttons(int value) {
            NkStyleSlider.nshow_buttons(this.address(), value);
            return this;
        }

        public Buffer inc_button(NkStyleButton value) {
            NkStyleSlider.ninc_button(this.address(), value);
            return this;
        }

        public Buffer dec_button(NkStyleButton value) {
            NkStyleSlider.ndec_button(this.address(), value);
            return this;
        }

        public Buffer inc_symbol(int value) {
            NkStyleSlider.ninc_symbol(this.address(), value);
            return this;
        }

        public Buffer dec_symbol(int value) {
            NkStyleSlider.ndec_symbol(this.address(), value);
            return this;
        }

        public Buffer userdata(NkHandle value) {
            NkStyleSlider.nuserdata(this.address(), value);
            return this;
        }

        public Buffer draw_begin(NkDrawBeginCallbackI value) {
            NkStyleSlider.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(NkDrawEndCallbackI value) {
            NkStyleSlider.ndraw_end(this.address(), value);
            return this;
        }
    }
}

