/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkStyleWindowHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int CLOSE_BUTTON;
    public static final int MINIMIZE_BUTTON;
    public static final int CLOSE_SYMBOL;
    public static final int MINIMIZE_SYMBOL;
    public static final int MAXIMIZE_SYMBOL;
    public static final int LABEL_NORMAL;
    public static final int LABEL_HOVER;
    public static final int LABEL_ACTIVE;
    public static final int ALIGN;
    public static final int PADDING;
    public static final int LABEL_PADDING;
    public static final int SPACING;

    NkStyleWindowHeader(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkStyleWindowHeader(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleWindowHeader.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem normal() {
        return NkStyleWindowHeader.nnormal(this.address());
    }

    public NkStyleItem hover() {
        return NkStyleWindowHeader.nhover(this.address());
    }

    public NkStyleItem active() {
        return NkStyleWindowHeader.nactive(this.address());
    }

    public NkStyleButton close_button() {
        return NkStyleWindowHeader.nclose_button(this.address());
    }

    public NkStyleButton minimize_button() {
        return NkStyleWindowHeader.nminimize_button(this.address());
    }

    public int close_symbol() {
        return NkStyleWindowHeader.nclose_symbol(this.address());
    }

    public int minimize_symbol() {
        return NkStyleWindowHeader.nminimize_symbol(this.address());
    }

    public int maximize_symbol() {
        return NkStyleWindowHeader.nmaximize_symbol(this.address());
    }

    public NkColor label_normal() {
        return NkStyleWindowHeader.nlabel_normal(this.address());
    }

    public NkColor label_hover() {
        return NkStyleWindowHeader.nlabel_hover(this.address());
    }

    public NkColor label_active() {
        return NkStyleWindowHeader.nlabel_active(this.address());
    }

    public int align() {
        return NkStyleWindowHeader.nalign(this.address());
    }

    public NkVec2 padding() {
        return NkStyleWindowHeader.npadding(this.address());
    }

    public NkVec2 label_padding() {
        return NkStyleWindowHeader.nlabel_padding(this.address());
    }

    public NkVec2 spacing() {
        return NkStyleWindowHeader.nspacing(this.address());
    }

    public NkStyleWindowHeader normal(NkStyleItem value) {
        NkStyleWindowHeader.nnormal(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader hover(NkStyleItem value) {
        NkStyleWindowHeader.nhover(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader active(NkStyleItem value) {
        NkStyleWindowHeader.nactive(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader close_button(NkStyleButton value) {
        NkStyleWindowHeader.nclose_button(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader minimize_button(NkStyleButton value) {
        NkStyleWindowHeader.nminimize_button(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader close_symbol(int value) {
        NkStyleWindowHeader.nclose_symbol(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader minimize_symbol(int value) {
        NkStyleWindowHeader.nminimize_symbol(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader maximize_symbol(int value) {
        NkStyleWindowHeader.nmaximize_symbol(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_normal(NkColor value) {
        NkStyleWindowHeader.nlabel_normal(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_hover(NkColor value) {
        NkStyleWindowHeader.nlabel_hover(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_active(NkColor value) {
        NkStyleWindowHeader.nlabel_active(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader align(int value) {
        NkStyleWindowHeader.nalign(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader padding(NkVec2 value) {
        NkStyleWindowHeader.npadding(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader label_padding(NkVec2 value) {
        NkStyleWindowHeader.nlabel_padding(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader spacing(NkVec2 value) {
        NkStyleWindowHeader.nspacing(this.address(), value);
        return this;
    }

    public NkStyleWindowHeader set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkStyleButton close_button, NkStyleButton minimize_button, int close_symbol, int minimize_symbol, int maximize_symbol, NkColor label_normal, NkColor label_hover, NkColor label_active, int align, NkVec2 padding, NkVec2 label_padding, NkVec2 spacing) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.close_button(close_button);
        this.minimize_button(minimize_button);
        this.close_symbol(close_symbol);
        this.minimize_symbol(minimize_symbol);
        this.maximize_symbol(maximize_symbol);
        this.label_normal(label_normal);
        this.label_hover(label_hover);
        this.label_active(label_active);
        this.align(align);
        this.padding(padding);
        this.label_padding(label_padding);
        this.spacing(spacing);
        return this;
    }

    public NkStyleWindowHeader set(NkStyleWindowHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleWindowHeader malloc() {
        return NkStyleWindowHeader.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkStyleWindowHeader calloc() {
        return NkStyleWindowHeader.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkStyleWindowHeader create() {
        return new NkStyleWindowHeader(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleWindowHeader create(long address) {
        return address == 0L ? null : new NkStyleWindowHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleWindowHeader.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleWindowHeader.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleWindowHeader mallocStack() {
        return NkStyleWindowHeader.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleWindowHeader callocStack() {
        return NkStyleWindowHeader.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleWindowHeader mallocStack(MemoryStack stack) {
        return NkStyleWindowHeader.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleWindowHeader callocStack(MemoryStack stack) {
        return NkStyleWindowHeader.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleWindowHeader.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleWindowHeader.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleWindowHeader.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleWindowHeader.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkStyleButton nclose_button(long struct) {
        return NkStyleButton.create(struct + (long)CLOSE_BUTTON);
    }

    public static NkStyleButton nminimize_button(long struct) {
        return NkStyleButton.create(struct + (long)MINIMIZE_BUTTON);
    }

    public static int nclose_symbol(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLOSE_SYMBOL);
    }

    public static int nminimize_symbol(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINIMIZE_SYMBOL);
    }

    public static int nmaximize_symbol(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMIZE_SYMBOL);
    }

    public static NkColor nlabel_normal(long struct) {
        return NkColor.create(struct + (long)LABEL_NORMAL);
    }

    public static NkColor nlabel_hover(long struct) {
        return NkColor.create(struct + (long)LABEL_HOVER);
    }

    public static NkColor nlabel_active(long struct) {
        return NkColor.create(struct + (long)LABEL_ACTIVE);
    }

    public static int nalign(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALIGN);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 nlabel_padding(long struct) {
        return NkVec2.create(struct + (long)LABEL_PADDING);
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nclose_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CLOSE_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nminimize_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MINIMIZE_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nclose_symbol(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CLOSE_SYMBOL, value);
    }

    public static void nminimize_symbol(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MINIMIZE_SYMBOL, value);
    }

    public static void nmaximize_symbol(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXIMIZE_SYMBOL, value);
    }

    public static void nlabel_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_NORMAL, NkColor.SIZEOF);
    }

    public static void nlabel_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_HOVER, NkColor.SIZEOF);
    }

    public static void nlabel_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_ACTIVE, NkColor.SIZEOF);
    }

    public static void nalign(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALIGN, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nlabel_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_PADDING, NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SPACING, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleWindowHeader.__struct(NkStyleWindowHeader.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleWindowHeader.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleWindowHeader.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleWindowHeader.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleWindowHeader.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleWindowHeader.__member(4), NkStyleWindowHeader.__member(4), NkStyleWindowHeader.__member(4), NkStyleWindowHeader.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindowHeader.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindowHeader.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindowHeader.__member(4), NkStyleWindowHeader.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindowHeader.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindowHeader.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        CLOSE_BUTTON = layout.offsetof(3);
        MINIMIZE_BUTTON = layout.offsetof(4);
        CLOSE_SYMBOL = layout.offsetof(5);
        MINIMIZE_SYMBOL = layout.offsetof(6);
        MAXIMIZE_SYMBOL = layout.offsetof(7);
        LABEL_NORMAL = layout.offsetof(8);
        LABEL_HOVER = layout.offsetof(9);
        LABEL_ACTIVE = layout.offsetof(10);
        ALIGN = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        LABEL_PADDING = layout.offsetof(13);
        SPACING = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<NkStyleWindowHeader, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleWindowHeader newInstance(long address) {
            return new NkStyleWindowHeader(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem normal() {
            return NkStyleWindowHeader.nnormal(this.address());
        }

        public NkStyleItem hover() {
            return NkStyleWindowHeader.nhover(this.address());
        }

        public NkStyleItem active() {
            return NkStyleWindowHeader.nactive(this.address());
        }

        public NkStyleButton close_button() {
            return NkStyleWindowHeader.nclose_button(this.address());
        }

        public NkStyleButton minimize_button() {
            return NkStyleWindowHeader.nminimize_button(this.address());
        }

        public int close_symbol() {
            return NkStyleWindowHeader.nclose_symbol(this.address());
        }

        public int minimize_symbol() {
            return NkStyleWindowHeader.nminimize_symbol(this.address());
        }

        public int maximize_symbol() {
            return NkStyleWindowHeader.nmaximize_symbol(this.address());
        }

        public NkColor label_normal() {
            return NkStyleWindowHeader.nlabel_normal(this.address());
        }

        public NkColor label_hover() {
            return NkStyleWindowHeader.nlabel_hover(this.address());
        }

        public NkColor label_active() {
            return NkStyleWindowHeader.nlabel_active(this.address());
        }

        public int align() {
            return NkStyleWindowHeader.nalign(this.address());
        }

        public NkVec2 padding() {
            return NkStyleWindowHeader.npadding(this.address());
        }

        public NkVec2 label_padding() {
            return NkStyleWindowHeader.nlabel_padding(this.address());
        }

        public NkVec2 spacing() {
            return NkStyleWindowHeader.nspacing(this.address());
        }

        public Buffer normal(NkStyleItem value) {
            NkStyleWindowHeader.nnormal(this.address(), value);
            return this;
        }

        public Buffer hover(NkStyleItem value) {
            NkStyleWindowHeader.nhover(this.address(), value);
            return this;
        }

        public Buffer active(NkStyleItem value) {
            NkStyleWindowHeader.nactive(this.address(), value);
            return this;
        }

        public Buffer close_button(NkStyleButton value) {
            NkStyleWindowHeader.nclose_button(this.address(), value);
            return this;
        }

        public Buffer minimize_button(NkStyleButton value) {
            NkStyleWindowHeader.nminimize_button(this.address(), value);
            return this;
        }

        public Buffer close_symbol(int value) {
            NkStyleWindowHeader.nclose_symbol(this.address(), value);
            return this;
        }

        public Buffer minimize_symbol(int value) {
            NkStyleWindowHeader.nminimize_symbol(this.address(), value);
            return this;
        }

        public Buffer maximize_symbol(int value) {
            NkStyleWindowHeader.nmaximize_symbol(this.address(), value);
            return this;
        }

        public Buffer label_normal(NkColor value) {
            NkStyleWindowHeader.nlabel_normal(this.address(), value);
            return this;
        }

        public Buffer label_hover(NkColor value) {
            NkStyleWindowHeader.nlabel_hover(this.address(), value);
            return this;
        }

        public Buffer label_active(NkColor value) {
            NkStyleWindowHeader.nlabel_active(this.address(), value);
            return this;
        }

        public Buffer align(int value) {
            NkStyleWindowHeader.nalign(this.address(), value);
            return this;
        }

        public Buffer padding(NkVec2 value) {
            NkStyleWindowHeader.npadding(this.address(), value);
            return this;
        }

        public Buffer label_padding(NkVec2 value) {
            NkStyleWindowHeader.nlabel_padding(this.address(), value);
            return this;
        }

        public Buffer spacing(NkVec2 value) {
            NkStyleWindowHeader.nspacing(this.address(), value);
            return this;
        }
    }
}

