/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkQueryFontGlyphCallback;
import org.lwjgl.nuklear.NkQueryFontGlyphCallbackI;
import org.lwjgl.nuklear.NkTextWidthCallback;
import org.lwjgl.nuklear.NkTextWidthCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkUserFont
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int HEIGHT;
    public static final int WIDTH;
    public static final int QUERY;
    public static final int TEXTURE;

    NkUserFont(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkUserFont(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkUserFont.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkHandle userdata() {
        return NkUserFont.nuserdata(this.address());
    }

    public float height() {
        return NkUserFont.nheight(this.address());
    }

    public NkTextWidthCallback width() {
        return NkUserFont.nwidth(this.address());
    }

    public NkQueryFontGlyphCallback query() {
        return NkUserFont.nquery(this.address());
    }

    public NkHandle texture() {
        return NkUserFont.ntexture(this.address());
    }

    public NkUserFont userdata(NkHandle value) {
        NkUserFont.nuserdata(this.address(), value);
        return this;
    }

    public NkUserFont height(float value) {
        NkUserFont.nheight(this.address(), value);
        return this;
    }

    public NkUserFont width(NkTextWidthCallbackI value) {
        NkUserFont.nwidth(this.address(), value);
        return this;
    }

    public NkUserFont query(NkQueryFontGlyphCallbackI value) {
        NkUserFont.nquery(this.address(), value);
        return this;
    }

    public NkUserFont texture(NkHandle value) {
        NkUserFont.ntexture(this.address(), value);
        return this;
    }

    public NkUserFont set(NkHandle userdata, float height, NkTextWidthCallbackI width, NkQueryFontGlyphCallbackI query, NkHandle texture) {
        this.userdata(userdata);
        this.height(height);
        this.width(width);
        this.query(query);
        this.texture(texture);
        return this;
    }

    public NkUserFont set(NkUserFont src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkUserFont malloc() {
        return NkUserFont.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkUserFont calloc() {
        return NkUserFont.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkUserFont create() {
        return new NkUserFont(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkUserFont create(long address) {
        return address == 0L ? null : new NkUserFont(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkUserFont.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkUserFont.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkUserFont mallocStack() {
        return NkUserFont.mallocStack(MemoryStack.stackGet());
    }

    public static NkUserFont callocStack() {
        return NkUserFont.callocStack(MemoryStack.stackGet());
    }

    public static NkUserFont mallocStack(MemoryStack stack) {
        return NkUserFont.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkUserFont callocStack(MemoryStack stack) {
        return NkUserFont.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkUserFont.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkUserFont.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkUserFont.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkUserFont.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static NkTextWidthCallback nwidth(long struct) {
        return NkTextWidthCallback.create(MemoryUtil.memGetAddress(struct + (long)WIDTH));
    }

    public static NkQueryFontGlyphCallback nquery(long struct) {
        return NkQueryFontGlyphCallback.create(MemoryUtil.memGetAddress(struct + (long)QUERY));
    }

    public static NkHandle ntexture(long struct) {
        return NkHandle.create(struct + (long)TEXTURE);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    public static void nwidth(long struct, NkTextWidthCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)WIDTH, NkUserFont.addressSafe(value));
    }

    public static void nquery(long struct, NkQueryFontGlyphCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)QUERY, NkUserFont.addressSafe(value));
    }

    public static void ntexture(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURE, NkHandle.SIZEOF);
    }

    static {
        Struct.Layout layout = NkUserFont.__struct(NkUserFont.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkUserFont.__member(4), NkUserFont.__member(POINTER_SIZE), NkUserFont.__member(POINTER_SIZE), NkUserFont.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        QUERY = layout.offsetof(3);
        TEXTURE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkUserFont, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkUserFont newInstance(long address) {
            return new NkUserFont(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkHandle userdata() {
            return NkUserFont.nuserdata(this.address());
        }

        public float height() {
            return NkUserFont.nheight(this.address());
        }

        public NkTextWidthCallback width() {
            return NkUserFont.nwidth(this.address());
        }

        public NkQueryFontGlyphCallback query() {
            return NkUserFont.nquery(this.address());
        }

        public NkHandle texture() {
            return NkUserFont.ntexture(this.address());
        }

        public Buffer userdata(NkHandle value) {
            NkUserFont.nuserdata(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            NkUserFont.nheight(this.address(), value);
            return this;
        }

        public Buffer width(NkTextWidthCallbackI value) {
            NkUserFont.nwidth(this.address(), value);
            return this;
        }

        public Buffer query(NkQueryFontGlyphCallbackI value) {
            NkUserFont.nquery(this.address(), value);
            return this;
        }

        public Buffer texture(NkHandle value) {
            NkUserFont.ntexture(this.address(), value);
            return this;
        }
    }
}

