/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkUserFontGlyph
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UV;
    public static final int OFFSET;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int XADVANCE;

    NkUserFontGlyph(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkUserFontGlyph(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkUserFontGlyph.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkVec2.Buffer uv() {
        return NkUserFontGlyph.nuv(this.address());
    }

    public NkVec2 uv(int index) {
        return NkUserFontGlyph.nuv(this.address(), index);
    }

    public NkVec2 offset() {
        return NkUserFontGlyph.noffset(this.address());
    }

    public float width() {
        return NkUserFontGlyph.nwidth(this.address());
    }

    public float height() {
        return NkUserFontGlyph.nheight(this.address());
    }

    public float xadvance() {
        return NkUserFontGlyph.nxadvance(this.address());
    }

    public NkUserFontGlyph uv(NkVec2.Buffer value) {
        NkUserFontGlyph.nuv(this.address(), value);
        return this;
    }

    public NkUserFontGlyph uv(int index, NkVec2 value) {
        NkUserFontGlyph.nuv(this.address(), index, value);
        return this;
    }

    public NkUserFontGlyph offset(NkVec2 value) {
        NkUserFontGlyph.noffset(this.address(), value);
        return this;
    }

    public NkUserFontGlyph width(float value) {
        NkUserFontGlyph.nwidth(this.address(), value);
        return this;
    }

    public NkUserFontGlyph height(float value) {
        NkUserFontGlyph.nheight(this.address(), value);
        return this;
    }

    public NkUserFontGlyph xadvance(float value) {
        NkUserFontGlyph.nxadvance(this.address(), value);
        return this;
    }

    public NkUserFontGlyph set(NkVec2.Buffer uv, NkVec2 offset, float width, float height, float xadvance) {
        this.uv(uv);
        this.offset(offset);
        this.width(width);
        this.height(height);
        this.xadvance(xadvance);
        return this;
    }

    public NkUserFontGlyph set(NkUserFontGlyph src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkUserFontGlyph malloc() {
        return NkUserFontGlyph.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkUserFontGlyph calloc() {
        return NkUserFontGlyph.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkUserFontGlyph create() {
        return new NkUserFontGlyph(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkUserFontGlyph create(long address) {
        return address == 0L ? null : new NkUserFontGlyph(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkUserFontGlyph.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkUserFontGlyph.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkUserFontGlyph mallocStack() {
        return NkUserFontGlyph.mallocStack(MemoryStack.stackGet());
    }

    public static NkUserFontGlyph callocStack() {
        return NkUserFontGlyph.callocStack(MemoryStack.stackGet());
    }

    public static NkUserFontGlyph mallocStack(MemoryStack stack) {
        return NkUserFontGlyph.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkUserFontGlyph callocStack(MemoryStack stack) {
        return NkUserFontGlyph.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkUserFontGlyph.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkUserFontGlyph.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkVec2.Buffer nuv(long struct) {
        return NkVec2.create(struct + (long)UV, 2);
    }

    public static NkVec2 nuv(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return NkVec2.create(struct + (long)UV + (long)(index * NkVec2.SIZEOF));
    }

    public static NkVec2 noffset(long struct) {
        return NkVec2.create(struct + (long)OFFSET);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static float nxadvance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XADVANCE);
    }

    public static void nuv(long struct, NkVec2.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)UV, value.remaining() * NkVec2.SIZEOF);
    }

    public static void nuv(long struct, int index, NkVec2 value) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)UV + (long)(index * NkVec2.SIZEOF), NkVec2.SIZEOF);
    }

    public static void noffset(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, NkVec2.SIZEOF);
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    public static void nxadvance(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)XADVANCE, value);
    }

    static {
        Struct.Layout layout = NkUserFontGlyph.__struct(NkUserFontGlyph.__array(NkVec2.SIZEOF, NkVec2.ALIGNOF, 2), NkUserFontGlyph.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkUserFontGlyph.__member(4), NkUserFontGlyph.__member(4), NkUserFontGlyph.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UV = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        XADVANCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkUserFontGlyph, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkUserFontGlyph newInstance(long address) {
            return new NkUserFontGlyph(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkVec2.Buffer uv() {
            return NkUserFontGlyph.nuv(this.address());
        }

        public NkVec2 uv(int index) {
            return NkUserFontGlyph.nuv(this.address(), index);
        }

        public NkVec2 offset() {
            return NkUserFontGlyph.noffset(this.address());
        }

        public float width() {
            return NkUserFontGlyph.nwidth(this.address());
        }

        public float height() {
            return NkUserFontGlyph.nheight(this.address());
        }

        public float xadvance() {
            return NkUserFontGlyph.nxadvance(this.address());
        }

        public Buffer uv(NkVec2.Buffer value) {
            NkUserFontGlyph.nuv(this.address(), value);
            return this;
        }

        public Buffer uv(int index, NkVec2 value) {
            NkUserFontGlyph.nuv(this.address(), index, value);
            return this;
        }

        public Buffer offset(NkVec2 value) {
            NkUserFontGlyph.noffset(this.address(), value);
            return this;
        }

        public Buffer width(float value) {
            NkUserFontGlyph.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            NkUserFontGlyph.nheight(this.address(), value);
            return this;
        }

        public Buffer xadvance(float value) {
            NkUserFontGlyph.nxadvance(this.address(), value);
            return this;
        }
    }
}

