/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkCommandBuffer;
import org.lwjgl.nuklear.NkEditState;
import org.lwjgl.nuklear.NkPanel;
import org.lwjgl.nuklear.NkPopupState;
import org.lwjgl.nuklear.NkPropertyState;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkScroll;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkWindow
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SEQ;
    public static final int NAME;
    public static final int NAME_STRING;
    public static final int FLAGS;
    public static final int BOUNDS;
    public static final int SCROLLBAR;
    public static final int BUFFER;
    public static final int LAYOUT;
    public static final int SCROLLBAR_HIDING_TIMER;
    public static final int PROPERTY;
    public static final int POPUP;
    public static final int EDIT;
    public static final int SCROLLED;
    public static final int TABLES;
    public static final int TABLE_COUNT;
    public static final int TABLE_SIZE;
    public static final int NEXT;
    public static final int PREV;
    public static final int PARENT;

    NkWindow(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkWindow(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkWindow.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int seq() {
        return NkWindow.nseq(this.address());
    }

    public int name() {
        return NkWindow.nname(this.address());
    }

    public ByteBuffer name_string() {
        return NkWindow.nname_string(this.address());
    }

    public String name_stringString() {
        return NkWindow.nname_stringString(this.address());
    }

    public int flags() {
        return NkWindow.nflags(this.address());
    }

    public NkRect bounds() {
        return NkWindow.nbounds(this.address());
    }

    public NkScroll scrollbar() {
        return NkWindow.nscrollbar(this.address());
    }

    public NkCommandBuffer buffer() {
        return NkWindow.nbuffer(this.address());
    }

    public NkPanel layout() {
        return NkWindow.nlayout(this.address());
    }

    public float scrollbar_hiding_timer() {
        return NkWindow.nscrollbar_hiding_timer(this.address());
    }

    public NkPropertyState property() {
        return NkWindow.nproperty(this.address());
    }

    public NkPopupState popup() {
        return NkWindow.npopup(this.address());
    }

    public NkEditState edit() {
        return NkWindow.nedit(this.address());
    }

    public int scrolled() {
        return NkWindow.nscrolled(this.address());
    }

    public long tables() {
        return NkWindow.ntables(this.address());
    }

    public short table_count() {
        return NkWindow.ntable_count(this.address());
    }

    public short table_size() {
        return NkWindow.ntable_size(this.address());
    }

    public NkWindow next() {
        return NkWindow.nnext(this.address());
    }

    public NkWindow prev() {
        return NkWindow.nprev(this.address());
    }

    public NkWindow parent() {
        return NkWindow.nparent(this.address());
    }

    public static NkWindow create(long address) {
        return address == 0L ? null : new NkWindow(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nseq(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SEQ);
    }

    public static int nname(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NAME);
    }

    public static ByteBuffer nname_string(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME_STRING, 64);
    }

    public static String nname_stringString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)NAME_STRING);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static NkRect nbounds(long struct) {
        return NkRect.create(struct + (long)BOUNDS);
    }

    public static NkScroll nscrollbar(long struct) {
        return NkScroll.create(struct + (long)SCROLLBAR);
    }

    public static NkCommandBuffer nbuffer(long struct) {
        return NkCommandBuffer.create(struct + (long)BUFFER);
    }

    public static NkPanel nlayout(long struct) {
        return NkPanel.create(MemoryUtil.memGetAddress(struct + (long)LAYOUT));
    }

    public static float nscrollbar_hiding_timer(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)SCROLLBAR_HIDING_TIMER);
    }

    public static NkPropertyState nproperty(long struct) {
        return NkPropertyState.create(struct + (long)PROPERTY);
    }

    public static NkPopupState npopup(long struct) {
        return NkPopupState.create(struct + (long)POPUP);
    }

    public static NkEditState nedit(long struct) {
        return NkEditState.create(struct + (long)EDIT);
    }

    public static int nscrolled(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCROLLED);
    }

    public static long ntables(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TABLES);
    }

    public static short ntable_count(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TABLE_COUNT);
    }

    public static short ntable_size(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TABLE_SIZE);
    }

    public static NkWindow nnext(long struct) {
        return NkWindow.create(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    public static NkWindow nprev(long struct) {
        return NkWindow.create(MemoryUtil.memGetAddress(struct + (long)PREV));
    }

    public static NkWindow nparent(long struct) {
        return NkWindow.create(MemoryUtil.memGetAddress(struct + (long)PARENT));
    }

    static {
        Struct.Layout layout = NkWindow.__struct(NkWindow.__member(4), NkWindow.__member(4), NkWindow.__array(1, 64), NkWindow.__member(4), NkWindow.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkWindow.__member(NkScroll.SIZEOF, NkScroll.ALIGNOF), NkWindow.__member(NkCommandBuffer.SIZEOF, NkCommandBuffer.ALIGNOF), NkWindow.__member(POINTER_SIZE), NkWindow.__member(4), NkWindow.__member(NkPropertyState.SIZEOF, NkPropertyState.ALIGNOF), NkWindow.__member(NkPopupState.SIZEOF, NkPopupState.ALIGNOF), NkWindow.__member(NkEditState.SIZEOF, NkEditState.ALIGNOF), NkWindow.__member(4), NkWindow.__member(POINTER_SIZE), NkWindow.__member(2), NkWindow.__member(2), NkWindow.__member(POINTER_SIZE), NkWindow.__member(POINTER_SIZE), NkWindow.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SEQ = layout.offsetof(0);
        NAME = layout.offsetof(1);
        NAME_STRING = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        BOUNDS = layout.offsetof(4);
        SCROLLBAR = layout.offsetof(5);
        BUFFER = layout.offsetof(6);
        LAYOUT = layout.offsetof(7);
        SCROLLBAR_HIDING_TIMER = layout.offsetof(8);
        PROPERTY = layout.offsetof(9);
        POPUP = layout.offsetof(10);
        EDIT = layout.offsetof(11);
        SCROLLED = layout.offsetof(12);
        TABLES = layout.offsetof(13);
        TABLE_COUNT = layout.offsetof(14);
        TABLE_SIZE = layout.offsetof(15);
        NEXT = layout.offsetof(16);
        PREV = layout.offsetof(17);
        PARENT = layout.offsetof(18);
    }

    public static class Buffer
    extends StructBuffer<NkWindow, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkWindow newInstance(long address) {
            return new NkWindow(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int seq() {
            return NkWindow.nseq(this.address());
        }

        public int name() {
            return NkWindow.nname(this.address());
        }

        public ByteBuffer name_string() {
            return NkWindow.nname_string(this.address());
        }

        public String name_stringString() {
            return NkWindow.nname_stringString(this.address());
        }

        public int flags() {
            return NkWindow.nflags(this.address());
        }

        public NkRect bounds() {
            return NkWindow.nbounds(this.address());
        }

        public NkScroll scrollbar() {
            return NkWindow.nscrollbar(this.address());
        }

        public NkCommandBuffer buffer() {
            return NkWindow.nbuffer(this.address());
        }

        public NkPanel layout() {
            return NkWindow.nlayout(this.address());
        }

        public float scrollbar_hiding_timer() {
            return NkWindow.nscrollbar_hiding_timer(this.address());
        }

        public NkPropertyState property() {
            return NkWindow.nproperty(this.address());
        }

        public NkPopupState popup() {
            return NkWindow.npopup(this.address());
        }

        public NkEditState edit() {
            return NkWindow.nedit(this.address());
        }

        public int scrolled() {
            return NkWindow.nscrolled(this.address());
        }

        public long tables() {
            return NkWindow.ntables(this.address());
        }

        public short table_count() {
            return NkWindow.ntable_count(this.address());
        }

        public short table_size() {
            return NkWindow.ntable_size(this.address());
        }

        public NkWindow next() {
            return NkWindow.nnext(this.address());
        }

        public NkWindow prev() {
            return NkWindow.nprev(this.address());
        }

        public NkWindow parent() {
            return NkWindow.nparent(this.address());
        }
    }
}

