/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.nuklear.NkAllocator;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkCommand;
import org.lwjgl.nuklear.NkCommandBuffer;
import org.lwjgl.nuklear.NkCommandCustomCallbackI;
import org.lwjgl.nuklear.NkContext;
import org.lwjgl.nuklear.NkConvertConfig;
import org.lwjgl.nuklear.NkCursor;
import org.lwjgl.nuklear.NkDrawCommand;
import org.lwjgl.nuklear.NkDrawList;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkImage;
import org.lwjgl.nuklear.NkInput;
import org.lwjgl.nuklear.NkItemGetterI;
import org.lwjgl.nuklear.NkListView;
import org.lwjgl.nuklear.NkMemoryStatus;
import org.lwjgl.nuklear.NkPanel;
import org.lwjgl.nuklear.NkPluginFilterI;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkScroll;
import org.lwjgl.nuklear.NkStr;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkTextEdit;
import org.lwjgl.nuklear.NkUserFont;
import org.lwjgl.nuklear.NkValueGetterI;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.nuklear.NkWindow;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;

public class Nuklear {
    public static final int NK_UTF_INVALID = 65533;
    public static final int NK_UTF_SIZE = 4;
    public static final int NK_INPUT_MAX = 16;
    public static final int NK_MAX_NUMBER_BUFFER = 64;
    public static final float NK_UNDEFINED = -1.0f;
    public static final float NK_SCROLLBAR_HIDING_TIMEOUT = 4.0f;
    public static final int nk_false = 0;
    public static final int nk_true = 1;
    public static final int NK_UP = 0;
    public static final int NK_RIGHT = 1;
    public static final int NK_DOWN = 2;
    public static final int NK_LEFT = 3;
    public static final int NK_BUTTON_DEFAULT = 0;
    public static final int NK_BUTTON_REPEATER = 1;
    public static final int NK_FIXED = 0;
    public static final int NK_MODIFIABLE = 1;
    public static final int NK_VERTICAL = 0;
    public static final int NK_HORIZONTAL = 1;
    public static final int NK_MINIMIZED = 0;
    public static final int NK_MAXIMIZED = 1;
    public static final int NK_HIDDEN = 0;
    public static final int NK_SHOWN = 1;
    public static final int NK_CHART_LINES = 0;
    public static final int NK_CHART_COLUMN = 1;
    public static final int NK_CHART_MAX = 2;
    public static final int NK_CHART_HOVERING = 1;
    public static final int NK_CHART_CLICKED = 2;
    public static final int NK_RGB = 0;
    public static final int NK_RGBA = 1;
    public static final int NK_POPUP_STATIC = 0;
    public static final int NK_POPUP_DYNAMIC = 1;
    public static final int NK_DYNAMIC = 0;
    public static final int NK_STATIC = 1;
    public static final int NK_TREE_NODE = 0;
    public static final int NK_TREE_TAB = 1;
    public static final int NK_ANTI_ALIASING_OFF = 0;
    public static final int NK_ANTI_ALIASING_ON = 1;
    public static final int NK_CONVERT_SUCCESS = 0;
    public static final int NK_CONVERT_INVALID_PARAM = 1;
    public static final int NK_CONVERT_COMMAND_BUFFER_FULL = 2;
    public static final int NK_CONVERT_VERTEX_BUFFER_FULL = 4;
    public static final int NK_CONVERT_ELEMENT_BUFFER_FULL = 8;
    public static final int NK_SYMBOL_NONE = 0;
    public static final int NK_SYMBOL_X = 1;
    public static final int NK_SYMBOL_UNDERSCORE = 2;
    public static final int NK_SYMBOL_CIRCLE_SOLID = 3;
    public static final int NK_SYMBOL_CIRCLE_OUTLINE = 4;
    public static final int NK_SYMBOL_RECT_SOLID = 5;
    public static final int NK_SYMBOL_RECT_OUTLINE = 6;
    public static final int NK_SYMBOL_TRIANGLE_UP = 7;
    public static final int NK_SYMBOL_TRIANGLE_DOWN = 8;
    public static final int NK_SYMBOL_TRIANGLE_LEFT = 9;
    public static final int NK_SYMBOL_TRIANGLE_RIGHT = 10;
    public static final int NK_SYMBOL_PLUS = 11;
    public static final int NK_SYMBOL_MINUS = 12;
    public static final int NK_SYMBOL_MAX = 13;
    public static final int NK_KEY_NONE = 0;
    public static final int NK_KEY_SHIFT = 1;
    public static final int NK_KEY_CTRL = 2;
    public static final int NK_KEY_DEL = 3;
    public static final int NK_KEY_ENTER = 4;
    public static final int NK_KEY_TAB = 5;
    public static final int NK_KEY_BACKSPACE = 6;
    public static final int NK_KEY_COPY = 7;
    public static final int NK_KEY_CUT = 8;
    public static final int NK_KEY_PASTE = 9;
    public static final int NK_KEY_UP = 10;
    public static final int NK_KEY_DOWN = 11;
    public static final int NK_KEY_LEFT = 12;
    public static final int NK_KEY_RIGHT = 13;
    public static final int NK_KEY_TEXT_INSERT_MODE = 14;
    public static final int NK_KEY_TEXT_REPLACE_MODE = 15;
    public static final int NK_KEY_TEXT_RESET_MODE = 16;
    public static final int NK_KEY_TEXT_LINE_START = 17;
    public static final int NK_KEY_TEXT_LINE_END = 18;
    public static final int NK_KEY_TEXT_START = 19;
    public static final int NK_KEY_TEXT_END = 20;
    public static final int NK_KEY_TEXT_UNDO = 21;
    public static final int NK_KEY_TEXT_REDO = 22;
    public static final int NK_KEY_TEXT_SELECT_ALL = 23;
    public static final int NK_KEY_TEXT_WORD_LEFT = 24;
    public static final int NK_KEY_TEXT_WORD_RIGHT = 25;
    public static final int NK_KEY_SCROLL_START = 26;
    public static final int NK_KEY_SCROLL_END = 27;
    public static final int NK_KEY_SCROLL_DOWN = 28;
    public static final int NK_KEY_SCROLL_UP = 29;
    public static final int NK_KEY_MAX = 30;
    public static final int NK_BUTTON_LEFT = 0;
    public static final int NK_BUTTON_MIDDLE = 1;
    public static final int NK_BUTTON_RIGHT = 2;
    public static final int NK_BUTTON_DOUBLE = 3;
    public static final int NK_BUTTON_MAX = 4;
    public static final int NK_COLOR_TEXT = 0;
    public static final int NK_COLOR_WINDOW = 1;
    public static final int NK_COLOR_HEADER = 2;
    public static final int NK_COLOR_BORDER = 3;
    public static final int NK_COLOR_BUTTON = 4;
    public static final int NK_COLOR_BUTTON_HOVER = 5;
    public static final int NK_COLOR_BUTTON_ACTIVE = 6;
    public static final int NK_COLOR_TOGGLE = 7;
    public static final int NK_COLOR_TOGGLE_HOVER = 8;
    public static final int NK_COLOR_TOGGLE_CURSOR = 9;
    public static final int NK_COLOR_SELECT = 10;
    public static final int NK_COLOR_SELECT_ACTIVE = 11;
    public static final int NK_COLOR_SLIDER = 12;
    public static final int NK_COLOR_SLIDER_CURSOR = 13;
    public static final int NK_COLOR_SLIDER_CURSOR_HOVER = 14;
    public static final int NK_COLOR_SLIDER_CURSOR_ACTIVE = 15;
    public static final int NK_COLOR_PROPERTY = 16;
    public static final int NK_COLOR_EDIT = 17;
    public static final int NK_COLOR_EDIT_CURSOR = 18;
    public static final int NK_COLOR_COMBO = 19;
    public static final int NK_COLOR_CHART = 20;
    public static final int NK_COLOR_CHART_COLOR = 21;
    public static final int NK_COLOR_CHART_COLOR_HIGHLIGHT = 22;
    public static final int NK_COLOR_SCROLLBAR = 23;
    public static final int NK_COLOR_SCROLLBAR_CURSOR = 24;
    public static final int NK_COLOR_SCROLLBAR_CURSOR_HOVER = 25;
    public static final int NK_COLOR_SCROLLBAR_CURSOR_ACTIVE = 26;
    public static final int NK_COLOR_TAB_HEADER = 27;
    public static final int NK_COLOR_COUNT = 28;
    public static final int NK_CURSOR_ARROW = 0;
    public static final int NK_CURSOR_TEXT = 1;
    public static final int NK_CURSOR_MOVE = 2;
    public static final int NK_CURSOR_RESIZE_VERTICAL = 3;
    public static final int NK_CURSOR_RESIZE_HORIZONTAL = 4;
    public static final int NK_CURSOR_RESIZE_TOP_LEFT_DOWN_RIGHT = 5;
    public static final int NK_CURSOR_RESIZE_TOP_RIGHT_DOWN_LEFT = 6;
    public static final int NK_CURSOR_COUNT = 7;
    public static final int NK_WIDGET_INVALID = 0;
    public static final int NK_WIDGET_VALID = 1;
    public static final int NK_WIDGET_ROM = 2;
    public static final int NK_WIDGET_STATE_MODIFIED = 2;
    public static final int NK_WIDGET_STATE_INACTIVE = 4;
    public static final int NK_WIDGET_STATE_ENTERED = 8;
    public static final int NK_WIDGET_STATE_HOVER = 16;
    public static final int NK_WIDGET_STATE_ACTIVED = 32;
    public static final int NK_WIDGET_STATE_LEFT = 64;
    public static final int NK_WIDGET_STATE_HOVERED = 18;
    public static final int NK_WIDGET_STATE_ACTIVE = 34;
    public static final int NK_TEXT_ALIGN_LEFT = 1;
    public static final int NK_TEXT_ALIGN_CENTERED = 2;
    public static final int NK_TEXT_ALIGN_RIGHT = 4;
    public static final int NK_TEXT_ALIGN_TOP = 8;
    public static final int NK_TEXT_ALIGN_MIDDLE = 16;
    public static final int NK_TEXT_ALIGN_BOTTOM = 32;
    public static final int NK_TEXT_LEFT = 17;
    public static final int NK_TEXT_CENTERED = 18;
    public static final int NK_TEXT_RIGHT = 20;
    public static final int NK_EDIT_DEFAULT = 0;
    public static final int NK_EDIT_READ_ONLY = 1;
    public static final int NK_EDIT_AUTO_SELECT = 2;
    public static final int NK_EDIT_SIG_ENTER = 4;
    public static final int NK_EDIT_ALLOW_TAB = 8;
    public static final int NK_EDIT_NO_CURSOR = 16;
    public static final int NK_EDIT_SELECTABLE = 32;
    public static final int NK_EDIT_CLIPBOARD = 64;
    public static final int NK_EDIT_CTRL_ENTER_NEWLINE = 128;
    public static final int NK_EDIT_NO_HORIZONTAL_SCROLL = 256;
    public static final int NK_EDIT_ALWAYS_INSERT_MODE = 512;
    public static final int NK_EDIT_MULTILINE = 1024;
    public static final int NK_EDIT_GOTO_END_ON_ACTIVATE = 2048;
    public static final int NK_EDIT_SIMPLE = 512;
    public static final int NK_EDIT_FIELD = 608;
    public static final int NK_EDIT_BOX = 1640;
    public static final int NK_EDIT_EDITOR = 1128;
    public static final int NK_EDIT_ACTIVE = 1;
    public static final int NK_EDIT_INACTIVE = 2;
    public static final int NK_EDIT_ACTIVATED = 4;
    public static final int NK_EDIT_DEACTIVATED = 8;
    public static final int NK_EDIT_COMMITED = 16;
    public static final int NK_WINDOW_BORDER = 1;
    public static final int NK_WINDOW_MOVABLE = 2;
    public static final int NK_WINDOW_SCALABLE = 4;
    public static final int NK_WINDOW_CLOSABLE = 8;
    public static final int NK_WINDOW_MINIMIZABLE = 16;
    public static final int NK_WINDOW_NO_SCROLLBAR = 32;
    public static final int NK_WINDOW_TITLE = 64;
    public static final int NK_WINDOW_SCROLL_AUTO_HIDE = 128;
    public static final int NK_WINDOW_BACKGROUND = 256;
    public static final int NK_WINDOW_SCALE_LEFT = 512;
    public static final int NK_WINDOW_NO_INPUT = 1024;
    public static final int NK_BUFFER_FIXED = 0;
    public static final int NK_BUFFER_DYNAMIC = 1;
    public static final int NK_BUFFER_FRONT = 0;
    public static final int NK_BUFFER_BACK = 1;
    public static final int NK_BUFFER_MAX = 2;
    public static final int NK_TEXT_EDIT_SINGLE_LINE = 0;
    public static final int NK_TEXT_EDIT_MULTI_LINE = 1;
    public static final int NK_TEXT_EDIT_MODE_VIEW = 0;
    public static final int NK_TEXT_EDIT_MODE_INSERT = 1;
    public static final int NK_TEXT_EDIT_MODE_REPLACE = 2;
    public static final int NK_FONT_ATLAS_ALPHA8 = 0;
    public static final int NK_FONT_ATLAS_RGBA32 = 1;
    public static final int NK_COMMAND_NOP = 0;
    public static final int NK_COMMAND_SCISSOR = 1;
    public static final int NK_COMMAND_LINE = 2;
    public static final int NK_COMMAND_CURVE = 3;
    public static final int NK_COMMAND_RECT = 4;
    public static final int NK_COMMAND_RECT_FILLED = 5;
    public static final int NK_COMMAND_RECT_MULTI_COLOR = 6;
    public static final int NK_COMMAND_CIRCLE = 7;
    public static final int NK_COMMAND_CIRCLE_FILLED = 8;
    public static final int NK_COMMAND_ARC = 9;
    public static final int NK_COMMAND_ARC_FILLED = 10;
    public static final int NK_COMMAND_TRIANGLE = 11;
    public static final int NK_COMMAND_TRIANGLE_FILLED = 12;
    public static final int NK_COMMAND_POLYGON = 13;
    public static final int NK_COMMAND_POLYGON_FILLED = 14;
    public static final int NK_COMMAND_POLYLINE = 15;
    public static final int NK_COMMAND_TEXT = 16;
    public static final int NK_COMMAND_IMAGE = 17;
    public static final int NK_COMMAND_CUSTOM = 18;
    public static final int NK_CLIPPING_OFF = 0;
    public static final int NK_CLIPPING_ON = 1;
    public static final int NK_STROKE_OPEN = 0;
    public static final int NK_STROKE_CLOSED = 1;
    public static final int NK_VERTEX_POSITION = 0;
    public static final int NK_VERTEX_COLOR = 1;
    public static final int NK_VERTEX_TEXCOORD = 2;
    public static final int NK_VERTEX_ATTRIBUTE_COUNT = 3;
    public static final int NK_FORMAT_SCHAR = 0;
    public static final int NK_FORMAT_SSHORT = 1;
    public static final int NK_FORMAT_SINT = 2;
    public static final int NK_FORMAT_UCHAR = 3;
    public static final int NK_FORMAT_USHORT = 4;
    public static final int NK_FORMAT_UINT = 5;
    public static final int NK_FORMAT_FLOAT = 6;
    public static final int NK_FORMAT_DOUBLE = 7;
    public static final int NK_FORMAT_R8G8B8 = 8;
    public static final int NK_FORMAT_R16G15B16 = 9;
    public static final int NK_FORMAT_R32G32B32 = 10;
    public static final int NK_FORMAT_R8G8B8A8 = 11;
    public static final int NK_FORMAT_R16G15B16A16 = 12;
    public static final int NK_FORMAT_R32G32B32A32 = 13;
    public static final int NK_FORMAT_R32G32B32A32_FLOAT = 14;
    public static final int NK_FORMAT_R32G32B32A32_DOUBLE = 15;
    public static final int NK_FORMAT_RGB32 = 16;
    public static final int NK_FORMAT_RGBA32 = 17;
    public static final int NK_FORMAT_COUNT = 18;
    public static final int NK_STYLE_ITEM_COLOR = 0;
    public static final int NK_STYLE_ITEM_IMAGE = 1;
    public static final int NK_HEADER_LEFT = 0;
    public static final int NK_HEADER_RIGHT = 1;
    public static final int NK_PANEL_WINDOW = 1;
    public static final int NK_PANEL_GROUP = 2;
    public static final int NK_PANEL_POPUP = 4;
    public static final int NK_PANEL_CONTEXTUAL = 16;
    public static final int NK_PANEL_COMBO = 32;
    public static final int NK_PANEL_MENU = 64;
    public static final int NK_PANEL_TOOLTIP = 128;
    public static final int NK_PANEL_SET_NONBLOCK = 240;
    public static final int NK_PANEL_SET_POPUP = 244;
    public static final int NK_PANEL_SET_SUB = 246;
    public static final int NK_LAYOUT_DYNAMIC_FIXED = 0;
    public static final int NK_LAYOUT_DYNAMIC_ROW = 1;
    public static final int NK_LAYOUT_DYNAMIC_FREE = 2;
    public static final int NK_LAYOUT_DYNAMIC = 3;
    public static final int NK_LAYOUT_STATIC_FIXED = 4;
    public static final int NK_LAYOUT_STATIC_ROW = 5;
    public static final int NK_LAYOUT_STATIC_FREE = 6;
    public static final int NK_LAYOUT_STATIC = 7;
    public static final int NK_LAYOUT_TEMPLATE = 8;
    public static final int NK_LAYOUT_COUNT = 9;
    public static final int NK_WINDOW_PRIVATE = 2048;
    public static final int NK_WINDOW_DYNAMIC = 2048;
    public static final int NK_WINDOW_ROM = 4096;
    public static final int NK_WINDOW_HIDDEN = 8192;
    public static final int NK_WINDOW_CLOSED = 16384;
    public static final int NK_WINDOW_MINIMIZED = 32768;
    public static final int NK_WINDOW_REMOVE_ROM = 65536;

    protected Nuklear() {
        throw new UnsupportedOperationException();
    }

    public static native int nnk_init_fixed(long var0, long var2, long var4, long var6);

    public static boolean nk_init_fixed(NkContext ctx, ByteBuffer memory, NkUserFont font) {
        return Nuklear.nnk_init_fixed(ctx.address(), MemoryUtil.memAddress(memory), memory.remaining(), MemoryUtil.memAddressSafe(font)) != 0;
    }

    public static native int nnk_init(long var0, long var2, long var4);

    public static boolean nk_init(NkContext ctx, NkAllocator allocator, NkUserFont font) {
        return Nuklear.nnk_init(ctx.address(), allocator.address(), MemoryUtil.memAddressSafe(font)) != 0;
    }

    public static native int nnk_init_custom(long var0, long var2, long var4, long var6);

    public static boolean nk_init_custom(NkContext ctx, NkBuffer cmds, NkBuffer pool, NkUserFont font) {
        return Nuklear.nnk_init_custom(ctx.address(), cmds.address(), pool.address(), MemoryUtil.memAddressSafe(font)) != 0;
    }

    public static native void nnk_clear(long var0);

    public static void nk_clear(NkContext ctx) {
        Nuklear.nnk_clear(ctx.address());
    }

    public static native void nnk_free(long var0);

    public static void nk_free(NkContext ctx) {
        Nuklear.nnk_free(ctx.address());
    }

    public static native void nnk_set_user_data(long var0, long var2);

    public static void nk_set_user_data(NkContext ctx, NkHandle handle) {
        Nuklear.nnk_set_user_data(ctx.address(), handle.address());
    }

    public static native int nnk_begin(long var0, long var2, long var4, int var6);

    public static boolean nk_begin(NkContext ctx, ByteBuffer title, NkRect bounds, int flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_begin(ctx.address(), MemoryUtil.memAddress(title), bounds.address(), flags) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_begin(NkContext ctx, CharSequence title, NkRect bounds, int flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_begin(ctx.address(), MemoryUtil.memAddress(titleEncoded), bounds.address(), flags) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_begin_titled(long var0, long var2, long var4, long var6, int var8);

    public static boolean nk_begin_titled(NkContext ctx, ByteBuffer name, ByteBuffer title, NkRect bounds, int flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_begin_titled(ctx.address(), MemoryUtil.memAddress(name), MemoryUtil.memAddress(title), bounds.address(), flags) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_begin_titled(NkContext ctx, CharSequence name, CharSequence title, NkRect bounds, int flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_begin_titled(ctx.address(), MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddress(titleEncoded), bounds.address(), flags) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_end(long var0);

    public static void nk_end(NkContext ctx) {
        Nuklear.nnk_end(ctx.address());
    }

    public static native long nnk_window_find(long var0, long var2);

    public static NkWindow nk_window_find(NkContext ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        long __result = Nuklear.nnk_window_find(ctx.address(), MemoryUtil.memAddress(name));
        return NkWindow.create(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NkWindow nk_window_find(NkContext ctx, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long __result = Nuklear.nnk_window_find(ctx.address(), MemoryUtil.memAddress(nameEncoded));
            NkWindow nkWindow = NkWindow.create(__result);
            return nkWindow;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_window_get_bounds(long var0, long var2);

    public static NkRect nk_window_get_bounds(NkContext ctx, NkRect __result) {
        Nuklear.nnk_window_get_bounds(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_window_get_position(long var0, long var2);

    public static NkVec2 nk_window_get_position(NkContext ctx, NkVec2 __result) {
        Nuklear.nnk_window_get_position(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_window_get_size(long var0, long var2);

    public static NkVec2 nk_window_get_size(NkContext ctx, NkVec2 __result) {
        Nuklear.nnk_window_get_size(ctx.address(), __result.address());
        return __result;
    }

    public static native float nnk_window_get_width(long var0);

    public static float nk_window_get_width(NkContext ctx) {
        return Nuklear.nnk_window_get_width(ctx.address());
    }

    public static native float nnk_window_get_height(long var0);

    public static float nk_window_get_height(NkContext ctx) {
        return Nuklear.nnk_window_get_height(ctx.address());
    }

    public static native long nnk_window_get_panel(long var0);

    public static NkPanel nk_window_get_panel(NkContext ctx) {
        long __result = Nuklear.nnk_window_get_panel(ctx.address());
        return NkPanel.create(__result);
    }

    public static native void nnk_window_get_content_region(long var0, long var2);

    public static NkRect nk_window_get_content_region(NkContext ctx, NkRect __result) {
        Nuklear.nnk_window_get_content_region(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_window_get_content_region_min(long var0, long var2);

    public static NkVec2 nk_window_get_content_region_min(NkContext ctx, NkVec2 __result) {
        Nuklear.nnk_window_get_content_region_min(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_window_get_content_region_max(long var0, long var2);

    public static NkVec2 nk_window_get_content_region_max(NkContext ctx, NkVec2 __result) {
        Nuklear.nnk_window_get_content_region_max(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_window_get_content_region_size(long var0, long var2);

    public static NkVec2 nk_window_get_content_region_size(NkContext ctx, NkVec2 __result) {
        Nuklear.nnk_window_get_content_region_size(ctx.address(), __result.address());
        return __result;
    }

    public static native long nnk_window_get_canvas(long var0);

    public static NkCommandBuffer nk_window_get_canvas(NkContext ctx) {
        long __result = Nuklear.nnk_window_get_canvas(ctx.address());
        return NkCommandBuffer.create(__result);
    }

    public static native int nnk_window_has_focus(long var0);

    public static boolean nk_window_has_focus(NkContext ctx) {
        return Nuklear.nnk_window_has_focus(ctx.address()) != 0;
    }

    public static native int nnk_window_is_collapsed(long var0, long var2);

    public static boolean nk_window_is_collapsed(NkContext ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return Nuklear.nnk_window_is_collapsed(ctx.address(), MemoryUtil.memAddress(name)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_window_is_collapsed(NkContext ctx, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            boolean bl = Nuklear.nnk_window_is_collapsed(ctx.address(), MemoryUtil.memAddress(nameEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_window_is_closed(long var0, long var2);

    public static boolean nk_window_is_closed(NkContext ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return Nuklear.nnk_window_is_closed(ctx.address(), MemoryUtil.memAddress(name)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_window_is_closed(NkContext ctx, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            boolean bl = Nuklear.nnk_window_is_closed(ctx.address(), MemoryUtil.memAddress(nameEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_window_is_hidden(long var0, long var2);

    public static boolean nk_window_is_hidden(NkContext ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return Nuklear.nnk_window_is_hidden(ctx.address(), MemoryUtil.memAddress(name)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_window_is_hidden(NkContext ctx, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            boolean bl = Nuklear.nnk_window_is_hidden(ctx.address(), MemoryUtil.memAddress(nameEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_window_is_active(long var0, long var2);

    public static boolean nk_window_is_active(NkContext ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return Nuklear.nnk_window_is_active(ctx.address(), MemoryUtil.memAddress(name)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_window_is_active(NkContext ctx, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            boolean bl = Nuklear.nnk_window_is_active(ctx.address(), MemoryUtil.memAddress(nameEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_window_is_hovered(long var0);

    public static boolean nk_window_is_hovered(NkContext ctx) {
        return Nuklear.nnk_window_is_hovered(ctx.address()) != 0;
    }

    public static native int nnk_window_is_any_hovered(long var0);

    public static boolean nk_window_is_any_hovered(NkContext ctx) {
        return Nuklear.nnk_window_is_any_hovered(ctx.address()) != 0;
    }

    public static native int nnk_item_is_any_active(long var0);

    public static boolean nk_item_is_any_active(NkContext ctx) {
        return Nuklear.nnk_item_is_any_active(ctx.address()) != 0;
    }

    public static native void nnk_window_set_bounds(long var0, long var2);

    public static void nk_window_set_bounds(NkContext ctx, NkRect bounds) {
        Nuklear.nnk_window_set_bounds(ctx.address(), bounds.address());
    }

    public static native void nnk_window_set_position(long var0, long var2);

    public static void nk_window_set_position(NkContext ctx, NkVec2 position) {
        Nuklear.nnk_window_set_position(ctx.address(), position.address());
    }

    public static native void nnk_window_set_size(long var0, long var2);

    public static void nk_window_set_size(NkContext ctx, NkVec2 size) {
        Nuklear.nnk_window_set_size(ctx.address(), size.address());
    }

    public static native void nnk_window_set_focus(long var0, long var2);

    public static void nk_window_set_focus(NkContext ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        Nuklear.nnk_window_set_focus(ctx.address(), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_window_set_focus(NkContext ctx, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_window_set_focus(ctx.address(), MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_window_close(long var0, long var2);

    public static void nk_window_close(NkContext ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        Nuklear.nnk_window_close(ctx.address(), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_window_close(NkContext ctx, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_window_close(ctx.address(), MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_window_collapse(long var0, long var2, int var4);

    public static void nk_window_collapse(NkContext ctx, ByteBuffer name, int c) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        Nuklear.nnk_window_collapse(ctx.address(), MemoryUtil.memAddress(name), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_window_collapse(NkContext ctx, CharSequence name, int c) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_window_collapse(ctx.address(), MemoryUtil.memAddress(nameEncoded), c);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_window_collapse_if(long var0, long var2, int var4, int var5);

    public static void nk_window_collapse_if(NkContext ctx, ByteBuffer name, int c, boolean cond) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        Nuklear.nnk_window_collapse_if(ctx.address(), MemoryUtil.memAddress(name), c, cond ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_window_collapse_if(NkContext ctx, CharSequence name, int c, boolean cond) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_window_collapse_if(ctx.address(), MemoryUtil.memAddress(nameEncoded), c, cond ? 1 : 0);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_window_show(long var0, long var2, int var4);

    public static void nk_window_show(NkContext ctx, ByteBuffer name, int s) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        Nuklear.nnk_window_show(ctx.address(), MemoryUtil.memAddress(name), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_window_show(NkContext ctx, CharSequence name, int s) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_window_show(ctx.address(), MemoryUtil.memAddress(nameEncoded), s);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_window_show_if(long var0, long var2, int var4, int var5);

    public static void nk_window_show_if(NkContext ctx, ByteBuffer name, int s, boolean cond) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        Nuklear.nnk_window_show_if(ctx.address(), MemoryUtil.memAddress(name), s, cond ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_window_show_if(NkContext ctx, CharSequence name, int s, boolean cond) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_window_show_if(ctx.address(), MemoryUtil.memAddress(nameEncoded), s, cond ? 1 : 0);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_layout_row_dynamic(long var0, float var2, int var3);

    public static void nk_layout_row_dynamic(NkContext ctx, float height, int cols) {
        Nuklear.nnk_layout_row_dynamic(ctx.address(), height, cols);
    }

    public static native void nnk_layout_row_static(long var0, float var2, int var3, int var4);

    public static void nk_layout_row_static(NkContext ctx, float height, int item_width, int cols) {
        Nuklear.nnk_layout_row_static(ctx.address(), height, item_width, cols);
    }

    public static native void nnk_layout_row_begin(long var0, int var2, float var3, int var4);

    public static void nk_layout_row_begin(NkContext ctx, int fmt, float row_height, int cols) {
        Nuklear.nnk_layout_row_begin(ctx.address(), fmt, row_height, cols);
    }

    public static native void nnk_layout_row_push(long var0, float var2);

    public static void nk_layout_row_push(NkContext ctx, float value) {
        Nuklear.nnk_layout_row_push(ctx.address(), value);
    }

    public static native void nnk_layout_row_end(long var0);

    public static void nk_layout_row_end(NkContext ctx) {
        Nuklear.nnk_layout_row_end(ctx.address());
    }

    public static native void nnk_layout_row(long var0, int var2, float var3, int var4, long var5);

    public static void nk_layout_row(NkContext ctx, int fmt, float height, FloatBuffer ratio) {
        Nuklear.nnk_layout_row(ctx.address(), fmt, height, ratio.remaining(), MemoryUtil.memAddress(ratio));
    }

    public static native void nnk_layout_row_template_begin(long var0, float var2);

    public static void nk_layout_row_template_begin(NkContext ctx, float height) {
        Nuklear.nnk_layout_row_template_begin(ctx.address(), height);
    }

    public static native void nnk_layout_row_template_push_dynamic(long var0);

    public static void nk_layout_row_template_push_dynamic(NkContext ctx) {
        Nuklear.nnk_layout_row_template_push_dynamic(ctx.address());
    }

    public static native void nnk_layout_row_template_push_variable(long var0, float var2);

    public static void nk_layout_row_template_push_variable(NkContext ctx, float min_width) {
        Nuklear.nnk_layout_row_template_push_variable(ctx.address(), min_width);
    }

    public static native void nnk_layout_row_template_push_static(long var0, float var2);

    public static void nk_layout_row_template_push_static(NkContext ctx, float width) {
        Nuklear.nnk_layout_row_template_push_static(ctx.address(), width);
    }

    public static native void nnk_layout_row_template_end(long var0);

    public static void nk_layout_row_template_end(NkContext ctx) {
        Nuklear.nnk_layout_row_template_end(ctx.address());
    }

    public static native void nnk_layout_space_begin(long var0, int var2, float var3, int var4);

    public static void nk_layout_space_begin(NkContext ctx, int fmt, float height, int widget_count) {
        Nuklear.nnk_layout_space_begin(ctx.address(), fmt, height, widget_count);
    }

    public static native void nnk_layout_space_push(long var0, long var2);

    public static void nk_layout_space_push(NkContext ctx, NkRect rect) {
        Nuklear.nnk_layout_space_push(ctx.address(), rect.address());
    }

    public static native void nnk_layout_space_end(long var0);

    public static void nk_layout_space_end(NkContext ctx) {
        Nuklear.nnk_layout_space_end(ctx.address());
    }

    public static native void nnk_layout_space_bounds(long var0, long var2);

    public static NkRect nk_layout_space_bounds(NkContext ctx, NkRect __result) {
        Nuklear.nnk_layout_space_bounds(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_layout_space_to_screen(long var0, long var2);

    public static NkVec2 nk_layout_space_to_screen(NkContext ctx, NkVec2 ret) {
        Nuklear.nnk_layout_space_to_screen(ctx.address(), ret.address());
        return ret;
    }

    public static native void nnk_layout_space_to_local(long var0, long var2);

    public static NkVec2 nk_layout_space_to_local(NkContext ctx, NkVec2 ret) {
        Nuklear.nnk_layout_space_to_local(ctx.address(), ret.address());
        return ret;
    }

    public static native void nnk_layout_space_rect_to_screen(long var0, long var2);

    public static NkRect nk_layout_space_rect_to_screen(NkContext ctx, NkRect ret) {
        Nuklear.nnk_layout_space_rect_to_screen(ctx.address(), ret.address());
        return ret;
    }

    public static native void nnk_layout_space_rect_to_local(long var0, long var2);

    public static NkRect nk_layout_space_rect_to_local(NkContext ctx, NkRect ret) {
        Nuklear.nnk_layout_space_rect_to_local(ctx.address(), ret.address());
        return ret;
    }

    public static native float nnk_layout_ratio_from_pixel(long var0, float var2);

    public static float nk_layout_ratio_from_pixel(NkContext ctx, float pixel_width) {
        return Nuklear.nnk_layout_ratio_from_pixel(ctx.address(), pixel_width);
    }

    public static native int nnk_group_begin(long var0, long var2, int var4);

    public static boolean nk_group_begin(NkContext ctx, ByteBuffer title, int flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_group_begin(ctx.address(), MemoryUtil.memAddress(title), flags) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_group_begin(NkContext ctx, CharSequence title, int flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_group_begin(ctx.address(), MemoryUtil.memAddress(titleEncoded), flags) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_group_scrolled_offset_begin(long var0, long var2, long var4, long var6, int var8);

    public static boolean nk_group_scrolled_offset_begin(NkContext ctx, IntBuffer x_offset, IntBuffer y_offset, ByteBuffer title, int flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x_offset, 1);
            Checks.check((Buffer)y_offset, 1);
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_group_scrolled_offset_begin(ctx.address(), MemoryUtil.memAddress(x_offset), MemoryUtil.memAddress(y_offset), MemoryUtil.memAddress(title), flags) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_group_scrolled_offset_begin(NkContext ctx, IntBuffer x_offset, IntBuffer y_offset, CharSequence title, int flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x_offset, 1);
            Checks.check((Buffer)y_offset, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_group_scrolled_offset_begin(ctx.address(), MemoryUtil.memAddress(x_offset), MemoryUtil.memAddress(y_offset), MemoryUtil.memAddress(titleEncoded), flags) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_group_scrolled_begin(long var0, long var2, long var4, int var6);

    public static boolean nk_group_scrolled_begin(NkContext ctx, NkScroll scroll, ByteBuffer title, int flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_group_scrolled_begin(ctx.address(), scroll.address(), MemoryUtil.memAddress(title), flags) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_group_scrolled_begin(NkContext ctx, NkScroll scroll, CharSequence title, int flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_group_scrolled_begin(ctx.address(), scroll.address(), MemoryUtil.memAddress(titleEncoded), flags) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_group_scrolled_end(long var0);

    public static void nk_group_scrolled_end(NkContext ctx) {
        Nuklear.nnk_group_scrolled_end(ctx.address());
    }

    public static native void nnk_group_end(long var0);

    public static void nk_group_end(NkContext ctx) {
        Nuklear.nnk_group_end(ctx.address());
    }

    public static native int nnk_list_view_begin(long var0, long var2, long var4, int var6, int var7, int var8);

    public static boolean nk_list_view_begin(NkContext ctx, NkListView view, ByteBuffer title, int flags, int row_height, int row_count) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_list_view_begin(ctx.address(), view.address(), MemoryUtil.memAddress(title), flags, row_height, row_count) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_list_view_begin(NkContext ctx, NkListView view, CharSequence title, int flags, int row_height, int row_count) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_list_view_begin(ctx.address(), view.address(), MemoryUtil.memAddress(titleEncoded), flags, row_height, row_count) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_list_view_end(long var0);

    public static void nk_list_view_end(NkListView view) {
        Nuklear.nnk_list_view_end(view.address());
    }

    public static native int nnk_tree_push_hashed(long var0, int var2, long var3, int var5, long var6, int var8, int var9);

    public static boolean nk_tree_push_hashed(NkContext ctx, int type, ByteBuffer title, int initial_state, ByteBuffer hash, int seed) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_tree_push_hashed(ctx.address(), type, MemoryUtil.memAddress(title), initial_state, MemoryUtil.memAddress(hash), hash.remaining(), seed) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_tree_push_hashed(NkContext ctx, int type, CharSequence title, int initial_state, ByteBuffer hash, int seed) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_tree_push_hashed(ctx.address(), type, MemoryUtil.memAddress(titleEncoded), initial_state, MemoryUtil.memAddress(hash), hash.remaining(), seed) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_tree_image_push_hashed(long var0, int var2, long var3, long var5, int var7, long var8, int var10, int var11);

    public static boolean nk_tree_image_push_hashed(NkContext ctx, int type, NkImage img, ByteBuffer title, int initial_state, ByteBuffer hash, int seed) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_tree_image_push_hashed(ctx.address(), type, img.address(), MemoryUtil.memAddress(title), initial_state, MemoryUtil.memAddress(hash), hash.remaining(), seed) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_tree_image_push_hashed(NkContext ctx, int type, NkImage img, CharSequence title, int initial_state, CharSequence hash, int seed) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            ByteBuffer hashEncoded = stack.UTF8(hash, false);
            boolean bl = Nuklear.nnk_tree_image_push_hashed(ctx.address(), type, img.address(), MemoryUtil.memAddress(titleEncoded), initial_state, MemoryUtil.memAddress(hashEncoded), hashEncoded.remaining(), seed) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_tree_pop(long var0);

    public static void nk_tree_pop(NkContext ctx) {
        Nuklear.nnk_tree_pop(ctx.address());
    }

    public static native int nnk_tree_state_push(long var0, int var2, long var3, long var5);

    public static boolean nk_tree_state_push(NkContext ctx, int type, ByteBuffer title, IntBuffer state) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
            Checks.check((Buffer)state, 1);
        }
        return Nuklear.nnk_tree_state_push(ctx.address(), type, MemoryUtil.memAddress(title), MemoryUtil.memAddress(state)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_tree_state_push(NkContext ctx, int type, CharSequence title, IntBuffer state) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)state, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_tree_state_push(ctx.address(), type, MemoryUtil.memAddress(titleEncoded), MemoryUtil.memAddress(state)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_tree_state_image_push(long var0, int var2, long var3, long var5, long var7);

    public static boolean nk_tree_state_image_push(NkContext ctx, int type, NkImage image, ByteBuffer title, IntBuffer state) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
            Checks.check((Buffer)state, 1);
        }
        return Nuklear.nnk_tree_state_image_push(ctx.address(), type, image.address(), MemoryUtil.memAddress(title), MemoryUtil.memAddress(state)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_tree_state_image_push(NkContext ctx, int type, NkImage image, CharSequence title, IntBuffer state) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)state, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_tree_state_image_push(ctx.address(), type, image.address(), MemoryUtil.memAddress(titleEncoded), MemoryUtil.memAddress(state)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_tree_state_pop(long var0);

    public static void nk_tree_state_pop(NkContext ctx) {
        Nuklear.nnk_tree_state_pop(ctx.address());
    }

    public static native void nnk_text(long var0, long var2, int var4, int var5);

    public static void nk_text(NkContext ctx, ByteBuffer str, int alignment) {
        Nuklear.nnk_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), alignment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_text(NkContext ctx, CharSequence str, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            Nuklear.nnk_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), alignment);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_text_colored(long var0, long var2, int var4, int var5, long var6);

    public static void nk_text_colored(NkContext ctx, ByteBuffer str, int alignment, NkColor color) {
        Nuklear.nnk_text_colored(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), alignment, color.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_text_colored(NkContext ctx, CharSequence str, int alignment, NkColor color) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            Nuklear.nnk_text_colored(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), alignment, color.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_text_wrap(long var0, long var2, int var4);

    public static void nk_text_wrap(NkContext ctx, ByteBuffer str) {
        Nuklear.nnk_text_wrap(ctx.address(), MemoryUtil.memAddress(str), str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_text_wrap(NkContext ctx, CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            Nuklear.nnk_text_wrap(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_text_wrap_colored(long var0, long var2, int var4, long var5);

    public static void nk_text_wrap_colored(NkContext ctx, ByteBuffer str, NkColor color) {
        Nuklear.nnk_text_wrap_colored(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), color.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_text_wrap_colored(NkContext ctx, CharSequence str, NkColor color) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            Nuklear.nnk_text_wrap_colored(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), color.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_label(long var0, long var2, int var4);

    public static void nk_label(NkContext ctx, ByteBuffer str, int align) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        Nuklear.nnk_label(ctx.address(), MemoryUtil.memAddress(str), align);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_label(NkContext ctx, CharSequence str, int align) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            Nuklear.nnk_label(ctx.address(), MemoryUtil.memAddress(strEncoded), align);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_label_colored(long var0, long var2, int var4, long var5);

    public static void nk_label_colored(NkContext ctx, ByteBuffer str, int align, NkColor color) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        Nuklear.nnk_label_colored(ctx.address(), MemoryUtil.memAddress(str), align, color.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_label_colored(NkContext ctx, CharSequence str, int align, NkColor color) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            Nuklear.nnk_label_colored(ctx.address(), MemoryUtil.memAddress(strEncoded), align, color.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_label_wrap(long var0, long var2);

    public static void nk_label_wrap(NkContext ctx, ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        Nuklear.nnk_label_wrap(ctx.address(), MemoryUtil.memAddress(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_label_wrap(NkContext ctx, CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            Nuklear.nnk_label_wrap(ctx.address(), MemoryUtil.memAddress(strEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_label_colored_wrap(long var0, long var2, long var4);

    public static void nk_label_colored_wrap(NkContext ctx, ByteBuffer str, NkColor color) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        Nuklear.nnk_label_colored_wrap(ctx.address(), MemoryUtil.memAddress(str), color.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_label_colored_wrap(NkContext ctx, CharSequence str, NkColor color) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            Nuklear.nnk_label_colored_wrap(ctx.address(), MemoryUtil.memAddress(strEncoded), color.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_image(long var0, long var2);

    public static void nk_image(NkContext ctx, NkImage img) {
        Nuklear.nnk_image(ctx.address(), img.address());
    }

    public static native void nnk_button_set_behavior(long var0, int var2);

    public static void nk_button_set_behavior(NkContext ctx, int behavior) {
        Nuklear.nnk_button_set_behavior(ctx.address(), behavior);
    }

    public static native int nnk_button_push_behavior(long var0, int var2);

    public static boolean nk_button_push_behavior(NkContext ctx, int behavior) {
        return Nuklear.nnk_button_push_behavior(ctx.address(), behavior) != 0;
    }

    public static native int nnk_button_pop_behavior(long var0);

    public static boolean nk_button_pop_behavior(NkContext ctx) {
        return Nuklear.nnk_button_pop_behavior(ctx.address()) != 0;
    }

    public static native int nnk_button_text(long var0, long var2, int var4);

    public static boolean nk_button_text(NkContext ctx, ByteBuffer title) {
        return Nuklear.nnk_button_text(ctx.address(), MemoryUtil.memAddress(title), title.remaining()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_text(NkContext ctx, CharSequence title) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title, false);
            boolean bl = Nuklear.nnk_button_text(ctx.address(), MemoryUtil.memAddress(titleEncoded), titleEncoded.remaining()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_label(long var0, long var2);

    public static boolean nk_button_label(NkContext ctx, ByteBuffer title) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_button_label(ctx.address(), MemoryUtil.memAddress(title)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_label(NkContext ctx, CharSequence title) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_button_label(ctx.address(), MemoryUtil.memAddress(titleEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_color(long var0, long var2);

    public static boolean nk_button_color(NkContext ctx, NkColor color) {
        return Nuklear.nnk_button_color(ctx.address(), color.address()) != 0;
    }

    public static native int nnk_button_symbol(long var0, int var2);

    public static boolean nk_button_symbol(NkContext ctx, int symbol) {
        return Nuklear.nnk_button_symbol(ctx.address(), symbol) != 0;
    }

    public static native int nnk_button_image(long var0, long var2);

    public static boolean nk_button_image(NkContext ctx, NkImage img) {
        return Nuklear.nnk_button_image(ctx.address(), img.address()) != 0;
    }

    public static native int nnk_button_symbol_label(long var0, int var2, long var3, int var5);

    public static boolean nk_button_symbol_label(NkContext ctx, int symbol, ByteBuffer text, int text_alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_button_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(text), text_alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_symbol_label(NkContext ctx, int symbol, CharSequence text, int text_alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_button_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), text_alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_symbol_text(long var0, int var2, long var3, int var5, int var6);

    public static boolean nk_button_symbol_text(NkContext ctx, int symbol, ByteBuffer text, int alignment) {
        return Nuklear.nnk_button_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_symbol_text(NkContext ctx, int symbol, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_button_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_image_label(long var0, long var2, long var4, int var6);

    public static boolean nk_button_image_label(NkContext ctx, NkImage img, ByteBuffer text, int text_alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_button_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(text), text_alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_image_label(NkContext ctx, NkImage img, CharSequence text, int text_alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_button_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), text_alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_image_text(long var0, long var2, long var4, int var6, int var7);

    public static boolean nk_button_image_text(NkContext ctx, NkImage img, ByteBuffer text, int alignment) {
        return Nuklear.nnk_button_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_image_text(NkContext ctx, NkImage img, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_button_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_text_styled(long var0, long var2, long var4, int var6);

    public static boolean nk_button_text_styled(NkContext ctx, NkStyleButton style, ByteBuffer title, int len) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_button_text_styled(ctx.address(), style.address(), MemoryUtil.memAddress(title), len) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_text_styled(NkContext ctx, NkStyleButton style, CharSequence title, int len) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_button_text_styled(ctx.address(), style.address(), MemoryUtil.memAddress(titleEncoded), len) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_label_styled(long var0, long var2, long var4);

    public static boolean nk_button_label_styled(NkContext ctx, NkStyleButton style, ByteBuffer title) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_button_label_styled(ctx.address(), style.address(), MemoryUtil.memAddress(title)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_label_styled(NkContext ctx, NkStyleButton style, CharSequence title) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_button_label_styled(ctx.address(), style.address(), MemoryUtil.memAddress(titleEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_symbol_styled(long var0, long var2, int var4);

    public static boolean nk_button_symbol_styled(NkContext ctx, NkStyleButton style, int symbol) {
        return Nuklear.nnk_button_symbol_styled(ctx.address(), style.address(), symbol) != 0;
    }

    public static native int nnk_button_image_styled(long var0, long var2, long var4);

    public static boolean nk_button_image_styled(NkContext ctx, NkStyleButton style, NkImage img) {
        return Nuklear.nnk_button_image_styled(ctx.address(), style.address(), img.address()) != 0;
    }

    public static native int nnk_button_symbol_label_styled(long var0, long var2, int var4, long var5, int var7);

    public static boolean nk_button_symbol_label_styled(NkContext ctx, NkStyleButton style, int symbol, ByteBuffer title, int text_alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_button_symbol_label_styled(ctx.address(), style.address(), symbol, MemoryUtil.memAddress(title), text_alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_symbol_label_styled(NkContext ctx, NkStyleButton style, int symbol, CharSequence title, int text_alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_button_symbol_label_styled(ctx.address(), style.address(), symbol, MemoryUtil.memAddress(titleEncoded), text_alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_symbol_text_styled(long var0, long var2, int var4, long var5, int var7, int var8);

    public static boolean nk_button_symbol_text_styled(NkContext ctx, NkStyleButton style, int symbol, ByteBuffer title, int len, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_button_symbol_text_styled(ctx.address(), style.address(), symbol, MemoryUtil.memAddress(title), len, alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_symbol_text_styled(NkContext ctx, NkStyleButton style, int symbol, CharSequence title, int len, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_button_symbol_text_styled(ctx.address(), style.address(), symbol, MemoryUtil.memAddress(titleEncoded), len, alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_image_label_styled(long var0, long var2, long var4, long var6, int var8);

    public static boolean nk_button_image_label_styled(NkContext ctx, NkStyleButton style, NkImage img, ByteBuffer title, int text_alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_button_image_label_styled(ctx.address(), style.address(), img.address(), MemoryUtil.memAddress(title), text_alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_image_label_styled(NkContext ctx, NkStyleButton style, NkImage img, CharSequence title, int text_alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_button_image_label_styled(ctx.address(), style.address(), img.address(), MemoryUtil.memAddress(titleEncoded), text_alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_button_image_text_styled(long var0, long var2, long var4, long var6, int var8, int var9);

    public static boolean nk_button_image_text_styled(NkContext ctx, NkStyleButton style, NkImage img, ByteBuffer title, int len, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_button_image_text_styled(ctx.address(), style.address(), img.address(), MemoryUtil.memAddress(title), len, alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_button_image_text_styled(NkContext ctx, NkStyleButton style, NkImage img, CharSequence title, int len, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_button_image_text_styled(ctx.address(), style.address(), img.address(), MemoryUtil.memAddress(titleEncoded), len, alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_check_label(long var0, long var2, int var4);

    public static boolean nk_check_label(NkContext ctx, ByteBuffer str, boolean active) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_check_label(ctx.address(), MemoryUtil.memAddress(str), active ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_check_label(NkContext ctx, CharSequence str, boolean active) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_check_label(ctx.address(), MemoryUtil.memAddress(strEncoded), active ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_check_text(long var0, long var2, int var4, int var5);

    public static boolean nk_check_text(NkContext ctx, ByteBuffer str, boolean active) {
        return Nuklear.nnk_check_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), active ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_check_text(NkContext ctx, CharSequence str, boolean active) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_check_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), active ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_check_flags_label(long var0, long var2, int var4, int var5);

    public static int nk_check_flags_label(NkContext ctx, ByteBuffer str, int flags, int value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_check_flags_label(ctx.address(), MemoryUtil.memAddress(str), flags, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_check_flags_label(NkContext ctx, CharSequence str, int flags, int value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            int n = Nuklear.nnk_check_flags_label(ctx.address(), MemoryUtil.memAddress(strEncoded), flags, value);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_check_flags_text(long var0, long var2, int var4, int var5, int var6);

    public static int nk_check_flags_text(NkContext ctx, ByteBuffer str, int flags, int value) {
        return Nuklear.nnk_check_flags_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), flags, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_check_flags_text(NkContext ctx, CharSequence str, int flags, int value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            int n = Nuklear.nnk_check_flags_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), flags, value);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_label(long var0, long var2, long var4);

    public static boolean nk_checkbox_label(NkContext ctx, ByteBuffer str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check((Buffer)active, 1);
        }
        return Nuklear.nnk_checkbox_label(ctx.address(), MemoryUtil.memAddress(str), MemoryUtil.memAddress(active)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_label(NkContext ctx, CharSequence str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_checkbox_label(ctx.address(), MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(active)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_text(long var0, long var2, int var4, long var5);

    public static boolean nk_checkbox_text(NkContext ctx, ByteBuffer str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)active, 1);
        }
        return Nuklear.nnk_checkbox_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), MemoryUtil.memAddress(active)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_text(NkContext ctx, CharSequence str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_checkbox_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), MemoryUtil.memAddress(active)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_flags_label(long var0, long var2, long var4, int var6);

    public static boolean nk_checkbox_flags_label(NkContext ctx, ByteBuffer str, IntBuffer flags, int value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check((Buffer)flags, 1);
        }
        return Nuklear.nnk_checkbox_flags_label(ctx.address(), MemoryUtil.memAddress(str), MemoryUtil.memAddress(flags), value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_flags_label(NkContext ctx, CharSequence str, IntBuffer flags, int value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)flags, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_checkbox_flags_label(ctx.address(), MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(flags), value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_flags_text(long var0, long var2, int var4, long var5, int var7);

    public static boolean nk_checkbox_flags_text(NkContext ctx, ByteBuffer str, IntBuffer flags, int value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)flags, 1);
        }
        return Nuklear.nnk_checkbox_flags_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), MemoryUtil.memAddress(flags), value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_flags_text(NkContext ctx, CharSequence str, IntBuffer flags, int value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)flags, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_checkbox_flags_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), MemoryUtil.memAddress(flags), value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_radio_label(long var0, long var2, long var4);

    public static boolean nk_radio_label(NkContext ctx, ByteBuffer str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check((Buffer)active, 1);
        }
        return Nuklear.nnk_radio_label(ctx.address(), MemoryUtil.memAddress(str), MemoryUtil.memAddress(active)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_radio_label(NkContext ctx, CharSequence str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_radio_label(ctx.address(), MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(active)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_radio_text(long var0, long var2, int var4, long var5);

    public static boolean nk_radio_text(NkContext ctx, ByteBuffer str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)active, 1);
        }
        return Nuklear.nnk_radio_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), MemoryUtil.memAddress(active)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_radio_text(NkContext ctx, CharSequence str, IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_radio_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), MemoryUtil.memAddress(active)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_option_label(long var0, long var2, int var4);

    public static boolean nk_option_label(NkContext ctx, ByteBuffer str, boolean active) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_option_label(ctx.address(), MemoryUtil.memAddress(str), active ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_option_label(NkContext ctx, CharSequence str, boolean active) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_option_label(ctx.address(), MemoryUtil.memAddress(strEncoded), active ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_option_text(long var0, long var2, int var4, int var5);

    public static boolean nk_option_text(NkContext ctx, ByteBuffer str, boolean active) {
        return Nuklear.nnk_option_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), active ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_option_text(NkContext ctx, CharSequence str, boolean active) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_option_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), active ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_label(long var0, long var2, int var4, long var5);

    public static boolean nk_selectable_label(NkContext ctx, ByteBuffer str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check((Buffer)value, 1);
        }
        return Nuklear.nnk_selectable_label(ctx.address(), MemoryUtil.memAddress(str), align, MemoryUtil.memAddress(value)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_label(NkContext ctx, CharSequence str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_selectable_label(ctx.address(), MemoryUtil.memAddress(strEncoded), align, MemoryUtil.memAddress(value)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_text(long var0, long var2, int var4, int var5, long var6);

    public static boolean nk_selectable_text(NkContext ctx, ByteBuffer str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return Nuklear.nnk_selectable_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), align, MemoryUtil.memAddress(value)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_text(NkContext ctx, CharSequence str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_selectable_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), align, MemoryUtil.memAddress(value)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_image_label(long var0, long var2, long var4, int var6, long var7);

    public static boolean nk_selectable_image_label(NkContext ctx, NkImage img, ByteBuffer str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check((Buffer)value, 1);
        }
        return Nuklear.nnk_selectable_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(str), align, MemoryUtil.memAddress(value)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_image_label(NkContext ctx, NkImage img, CharSequence str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_selectable_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(strEncoded), align, MemoryUtil.memAddress(value)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_image_text(long var0, long var2, long var4, int var6, int var7, long var8);

    public static boolean nk_selectable_image_text(NkContext ctx, NkImage img, ByteBuffer str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return Nuklear.nnk_selectable_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(str), str.remaining(), align, MemoryUtil.memAddress(value)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_image_text(NkContext ctx, NkImage img, CharSequence str, int align, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_selectable_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), align, MemoryUtil.memAddress(value)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_select_label(long var0, long var2, int var4, int var5);

    public static boolean nk_select_label(NkContext ctx, ByteBuffer str, int align, boolean value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_select_label(ctx.address(), MemoryUtil.memAddress(str), align, value ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_select_label(NkContext ctx, CharSequence str, int align, boolean value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_select_label(ctx.address(), MemoryUtil.memAddress(strEncoded), align, value ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_select_text(long var0, long var2, int var4, int var5, int var6);

    public static boolean nk_select_text(NkContext ctx, ByteBuffer str, int align, boolean value) {
        return Nuklear.nnk_select_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), align, value ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_select_text(NkContext ctx, CharSequence str, int align, boolean value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_select_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), align, value ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_select_image_label(long var0, long var2, long var4, int var6, int var7);

    public static boolean nk_select_image_label(NkContext ctx, NkImage img, ByteBuffer str, int align, boolean value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_select_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(str), align, value ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_select_image_label(NkContext ctx, NkImage img, CharSequence str, int align, boolean value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_select_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(strEncoded), align, value ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_select_image_text(long var0, long var2, long var4, int var6, int var7, int var8);

    public static boolean nk_select_image_text(NkContext ctx, NkImage img, ByteBuffer str, int align, boolean value) {
        return Nuklear.nnk_select_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(str), str.remaining(), align, value ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_select_image_text(NkContext ctx, NkImage img, CharSequence str, int align, boolean value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_select_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), align, value ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native float nnk_slide_float(long var0, float var2, float var3, float var4, float var5);

    public static float nk_slide_float(NkContext ctx, float min, float val, float max, float step) {
        return Nuklear.nnk_slide_float(ctx.address(), min, val, max, step);
    }

    public static native int nnk_slide_int(long var0, int var2, int var3, int var4, int var5);

    public static int nk_slide_int(NkContext ctx, int min, int val, int max, int step) {
        return Nuklear.nnk_slide_int(ctx.address(), min, val, max, step);
    }

    public static native int nnk_slider_float(long var0, float var2, long var3, float var5, float var6);

    public static int nk_slider_float(NkContext ctx, float min, FloatBuffer val, float max, float step) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)val, 1);
        }
        return Nuklear.nnk_slider_float(ctx.address(), min, MemoryUtil.memAddress(val), max, step);
    }

    public static native int nnk_slider_int(long var0, int var2, long var3, int var5, int var6);

    public static int nk_slider_int(NkContext ctx, int min, IntBuffer val, int max, int step) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)val, 1);
        }
        return Nuklear.nnk_slider_int(ctx.address(), min, MemoryUtil.memAddress(val), max, step);
    }

    public static native int nnk_progress(long var0, long var2, long var4, int var6);

    public static boolean nk_progress(NkContext ctx, PointerBuffer cur, long max, boolean modifyable) {
        if (Checks.CHECKS) {
            Checks.check(cur, 1);
        }
        return Nuklear.nnk_progress(ctx.address(), MemoryUtil.memAddress(cur), max, modifyable ? 1 : 0) != 0;
    }

    public static native long nnk_prog(long var0, long var2, long var4, int var6);

    public static long nk_prog(NkContext ctx, long cur, long max, boolean modifyable) {
        return Nuklear.nnk_prog(ctx.address(), cur, max, modifyable ? 1 : 0);
    }

    public static native void nnk_color_picker(long var0, long var2, int var4);

    public static NkColor nk_color_picker(NkContext ctx, NkColor color, int fmt) {
        Nuklear.nnk_color_picker(ctx.address(), color.address(), fmt);
        return color;
    }

    public static native int nnk_color_pick(long var0, long var2, int var4);

    public static boolean nk_color_pick(NkContext ctx, NkColor color, int fmt) {
        return Nuklear.nnk_color_pick(ctx.address(), color.address(), fmt) != 0;
    }

    public static native void nnk_property_int(long var0, long var2, int var4, long var5, int var7, int var8, float var9);

    public static void nk_property_int(NkContext ctx, ByteBuffer name, int min, IntBuffer val, int max, int step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.check((Buffer)val, 1);
        }
        Nuklear.nnk_property_int(ctx.address(), MemoryUtil.memAddress(name), min, MemoryUtil.memAddress(val), max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_property_int(NkContext ctx, CharSequence name, int min, IntBuffer val, int max, int step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)val, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_property_int(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, MemoryUtil.memAddress(val), max, step, inc_per_pixel);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_property_float(long var0, long var2, float var4, long var5, float var7, float var8, float var9);

    public static void nk_property_float(NkContext ctx, ByteBuffer name, float min, FloatBuffer val, float max, float step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.check((Buffer)val, 1);
        }
        Nuklear.nnk_property_float(ctx.address(), MemoryUtil.memAddress(name), min, MemoryUtil.memAddress(val), max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_property_float(NkContext ctx, CharSequence name, float min, FloatBuffer val, float max, float step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)val, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_property_float(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, MemoryUtil.memAddress(val), max, step, inc_per_pixel);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_property_double(long var0, long var2, double var4, long var6, double var8, double var10, float var12);

    public static void nk_property_double(NkContext ctx, ByteBuffer name, double min, DoubleBuffer val, double max, double step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.check((Buffer)val, 1);
        }
        Nuklear.nnk_property_double(ctx.address(), MemoryUtil.memAddress(name), min, MemoryUtil.memAddress(val), max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_property_double(NkContext ctx, CharSequence name, double min, DoubleBuffer val, double max, double step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)val, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_property_double(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, MemoryUtil.memAddress(val), max, step, inc_per_pixel);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_propertyi(long var0, long var2, int var4, int var5, int var6, int var7, float var8);

    public static int nk_propertyi(NkContext ctx, ByteBuffer name, int min, int val, int max, int step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return Nuklear.nnk_propertyi(ctx.address(), MemoryUtil.memAddress(name), min, val, max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_propertyi(NkContext ctx, CharSequence name, int min, int val, int max, int step, float inc_per_pixel) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            int n = Nuklear.nnk_propertyi(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, val, max, step, inc_per_pixel);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native float nnk_propertyf(long var0, long var2, float var4, float var5, float var6, float var7, float var8);

    public static float nk_propertyf(NkContext ctx, ByteBuffer name, float min, float val, float max, float step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return Nuklear.nnk_propertyf(ctx.address(), MemoryUtil.memAddress(name), min, val, max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nk_propertyf(NkContext ctx, CharSequence name, float min, float val, float max, float step, float inc_per_pixel) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            float f = Nuklear.nnk_propertyf(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, val, max, step, inc_per_pixel);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native double nnk_propertyd(long var0, long var2, double var4, double var6, double var8, double var10, float var12);

    public static double nk_propertyd(NkContext ctx, ByteBuffer name, double min, double val, double max, double step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return Nuklear.nnk_propertyd(ctx.address(), MemoryUtil.memAddress(name), min, val, max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nk_propertyd(NkContext ctx, CharSequence name, double min, double val, double max, double step, float inc_per_pixel) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            double d = Nuklear.nnk_propertyd(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, val, max, step, inc_per_pixel);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_edit_focus(long var0, int var2);

    public static void nk_edit_focus(NkContext ctx, int flags) {
        Nuklear.nnk_edit_focus(ctx.address(), flags);
    }

    public static native void nnk_edit_unfocus(long var0);

    public static void nk_edit_unfocus(NkContext ctx) {
        Nuklear.nnk_edit_unfocus(ctx.address());
    }

    public static native int nnk_edit_string(long var0, int var2, long var3, long var5, int var7, long var8);

    public static int nk_edit_string(NkContext ctx, int flags, ByteBuffer memory, IntBuffer len, int max, NkPluginFilterI filter) {
        if (Checks.CHECKS) {
            Checks.checkNT1(memory);
            Checks.check((Buffer)len, 1);
        }
        return Nuklear.nnk_edit_string(ctx.address(), flags, MemoryUtil.memAddress(memory), MemoryUtil.memAddress(len), max, MemoryUtil.memAddressSafe(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_edit_string(NkContext ctx, int flags, CharSequence memory, IntBuffer len, int max, NkPluginFilterI filter) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)len, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer memoryEncoded = stack.UTF8(memory);
            int n = Nuklear.nnk_edit_string(ctx.address(), flags, MemoryUtil.memAddress(memoryEncoded), MemoryUtil.memAddress(len), max, MemoryUtil.memAddressSafe(filter));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_edit_buffer(long var0, int var2, long var3, long var5);

    public static int nk_edit_buffer(NkContext ctx, int flags, NkTextEdit edit, NkPluginFilterI filter) {
        return Nuklear.nnk_edit_buffer(ctx.address(), flags, edit.address(), MemoryUtil.memAddressSafe(filter));
    }

    public static native int nnk_edit_string_zero_terminated(long var0, int var2, long var3, int var5, long var6);

    public static int nk_edit_string_zero_terminated(NkContext ctx, int flags, ByteBuffer buffer, int max, NkPluginFilterI filter) {
        if (Checks.CHECKS) {
            Checks.checkNT1(buffer);
        }
        return Nuklear.nnk_edit_string_zero_terminated(ctx.address(), flags, MemoryUtil.memAddress(buffer), max, MemoryUtil.memAddressSafe(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_edit_string_zero_terminated(NkContext ctx, int flags, CharSequence buffer, int max, NkPluginFilterI filter) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer bufferEncoded = stack.UTF8(buffer);
            int n = Nuklear.nnk_edit_string_zero_terminated(ctx.address(), flags, MemoryUtil.memAddress(bufferEncoded), max, MemoryUtil.memAddressSafe(filter));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_chart_begin(long var0, int var2, int var3, float var4, float var5);

    public static boolean nk_chart_begin(NkContext ctx, int type, int num, float min, float max) {
        return Nuklear.nnk_chart_begin(ctx.address(), type, num, min, max) != 0;
    }

    public static native int nnk_chart_begin_colored(long var0, int var2, long var3, long var5, int var7, float var8, float var9);

    public static boolean nk_chart_begin_colored(NkContext ctx, int type, NkColor color, NkColor active, int num, float min, float max) {
        return Nuklear.nnk_chart_begin_colored(ctx.address(), type, color.address(), active.address(), num, min, max) != 0;
    }

    public static native void nnk_chart_add_slot(long var0, int var2, int var3, float var4, float var5);

    public static void nk_chart_add_slot(NkContext ctx, int type, int count, float min_value, float max_value) {
        Nuklear.nnk_chart_add_slot(ctx.address(), type, count, min_value, max_value);
    }

    public static native void nnk_chart_add_slot_colored(long var0, int var2, long var3, long var5, int var7, float var8, float var9);

    public static void nk_chart_add_slot_colored(NkContext ctx, int type, NkColor color, NkColor active, int count, float min_value, float max_value) {
        Nuklear.nnk_chart_add_slot_colored(ctx.address(), type, color.address(), active.address(), count, min_value, max_value);
    }

    public static native int nnk_chart_push(long var0, float var2);

    public static int nk_chart_push(NkContext ctx, float value) {
        return Nuklear.nnk_chart_push(ctx.address(), value);
    }

    public static native int nnk_chart_push_slot(long var0, float var2, int var3);

    public static int nk_chart_push_slot(NkContext ctx, float value, int slot) {
        return Nuklear.nnk_chart_push_slot(ctx.address(), value, slot);
    }

    public static native void nnk_chart_end(long var0);

    public static void nk_chart_end(NkContext ctx) {
        Nuklear.nnk_chart_end(ctx.address());
    }

    public static native void nnk_plot(long var0, int var2, long var3, int var5, int var6);

    public static void nk_plot(NkContext ctx, int type, FloatBuffer values, int count, int offset) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)values, offset + count);
        }
        Nuklear.nnk_plot(ctx.address(), type, MemoryUtil.memAddress(values), count, offset);
    }

    public static native void nnk_plot_function(long var0, int var2, long var3, long var5, int var7, int var8);

    public static void nk_plot_function(NkContext ctx, int type, long userdata, NkValueGetterI value_getter, int count, int offset) {
        if (Checks.CHECKS) {
            Checks.check(userdata);
        }
        Nuklear.nnk_plot_function(ctx.address(), type, userdata, value_getter.address(), count, offset);
    }

    public static native int nnk_popup_begin(long var0, int var2, long var3, int var5, long var6);

    public static boolean nk_popup_begin(NkContext ctx, int type, ByteBuffer title, int flags, NkRect rect) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_popup_begin(ctx.address(), type, MemoryUtil.memAddress(title), flags, rect.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_popup_begin(NkContext ctx, int type, CharSequence title, int flags, NkRect rect) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_popup_begin(ctx.address(), type, MemoryUtil.memAddress(titleEncoded), flags, rect.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_popup_close(long var0);

    public static void nk_popup_close(NkContext ctx) {
        Nuklear.nnk_popup_close(ctx.address());
    }

    public static native void nnk_popup_end(long var0);

    public static void nk_popup_end(NkContext ctx) {
        Nuklear.nnk_popup_end(ctx.address());
    }

    public static native int nnk_combo(long var0, long var2, int var4, int var5, int var6, long var7);

    public static boolean nk_combo(NkContext ctx, PointerBuffer items, boolean selected, int item_height, NkVec2 size) {
        return Nuklear.nnk_combo(ctx.address(), MemoryUtil.memAddress(items), items.remaining(), selected ? 1 : 0, item_height, size.address()) != 0;
    }

    public static native int nnk_combo_separator(long var0, long var2, int var4, int var5, int var6, int var7, long var8);

    public static boolean nk_combo_separator(NkContext ctx, ByteBuffer items_separated_by_separator, int separator, boolean selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(items_separated_by_separator);
        }
        return Nuklear.nnk_combo_separator(ctx.address(), MemoryUtil.memAddress(items_separated_by_separator), separator, selected ? 1 : 0, count, item_height, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_separator(NkContext ctx, CharSequence items_separated_by_separator, int separator, boolean selected, int count, int item_height, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer items_separated_by_separatorEncoded = stack.UTF8(items_separated_by_separator);
            boolean bl = Nuklear.nnk_combo_separator(ctx.address(), MemoryUtil.memAddress(items_separated_by_separatorEncoded), separator, selected ? 1 : 0, count, item_height, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_string(long var0, long var2, int var4, int var5, int var6, long var7);

    public static boolean nk_combo_string(NkContext ctx, ByteBuffer items_separated_by_zeros, boolean selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(items_separated_by_zeros);
        }
        return Nuklear.nnk_combo_string(ctx.address(), MemoryUtil.memAddress(items_separated_by_zeros), selected ? 1 : 0, count, item_height, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_string(NkContext ctx, CharSequence items_separated_by_zeros, boolean selected, int count, int item_height, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer items_separated_by_zerosEncoded = stack.UTF8(items_separated_by_zeros);
            boolean bl = Nuklear.nnk_combo_string(ctx.address(), MemoryUtil.memAddress(items_separated_by_zerosEncoded), selected ? 1 : 0, count, item_height, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_callback(long var0, long var2, long var4, int var6, int var7, int var8, long var9);

    public static boolean nk_combo_callback(NkContext ctx, NkItemGetterI item_getter, long userdata, boolean selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check(userdata);
        }
        return Nuklear.nnk_combo_callback(ctx.address(), item_getter.address(), userdata, selected ? 1 : 0, count, item_height, size.address()) != 0;
    }

    public static native void nnk_combobox(long var0, long var2, int var4, long var5, int var7, long var8);

    public static void nk_combobox(NkContext ctx, PointerBuffer items, IntBuffer selected, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)selected, 1);
        }
        Nuklear.nnk_combobox(ctx.address(), MemoryUtil.memAddress(items), items.remaining(), MemoryUtil.memAddress(selected), item_height, size.address());
    }

    public static native void nnk_combobox_string(long var0, long var2, long var4, int var6, int var7, long var8);

    public static void nk_combobox_string(NkContext ctx, ByteBuffer items_separated_by_zeros, IntBuffer selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(items_separated_by_zeros);
            Checks.check((Buffer)selected, 1);
        }
        Nuklear.nnk_combobox_string(ctx.address(), MemoryUtil.memAddress(items_separated_by_zeros), MemoryUtil.memAddress(selected), count, item_height, size.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_combobox_string(NkContext ctx, CharSequence items_separated_by_zeros, IntBuffer selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)selected, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer items_separated_by_zerosEncoded = stack.UTF8(items_separated_by_zeros);
            Nuklear.nnk_combobox_string(ctx.address(), MemoryUtil.memAddress(items_separated_by_zerosEncoded), MemoryUtil.memAddress(selected), count, item_height, size.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_combobox_separator(long var0, long var2, int var4, long var5, int var7, int var8, long var9);

    public static void nk_combobox_separator(NkContext ctx, ByteBuffer items_separated_by_separator, int separator, IntBuffer selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(items_separated_by_separator);
            Checks.check((Buffer)selected, 1);
        }
        Nuklear.nnk_combobox_separator(ctx.address(), MemoryUtil.memAddress(items_separated_by_separator), separator, MemoryUtil.memAddress(selected), count, item_height, size.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_combobox_separator(NkContext ctx, CharSequence items_separated_by_separator, int separator, IntBuffer selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)selected, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer items_separated_by_separatorEncoded = stack.UTF8(items_separated_by_separator);
            Nuklear.nnk_combobox_separator(ctx.address(), MemoryUtil.memAddress(items_separated_by_separatorEncoded), separator, MemoryUtil.memAddress(selected), count, item_height, size.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_combobox_callback(long var0, long var2, long var4, long var6, int var8, int var9, long var10);

    public static void nk_combobox_callback(NkContext ctx, NkItemGetterI item_getter, long userdata, IntBuffer selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check(userdata);
            Checks.check((Buffer)selected, 1);
        }
        Nuklear.nnk_combobox_callback(ctx.address(), item_getter.address(), userdata, MemoryUtil.memAddress(selected), count, item_height, size.address());
    }

    public static native int nnk_combo_begin_text(long var0, long var2, int var4, long var5);

    public static boolean nk_combo_begin_text(NkContext ctx, ByteBuffer selected, NkVec2 size) {
        return Nuklear.nnk_combo_begin_text(ctx.address(), MemoryUtil.memAddress(selected), selected.remaining(), size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_begin_text(NkContext ctx, CharSequence selected, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer selectedEncoded = stack.UTF8(selected, false);
            boolean bl = Nuklear.nnk_combo_begin_text(ctx.address(), MemoryUtil.memAddress(selectedEncoded), selectedEncoded.remaining(), size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_begin_label(long var0, long var2, long var4);

    public static boolean nk_combo_begin_label(NkContext ctx, ByteBuffer selected, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(selected);
        }
        return Nuklear.nnk_combo_begin_label(ctx.address(), MemoryUtil.memAddress(selected), size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_begin_label(NkContext ctx, CharSequence selected, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer selectedEncoded = stack.UTF8(selected);
            boolean bl = Nuklear.nnk_combo_begin_label(ctx.address(), MemoryUtil.memAddress(selectedEncoded), size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_begin_color(long var0, long var2, long var4);

    public static boolean nk_combo_begin_color(NkContext ctx, NkColor color, NkVec2 size) {
        return Nuklear.nnk_combo_begin_color(ctx.address(), color.address(), size.address()) != 0;
    }

    public static native int nnk_combo_begin_symbol(long var0, int var2, long var3);

    public static boolean nk_combo_begin_symbol(NkContext ctx, int symbol, NkVec2 size) {
        return Nuklear.nnk_combo_begin_symbol(ctx.address(), symbol, size.address()) != 0;
    }

    public static native int nnk_combo_begin_symbol_label(long var0, long var2, int var4, long var5);

    public static boolean nk_combo_begin_symbol_label(NkContext ctx, ByteBuffer selected, int symbol, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(selected);
        }
        return Nuklear.nnk_combo_begin_symbol_label(ctx.address(), MemoryUtil.memAddress(selected), symbol, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_begin_symbol_label(NkContext ctx, CharSequence selected, int symbol, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer selectedEncoded = stack.UTF8(selected);
            boolean bl = Nuklear.nnk_combo_begin_symbol_label(ctx.address(), MemoryUtil.memAddress(selectedEncoded), symbol, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_begin_symbol_text(long var0, long var2, int var4, int var5, long var6);

    public static boolean nk_combo_begin_symbol_text(NkContext ctx, ByteBuffer selected, int symbol, NkVec2 size) {
        return Nuklear.nnk_combo_begin_symbol_text(ctx.address(), MemoryUtil.memAddress(selected), selected.remaining(), symbol, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_begin_symbol_text(NkContext ctx, CharSequence selected, int symbol, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer selectedEncoded = stack.UTF8(selected, false);
            boolean bl = Nuklear.nnk_combo_begin_symbol_text(ctx.address(), MemoryUtil.memAddress(selectedEncoded), selectedEncoded.remaining(), symbol, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_begin_image(long var0, long var2, long var4);

    public static boolean nk_combo_begin_image(NkContext ctx, NkImage img, NkVec2 size) {
        return Nuklear.nnk_combo_begin_image(ctx.address(), img.address(), size.address()) != 0;
    }

    public static native int nnk_combo_begin_image_label(long var0, long var2, long var4, long var6);

    public static boolean nk_combo_begin_image_label(NkContext ctx, ByteBuffer selected, NkImage img, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(selected);
        }
        return Nuklear.nnk_combo_begin_image_label(ctx.address(), MemoryUtil.memAddress(selected), img.address(), size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_begin_image_label(NkContext ctx, CharSequence selected, NkImage img, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer selectedEncoded = stack.UTF8(selected);
            boolean bl = Nuklear.nnk_combo_begin_image_label(ctx.address(), MemoryUtil.memAddress(selectedEncoded), img.address(), size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_begin_image_text(long var0, long var2, int var4, long var5, long var7);

    public static boolean nk_combo_begin_image_text(NkContext ctx, ByteBuffer selected, NkImage img, NkVec2 size) {
        return Nuklear.nnk_combo_begin_image_text(ctx.address(), MemoryUtil.memAddress(selected), selected.remaining(), img.address(), size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_begin_image_text(NkContext ctx, CharSequence selected, NkImage img, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer selectedEncoded = stack.UTF8(selected, false);
            boolean bl = Nuklear.nnk_combo_begin_image_text(ctx.address(), MemoryUtil.memAddress(selectedEncoded), selectedEncoded.remaining(), img.address(), size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_item_label(long var0, long var2, int var4);

    public static boolean nk_combo_item_label(NkContext ctx, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_combo_item_label(ctx.address(), MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_item_label(NkContext ctx, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_combo_item_label(ctx.address(), MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_item_text(long var0, long var2, int var4, int var5);

    public static boolean nk_combo_item_text(NkContext ctx, ByteBuffer text, int alignment) {
        return Nuklear.nnk_combo_item_text(ctx.address(), MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_item_text(NkContext ctx, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_combo_item_text(ctx.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_item_image_label(long var0, long var2, long var4, int var6);

    public static boolean nk_combo_item_image_label(NkContext ctx, NkImage img, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_combo_item_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_item_image_label(NkContext ctx, NkImage img, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_combo_item_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_item_image_text(long var0, long var2, long var4, int var6, int var7);

    public static boolean nk_combo_item_image_text(NkContext ctx, NkImage img, ByteBuffer text, int alignment) {
        return Nuklear.nnk_combo_item_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_item_image_text(NkContext ctx, NkImage img, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_combo_item_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_item_symbol_label(long var0, int var2, long var3, int var5);

    public static boolean nk_combo_item_symbol_label(NkContext ctx, int symbol, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_combo_item_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_item_symbol_label(NkContext ctx, int symbol, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_combo_item_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_combo_item_symbol_text(long var0, int var2, long var3, int var5, int var6);

    public static boolean nk_combo_item_symbol_text(NkContext ctx, int symbol, ByteBuffer text, int alignment) {
        return Nuklear.nnk_combo_item_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_combo_item_symbol_text(NkContext ctx, int symbol, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_combo_item_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_combo_close(long var0);

    public static void nk_combo_close(NkContext ctx) {
        Nuklear.nnk_combo_close(ctx.address());
    }

    public static native void nnk_combo_end(long var0);

    public static void nk_combo_end(NkContext ctx) {
        Nuklear.nnk_combo_end(ctx.address());
    }

    public static native int nnk_contextual_begin(long var0, int var2, long var3, long var5);

    public static boolean nk_contextual_begin(NkContext ctx, int flags, NkVec2 size, NkRect trigger_bounds) {
        return Nuklear.nnk_contextual_begin(ctx.address(), flags, size.address(), trigger_bounds.address()) != 0;
    }

    public static native int nnk_contextual_item_text(long var0, long var2, int var4, int var5);

    public static boolean nk_contextual_item_text(NkContext ctx, ByteBuffer text, int align) {
        return Nuklear.nnk_contextual_item_text(ctx.address(), MemoryUtil.memAddress(text), text.remaining(), align) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_contextual_item_text(NkContext ctx, CharSequence text, int align) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_contextual_item_text(ctx.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), align) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_contextual_item_label(long var0, long var2, int var4);

    public static boolean nk_contextual_item_label(NkContext ctx, ByteBuffer text, int align) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_contextual_item_label(ctx.address(), MemoryUtil.memAddress(text), align) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_contextual_item_label(NkContext ctx, CharSequence text, int align) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_contextual_item_label(ctx.address(), MemoryUtil.memAddress(textEncoded), align) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_contextual_item_image_label(long var0, long var2, long var4, int var6);

    public static boolean nk_contextual_item_image_label(NkContext ctx, NkImage img, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_contextual_item_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_contextual_item_image_label(NkContext ctx, NkImage img, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_contextual_item_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_contextual_item_image_text(long var0, long var2, long var4, int var6, int var7);

    public static boolean nk_contextual_item_image_text(NkContext ctx, NkImage img, ByteBuffer text, int alignment) {
        return Nuklear.nnk_contextual_item_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_contextual_item_image_text(NkContext ctx, NkImage img, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_contextual_item_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_contextual_item_symbol_label(long var0, int var2, long var3, int var5);

    public static boolean nk_contextual_item_symbol_label(NkContext ctx, int symbol, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_contextual_item_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_contextual_item_symbol_label(NkContext ctx, int symbol, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_contextual_item_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_contextual_item_symbol_text(long var0, int var2, long var3, int var5, int var6);

    public static boolean nk_contextual_item_symbol_text(NkContext ctx, int symbol, ByteBuffer text, int alignment) {
        return Nuklear.nnk_contextual_item_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_contextual_item_symbol_text(NkContext ctx, int symbol, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_contextual_item_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_contextual_close(long var0);

    public static void nk_contextual_close(NkContext ctx) {
        Nuklear.nnk_contextual_close(ctx.address());
    }

    public static native void nnk_contextual_end(long var0);

    public static void nk_contextual_end(NkContext ctx) {
        Nuklear.nnk_contextual_end(ctx.address());
    }

    public static native void nnk_tooltip(long var0, long var2);

    public static void nk_tooltip(NkContext ctx, ByteBuffer text) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        Nuklear.nnk_tooltip(ctx.address(), MemoryUtil.memAddress(text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_tooltip(NkContext ctx, CharSequence text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            Nuklear.nnk_tooltip(ctx.address(), MemoryUtil.memAddress(textEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_tooltip_begin(long var0, float var2);

    public static boolean nk_tooltip_begin(NkContext ctx, float width) {
        return Nuklear.nnk_tooltip_begin(ctx.address(), width) != 0;
    }

    public static native void nnk_tooltip_end(long var0);

    public static void nk_tooltip_end(NkContext ctx) {
        Nuklear.nnk_tooltip_end(ctx.address());
    }

    public static native void nnk_menubar_begin(long var0);

    public static void nk_menubar_begin(NkContext ctx) {
        Nuklear.nnk_menubar_begin(ctx.address());
    }

    public static native void nnk_menubar_end(long var0);

    public static void nk_menubar_end(NkContext ctx) {
        Nuklear.nnk_menubar_end(ctx.address());
    }

    public static native int nnk_menu_begin_text(long var0, long var2, int var4, int var5, long var6);

    public static boolean nk_menu_begin_text(NkContext ctx, ByteBuffer text, int align, NkVec2 size) {
        return Nuklear.nnk_menu_begin_text(ctx.address(), MemoryUtil.memAddress(text), text.remaining(), align, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_text(NkContext ctx, CharSequence text, int align, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_menu_begin_text(ctx.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), align, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_begin_label(long var0, long var2, int var4, long var5);

    public static boolean nk_menu_begin_label(NkContext ctx, ByteBuffer text, int align, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_begin_label(ctx.address(), MemoryUtil.memAddress(text), align, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_label(NkContext ctx, CharSequence text, int align, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_begin_label(ctx.address(), MemoryUtil.memAddress(textEncoded), align, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_begin_image(long var0, long var2, long var4, long var6);

    public static boolean nk_menu_begin_image(NkContext ctx, ByteBuffer text, NkImage img, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_begin_image(ctx.address(), MemoryUtil.memAddress(text), img.address(), size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_image(NkContext ctx, CharSequence text, NkImage img, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_begin_image(ctx.address(), MemoryUtil.memAddress(textEncoded), img.address(), size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_begin_image_text(long var0, long var2, int var4, int var5, long var6, long var8);

    public static boolean nk_menu_begin_image_text(NkContext ctx, ByteBuffer text, int align, NkImage img, NkVec2 size) {
        return Nuklear.nnk_menu_begin_image_text(ctx.address(), MemoryUtil.memAddress(text), text.remaining(), align, img.address(), size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_image_text(NkContext ctx, CharSequence text, int align, NkImage img, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_menu_begin_image_text(ctx.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), align, img.address(), size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_begin_image_label(long var0, long var2, int var4, long var5, long var7);

    public static boolean nk_menu_begin_image_label(NkContext ctx, ByteBuffer text, int align, NkImage img, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_begin_image_label(ctx.address(), MemoryUtil.memAddress(text), align, img.address(), size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_image_label(NkContext ctx, CharSequence text, int align, NkImage img, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_begin_image_label(ctx.address(), MemoryUtil.memAddress(textEncoded), align, img.address(), size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_begin_symbol(long var0, long var2, int var4, long var5);

    public static boolean nk_menu_begin_symbol(NkContext ctx, ByteBuffer text, int symbol, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_begin_symbol(ctx.address(), MemoryUtil.memAddress(text), symbol, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_symbol(NkContext ctx, CharSequence text, int symbol, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_begin_symbol(ctx.address(), MemoryUtil.memAddress(textEncoded), symbol, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_begin_symbol_text(long var0, long var2, int var4, int var5, int var6, long var7);

    public static boolean nk_menu_begin_symbol_text(NkContext ctx, ByteBuffer text, int align, int symbol, NkVec2 size) {
        return Nuklear.nnk_menu_begin_symbol_text(ctx.address(), MemoryUtil.memAddress(text), text.remaining(), align, symbol, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_symbol_text(NkContext ctx, CharSequence text, int align, int symbol, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_menu_begin_symbol_text(ctx.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), align, symbol, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_begin_symbol_label(long var0, long var2, int var4, int var5, long var6);

    public static boolean nk_menu_begin_symbol_label(NkContext ctx, ByteBuffer text, int align, int symbol, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_begin_symbol_label(ctx.address(), MemoryUtil.memAddress(text), align, symbol, size.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_begin_symbol_label(NkContext ctx, CharSequence text, int align, int symbol, NkVec2 size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_begin_symbol_label(ctx.address(), MemoryUtil.memAddress(textEncoded), align, symbol, size.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_item_text(long var0, long var2, int var4, int var5);

    public static boolean nk_menu_item_text(NkContext ctx, ByteBuffer text, int align) {
        return Nuklear.nnk_menu_item_text(ctx.address(), MemoryUtil.memAddress(text), text.remaining(), align) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_item_text(NkContext ctx, CharSequence text, int align) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_menu_item_text(ctx.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), align) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_item_label(long var0, long var2, int var4);

    public static boolean nk_menu_item_label(NkContext ctx, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_item_label(ctx.address(), MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_item_label(NkContext ctx, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_item_label(ctx.address(), MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_item_image_label(long var0, long var2, long var4, int var6);

    public static boolean nk_menu_item_image_label(NkContext ctx, NkImage img, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_item_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_item_image_label(NkContext ctx, NkImage img, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_item_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_item_image_text(long var0, long var2, long var4, int var6, int var7);

    public static boolean nk_menu_item_image_text(NkContext ctx, NkImage img, ByteBuffer text, int alignment) {
        return Nuklear.nnk_menu_item_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_item_image_text(NkContext ctx, NkImage img, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_menu_item_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_item_symbol_text(long var0, int var2, long var3, int var5, int var6);

    public static boolean nk_menu_item_symbol_text(NkContext ctx, int symbol, ByteBuffer text, int alignment) {
        return Nuklear.nnk_menu_item_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(text), text.remaining(), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_item_symbol_text(NkContext ctx, int symbol, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            boolean bl = Nuklear.nnk_menu_item_symbol_text(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_menu_item_symbol_label(long var0, int var2, long var3, int var5);

    public static boolean nk_menu_item_symbol_label(NkContext ctx, int symbol, ByteBuffer text, int alignment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return Nuklear.nnk_menu_item_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(text), alignment) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_menu_item_symbol_label(NkContext ctx, int symbol, CharSequence text, int alignment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text);
            boolean bl = Nuklear.nnk_menu_item_symbol_label(ctx.address(), symbol, MemoryUtil.memAddress(textEncoded), alignment) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_menu_close(long var0);

    public static void nk_menu_close(NkContext ctx) {
        Nuklear.nnk_menu_close(ctx.address());
    }

    public static native void nnk_menu_end(long var0);

    public static void nk_menu_end(NkContext ctx) {
        Nuklear.nnk_menu_end(ctx.address());
    }

    public static native int nnk_convert(long var0, long var2, long var4, long var6, long var8);

    public static int nk_convert(NkContext ctx, NkBuffer cmds, NkBuffer vertices, NkBuffer elements, NkConvertConfig config) {
        if (Checks.CHECKS) {
            NkConvertConfig.validate(config.address());
        }
        return Nuklear.nnk_convert(ctx.address(), cmds.address(), vertices.address(), elements.address(), config.address());
    }

    public static native void nnk_input_begin(long var0);

    public static void nk_input_begin(NkContext ctx) {
        Nuklear.nnk_input_begin(ctx.address());
    }

    public static native void nnk_input_motion(long var0, int var2, int var3);

    public static void nk_input_motion(NkContext ctx, int x, int y) {
        Nuklear.nnk_input_motion(ctx.address(), x, y);
    }

    public static native void nnk_input_key(long var0, int var2, int var3);

    public static void nk_input_key(NkContext ctx, int key, boolean down) {
        Nuklear.nnk_input_key(ctx.address(), key, down ? 1 : 0);
    }

    public static native void nnk_input_button(long var0, int var2, int var3, int var4, int var5);

    public static void nk_input_button(NkContext ctx, int id, int x, int y, boolean down) {
        Nuklear.nnk_input_button(ctx.address(), id, x, y, down ? 1 : 0);
    }

    public static native void nnk_input_scroll(long var0, long var2);

    public static void nk_input_scroll(NkContext ctx, NkVec2 val) {
        Nuklear.nnk_input_scroll(ctx.address(), val.address());
    }

    public static native void nnk_input_char(long var0, byte var2);

    public static void nk_input_char(NkContext ctx, byte c) {
        Nuklear.nnk_input_char(ctx.address(), c);
    }

    public static native void nnk_input_glyph(long var0, long var2);

    public static void nk_input_glyph(NkContext ctx, ByteBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 4);
        }
        Nuklear.nnk_input_glyph(ctx.address(), MemoryUtil.memAddress(glyph));
    }

    public static native void nnk_input_unicode(long var0, int var2);

    public static void nk_input_unicode(NkContext ctx, int unicode) {
        Nuklear.nnk_input_unicode(ctx.address(), unicode);
    }

    public static native void nnk_input_end(long var0);

    public static void nk_input_end(NkContext ctx) {
        Nuklear.nnk_input_end(ctx.address());
    }

    public static native void nnk_style_default(long var0);

    public static void nk_style_default(NkContext ctx) {
        Nuklear.nnk_style_default(ctx.address());
    }

    public static native void nnk_style_from_table(long var0, long var2);

    public static void nk_style_from_table(NkContext ctx, NkColor.Buffer table) {
        if (Checks.CHECKS) {
            Checks.check(table, 28);
        }
        Nuklear.nnk_style_from_table(ctx.address(), table.address());
    }

    public static native void nnk_style_load_cursor(long var0, int var2, long var3);

    public static void nk_style_load_cursor(NkContext ctx, int style, NkCursor cursor) {
        Nuklear.nnk_style_load_cursor(ctx.address(), style, cursor.address());
    }

    public static native void nnk_style_load_all_cursors(long var0, long var2);

    public static void nk_style_load_all_cursors(NkContext ctx, NkCursor.Buffer cursors) {
        if (Checks.CHECKS) {
            Checks.check(cursors, 7);
        }
        Nuklear.nnk_style_load_all_cursors(ctx.address(), cursors.address());
    }

    public static native long nnk_style_get_color_by_name(int var0);

    public static String nk_style_get_color_by_name(int c) {
        long __result = Nuklear.nnk_style_get_color_by_name(c);
        return MemoryUtil.memUTF8(__result);
    }

    public static native void nnk_style_set_font(long var0, long var2);

    public static void nk_style_set_font(NkContext ctx, NkUserFont font) {
        Nuklear.nnk_style_set_font(ctx.address(), font.address());
    }

    public static native int nnk_style_set_cursor(long var0, int var2);

    public static int nk_style_set_cursor(NkContext ctx, int style) {
        return Nuklear.nnk_style_set_cursor(ctx.address(), style);
    }

    public static native void nnk_style_show_cursor(long var0);

    public static void nk_style_show_cursor(NkContext ctx) {
        Nuklear.nnk_style_show_cursor(ctx.address());
    }

    public static native void nnk_style_hide_cursor(long var0);

    public static void nk_style_hide_cursor(NkContext ctx) {
        Nuklear.nnk_style_hide_cursor(ctx.address());
    }

    public static native int nnk_style_push_font(long var0, long var2);

    public static int nk_style_push_font(NkContext ctx, NkUserFont font) {
        return Nuklear.nnk_style_push_font(ctx.address(), font.address());
    }

    public static native int nnk_style_push_float(long var0, long var2, float var4);

    public static int nk_style_push_float(NkContext ctx, FloatBuffer address, float value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)address, 1);
        }
        return Nuklear.nnk_style_push_float(ctx.address(), MemoryUtil.memAddress(address), value);
    }

    public static native int nnk_style_push_vec2(long var0, long var2, long var4);

    public static int nk_style_push_vec2(NkContext ctx, NkVec2 address, NkVec2 value) {
        return Nuklear.nnk_style_push_vec2(ctx.address(), address.address(), value.address());
    }

    public static native int nnk_style_push_style_item(long var0, long var2, long var4);

    public static int nk_style_push_style_item(NkContext ctx, NkStyleItem address, NkStyleItem value) {
        return Nuklear.nnk_style_push_style_item(ctx.address(), address.address(), value.address());
    }

    public static native int nnk_style_push_flags(long var0, long var2, int var4);

    public static int nk_style_push_flags(NkContext ctx, IntBuffer address, int value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)address, 1);
        }
        return Nuklear.nnk_style_push_flags(ctx.address(), MemoryUtil.memAddress(address), value);
    }

    public static native int nnk_style_push_color(long var0, long var2, long var4);

    public static int nk_style_push_color(NkContext ctx, NkColor address, NkColor value) {
        return Nuklear.nnk_style_push_color(ctx.address(), address.address(), value.address());
    }

    public static native int nnk_style_pop_font(long var0);

    public static int nk_style_pop_font(NkContext ctx) {
        return Nuklear.nnk_style_pop_font(ctx.address());
    }

    public static native int nnk_style_pop_float(long var0);

    public static int nk_style_pop_float(NkContext ctx) {
        return Nuklear.nnk_style_pop_float(ctx.address());
    }

    public static native int nnk_style_pop_vec2(long var0);

    public static int nk_style_pop_vec2(NkContext ctx) {
        return Nuklear.nnk_style_pop_vec2(ctx.address());
    }

    public static native int nnk_style_pop_style_item(long var0);

    public static int nk_style_pop_style_item(NkContext ctx) {
        return Nuklear.nnk_style_pop_style_item(ctx.address());
    }

    public static native int nnk_style_pop_flags(long var0);

    public static int nk_style_pop_flags(NkContext ctx) {
        return Nuklear.nnk_style_pop_flags(ctx.address());
    }

    public static native int nnk_style_pop_color(long var0);

    public static int nk_style_pop_color(NkContext ctx) {
        return Nuklear.nnk_style_pop_color(ctx.address());
    }

    public static native void nnk_widget_bounds(long var0, long var2);

    public static NkRect nk_widget_bounds(NkContext ctx, NkRect __result) {
        Nuklear.nnk_widget_bounds(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_widget_position(long var0, long var2);

    public static NkVec2 nk_widget_position(NkContext ctx, NkVec2 __result) {
        Nuklear.nnk_widget_position(ctx.address(), __result.address());
        return __result;
    }

    public static native void nnk_widget_size(long var0, long var2);

    public static NkVec2 nk_widget_size(NkContext ctx, NkVec2 __result) {
        Nuklear.nnk_widget_size(ctx.address(), __result.address());
        return __result;
    }

    public static native float nnk_widget_width(long var0);

    public static float nk_widget_width(NkContext ctx) {
        return Nuklear.nnk_widget_width(ctx.address());
    }

    public static native float nnk_widget_height(long var0);

    public static float nk_widget_height(NkContext ctx) {
        return Nuklear.nnk_widget_height(ctx.address());
    }

    public static native int nnk_widget_is_hovered(long var0);

    public static boolean nk_widget_is_hovered(NkContext ctx) {
        return Nuklear.nnk_widget_is_hovered(ctx.address()) != 0;
    }

    public static native int nnk_widget_is_mouse_clicked(long var0, int var2);

    public static boolean nk_widget_is_mouse_clicked(NkContext ctx, int btn) {
        return Nuklear.nnk_widget_is_mouse_clicked(ctx.address(), btn) != 0;
    }

    public static native int nnk_widget_has_mouse_click_down(long var0, int var2, int var3);

    public static boolean nk_widget_has_mouse_click_down(NkContext ctx, int btn, boolean down) {
        return Nuklear.nnk_widget_has_mouse_click_down(ctx.address(), btn, down ? 1 : 0) != 0;
    }

    public static native void nnk_spacing(long var0, int var2);

    public static void nk_spacing(NkContext ctx, int cols) {
        Nuklear.nnk_spacing(ctx.address(), cols);
    }

    public static native int nnk_widget(long var0, long var2);

    public static int nk_widget(NkRect bounds, NkContext ctx) {
        return Nuklear.nnk_widget(bounds.address(), ctx.address());
    }

    public static native int nnk_widget_fitting(long var0, long var2, long var4);

    public static int nk_widget_fitting(NkRect bounds, NkContext ctx, NkVec2 item_padding) {
        return Nuklear.nnk_widget_fitting(bounds.address(), ctx.address(), item_padding.address());
    }

    public static native void nnk_rgb(int var0, int var1, int var2, long var3);

    public static NkColor nk_rgb(int r, int g, int b, NkColor __result) {
        Nuklear.nnk_rgb(r, g, b, __result.address());
        return __result;
    }

    public static native void nnk_rgb_iv(long var0, long var2);

    public static NkColor nk_rgb_iv(IntBuffer rgb, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgb, 3);
        }
        Nuklear.nnk_rgb_iv(MemoryUtil.memAddress(rgb), __result.address());
        return __result;
    }

    public static native void nnk_rgb_bv(long var0, long var2);

    public static NkColor nk_rgb_bv(ByteBuffer rgb, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgb, 3);
        }
        Nuklear.nnk_rgb_bv(MemoryUtil.memAddress(rgb), __result.address());
        return __result;
    }

    public static native void nnk_rgb_f(float var0, float var1, float var2, long var3);

    public static NkColor nk_rgb_f(float r, float g, float b, NkColor __result) {
        Nuklear.nnk_rgb_f(r, g, b, __result.address());
        return __result;
    }

    public static native void nnk_rgb_fv(long var0, long var2);

    public static NkColor nk_rgb_fv(FloatBuffer rgb, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgb, 3);
        }
        Nuklear.nnk_rgb_fv(MemoryUtil.memAddress(rgb), __result.address());
        return __result;
    }

    public static native void nnk_rgb_hex(long var0, long var2);

    public static NkColor nk_rgb_hex(ByteBuffer rgb, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgb, 6);
        }
        Nuklear.nnk_rgb_hex(MemoryUtil.memAddress(rgb), __result.address());
        return __result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NkColor nk_rgb_hex(CharSequence rgb, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(rgb, 6);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer rgbEncoded = stack.ASCII(rgb);
            Nuklear.nnk_rgb_hex(MemoryUtil.memAddress(rgbEncoded), __result.address());
            NkColor nkColor = __result;
            return nkColor;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_rgba(int var0, int var1, int var2, int var3, long var4);

    public static NkColor nk_rgba(int r, int g, int b, int a, NkColor __result) {
        Nuklear.nnk_rgba(r, g, b, a, __result.address());
        return __result;
    }

    public static native void nnk_rgba_u32(int var0, long var1);

    public static NkColor nk_rgba_u32(int in, NkColor __result) {
        Nuklear.nnk_rgba_u32(in, __result.address());
        return __result;
    }

    public static native void nnk_rgba_iv(long var0, long var2);

    public static NkColor nk_rgba_iv(IntBuffer rgba, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgba, 4);
        }
        Nuklear.nnk_rgba_iv(MemoryUtil.memAddress(rgba), __result.address());
        return __result;
    }

    public static native void nnk_rgba_bv(long var0, long var2);

    public static NkColor nk_rgba_bv(ByteBuffer rgba, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgba, 4);
        }
        Nuklear.nnk_rgba_bv(MemoryUtil.memAddress(rgba), __result.address());
        return __result;
    }

    public static native void nnk_rgba_f(float var0, float var1, float var2, float var3, long var4);

    public static NkColor nk_rgba_f(float r, float g, float b, float a, NkColor __result) {
        Nuklear.nnk_rgba_f(r, g, b, a, __result.address());
        return __result;
    }

    public static native void nnk_rgba_fv(long var0, long var2);

    public static NkColor nk_rgba_fv(FloatBuffer rgba, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgba, 4);
        }
        Nuklear.nnk_rgba_fv(MemoryUtil.memAddress(rgba), __result.address());
        return __result;
    }

    public static native void nnk_rgba_hex(long var0, long var2);

    public static NkColor nk_rgba_hex(ByteBuffer rgba, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgba, 8);
        }
        Nuklear.nnk_rgba_hex(MemoryUtil.memAddress(rgba), __result.address());
        return __result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NkColor nk_rgba_hex(CharSequence rgba, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(rgba, 8);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer rgbaEncoded = stack.ASCII(rgba);
            Nuklear.nnk_rgba_hex(MemoryUtil.memAddress(rgbaEncoded), __result.address());
            NkColor nkColor = __result;
            return nkColor;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_hsv(int var0, int var1, int var2, long var3);

    public static NkColor nk_hsv(int h, int s, int v, NkColor __result) {
        Nuklear.nnk_hsv(h, s, v, __result.address());
        return __result;
    }

    public static native void nnk_hsv_iv(long var0, long var2);

    public static NkColor nk_hsv_iv(IntBuffer hsv, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsv, 3);
        }
        Nuklear.nnk_hsv_iv(MemoryUtil.memAddress(hsv), __result.address());
        return __result;
    }

    public static native void nnk_hsv_bv(long var0, long var2);

    public static NkColor nk_hsv_bv(ByteBuffer hsv, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsv, 3);
        }
        Nuklear.nnk_hsv_bv(MemoryUtil.memAddress(hsv), __result.address());
        return __result;
    }

    public static native void nnk_hsv_f(float var0, float var1, float var2, long var3);

    public static NkColor nk_hsv_f(float h, float s, float v, NkColor __result) {
        Nuklear.nnk_hsv_f(h, s, v, __result.address());
        return __result;
    }

    public static native void nnk_hsv_fv(long var0, long var2);

    public static NkColor nk_hsv_fv(FloatBuffer hsv, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsv, 3);
        }
        Nuklear.nnk_hsv_fv(MemoryUtil.memAddress(hsv), __result.address());
        return __result;
    }

    public static native void nnk_hsva(int var0, int var1, int var2, int var3, long var4);

    public static NkColor nk_hsva(int h, int s, int v, int a, NkColor __result) {
        Nuklear.nnk_hsva(h, s, v, a, __result.address());
        return __result;
    }

    public static native void nnk_hsva_iv(long var0, long var2);

    public static NkColor nk_hsva_iv(IntBuffer hsva, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsva, 4);
        }
        Nuklear.nnk_hsva_iv(MemoryUtil.memAddress(hsva), __result.address());
        return __result;
    }

    public static native void nnk_hsva_bv(long var0, long var2);

    public static NkColor nk_hsva_bv(ByteBuffer hsva, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsva, 4);
        }
        Nuklear.nnk_hsva_bv(MemoryUtil.memAddress(hsva), __result.address());
        return __result;
    }

    public static native void nnk_hsva_f(float var0, float var1, float var2, float var3, long var4);

    public static NkColor nk_hsva_f(float h, float s, float v, float a, NkColor __result) {
        Nuklear.nnk_hsva_f(h, s, v, a, __result.address());
        return __result;
    }

    public static native void nnk_hsva_fv(long var0, long var2);

    public static NkColor nk_hsva_fv(FloatBuffer hsva, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsva, 4);
        }
        Nuklear.nnk_hsva_fv(MemoryUtil.memAddress(hsva), __result.address());
        return __result;
    }

    public static native void nnk_color_f(long var0, long var2, long var4, long var6, long var8);

    public static void nk_color_f(FloatBuffer r, FloatBuffer g, FloatBuffer b, FloatBuffer a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)r, 1);
            Checks.check((Buffer)g, 1);
            Checks.check((Buffer)b, 1);
            Checks.check((Buffer)a, 1);
        }
        Nuklear.nnk_color_f(MemoryUtil.memAddress(r), MemoryUtil.memAddress(g), MemoryUtil.memAddress(b), MemoryUtil.memAddress(a), color.address());
    }

    public static native void nnk_color_fv(long var0, long var2);

    public static void nk_color_fv(FloatBuffer rgba_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgba_out, 4);
        }
        Nuklear.nnk_color_fv(MemoryUtil.memAddress(rgba_out), color.address());
    }

    public static native void nnk_color_d(long var0, long var2, long var4, long var6, long var8);

    public static void nk_color_d(DoubleBuffer r, DoubleBuffer g, DoubleBuffer b, DoubleBuffer a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)r, 1);
            Checks.check((Buffer)g, 1);
            Checks.check((Buffer)b, 1);
            Checks.check((Buffer)a, 1);
        }
        Nuklear.nnk_color_d(MemoryUtil.memAddress(r), MemoryUtil.memAddress(g), MemoryUtil.memAddress(b), MemoryUtil.memAddress(a), color.address());
    }

    public static native void nnk_color_dv(long var0, long var2);

    public static void nk_color_dv(DoubleBuffer rgba_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)rgba_out, 4);
        }
        Nuklear.nnk_color_dv(MemoryUtil.memAddress(rgba_out), color.address());
    }

    public static native int nnk_color_u32(long var0);

    public static int nk_color_u32(NkColor color) {
        return Nuklear.nnk_color_u32(color.address());
    }

    public static native void nnk_color_hex_rgba(long var0, long var2);

    public static void nk_color_hex_rgba(ByteBuffer output, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)output, 8);
        }
        Nuklear.nnk_color_hex_rgba(MemoryUtil.memAddress(output), color.address());
    }

    public static native void nnk_color_hex_rgb(long var0, long var2);

    public static void nk_color_hex_rgb(ByteBuffer output, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)output, 6);
        }
        Nuklear.nnk_color_hex_rgb(MemoryUtil.memAddress(output), color.address());
    }

    public static native void nnk_color_hsv_i(long var0, long var2, long var4, long var6);

    public static void nk_color_hsv_i(IntBuffer out_h, IntBuffer out_s, IntBuffer out_v, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)out_h, 1);
            Checks.check((Buffer)out_s, 1);
            Checks.check((Buffer)out_v, 1);
        }
        Nuklear.nnk_color_hsv_i(MemoryUtil.memAddress(out_h), MemoryUtil.memAddress(out_s), MemoryUtil.memAddress(out_v), color.address());
    }

    public static native void nnk_color_hsv_b(long var0, long var2, long var4, long var6);

    public static void nk_color_hsv_b(ByteBuffer out_h, ByteBuffer out_s, ByteBuffer out_v, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)out_h, 1);
            Checks.check((Buffer)out_s, 1);
            Checks.check((Buffer)out_v, 1);
        }
        Nuklear.nnk_color_hsv_b(MemoryUtil.memAddress(out_h), MemoryUtil.memAddress(out_s), MemoryUtil.memAddress(out_v), color.address());
    }

    public static native void nnk_color_hsv_iv(long var0, long var2);

    public static void nk_color_hsv_iv(IntBuffer hsv_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsv_out, 3);
        }
        Nuklear.nnk_color_hsv_iv(MemoryUtil.memAddress(hsv_out), color.address());
    }

    public static native void nnk_color_hsv_bv(long var0, long var2);

    public static void nk_color_hsv_bv(ByteBuffer hsv_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsv_out, 3);
        }
        Nuklear.nnk_color_hsv_bv(MemoryUtil.memAddress(hsv_out), color.address());
    }

    public static native void nnk_color_hsv_f(long var0, long var2, long var4, long var6);

    public static void nk_color_hsv_f(FloatBuffer out_h, FloatBuffer out_s, FloatBuffer out_v, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)out_h, 1);
            Checks.check((Buffer)out_s, 1);
            Checks.check((Buffer)out_v, 1);
        }
        Nuklear.nnk_color_hsv_f(MemoryUtil.memAddress(out_h), MemoryUtil.memAddress(out_s), MemoryUtil.memAddress(out_v), color.address());
    }

    public static native void nnk_color_hsv_fv(long var0, long var2);

    public static void nk_color_hsv_fv(FloatBuffer hsv_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsv_out, 3);
        }
        Nuklear.nnk_color_hsv_fv(MemoryUtil.memAddress(hsv_out), color.address());
    }

    public static native void nnk_color_hsva_i(long var0, long var2, long var4, long var6, long var8);

    public static void nk_color_hsva_i(IntBuffer h, IntBuffer s, IntBuffer v, IntBuffer a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)h, 1);
            Checks.check((Buffer)s, 1);
            Checks.check((Buffer)v, 1);
            Checks.check((Buffer)a, 1);
        }
        Nuklear.nnk_color_hsva_i(MemoryUtil.memAddress(h), MemoryUtil.memAddress(s), MemoryUtil.memAddress(v), MemoryUtil.memAddress(a), color.address());
    }

    public static native void nnk_color_hsva_b(long var0, long var2, long var4, long var6, long var8);

    public static void nk_color_hsva_b(ByteBuffer h, ByteBuffer s, ByteBuffer v, ByteBuffer a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)h, 1);
            Checks.check((Buffer)s, 1);
            Checks.check((Buffer)v, 1);
            Checks.check((Buffer)a, 1);
        }
        Nuklear.nnk_color_hsva_b(MemoryUtil.memAddress(h), MemoryUtil.memAddress(s), MemoryUtil.memAddress(v), MemoryUtil.memAddress(a), color.address());
    }

    public static native void nnk_color_hsva_iv(long var0, long var2);

    public static void nk_color_hsva_iv(IntBuffer hsva_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsva_out, 4);
        }
        Nuklear.nnk_color_hsva_iv(MemoryUtil.memAddress(hsva_out), color.address());
    }

    public static native void nnk_color_hsva_bv(long var0, long var2);

    public static void nk_color_hsva_bv(ByteBuffer hsva_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsva_out, 4);
        }
        Nuklear.nnk_color_hsva_bv(MemoryUtil.memAddress(hsva_out), color.address());
    }

    public static native void nnk_color_hsva_f(long var0, long var2, long var4, long var6, long var8);

    public static void nk_color_hsva_f(FloatBuffer out_h, FloatBuffer out_s, FloatBuffer out_v, FloatBuffer out_a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)out_h, 1);
            Checks.check((Buffer)out_s, 1);
            Checks.check((Buffer)out_v, 1);
            Checks.check((Buffer)out_a, 1);
        }
        Nuklear.nnk_color_hsva_f(MemoryUtil.memAddress(out_h), MemoryUtil.memAddress(out_s), MemoryUtil.memAddress(out_v), MemoryUtil.memAddress(out_a), color.address());
    }

    public static native void nnk_color_hsva_fv(long var0, long var2);

    public static void nk_color_hsva_fv(FloatBuffer hsva_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)hsva_out, 4);
        }
        Nuklear.nnk_color_hsva_fv(MemoryUtil.memAddress(hsva_out), color.address());
    }

    public static native void nnk_handle_ptr(long var0, long var2);

    public static NkHandle nk_handle_ptr(long ptr, NkHandle __result) {
        if (Checks.CHECKS) {
            Checks.check(ptr);
        }
        Nuklear.nnk_handle_ptr(ptr, __result.address());
        return __result;
    }

    public static native void nnk_handle_id(int var0, long var1);

    public static NkHandle nk_handle_id(int id, NkHandle __result) {
        Nuklear.nnk_handle_id(id, __result.address());
        return __result;
    }

    public static native void nnk_image_handle(long var0, long var2);

    public static NkImage nk_image_handle(NkHandle handle, NkImage __result) {
        Nuklear.nnk_image_handle(handle.address(), __result.address());
        return __result;
    }

    public static native void nnk_image_ptr(long var0, long var2);

    public static NkImage nk_image_ptr(long ptr, NkImage __result) {
        if (Checks.CHECKS) {
            Checks.check(ptr);
        }
        Nuklear.nnk_image_ptr(ptr, __result.address());
        return __result;
    }

    public static native void nnk_image_id(int var0, long var1);

    public static NkImage nk_image_id(int id, NkImage __result) {
        Nuklear.nnk_image_id(id, __result.address());
        return __result;
    }

    public static native int nnk_image_is_subimage(long var0);

    public static boolean nk_image_is_subimage(NkImage img) {
        return Nuklear.nnk_image_is_subimage(img.address()) != 0;
    }

    public static native void nnk_subimage_ptr(long var0, short var2, short var3, long var4, long var6);

    public static NkImage nk_subimage_ptr(long ptr, short w, short h, NkRect sub_region, NkImage __result) {
        if (Checks.CHECKS) {
            Checks.check(ptr);
        }
        Nuklear.nnk_subimage_ptr(ptr, w, h, sub_region.address(), __result.address());
        return __result;
    }

    public static native void nnk_subimage_id(int var0, short var1, short var2, long var3, long var5);

    public static NkImage nk_subimage_id(int id, short w, short h, NkRect sub_region, NkImage __result) {
        Nuklear.nnk_subimage_id(id, w, h, sub_region.address(), __result.address());
        return __result;
    }

    public static native void nnk_subimage_handle(long var0, short var2, short var3, long var4, long var6);

    public static NkImage nk_subimage_handle(NkHandle handle, short w, short h, NkRect sub_region, NkImage __result) {
        Nuklear.nnk_subimage_handle(handle.address(), w, h, sub_region.address(), __result.address());
        return __result;
    }

    public static native int nnk_murmur_hash(long var0, int var2, int var3);

    public static int nk_murmur_hash(ByteBuffer key, int seed) {
        return Nuklear.nnk_murmur_hash(MemoryUtil.memAddress(key), key.remaining(), seed);
    }

    public static native void nnk_triangle_from_direction(long var0, long var2, float var4, float var5, int var6);

    public static void nk_triangle_from_direction(NkVec2 result, NkRect r, float pad_x, float pad_y, int direction) {
        Nuklear.nnk_triangle_from_direction(result.address(), r.address(), pad_x, pad_y, direction);
    }

    public static native void nnk_vec2(float var0, float var1, long var2);

    public static NkVec2 nk_vec2(float x, float y, NkVec2 __result) {
        Nuklear.nnk_vec2(x, y, __result.address());
        return __result;
    }

    public static native void nnk_vec2i(int var0, int var1, long var2);

    public static NkVec2 nk_vec2i(int x, int y, NkVec2 __result) {
        Nuklear.nnk_vec2i(x, y, __result.address());
        return __result;
    }

    public static native void nnk_vec2v(long var0, long var2);

    public static NkVec2 nk_vec2v(FloatBuffer xy, NkVec2 __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)xy, 2);
        }
        Nuklear.nnk_vec2v(MemoryUtil.memAddress(xy), __result.address());
        return __result;
    }

    public static native void nnk_vec2iv(long var0, long var2);

    public static NkVec2 nk_vec2iv(IntBuffer xy, NkVec2 __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)xy, 2);
        }
        Nuklear.nnk_vec2iv(MemoryUtil.memAddress(xy), __result.address());
        return __result;
    }

    public static native void nnk_get_null_rect(long var0);

    public static NkRect nk_get_null_rect(NkRect __result) {
        Nuklear.nnk_get_null_rect(__result.address());
        return __result;
    }

    public static native void nnk_rect(float var0, float var1, float var2, float var3, long var4);

    public static NkRect nk_rect(float x, float y, float w, float h, NkRect __result) {
        Nuklear.nnk_rect(x, y, w, h, __result.address());
        return __result;
    }

    public static native void nnk_recti(int var0, int var1, int var2, int var3, long var4);

    public static NkRect nk_recti(int x, int y, int w, int h, NkRect __result) {
        Nuklear.nnk_recti(x, y, w, h, __result.address());
        return __result;
    }

    public static native void nnk_recta(long var0, long var2, long var4);

    public static NkRect nk_recta(NkVec2 pos, NkVec2 size, NkRect __result) {
        Nuklear.nnk_recta(pos.address(), size.address(), __result.address());
        return __result;
    }

    public static native void nnk_rectv(long var0, long var2);

    public static NkRect nk_rectv(FloatBuffer xywh, NkRect __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)xywh, 4);
        }
        Nuklear.nnk_rectv(MemoryUtil.memAddress(xywh), __result.address());
        return __result;
    }

    public static native void nnk_rectiv(long var0, long var2);

    public static NkRect nk_rectiv(IntBuffer xywh, NkRect __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)xywh, 4);
        }
        Nuklear.nnk_rectiv(MemoryUtil.memAddress(xywh), __result.address());
        return __result;
    }

    public static native void nnk_rect_pos(long var0, long var2);

    public static NkVec2 nk_rect_pos(NkRect r, NkVec2 __result) {
        Nuklear.nnk_rect_pos(r.address(), __result.address());
        return __result;
    }

    public static native void nnk_rect_size(long var0, long var2);

    public static NkVec2 nk_rect_size(NkRect r, NkVec2 __result) {
        Nuklear.nnk_rect_size(r.address(), __result.address());
        return __result;
    }

    public static native int nnk_strlen(long var0);

    public static int nk_strlen(ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_strlen(MemoryUtil.memAddress(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_strlen(CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            int n = Nuklear.nnk_strlen(MemoryUtil.memAddress(strEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_stricmp(long var0, long var2);

    public static int nk_stricmp(ByteBuffer s1, ByteBuffer s2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(s1);
            Checks.checkNT1(s2);
        }
        return Nuklear.nnk_stricmp(MemoryUtil.memAddress(s1), MemoryUtil.memAddress(s2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_stricmp(CharSequence s1, CharSequence s2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer s1Encoded = stack.UTF8(s1);
            ByteBuffer s2Encoded = stack.UTF8(s2);
            int n = Nuklear.nnk_stricmp(MemoryUtil.memAddress(s1Encoded), MemoryUtil.memAddress(s2Encoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_stricmpn(long var0, long var2, int var4);

    public static int nk_stricmpn(ByteBuffer s1, ByteBuffer s2, int n) {
        if (Checks.CHECKS) {
            Checks.checkNT1(s1);
            Checks.checkNT1(s2);
        }
        return Nuklear.nnk_stricmpn(MemoryUtil.memAddress(s1), MemoryUtil.memAddress(s2), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_stricmpn(CharSequence s1, CharSequence s2, int n) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer s1Encoded = stack.UTF8(s1);
            ByteBuffer s2Encoded = stack.UTF8(s2);
            int n2 = Nuklear.nnk_stricmpn(MemoryUtil.memAddress(s1Encoded), MemoryUtil.memAddress(s2Encoded), n);
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_strtoi(long var0, long var2);

    public static int nk_strtoi(ByteBuffer str, PointerBuffer endptr) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(endptr, 1);
        }
        return Nuklear.nnk_strtoi(MemoryUtil.memAddress(str), MemoryUtil.memAddress(endptr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_strtoi(CharSequence str, PointerBuffer endptr) {
        if (Checks.CHECKS) {
            Checks.check(endptr, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            int n = Nuklear.nnk_strtoi(MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(endptr));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native float nnk_strtof(long var0, long var2);

    public static float nk_strtof(ByteBuffer str, PointerBuffer endptr) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(endptr, 1);
        }
        return Nuklear.nnk_strtof(MemoryUtil.memAddress(str), MemoryUtil.memAddress(endptr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nk_strtof(CharSequence str, PointerBuffer endptr) {
        if (Checks.CHECKS) {
            Checks.check(endptr, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            float f = Nuklear.nnk_strtof(MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(endptr));
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native double nnk_strtod(long var0, long var2);

    public static double nk_strtod(ByteBuffer str, PointerBuffer endptr) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(endptr, 1);
        }
        return Nuklear.nnk_strtod(MemoryUtil.memAddress(str), MemoryUtil.memAddress(endptr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nk_strtod(CharSequence str, PointerBuffer endptr) {
        if (Checks.CHECKS) {
            Checks.check(endptr, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            double d = Nuklear.nnk_strtod(MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(endptr));
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_strfilter(long var0, long var2);

    public static boolean nk_strfilter(ByteBuffer str, ByteBuffer regexp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.checkNT1(regexp);
        }
        return Nuklear.nnk_strfilter(MemoryUtil.memAddress(str), MemoryUtil.memAddress(regexp)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_strfilter(CharSequence str, CharSequence regexp) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            ByteBuffer regexpEncoded = stack.UTF8(regexp);
            boolean bl = Nuklear.nnk_strfilter(MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(regexpEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_strmatch_fuzzy_string(long var0, long var2, long var4);

    public static boolean nk_strmatch_fuzzy_string(ByteBuffer str, ByteBuffer pattern, IntBuffer out_score) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.checkNT1(pattern);
            Checks.check((Buffer)out_score, 1);
        }
        return Nuklear.nnk_strmatch_fuzzy_string(MemoryUtil.memAddress(str), MemoryUtil.memAddress(pattern), MemoryUtil.memAddress(out_score)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_strmatch_fuzzy_string(CharSequence str, CharSequence pattern, IntBuffer out_score) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)out_score, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            ByteBuffer patternEncoded = stack.UTF8(pattern);
            boolean bl = Nuklear.nnk_strmatch_fuzzy_string(MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(patternEncoded), MemoryUtil.memAddress(out_score)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_strmatch_fuzzy_text(long var0, int var2, long var3, long var5);

    public static int nk_strmatch_fuzzy_text(ByteBuffer txt, ByteBuffer pattern, IntBuffer out_score) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pattern);
            Checks.check((Buffer)out_score, 1);
        }
        return Nuklear.nnk_strmatch_fuzzy_text(MemoryUtil.memAddress(txt), txt.remaining(), MemoryUtil.memAddress(pattern), MemoryUtil.memAddress(out_score));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_strmatch_fuzzy_text(CharSequence txt, CharSequence pattern, IntBuffer out_score) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)out_score, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer txtEncoded = stack.UTF8(txt, false);
            ByteBuffer patternEncoded = stack.UTF8(pattern);
            int n = Nuklear.nnk_strmatch_fuzzy_text(MemoryUtil.memAddress(txtEncoded), txtEncoded.remaining(), MemoryUtil.memAddress(patternEncoded), MemoryUtil.memAddress(out_score));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_utf_decode(long var0, long var2, int var4);

    public static int nk_utf_decode(ByteBuffer c, IntBuffer u) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)u, 1);
        }
        return Nuklear.nnk_utf_decode(MemoryUtil.memAddress(c), MemoryUtil.memAddress(u), c.remaining());
    }

    public static native int nnk_utf_encode(int var0, long var1, int var3);

    public static int nk_utf_encode(int u, ByteBuffer c) {
        return Nuklear.nnk_utf_encode(u, MemoryUtil.memAddress(c), c.remaining());
    }

    public static native int nnk_utf_len(long var0, int var2);

    public static int nk_utf_len(ByteBuffer str) {
        return Nuklear.nnk_utf_len(MemoryUtil.memAddress(str), str.remaining());
    }

    public static native long nnk_utf_at(long var0, int var2, int var3, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer nk_utf_at(ByteBuffer buffer, int index, IntBuffer unicode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)unicode, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer len = stack.callocInt(1);
            long __result = Nuklear.nnk_utf_at(MemoryUtil.memAddress(buffer), buffer.remaining(), index, MemoryUtil.memAddress(unicode), MemoryUtil.memAddress(len));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, len.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_buffer_init(long var0, long var2, long var4);

    public static void nk_buffer_init(NkBuffer buffer, NkAllocator allocator, long size) {
        Nuklear.nnk_buffer_init(buffer.address(), allocator.address(), size);
    }

    public static native void nnk_buffer_init_fixed(long var0, long var2, long var4);

    public static void nk_buffer_init_fixed(NkBuffer buffer, ByteBuffer memory) {
        Nuklear.nnk_buffer_init_fixed(buffer.address(), MemoryUtil.memAddress(memory), memory.remaining());
    }

    public static native void nnk_buffer_info(long var0, long var2);

    public static void nk_buffer_info(NkMemoryStatus status, NkBuffer buffer) {
        Nuklear.nnk_buffer_info(status.address(), buffer.address());
    }

    public static native void nnk_buffer_push(long var0, int var2, long var3, long var5, long var7);

    public static void nk_buffer_push(NkBuffer buffer, int type, ByteBuffer memory, long align) {
        Nuklear.nnk_buffer_push(buffer.address(), type, MemoryUtil.memAddress(memory), memory.remaining(), align);
    }

    public static native void nnk_buffer_mark(long var0, int var2);

    public static void nk_buffer_mark(NkBuffer buffer, int type) {
        Nuklear.nnk_buffer_mark(buffer.address(), type);
    }

    public static native void nnk_buffer_reset(long var0, int var2);

    public static void nk_buffer_reset(NkBuffer buffer, int type) {
        Nuklear.nnk_buffer_reset(buffer.address(), type);
    }

    public static native void nnk_buffer_clear(long var0);

    public static void nk_buffer_clear(NkBuffer buffer) {
        Nuklear.nnk_buffer_clear(buffer.address());
    }

    public static native void nnk_buffer_free(long var0);

    public static void nk_buffer_free(NkBuffer buffer) {
        Nuklear.nnk_buffer_free(buffer.address());
    }

    public static native long nnk_buffer_memory(long var0);

    public static long nk_buffer_memory(NkBuffer buffer) {
        return Nuklear.nnk_buffer_memory(buffer.address());
    }

    public static native long nnk_buffer_memory_const(long var0);

    public static long nk_buffer_memory_const(NkBuffer buffer) {
        return Nuklear.nnk_buffer_memory_const(buffer.address());
    }

    public static native long nnk_buffer_total(long var0);

    public static long nk_buffer_total(NkBuffer buffer) {
        return Nuklear.nnk_buffer_total(buffer.address());
    }

    public static native void nnk_str_init(long var0, long var2, long var4);

    public static void nk_str_init(NkStr str, NkAllocator allocator, long size) {
        Nuklear.nnk_str_init(str.address(), allocator.address(), size);
    }

    public static native void nnk_str_init_fixed(long var0, long var2, long var4);

    public static void nk_str_init_fixed(NkStr str, ByteBuffer memory) {
        Nuklear.nnk_str_init_fixed(str.address(), MemoryUtil.memAddress(memory), memory.remaining());
    }

    public static native void nnk_str_clear(long var0);

    public static void nk_str_clear(NkStr str) {
        Nuklear.nnk_str_clear(str.address());
    }

    public static native void nnk_str_free(long var0);

    public static void nk_str_free(NkStr str) {
        Nuklear.nnk_str_free(str.address());
    }

    public static native int nnk_str_append_text_char(long var0, long var2, int var4);

    public static int nk_str_append_text_char(NkStr s, ByteBuffer str) {
        return Nuklear.nnk_str_append_text_char(s.address(), MemoryUtil.memAddress(str), str.remaining());
    }

    public static native int nnk_str_append_str_char(long var0, long var2);

    public static int nk_str_append_str_char(NkStr s, ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_str_append_str_char(s.address(), MemoryUtil.memAddress(str));
    }

    public static native int nnk_str_append_text_utf8(long var0, long var2, int var4);

    public static int nk_str_append_text_utf8(NkStr s, ByteBuffer str) {
        return Nuklear.nnk_str_append_text_utf8(s.address(), MemoryUtil.memAddress(str), str.remaining());
    }

    public static native int nnk_str_append_str_utf8(long var0, long var2);

    public static int nk_str_append_str_utf8(NkStr s, ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_str_append_str_utf8(s.address(), MemoryUtil.memAddress(str));
    }

    public static native int nnk_str_append_text_runes(long var0, long var2, int var4);

    public static int nk_str_append_text_runes(NkStr s, IntBuffer runes) {
        return Nuklear.nnk_str_append_text_runes(s.address(), MemoryUtil.memAddress(runes), runes.remaining());
    }

    public static native int nnk_str_append_str_runes(long var0, long var2);

    public static int nk_str_append_str_runes(NkStr s, IntBuffer runes) {
        if (Checks.CHECKS) {
            Checks.checkNT(runes);
        }
        return Nuklear.nnk_str_append_str_runes(s.address(), MemoryUtil.memAddress(runes));
    }

    public static native int nnk_str_insert_at_char(long var0, int var2, long var3, int var5);

    public static int nk_str_insert_at_char(NkStr s, int pos, ByteBuffer str) {
        return Nuklear.nnk_str_insert_at_char(s.address(), pos, MemoryUtil.memAddress(str), str.remaining());
    }

    public static native int nnk_str_insert_at_rune(long var0, int var2, long var3, int var5);

    public static int nk_str_insert_at_rune(NkStr s, int pos, ByteBuffer str) {
        return Nuklear.nnk_str_insert_at_rune(s.address(), pos, MemoryUtil.memAddress(str), str.remaining());
    }

    public static native int nnk_str_insert_text_char(long var0, int var2, long var3, int var5);

    public static int nk_str_insert_text_char(NkStr s, int pos, ByteBuffer str) {
        return Nuklear.nnk_str_insert_text_char(s.address(), pos, MemoryUtil.memAddress(str), str.remaining());
    }

    public static native int nnk_str_insert_str_char(long var0, int var2, long var3);

    public static int nk_str_insert_str_char(NkStr s, int pos, ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_str_insert_str_char(s.address(), pos, MemoryUtil.memAddress(str));
    }

    public static native int nnk_str_insert_text_utf8(long var0, int var2, long var3, int var5);

    public static int nk_str_insert_text_utf8(NkStr s, int pos, ByteBuffer str) {
        return Nuklear.nnk_str_insert_text_utf8(s.address(), pos, MemoryUtil.memAddress(str), str.remaining());
    }

    public static native int nnk_str_insert_str_utf8(long var0, int var2, long var3);

    public static int nk_str_insert_str_utf8(NkStr s, int pos, ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return Nuklear.nnk_str_insert_str_utf8(s.address(), pos, MemoryUtil.memAddress(str));
    }

    public static native int nnk_str_insert_text_runes(long var0, int var2, long var3, int var5);

    public static int nk_str_insert_text_runes(NkStr s, int pos, IntBuffer runes) {
        return Nuklear.nnk_str_insert_text_runes(s.address(), pos, MemoryUtil.memAddress(runes), runes.remaining());
    }

    public static native int nnk_str_insert_str_runes(long var0, int var2, long var3);

    public static int nk_str_insert_str_runes(NkStr s, int pos, IntBuffer runes) {
        if (Checks.CHECKS) {
            Checks.checkNT(runes);
        }
        return Nuklear.nnk_str_insert_str_runes(s.address(), pos, MemoryUtil.memAddress(runes));
    }

    public static native void nnk_str_remove_chars(long var0, int var2);

    public static void nk_str_remove_chars(NkStr s, int len) {
        Nuklear.nnk_str_remove_chars(s.address(), len);
    }

    public static native void nnk_str_remove_runes(long var0, int var2);

    public static void nk_str_remove_runes(NkStr str, int len) {
        Nuklear.nnk_str_remove_runes(str.address(), len);
    }

    public static native void nnk_str_delete_chars(long var0, int var2, int var3);

    public static void nk_str_delete_chars(NkStr s, int pos, int len) {
        Nuklear.nnk_str_delete_chars(s.address(), pos, len);
    }

    public static native void nnk_str_delete_runes(long var0, int var2, int var3);

    public static void nk_str_delete_runes(NkStr s, int pos, int len) {
        Nuklear.nnk_str_delete_runes(s.address(), pos, len);
    }

    public static native long nnk_str_at_char(long var0, int var2);

    public static String nk_str_at_char(NkStr s, int pos) {
        long __result = Nuklear.nnk_str_at_char(s.address(), pos);
        return MemoryUtil.memUTF8(__result);
    }

    public static native long nnk_str_at_rune(long var0, int var2, long var3, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer nk_str_at_rune(NkStr s, int pos, IntBuffer unicode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)unicode, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer len = stack.callocInt(1);
        try {
            long __result = Nuklear.nnk_str_at_rune(s.address(), pos, MemoryUtil.memAddress(unicode), MemoryUtil.memAddress(len));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, len.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_str_rune_at(long var0, int var2);

    public static int nk_str_rune_at(NkStr s, int pos) {
        return Nuklear.nnk_str_rune_at(s.address(), pos);
    }

    public static native long nnk_str_at_char_const(long var0, int var2);

    public static String nk_str_at_char_const(NkStr s, int pos) {
        long __result = Nuklear.nnk_str_at_char_const(s.address(), pos);
        return MemoryUtil.memUTF8(__result);
    }

    public static native long nnk_str_at_const(long var0, int var2, long var3, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer nk_str_at_const(NkStr s, int pos, IntBuffer unicode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)unicode, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer len = stack.callocInt(1);
        try {
            long __result = Nuklear.nnk_str_at_const(s.address(), pos, MemoryUtil.memAddress(unicode), MemoryUtil.memAddress(len));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, len.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nnk_str_get(long var0);

    public static String nk_str_get(NkStr s) {
        long __result = Nuklear.nnk_str_get(s.address());
        return MemoryUtil.memUTF8(__result);
    }

    public static native long nnk_str_get_const(long var0);

    public static String nk_str_get_const(NkStr s) {
        long __result = Nuklear.nnk_str_get_const(s.address());
        return MemoryUtil.memUTF8(__result);
    }

    public static native int nnk_str_len(long var0);

    public static int nk_str_len(NkStr s) {
        return Nuklear.nnk_str_len(s.address());
    }

    public static native int nnk_str_len_char(long var0);

    public static int nk_str_len_char(NkStr s) {
        return Nuklear.nnk_str_len_char(s.address());
    }

    public static native int nnk_filter_default(long var0, int var2);

    public static boolean nk_filter_default(NkTextEdit edit, int unicode) {
        return Nuklear.nnk_filter_default(edit.address(), unicode) != 0;
    }

    public static native int nnk_filter_ascii(long var0, int var2);

    public static boolean nk_filter_ascii(NkTextEdit edit, int unicode) {
        return Nuklear.nnk_filter_ascii(edit.address(), unicode) != 0;
    }

    public static native int nnk_filter_float(long var0, int var2);

    public static boolean nk_filter_float(NkTextEdit edit, int unicode) {
        return Nuklear.nnk_filter_float(edit.address(), unicode) != 0;
    }

    public static native int nnk_filter_decimal(long var0, int var2);

    public static boolean nk_filter_decimal(NkTextEdit edit, int unicode) {
        return Nuklear.nnk_filter_decimal(edit.address(), unicode) != 0;
    }

    public static native int nnk_filter_hex(long var0, int var2);

    public static boolean nk_filter_hex(NkTextEdit edit, int unicode) {
        return Nuklear.nnk_filter_hex(edit.address(), unicode) != 0;
    }

    public static native int nnk_filter_oct(long var0, int var2);

    public static boolean nk_filter_oct(NkTextEdit edit, int unicode) {
        return Nuklear.nnk_filter_oct(edit.address(), unicode) != 0;
    }

    public static native int nnk_filter_binary(long var0, int var2);

    public static boolean nk_filter_binary(NkTextEdit edit, int unicode) {
        return Nuklear.nnk_filter_binary(edit.address(), unicode) != 0;
    }

    public static native void nnk_textedit_init(long var0, long var2, long var4);

    public static void nk_textedit_init(NkTextEdit box, NkAllocator allocator, long size) {
        Nuklear.nnk_textedit_init(box.address(), allocator.address(), size);
    }

    public static native void nnk_textedit_init_fixed(long var0, long var2, long var4);

    public static void nk_textedit_init_fixed(NkTextEdit box, ByteBuffer memory) {
        Nuklear.nnk_textedit_init_fixed(box.address(), MemoryUtil.memAddress(memory), memory.remaining());
    }

    public static native void nnk_textedit_free(long var0);

    public static void nk_textedit_free(NkTextEdit box) {
        Nuklear.nnk_textedit_free(box.address());
    }

    public static native void nnk_textedit_text(long var0, long var2, int var4);

    public static void nk_textedit_text(NkTextEdit box, ByteBuffer text) {
        Nuklear.nnk_textedit_text(box.address(), MemoryUtil.memAddress(text), text.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_textedit_text(NkTextEdit box, CharSequence text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            Nuklear.nnk_textedit_text(box.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_textedit_delete(long var0, int var2, int var3);

    public static void nk_textedit_delete(NkTextEdit box, int where, int len) {
        Nuklear.nnk_textedit_delete(box.address(), where, len);
    }

    public static native void nnk_textedit_delete_selection(long var0);

    public static void nk_textedit_delete_selection(NkTextEdit box) {
        Nuklear.nnk_textedit_delete_selection(box.address());
    }

    public static native void nnk_textedit_select_all(long var0);

    public static void nk_textedit_select_all(NkTextEdit box) {
        Nuklear.nnk_textedit_select_all(box.address());
    }

    public static native int nnk_textedit_cut(long var0);

    public static boolean nk_textedit_cut(NkTextEdit box) {
        return Nuklear.nnk_textedit_cut(box.address()) != 0;
    }

    public static native int nnk_textedit_paste(long var0, long var2, int var4);

    public static boolean nk_textedit_paste(NkTextEdit box, ByteBuffer ctext) {
        return Nuklear.nnk_textedit_paste(box.address(), MemoryUtil.memAddress(ctext), ctext.remaining()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_textedit_paste(NkTextEdit box, CharSequence ctext) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer ctextEncoded = stack.UTF8(ctext, false);
            boolean bl = Nuklear.nnk_textedit_paste(box.address(), MemoryUtil.memAddress(ctextEncoded), ctextEncoded.remaining()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_textedit_undo(long var0);

    public static void nk_textedit_undo(NkTextEdit box) {
        Nuklear.nnk_textedit_undo(box.address());
    }

    public static native void nnk_textedit_redo(long var0);

    public static void nk_textedit_redo(NkTextEdit box) {
        Nuklear.nnk_textedit_redo(box.address());
    }

    public static native void nnk_stroke_line(long var0, float var2, float var3, float var4, float var5, float var6, long var7);

    public static void nk_stroke_line(NkCommandBuffer b, float x0, float y0, float x1, float y1, float line_thickness, NkColor color) {
        Nuklear.nnk_stroke_line(b.address(), x0, y0, x1, y1, line_thickness, color.address());
    }

    public static native void nnk_stroke_curve(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, long var11);

    public static void nk_stroke_curve(NkCommandBuffer b, float ax, float ay, float ctrl0x, float ctrl0y, float ctrl1x, float ctrl1y, float bx, float by, float line_thickness, NkColor color) {
        Nuklear.nnk_stroke_curve(b.address(), ax, ay, ctrl0x, ctrl0y, ctrl1x, ctrl1y, bx, by, line_thickness, color.address());
    }

    public static native void nnk_stroke_rect(long var0, long var2, float var4, float var5, long var6);

    public static void nk_stroke_rect(NkCommandBuffer b, NkRect rect, float rounding, float line_thickness, NkColor color) {
        Nuklear.nnk_stroke_rect(b.address(), rect.address(), rounding, line_thickness, color.address());
    }

    public static native void nnk_stroke_circle(long var0, long var2, float var4, long var5);

    public static void nk_stroke_circle(NkCommandBuffer b, NkRect rect, float line_thickness, NkColor color) {
        Nuklear.nnk_stroke_circle(b.address(), rect.address(), line_thickness, color.address());
    }

    public static native void nnk_stroke_arc(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    public static void nk_stroke_arc(NkCommandBuffer b, float cx, float cy, float radius, float a_min, float a_max, float line_thickness, NkColor color) {
        Nuklear.nnk_stroke_arc(b.address(), cx, cy, radius, a_min, a_max, line_thickness, color.address());
    }

    public static native void nnk_stroke_triangle(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, long var9);

    public static void nk_stroke_triangle(NkCommandBuffer b, float x0, float y0, float x1, float y1, float x2, float y2, float line_thichness, NkColor color) {
        Nuklear.nnk_stroke_triangle(b.address(), x0, y0, x1, y1, x2, y2, line_thichness, color.address());
    }

    public static native void nnk_stroke_polyline(long var0, long var2, int var4, float var5, long var6);

    public static void nk_stroke_polyline(NkCommandBuffer b, FloatBuffer points, float line_thickness, NkColor col) {
        Nuklear.nnk_stroke_polyline(b.address(), MemoryUtil.memAddress(points), points.remaining(), line_thickness, col.address());
    }

    public static native void nnk_stroke_polygon(long var0, long var2, int var4, float var5, long var6);

    public static void nk_stroke_polygon(NkCommandBuffer b, FloatBuffer points, float line_thickness, NkColor color) {
        Nuklear.nnk_stroke_polygon(b.address(), MemoryUtil.memAddress(points), points.remaining(), line_thickness, color.address());
    }

    public static native void nnk_fill_rect(long var0, long var2, float var4, long var5);

    public static void nk_fill_rect(NkCommandBuffer b, NkRect rect, float rounding, NkColor color) {
        Nuklear.nnk_fill_rect(b.address(), rect.address(), rounding, color.address());
    }

    public static native void nnk_fill_rect_multi_color(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void nk_fill_rect_multi_color(NkCommandBuffer b, NkRect rect, NkColor left, NkColor top, NkColor right, NkColor bottom) {
        Nuklear.nnk_fill_rect_multi_color(b.address(), rect.address(), left.address(), top.address(), right.address(), bottom.address());
    }

    public static native void nnk_fill_circle(long var0, long var2, long var4);

    public static void nk_fill_circle(NkCommandBuffer b, NkRect rect, NkColor color) {
        Nuklear.nnk_fill_circle(b.address(), rect.address(), color.address());
    }

    public static native void nnk_fill_arc(long var0, float var2, float var3, float var4, float var5, float var6, long var7);

    public static void nk_fill_arc(NkCommandBuffer b, float cx, float cy, float radius, float a_min, float a_max, NkColor color) {
        Nuklear.nnk_fill_arc(b.address(), cx, cy, radius, a_min, a_max, color.address());
    }

    public static native void nnk_fill_triangle(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    public static void nk_fill_triangle(NkCommandBuffer b, float x0, float y0, float x1, float y1, float x2, float y2, NkColor color) {
        Nuklear.nnk_fill_triangle(b.address(), x0, y0, x1, y1, x2, y2, color.address());
    }

    public static native void nnk_fill_polygon(long var0, long var2, int var4, long var5);

    public static void nk_fill_polygon(NkCommandBuffer b, FloatBuffer points, NkColor color) {
        Nuklear.nnk_fill_polygon(b.address(), MemoryUtil.memAddress(points), points.remaining(), color.address());
    }

    public static native void nnk_draw_image(long var0, long var2, long var4, long var6);

    public static void nk_draw_image(NkCommandBuffer b, NkRect rect, NkImage img, NkColor color) {
        Nuklear.nnk_draw_image(b.address(), rect.address(), img.address(), color.address());
    }

    public static native void nnk_draw_text(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static void nk_draw_text(NkCommandBuffer b, NkRect rect, ByteBuffer string, NkUserFont font, NkColor bg, NkColor fg) {
        Nuklear.nnk_draw_text(b.address(), rect.address(), MemoryUtil.memAddress(string), string.remaining(), font.address(), bg.address(), fg.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_draw_text(NkCommandBuffer b, NkRect rect, CharSequence string, NkUserFont font, NkColor bg, NkColor fg) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            Nuklear.nnk_draw_text(b.address(), rect.address(), MemoryUtil.memAddress(stringEncoded), stringEncoded.remaining(), font.address(), bg.address(), fg.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_push_scissor(long var0, long var2);

    public static void nk_push_scissor(NkCommandBuffer b, NkRect rect) {
        Nuklear.nnk_push_scissor(b.address(), rect.address());
    }

    public static native void nnk_push_custom(long var0, long var2, long var4, long var6);

    public static void nk_push_custom(NkCommandBuffer b, NkRect rect, NkCommandCustomCallbackI callback, NkHandle usr) {
        Nuklear.nnk_push_custom(b.address(), rect.address(), callback.address(), usr.address());
    }

    public static native long nnk__next(long var0, long var2);

    public static NkCommand nk__next(NkContext ctx, NkCommand cmd) {
        long __result = Nuklear.nnk__next(ctx.address(), cmd.address());
        return NkCommand.create(__result);
    }

    public static native long nnk__begin(long var0);

    public static NkCommand nk__begin(NkContext ctx) {
        long __result = Nuklear.nnk__begin(ctx.address());
        return NkCommand.create(__result);
    }

    public static native int nnk_input_has_mouse_click(long var0, int var2);

    public static boolean nk_input_has_mouse_click(NkInput i, int id) {
        return Nuklear.nnk_input_has_mouse_click(i.address(), id) != 0;
    }

    public static native int nnk_input_has_mouse_click_in_rect(long var0, int var2, long var3);

    public static boolean nk_input_has_mouse_click_in_rect(NkInput i, int id, NkRect rect) {
        return Nuklear.nnk_input_has_mouse_click_in_rect(i.address(), id, rect.address()) != 0;
    }

    public static native int nnk_input_has_mouse_click_down_in_rect(long var0, int var2, long var3, int var5);

    public static boolean nk_input_has_mouse_click_down_in_rect(NkInput i, int id, NkRect rect, int down) {
        return Nuklear.nnk_input_has_mouse_click_down_in_rect(i.address(), id, rect.address(), down) != 0;
    }

    public static native int nnk_input_is_mouse_click_in_rect(long var0, int var2, long var3);

    public static boolean nk_input_is_mouse_click_in_rect(NkInput i, int id, NkRect rect) {
        return Nuklear.nnk_input_is_mouse_click_in_rect(i.address(), id, rect.address()) != 0;
    }

    public static native int nnk_input_is_mouse_click_down_in_rect(long var0, int var2, long var3, int var5);

    public static boolean nk_input_is_mouse_click_down_in_rect(NkInput i, int id, NkRect b, int down) {
        return Nuklear.nnk_input_is_mouse_click_down_in_rect(i.address(), id, b.address(), down) != 0;
    }

    public static native int nnk_input_any_mouse_click_in_rect(long var0, long var2);

    public static boolean nk_input_any_mouse_click_in_rect(NkInput i, NkRect rect) {
        return Nuklear.nnk_input_any_mouse_click_in_rect(i.address(), rect.address()) != 0;
    }

    public static native int nnk_input_is_mouse_prev_hovering_rect(long var0, long var2);

    public static boolean nk_input_is_mouse_prev_hovering_rect(NkInput i, NkRect rect) {
        return Nuklear.nnk_input_is_mouse_prev_hovering_rect(i.address(), rect.address()) != 0;
    }

    public static native int nnk_input_is_mouse_hovering_rect(long var0, long var2);

    public static boolean nk_input_is_mouse_hovering_rect(NkInput i, NkRect rect) {
        return Nuklear.nnk_input_is_mouse_hovering_rect(i.address(), rect.address()) != 0;
    }

    public static native int nnk_input_mouse_clicked(long var0, int var2, long var3);

    public static boolean nk_input_mouse_clicked(NkInput i, int id, NkRect rect) {
        return Nuklear.nnk_input_mouse_clicked(i.address(), id, rect.address()) != 0;
    }

    public static native int nnk_input_is_mouse_down(long var0, int var2);

    public static boolean nk_input_is_mouse_down(NkInput i, int id) {
        return Nuklear.nnk_input_is_mouse_down(i.address(), id) != 0;
    }

    public static native int nnk_input_is_mouse_pressed(long var0, int var2);

    public static boolean nk_input_is_mouse_pressed(NkInput i, int id) {
        return Nuklear.nnk_input_is_mouse_pressed(i.address(), id) != 0;
    }

    public static native int nnk_input_is_mouse_released(long var0, int var2);

    public static boolean nk_input_is_mouse_released(NkInput i, int id) {
        return Nuklear.nnk_input_is_mouse_released(i.address(), id) != 0;
    }

    public static native int nnk_input_is_key_pressed(long var0, int var2);

    public static boolean nk_input_is_key_pressed(NkInput i, int key) {
        return Nuklear.nnk_input_is_key_pressed(i.address(), key) != 0;
    }

    public static native int nnk_input_is_key_released(long var0, int var2);

    public static boolean nk_input_is_key_released(NkInput i, int key) {
        return Nuklear.nnk_input_is_key_released(i.address(), key) != 0;
    }

    public static native int nnk_input_is_key_down(long var0, int var2);

    public static boolean nk_input_is_key_down(NkInput i, int key) {
        return Nuklear.nnk_input_is_key_down(i.address(), key) != 0;
    }

    public static native void nnk_draw_list_init(long var0);

    public static void nk_draw_list_init(NkDrawList list) {
        Nuklear.nnk_draw_list_init(list.address());
    }

    public static native void nnk_draw_list_setup(long var0, long var2, long var4, long var6, long var8);

    public static void nk_draw_list_setup(NkDrawList canvas, NkConvertConfig config, NkBuffer cmds, NkBuffer vertices, NkBuffer elements) {
        if (Checks.CHECKS) {
            NkConvertConfig.validate(config.address());
        }
        Nuklear.nnk_draw_list_setup(canvas.address(), config.address(), cmds.address(), vertices.address(), elements.address());
    }

    public static native void nnk_draw_list_clear(long var0);

    public static void nk_draw_list_clear(NkDrawList list) {
        Nuklear.nnk_draw_list_clear(list.address());
    }

    public static native long nnk__draw_list_begin(long var0, long var2);

    public static NkDrawCommand nk__draw_list_begin(NkDrawList list, NkBuffer buffer) {
        long __result = Nuklear.nnk__draw_list_begin(list.address(), buffer.address());
        return NkDrawCommand.create(__result);
    }

    public static native long nnk__draw_list_next(long var0, long var2, long var4);

    public static NkDrawCommand nk__draw_list_next(NkDrawCommand cmd, NkBuffer buffer, NkDrawList list) {
        long __result = Nuklear.nnk__draw_list_next(cmd.address(), buffer.address(), list.address());
        return NkDrawCommand.create(__result);
    }

    public static native long nnk__draw_begin(long var0, long var2);

    public static NkDrawCommand nk__draw_begin(NkContext ctx, NkBuffer buffer) {
        long __result = Nuklear.nnk__draw_begin(ctx.address(), buffer.address());
        return NkDrawCommand.create(__result);
    }

    public static native long nnk__draw_end(long var0, long var2);

    public static NkDrawCommand nk__draw_end(NkContext ctx, NkBuffer buffer) {
        long __result = Nuklear.nnk__draw_end(ctx.address(), buffer.address());
        return NkDrawCommand.create(__result);
    }

    public static native long nnk__draw_next(long var0, long var2, long var4);

    public static NkDrawCommand nk__draw_next(NkDrawCommand cmd, NkBuffer buffer, NkContext ctx) {
        long __result = Nuklear.nnk__draw_next(cmd.address(), buffer.address(), ctx.address());
        return NkDrawCommand.create(__result);
    }

    public static native void nnk_draw_list_path_clear(long var0);

    public static void nk_draw_list_path_clear(NkDrawList list) {
        Nuklear.nnk_draw_list_path_clear(list.address());
    }

    public static native void nnk_draw_list_path_line_to(long var0, long var2);

    public static void nk_draw_list_path_line_to(NkDrawList list, NkVec2 pos) {
        Nuklear.nnk_draw_list_path_line_to(list.address(), pos.address());
    }

    public static native void nnk_draw_list_path_arc_to_fast(long var0, long var2, float var4, int var5, int var6);

    public static void nk_draw_list_path_arc_to_fast(NkDrawList list, NkVec2 center, float radius, int a_min, int a_max) {
        Nuklear.nnk_draw_list_path_arc_to_fast(list.address(), center.address(), radius, a_min, a_max);
    }

    public static native void nnk_draw_list_path_arc_to(long var0, long var2, float var4, float var5, float var6, int var7);

    public static void nk_draw_list_path_arc_to(NkDrawList list, NkVec2 center, float radius, float a_min, float a_max, int segments) {
        Nuklear.nnk_draw_list_path_arc_to(list.address(), center.address(), radius, a_min, a_max, segments);
    }

    public static native void nnk_draw_list_path_rect_to(long var0, long var2, long var4, float var6);

    public static void nk_draw_list_path_rect_to(NkDrawList list, NkVec2 a, NkVec2 b, float rounding) {
        Nuklear.nnk_draw_list_path_rect_to(list.address(), a.address(), b.address(), rounding);
    }

    public static native void nnk_draw_list_path_curve_to(long var0, long var2, long var4, long var6, int var8);

    public static void nk_draw_list_path_curve_to(NkDrawList list, NkVec2 p2, NkVec2 p3, NkVec2 p4, int num_segments) {
        Nuklear.nnk_draw_list_path_curve_to(list.address(), p2.address(), p3.address(), p4.address(), num_segments);
    }

    public static native void nnk_draw_list_path_fill(long var0, long var2);

    public static void nk_draw_list_path_fill(NkDrawList list, NkColor color) {
        Nuklear.nnk_draw_list_path_fill(list.address(), color.address());
    }

    public static native void nnk_draw_list_path_stroke(long var0, long var2, int var4, float var5);

    public static void nk_draw_list_path_stroke(NkDrawList list, NkColor color, int closed, float thickness) {
        Nuklear.nnk_draw_list_path_stroke(list.address(), color.address(), closed, thickness);
    }

    public static native void nnk_draw_list_stroke_line(long var0, long var2, long var4, long var6, float var8);

    public static void nk_draw_list_stroke_line(NkDrawList list, NkVec2 a, NkVec2 b, NkColor color, float thickness) {
        Nuklear.nnk_draw_list_stroke_line(list.address(), a.address(), b.address(), color.address(), thickness);
    }

    public static native void nnk_draw_list_stroke_rect(long var0, long var2, long var4, float var6, float var7);

    public static void nk_draw_list_stroke_rect(NkDrawList list, NkRect rect, NkColor color, float rounding, float thickness) {
        Nuklear.nnk_draw_list_stroke_rect(list.address(), rect.address(), color.address(), rounding, thickness);
    }

    public static native void nnk_draw_list_stroke_triangle(long var0, long var2, long var4, long var6, long var8, float var10);

    public static void nk_draw_list_stroke_triangle(NkDrawList list, NkVec2 a, NkVec2 b, NkVec2 c, NkColor color, float thickness) {
        Nuklear.nnk_draw_list_stroke_triangle(list.address(), a.address(), b.address(), c.address(), color.address(), thickness);
    }

    public static native void nnk_draw_list_stroke_circle(long var0, long var2, float var4, long var5, int var7, float var8);

    public static void nk_draw_list_stroke_circle(NkDrawList list, NkVec2 center, float radius, NkColor color, int segs, float thickness) {
        Nuklear.nnk_draw_list_stroke_circle(list.address(), center.address(), radius, color.address(), segs, thickness);
    }

    public static native void nnk_draw_list_stroke_curve(long var0, long var2, long var4, long var6, long var8, long var10, int var12, float var13);

    public static void nk_draw_list_stroke_curve(NkDrawList list, NkVec2 p0, NkVec2 cp0, NkVec2 cp1, NkVec2 p1, NkColor color, int segments, float thickness) {
        Nuklear.nnk_draw_list_stroke_curve(list.address(), p0.address(), cp0.address(), cp1.address(), p1.address(), color.address(), segments, thickness);
    }

    public static native void nnk_draw_list_stroke_poly_line(long var0, long var2, int var4, long var5, int var7, float var8, int var9);

    public static void nk_draw_list_stroke_poly_line(NkDrawList list, NkVec2 pnts, int cnt, NkColor color, int closed, float thickness, int aliasing) {
        Nuklear.nnk_draw_list_stroke_poly_line(list.address(), pnts.address(), cnt, color.address(), closed, thickness, aliasing);
    }

    public static native void nnk_draw_list_fill_rect(long var0, long var2, long var4, float var6);

    public static void nk_draw_list_fill_rect(NkDrawList list, NkRect rect, NkColor color, float rounding) {
        Nuklear.nnk_draw_list_fill_rect(list.address(), rect.address(), color.address(), rounding);
    }

    public static native void nnk_draw_list_fill_rect_multi_color(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void nk_draw_list_fill_rect_multi_color(NkDrawList list, NkRect rect, NkColor left, NkColor top, NkColor right, NkColor bottom) {
        Nuklear.nnk_draw_list_fill_rect_multi_color(list.address(), rect.address(), left.address(), top.address(), right.address(), bottom.address());
    }

    public static native void nnk_draw_list_fill_triangle(long var0, long var2, long var4, long var6, long var8);

    public static void nk_draw_list_fill_triangle(NkDrawList list, NkVec2 a, NkVec2 b, NkVec2 c, NkColor color) {
        Nuklear.nnk_draw_list_fill_triangle(list.address(), a.address(), b.address(), c.address(), color.address());
    }

    public static native void nnk_draw_list_fill_circle(long var0, long var2, float var4, long var5, int var7);

    public static void nk_draw_list_fill_circle(NkDrawList list, NkVec2 center, float radius, NkColor col, int segs) {
        Nuklear.nnk_draw_list_fill_circle(list.address(), center.address(), radius, col.address(), segs);
    }

    public static native void nnk_draw_list_fill_poly_convex(long var0, long var2, int var4, long var5, int var7);

    public static void nk_draw_list_fill_poly_convex(NkDrawList list, NkVec2.Buffer points, NkColor color, int aliasing) {
        Nuklear.nnk_draw_list_fill_poly_convex(list.address(), points.address(), points.remaining(), color.address(), aliasing);
    }

    public static native void nnk_draw_list_add_image(long var0, long var2, long var4, long var6);

    public static void nk_draw_list_add_image(NkDrawList list, NkImage texture, NkRect rect, NkColor color) {
        Nuklear.nnk_draw_list_add_image(list.address(), texture.address(), rect.address(), color.address());
    }

    public static native void nnk_draw_list_add_text(long var0, long var2, long var4, long var6, int var8, float var9, long var10);

    public static void nk_draw_list_add_text(NkDrawList list, NkUserFont font, NkRect rect, ByteBuffer text, float font_height, NkColor color) {
        Nuklear.nnk_draw_list_add_text(list.address(), font.address(), rect.address(), MemoryUtil.memAddress(text), text.remaining(), font_height, color.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_draw_list_add_text(NkDrawList list, NkUserFont font, NkRect rect, CharSequence text, float font_height, NkColor color) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer textEncoded = stack.UTF8(text, false);
            Nuklear.nnk_draw_list_add_text(list.address(), font.address(), rect.address(), MemoryUtil.memAddress(textEncoded), textEncoded.remaining(), font_height, color.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_draw_list_push_userdata(long var0, long var2);

    public static void nk_draw_list_push_userdata(NkDrawList list, NkHandle userdata) {
        Nuklear.nnk_draw_list_push_userdata(list.address(), userdata.address());
    }

    public static native void nnk_style_item_image(long var0, long var2);

    public static NkStyleItem nk_style_item_image(NkImage img, NkStyleItem __result) {
        Nuklear.nnk_style_item_image(img.address(), __result.address());
        return __result;
    }

    public static native void nnk_style_item_color(long var0, long var2);

    public static NkStyleItem nk_style_item_color(NkColor color, NkStyleItem __result) {
        Nuklear.nnk_style_item_color(color.address(), __result.address());
        return __result;
    }

    public static native void nnk_style_item_hide(long var0);

    public static NkStyleItem nk_style_item_hide(NkStyleItem __result) {
        Nuklear.nnk_style_item_hide(__result.address());
        return __result;
    }

    public static native void nnk_layout_row(long var0, int var2, float var3, int var4, float[] var5);

    public static void nk_layout_row(NkContext ctx, int fmt, float height, float[] ratio) {
        Nuklear.nnk_layout_row(ctx.address(), fmt, height, ratio.length, ratio);
    }

    public static native int nnk_group_scrolled_offset_begin(long var0, int[] var2, int[] var3, long var4, int var6);

    public static boolean nk_group_scrolled_offset_begin(NkContext ctx, int[] x_offset, int[] y_offset, ByteBuffer title, int flags) {
        if (Checks.CHECKS) {
            Checks.check(x_offset, 1);
            Checks.check(y_offset, 1);
            Checks.checkNT1(title);
        }
        return Nuklear.nnk_group_scrolled_offset_begin(ctx.address(), x_offset, y_offset, MemoryUtil.memAddress(title), flags) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_group_scrolled_offset_begin(NkContext ctx, int[] x_offset, int[] y_offset, CharSequence title, int flags) {
        if (Checks.CHECKS) {
            Checks.check(x_offset, 1);
            Checks.check(y_offset, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_group_scrolled_offset_begin(ctx.address(), x_offset, y_offset, MemoryUtil.memAddress(titleEncoded), flags) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_tree_state_push(long var0, int var2, long var3, int[] var5);

    public static boolean nk_tree_state_push(NkContext ctx, int type, ByteBuffer title, int[] state) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
            Checks.check(state, 1);
        }
        return Nuklear.nnk_tree_state_push(ctx.address(), type, MemoryUtil.memAddress(title), state) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_tree_state_push(NkContext ctx, int type, CharSequence title, int[] state) {
        if (Checks.CHECKS) {
            Checks.check(state, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_tree_state_push(ctx.address(), type, MemoryUtil.memAddress(titleEncoded), state) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_tree_state_image_push(long var0, int var2, long var3, long var5, int[] var7);

    public static boolean nk_tree_state_image_push(NkContext ctx, int type, NkImage image, ByteBuffer title, int[] state) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
            Checks.check(state, 1);
        }
        return Nuklear.nnk_tree_state_image_push(ctx.address(), type, image.address(), MemoryUtil.memAddress(title), state) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_tree_state_image_push(NkContext ctx, int type, NkImage image, CharSequence title, int[] state) {
        if (Checks.CHECKS) {
            Checks.check(state, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer titleEncoded = stack.UTF8(title);
            boolean bl = Nuklear.nnk_tree_state_image_push(ctx.address(), type, image.address(), MemoryUtil.memAddress(titleEncoded), state) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_label(long var0, long var2, int[] var4);

    public static boolean nk_checkbox_label(NkContext ctx, ByteBuffer str, int[] active) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(active, 1);
        }
        return Nuklear.nnk_checkbox_label(ctx.address(), MemoryUtil.memAddress(str), active) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_label(NkContext ctx, CharSequence str, int[] active) {
        if (Checks.CHECKS) {
            Checks.check(active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_checkbox_label(ctx.address(), MemoryUtil.memAddress(strEncoded), active) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_text(long var0, long var2, int var4, int[] var5);

    public static boolean nk_checkbox_text(NkContext ctx, ByteBuffer str, int[] active) {
        if (Checks.CHECKS) {
            Checks.check(active, 1);
        }
        return Nuklear.nnk_checkbox_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), active) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_text(NkContext ctx, CharSequence str, int[] active) {
        if (Checks.CHECKS) {
            Checks.check(active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_checkbox_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), active) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_flags_label(long var0, long var2, int[] var4, int var5);

    public static boolean nk_checkbox_flags_label(NkContext ctx, ByteBuffer str, int[] flags, int value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(flags, 1);
        }
        return Nuklear.nnk_checkbox_flags_label(ctx.address(), MemoryUtil.memAddress(str), flags, value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_flags_label(NkContext ctx, CharSequence str, int[] flags, int value) {
        if (Checks.CHECKS) {
            Checks.check(flags, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_checkbox_flags_label(ctx.address(), MemoryUtil.memAddress(strEncoded), flags, value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_checkbox_flags_text(long var0, long var2, int var4, int[] var5, int var6);

    public static boolean nk_checkbox_flags_text(NkContext ctx, ByteBuffer str, int[] flags, int value) {
        if (Checks.CHECKS) {
            Checks.check(flags, 1);
        }
        return Nuklear.nnk_checkbox_flags_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), flags, value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_checkbox_flags_text(NkContext ctx, CharSequence str, int[] flags, int value) {
        if (Checks.CHECKS) {
            Checks.check(flags, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_checkbox_flags_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), flags, value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_radio_label(long var0, long var2, int[] var4);

    public static boolean nk_radio_label(NkContext ctx, ByteBuffer str, int[] active) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(active, 1);
        }
        return Nuklear.nnk_radio_label(ctx.address(), MemoryUtil.memAddress(str), active) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_radio_label(NkContext ctx, CharSequence str, int[] active) {
        if (Checks.CHECKS) {
            Checks.check(active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_radio_label(ctx.address(), MemoryUtil.memAddress(strEncoded), active) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_radio_text(long var0, long var2, int var4, int[] var5);

    public static boolean nk_radio_text(NkContext ctx, ByteBuffer str, int[] active) {
        if (Checks.CHECKS) {
            Checks.check(active, 1);
        }
        return Nuklear.nnk_radio_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), active) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_radio_text(NkContext ctx, CharSequence str, int[] active) {
        if (Checks.CHECKS) {
            Checks.check(active, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_radio_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), active) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_label(long var0, long var2, int var4, int[] var5);

    public static boolean nk_selectable_label(NkContext ctx, ByteBuffer str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(value, 1);
        }
        return Nuklear.nnk_selectable_label(ctx.address(), MemoryUtil.memAddress(str), align, value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_label(NkContext ctx, CharSequence str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_selectable_label(ctx.address(), MemoryUtil.memAddress(strEncoded), align, value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_text(long var0, long var2, int var4, int var5, int[] var6);

    public static boolean nk_selectable_text(NkContext ctx, ByteBuffer str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return Nuklear.nnk_selectable_text(ctx.address(), MemoryUtil.memAddress(str), str.remaining(), align, value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_text(NkContext ctx, CharSequence str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_selectable_text(ctx.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), align, value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_image_label(long var0, long var2, long var4, int var6, int[] var7);

    public static boolean nk_selectable_image_label(NkContext ctx, NkImage img, ByteBuffer str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.check(value, 1);
        }
        return Nuklear.nnk_selectable_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(str), align, value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_image_label(NkContext ctx, NkImage img, CharSequence str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            boolean bl = Nuklear.nnk_selectable_image_label(ctx.address(), img.address(), MemoryUtil.memAddress(strEncoded), align, value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_selectable_image_text(long var0, long var2, long var4, int var6, int var7, int[] var8);

    public static boolean nk_selectable_image_text(NkContext ctx, NkImage img, ByteBuffer str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return Nuklear.nnk_selectable_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(str), str.remaining(), align, value) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_selectable_image_text(NkContext ctx, NkImage img, CharSequence str, int align, int[] value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str, false);
            boolean bl = Nuklear.nnk_selectable_image_text(ctx.address(), img.address(), MemoryUtil.memAddress(strEncoded), strEncoded.remaining(), align, value) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_slider_float(long var0, float var2, float[] var3, float var4, float var5);

    public static int nk_slider_float(NkContext ctx, float min, float[] val, float max, float step) {
        if (Checks.CHECKS) {
            Checks.check(val, 1);
        }
        return Nuklear.nnk_slider_float(ctx.address(), min, val, max, step);
    }

    public static native int nnk_slider_int(long var0, int var2, int[] var3, int var4, int var5);

    public static int nk_slider_int(NkContext ctx, int min, int[] val, int max, int step) {
        if (Checks.CHECKS) {
            Checks.check(val, 1);
        }
        return Nuklear.nnk_slider_int(ctx.address(), min, val, max, step);
    }

    public static native void nnk_property_int(long var0, long var2, int var4, int[] var5, int var6, int var7, float var8);

    public static void nk_property_int(NkContext ctx, ByteBuffer name, int min, int[] val, int max, int step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.check(val, 1);
        }
        Nuklear.nnk_property_int(ctx.address(), MemoryUtil.memAddress(name), min, val, max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_property_int(NkContext ctx, CharSequence name, int min, int[] val, int max, int step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.check(val, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_property_int(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, val, max, step, inc_per_pixel);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_property_float(long var0, long var2, float var4, float[] var5, float var6, float var7, float var8);

    public static void nk_property_float(NkContext ctx, ByteBuffer name, float min, float[] val, float max, float step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.check(val, 1);
        }
        Nuklear.nnk_property_float(ctx.address(), MemoryUtil.memAddress(name), min, val, max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_property_float(NkContext ctx, CharSequence name, float min, float[] val, float max, float step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.check(val, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_property_float(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, val, max, step, inc_per_pixel);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_property_double(long var0, long var2, double var4, double[] var6, double var7, double var9, float var11);

    public static void nk_property_double(NkContext ctx, ByteBuffer name, double min, double[] val, double max, double step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.check(val, 1);
        }
        Nuklear.nnk_property_double(ctx.address(), MemoryUtil.memAddress(name), min, val, max, step, inc_per_pixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_property_double(NkContext ctx, CharSequence name, double min, double[] val, double max, double step, float inc_per_pixel) {
        if (Checks.CHECKS) {
            Checks.check(val, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            Nuklear.nnk_property_double(ctx.address(), MemoryUtil.memAddress(nameEncoded), min, val, max, step, inc_per_pixel);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_edit_string(long var0, int var2, long var3, int[] var5, int var6, long var7);

    public static int nk_edit_string(NkContext ctx, int flags, ByteBuffer memory, int[] len, int max, NkPluginFilterI filter) {
        if (Checks.CHECKS) {
            Checks.checkNT1(memory);
            Checks.check(len, 1);
        }
        return Nuklear.nnk_edit_string(ctx.address(), flags, MemoryUtil.memAddress(memory), len, max, MemoryUtil.memAddressSafe(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_edit_string(NkContext ctx, int flags, CharSequence memory, int[] len, int max, NkPluginFilterI filter) {
        if (Checks.CHECKS) {
            Checks.check(len, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer memoryEncoded = stack.UTF8(memory);
            int n = Nuklear.nnk_edit_string(ctx.address(), flags, MemoryUtil.memAddress(memoryEncoded), len, max, MemoryUtil.memAddressSafe(filter));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_plot(long var0, int var2, float[] var3, int var4, int var5);

    public static void nk_plot(NkContext ctx, int type, float[] values, int count, int offset) {
        if (Checks.CHECKS) {
            Checks.check(values, offset + count);
        }
        Nuklear.nnk_plot(ctx.address(), type, values, count, offset);
    }

    public static native void nnk_combobox(long var0, long var2, int var4, int[] var5, int var6, long var7);

    public static void nk_combobox(NkContext ctx, PointerBuffer items, int[] selected, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check(selected, 1);
        }
        Nuklear.nnk_combobox(ctx.address(), MemoryUtil.memAddress(items), items.remaining(), selected, item_height, size.address());
    }

    public static native void nnk_combobox_string(long var0, long var2, int[] var4, int var5, int var6, long var7);

    public static void nk_combobox_string(NkContext ctx, ByteBuffer items_separated_by_zeros, int[] selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(items_separated_by_zeros);
            Checks.check(selected, 1);
        }
        Nuklear.nnk_combobox_string(ctx.address(), MemoryUtil.memAddress(items_separated_by_zeros), selected, count, item_height, size.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_combobox_string(NkContext ctx, CharSequence items_separated_by_zeros, int[] selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check(selected, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer items_separated_by_zerosEncoded = stack.UTF8(items_separated_by_zeros);
            Nuklear.nnk_combobox_string(ctx.address(), MemoryUtil.memAddress(items_separated_by_zerosEncoded), selected, count, item_height, size.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_combobox_separator(long var0, long var2, int var4, int[] var5, int var6, int var7, long var8);

    public static void nk_combobox_separator(NkContext ctx, ByteBuffer items_separated_by_separator, int separator, int[] selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(items_separated_by_separator);
            Checks.check(selected, 1);
        }
        Nuklear.nnk_combobox_separator(ctx.address(), MemoryUtil.memAddress(items_separated_by_separator), separator, selected, count, item_height, size.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nk_combobox_separator(NkContext ctx, CharSequence items_separated_by_separator, int separator, int[] selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check(selected, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer items_separated_by_separatorEncoded = stack.UTF8(items_separated_by_separator);
            Nuklear.nnk_combobox_separator(ctx.address(), MemoryUtil.memAddress(items_separated_by_separatorEncoded), separator, selected, count, item_height, size.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_combobox_callback(long var0, long var2, long var4, int[] var6, int var7, int var8, long var9);

    public static void nk_combobox_callback(NkContext ctx, NkItemGetterI item_getter, long userdata, int[] selected, int count, int item_height, NkVec2 size) {
        if (Checks.CHECKS) {
            Checks.check(userdata);
            Checks.check(selected, 1);
        }
        Nuklear.nnk_combobox_callback(ctx.address(), item_getter.address(), userdata, selected, count, item_height, size.address());
    }

    public static native int nnk_style_push_float(long var0, float[] var2, float var3);

    public static int nk_style_push_float(NkContext ctx, float[] address, float value) {
        if (Checks.CHECKS) {
            Checks.check(address, 1);
        }
        return Nuklear.nnk_style_push_float(ctx.address(), address, value);
    }

    public static native int nnk_style_push_flags(long var0, int[] var2, int var3);

    public static int nk_style_push_flags(NkContext ctx, int[] address, int value) {
        if (Checks.CHECKS) {
            Checks.check(address, 1);
        }
        return Nuklear.nnk_style_push_flags(ctx.address(), address, value);
    }

    public static native void nnk_rgb_iv(int[] var0, long var1);

    public static NkColor nk_rgb_iv(int[] rgb, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(rgb, 3);
        }
        Nuklear.nnk_rgb_iv(rgb, __result.address());
        return __result;
    }

    public static native void nnk_rgb_fv(float[] var0, long var1);

    public static NkColor nk_rgb_fv(float[] rgb, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(rgb, 3);
        }
        Nuklear.nnk_rgb_fv(rgb, __result.address());
        return __result;
    }

    public static native void nnk_rgba_iv(int[] var0, long var1);

    public static NkColor nk_rgba_iv(int[] rgba, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(rgba, 4);
        }
        Nuklear.nnk_rgba_iv(rgba, __result.address());
        return __result;
    }

    public static native void nnk_rgba_fv(float[] var0, long var1);

    public static NkColor nk_rgba_fv(float[] rgba, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(rgba, 4);
        }
        Nuklear.nnk_rgba_fv(rgba, __result.address());
        return __result;
    }

    public static native void nnk_hsv_iv(int[] var0, long var1);

    public static NkColor nk_hsv_iv(int[] hsv, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(hsv, 3);
        }
        Nuklear.nnk_hsv_iv(hsv, __result.address());
        return __result;
    }

    public static native void nnk_hsv_fv(float[] var0, long var1);

    public static NkColor nk_hsv_fv(float[] hsv, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(hsv, 3);
        }
        Nuklear.nnk_hsv_fv(hsv, __result.address());
        return __result;
    }

    public static native void nnk_hsva_iv(int[] var0, long var1);

    public static NkColor nk_hsva_iv(int[] hsva, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(hsva, 4);
        }
        Nuklear.nnk_hsva_iv(hsva, __result.address());
        return __result;
    }

    public static native void nnk_hsva_fv(float[] var0, long var1);

    public static NkColor nk_hsva_fv(float[] hsva, NkColor __result) {
        if (Checks.CHECKS) {
            Checks.check(hsva, 4);
        }
        Nuklear.nnk_hsva_fv(hsva, __result.address());
        return __result;
    }

    public static native void nnk_color_f(float[] var0, float[] var1, float[] var2, float[] var3, long var4);

    public static void nk_color_f(float[] r, float[] g, float[] b, float[] a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(r, 1);
            Checks.check(g, 1);
            Checks.check(b, 1);
            Checks.check(a, 1);
        }
        Nuklear.nnk_color_f(r, g, b, a, color.address());
    }

    public static native void nnk_color_fv(float[] var0, long var1);

    public static void nk_color_fv(float[] rgba_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(rgba_out, 4);
        }
        Nuklear.nnk_color_fv(rgba_out, color.address());
    }

    public static native void nnk_color_d(double[] var0, double[] var1, double[] var2, double[] var3, long var4);

    public static void nk_color_d(double[] r, double[] g, double[] b, double[] a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(r, 1);
            Checks.check(g, 1);
            Checks.check(b, 1);
            Checks.check(a, 1);
        }
        Nuklear.nnk_color_d(r, g, b, a, color.address());
    }

    public static native void nnk_color_dv(double[] var0, long var1);

    public static void nk_color_dv(double[] rgba_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(rgba_out, 4);
        }
        Nuklear.nnk_color_dv(rgba_out, color.address());
    }

    public static native void nnk_color_hsv_i(int[] var0, int[] var1, int[] var2, long var3);

    public static void nk_color_hsv_i(int[] out_h, int[] out_s, int[] out_v, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(out_h, 1);
            Checks.check(out_s, 1);
            Checks.check(out_v, 1);
        }
        Nuklear.nnk_color_hsv_i(out_h, out_s, out_v, color.address());
    }

    public static native void nnk_color_hsv_iv(int[] var0, long var1);

    public static void nk_color_hsv_iv(int[] hsv_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(hsv_out, 3);
        }
        Nuklear.nnk_color_hsv_iv(hsv_out, color.address());
    }

    public static native void nnk_color_hsv_f(float[] var0, float[] var1, float[] var2, long var3);

    public static void nk_color_hsv_f(float[] out_h, float[] out_s, float[] out_v, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(out_h, 1);
            Checks.check(out_s, 1);
            Checks.check(out_v, 1);
        }
        Nuklear.nnk_color_hsv_f(out_h, out_s, out_v, color.address());
    }

    public static native void nnk_color_hsv_fv(float[] var0, long var1);

    public static void nk_color_hsv_fv(float[] hsv_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(hsv_out, 3);
        }
        Nuklear.nnk_color_hsv_fv(hsv_out, color.address());
    }

    public static native void nnk_color_hsva_i(int[] var0, int[] var1, int[] var2, int[] var3, long var4);

    public static void nk_color_hsva_i(int[] h, int[] s, int[] v, int[] a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(h, 1);
            Checks.check(s, 1);
            Checks.check(v, 1);
            Checks.check(a, 1);
        }
        Nuklear.nnk_color_hsva_i(h, s, v, a, color.address());
    }

    public static native void nnk_color_hsva_iv(int[] var0, long var1);

    public static void nk_color_hsva_iv(int[] hsva_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(hsva_out, 4);
        }
        Nuklear.nnk_color_hsva_iv(hsva_out, color.address());
    }

    public static native void nnk_color_hsva_f(float[] var0, float[] var1, float[] var2, float[] var3, long var4);

    public static void nk_color_hsva_f(float[] out_h, float[] out_s, float[] out_v, float[] out_a, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(out_h, 1);
            Checks.check(out_s, 1);
            Checks.check(out_v, 1);
            Checks.check(out_a, 1);
        }
        Nuklear.nnk_color_hsva_f(out_h, out_s, out_v, out_a, color.address());
    }

    public static native void nnk_color_hsva_fv(float[] var0, long var1);

    public static void nk_color_hsva_fv(float[] hsva_out, NkColor color) {
        if (Checks.CHECKS) {
            Checks.check(hsva_out, 4);
        }
        Nuklear.nnk_color_hsva_fv(hsva_out, color.address());
    }

    public static native void nnk_vec2v(float[] var0, long var1);

    public static NkVec2 nk_vec2v(float[] xy, NkVec2 __result) {
        if (Checks.CHECKS) {
            Checks.check(xy, 2);
        }
        Nuklear.nnk_vec2v(xy, __result.address());
        return __result;
    }

    public static native void nnk_vec2iv(int[] var0, long var1);

    public static NkVec2 nk_vec2iv(int[] xy, NkVec2 __result) {
        if (Checks.CHECKS) {
            Checks.check(xy, 2);
        }
        Nuklear.nnk_vec2iv(xy, __result.address());
        return __result;
    }

    public static native void nnk_rectv(float[] var0, long var1);

    public static NkRect nk_rectv(float[] xywh, NkRect __result) {
        if (Checks.CHECKS) {
            Checks.check(xywh, 4);
        }
        Nuklear.nnk_rectv(xywh, __result.address());
        return __result;
    }

    public static native void nnk_rectiv(int[] var0, long var1);

    public static NkRect nk_rectiv(int[] xywh, NkRect __result) {
        if (Checks.CHECKS) {
            Checks.check(xywh, 4);
        }
        Nuklear.nnk_rectiv(xywh, __result.address());
        return __result;
    }

    public static native int nnk_strmatch_fuzzy_string(long var0, long var2, int[] var4);

    public static boolean nk_strmatch_fuzzy_string(ByteBuffer str, ByteBuffer pattern, int[] out_score) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
            Checks.checkNT1(pattern);
            Checks.check(out_score, 1);
        }
        return Nuklear.nnk_strmatch_fuzzy_string(MemoryUtil.memAddress(str), MemoryUtil.memAddress(pattern), out_score) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nk_strmatch_fuzzy_string(CharSequence str, CharSequence pattern, int[] out_score) {
        if (Checks.CHECKS) {
            Checks.check(out_score, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            ByteBuffer patternEncoded = stack.UTF8(pattern);
            boolean bl = Nuklear.nnk_strmatch_fuzzy_string(MemoryUtil.memAddress(strEncoded), MemoryUtil.memAddress(patternEncoded), out_score) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_strmatch_fuzzy_text(long var0, int var2, long var3, int[] var5);

    public static int nk_strmatch_fuzzy_text(ByteBuffer txt, ByteBuffer pattern, int[] out_score) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pattern);
            Checks.check(out_score, 1);
        }
        return Nuklear.nnk_strmatch_fuzzy_text(MemoryUtil.memAddress(txt), txt.remaining(), MemoryUtil.memAddress(pattern), out_score);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nk_strmatch_fuzzy_text(CharSequence txt, CharSequence pattern, int[] out_score) {
        if (Checks.CHECKS) {
            Checks.check(out_score, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer txtEncoded = stack.UTF8(txt, false);
            ByteBuffer patternEncoded = stack.UTF8(pattern);
            int n = Nuklear.nnk_strmatch_fuzzy_text(MemoryUtil.memAddress(txtEncoded), txtEncoded.remaining(), MemoryUtil.memAddress(patternEncoded), out_score);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_utf_decode(long var0, int[] var2, int var3);

    public static int nk_utf_decode(ByteBuffer c, int[] u) {
        if (Checks.CHECKS) {
            Checks.check(u, 1);
        }
        return Nuklear.nnk_utf_decode(MemoryUtil.memAddress(c), u, c.remaining());
    }

    public static native long nnk_utf_at(long var0, int var2, int var3, int[] var4, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer nk_utf_at(ByteBuffer buffer, int index, int[] unicode) {
        if (Checks.CHECKS) {
            Checks.check(unicode, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer len = stack.callocInt(1);
            long __result = Nuklear.nnk_utf_at(MemoryUtil.memAddress(buffer), buffer.remaining(), index, unicode, MemoryUtil.memAddress(len));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, len.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnk_str_append_text_runes(long var0, int[] var2, int var3);

    public static int nk_str_append_text_runes(NkStr s, int[] runes) {
        return Nuklear.nnk_str_append_text_runes(s.address(), runes, runes.length);
    }

    public static native int nnk_str_append_str_runes(long var0, int[] var2);

    public static int nk_str_append_str_runes(NkStr s, int[] runes) {
        if (Checks.CHECKS) {
            Checks.checkNT(runes);
        }
        return Nuklear.nnk_str_append_str_runes(s.address(), runes);
    }

    public static native int nnk_str_insert_text_runes(long var0, int var2, int[] var3, int var4);

    public static int nk_str_insert_text_runes(NkStr s, int pos, int[] runes) {
        return Nuklear.nnk_str_insert_text_runes(s.address(), pos, runes, runes.length);
    }

    public static native int nnk_str_insert_str_runes(long var0, int var2, int[] var3);

    public static int nk_str_insert_str_runes(NkStr s, int pos, int[] runes) {
        if (Checks.CHECKS) {
            Checks.checkNT(runes);
        }
        return Nuklear.nnk_str_insert_str_runes(s.address(), pos, runes);
    }

    public static native long nnk_str_at_rune(long var0, int var2, int[] var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer nk_str_at_rune(NkStr s, int pos, int[] unicode) {
        if (Checks.CHECKS) {
            Checks.check(unicode, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer len = stack.callocInt(1);
        try {
            long __result = Nuklear.nnk_str_at_rune(s.address(), pos, unicode, MemoryUtil.memAddress(len));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, len.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nnk_str_at_const(long var0, int var2, int[] var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer nk_str_at_const(NkStr s, int pos, int[] unicode) {
        if (Checks.CHECKS) {
            Checks.check(unicode, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer len = stack.callocInt(1);
        try {
            long __result = Nuklear.nnk_str_at_const(s.address(), pos, unicode, MemoryUtil.memAddress(len));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, len.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnk_stroke_polyline(long var0, float[] var2, int var3, float var4, long var5);

    public static void nk_stroke_polyline(NkCommandBuffer b, float[] points, float line_thickness, NkColor col) {
        Nuklear.nnk_stroke_polyline(b.address(), points, points.length, line_thickness, col.address());
    }

    public static native void nnk_stroke_polygon(long var0, float[] var2, int var3, float var4, long var5);

    public static void nk_stroke_polygon(NkCommandBuffer b, float[] points, float line_thickness, NkColor color) {
        Nuklear.nnk_stroke_polygon(b.address(), points, points.length, line_thickness, color.address());
    }

    public static native void nnk_fill_polygon(long var0, float[] var2, int var3, long var4);

    public static void nk_fill_polygon(NkCommandBuffer b, float[] points, NkColor color) {
        Nuklear.nnk_fill_polygon(b.address(), points, points.length, color.address());
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, Nuklear.class, Platform.mapLibraryNameBundled("lwjgl_nuklear"));
    }
}

