/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTCapture {
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;

    protected EXTCapture() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCCapabilities caps) {
        return Checks.checkFunctions(caps.alcCaptureOpenDevice, caps.alcCaptureCloseDevice, caps.alcCaptureStart, caps.alcCaptureStop, caps.alcCaptureSamples);
    }

    public static long nalcCaptureOpenDevice(long deviceName, int frequency, int format, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureOpenDevice;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(__functionAddress, deviceName, frequency, format, samples);
    }

    public static long alcCaptureOpenDevice(ByteBuffer deviceName, int frequency, int format, int samples) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(deviceName);
        }
        return EXTCapture.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe(deviceName), frequency, format, samples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alcCaptureOpenDevice(CharSequence deviceName, int frequency, int format, int samples) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer deviceNameEncoded = stack.UTF8(deviceName);
            long l = EXTCapture.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe(deviceNameEncoded), frequency, format, samples);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean alcCaptureCloseDevice(long device) {
        long __functionAddress = ALC.getICD().alcCaptureCloseDevice;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.invokePZ(__functionAddress, device);
    }

    public static void alcCaptureStart(long device) {
        long __functionAddress = ALC.getICD().alcCaptureStart;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePV(__functionAddress, device);
    }

    public static void alcCaptureStop(long device) {
        long __functionAddress = ALC.getICD().alcCaptureStop;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePV(__functionAddress, device);
    }

    public static void nalcCaptureSamples(long device, long buffer, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }

    public static void alcCaptureSamples(long device, ByteBuffer buffer, int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcCaptureSamples(long device, ShortBuffer buffer, int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcCaptureSamples(long device, IntBuffer buffer, int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcCaptureSamples(long device, FloatBuffer buffer, int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcCaptureSamples(long device, short[] buffer, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }

    public static void alcCaptureSamples(long device, int[] buffer, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }

    public static void alcCaptureSamples(long device, float[] buffer, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }
}

