/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class SOFTLoopback {
    public static final int ALC_BYTE_SOFT = 5120;
    public static final int ALC_UNSIGNED_BYTE_SOFT = 5121;
    public static final int ALC_SHORT_SOFT = 5122;
    public static final int ALC_UNSIGNED_SHORT_SOFT = 5123;
    public static final int ALC_INT_SOFT = 5124;
    public static final int ALC_UNSIGNED_INT_SOFT = 5125;
    public static final int ALC_FLOAT_SOFT = 5126;
    public static final int ALC_MONO_SOFT = 5376;
    public static final int ALC_STEREO_SOFT = 5377;
    public static final int ALC_QUAD_SOFT = 5379;
    public static final int ALC_5POINT1_SOFT = 5380;
    public static final int ALC_6POINT1_SOFT = 5381;
    public static final int ALC_7POINT1_SOFT = 5382;
    public static final int ALC_FORMAT_CHANNELS_SOFT = 6544;
    public static final int ALC_FORMAT_TYPE_SOFT = 6545;

    protected SOFTLoopback() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCCapabilities caps) {
        return Checks.checkFunctions(caps.alcLoopbackOpenDeviceSOFT, caps.alcIsRenderFormatSupportedSOFT, caps.alcRenderSamplesSOFT);
    }

    public static long nalcLoopbackOpenDeviceSOFT(long deviceName) {
        long __functionAddress = ALC.getICD().alcLoopbackOpenDeviceSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(__functionAddress, deviceName);
    }

    public static long alcLoopbackOpenDeviceSOFT(ByteBuffer deviceName) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(deviceName);
        }
        return SOFTLoopback.nalcLoopbackOpenDeviceSOFT(MemoryUtil.memAddressSafe(deviceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alcLoopbackOpenDeviceSOFT(CharSequence deviceName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer deviceNameEncoded = stack.UTF8(deviceName);
            long l = SOFTLoopback.nalcLoopbackOpenDeviceSOFT(MemoryUtil.memAddressSafe(deviceNameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean alcIsRenderFormatSupportedSOFT(long device, int frequency, int channels, int type) {
        long __functionAddress = ALC.getICD().alcIsRenderFormatSupportedSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.invokePZ(__functionAddress, device, frequency, channels, type);
    }

    public static void nalcRenderSamplesSOFT(long device, long buffer, int samples) {
        long __functionAddress = ALC.getICD().alcRenderSamplesSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }

    public static void alcRenderSamplesSOFT(long device, ByteBuffer buffer, int samples) {
        SOFTLoopback.nalcRenderSamplesSOFT(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcRenderSamplesSOFT(long device, ShortBuffer buffer, int samples) {
        SOFTLoopback.nalcRenderSamplesSOFT(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcRenderSamplesSOFT(long device, IntBuffer buffer, int samples) {
        SOFTLoopback.nalcRenderSamplesSOFT(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcRenderSamplesSOFT(long device, FloatBuffer buffer, int samples) {
        SOFTLoopback.nalcRenderSamplesSOFT(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcRenderSamplesSOFT(long device, short[] buffer, int samples) {
        long __functionAddress = ALC.getICD().alcRenderSamplesSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }

    public static void alcRenderSamplesSOFT(long device, int[] buffer, int samples) {
        long __functionAddress = ALC.getICD().alcRenderSamplesSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }

    public static void alcRenderSamplesSOFT(long device, float[] buffer, int samples) {
        long __functionAddress = ALC.getICD().alcRenderSamplesSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }
}

