/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLBusAddressAMD;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class AMDBusAddressableMemory {
    public static final int CL_MEM_BUS_ADDRESSABLE_AMD = 0x40000000;
    public static final int CL_MEM_EXTERNAL_PHYSICAL_AMD = Integer.MIN_VALUE;
    public static final int CL_COMMAND_WAIT_SIGNAL_AMD = 16512;
    public static final int CL_COMMAND_WRITE_SIGNAL_AMD = 16513;
    public static final int CL_COMMAND_MAKE_BUFFERS_RESIDENT_AMD = 16514;

    protected AMDBusAddressableMemory() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clEnqueueWaitSignalAMD, caps.clEnqueueWriteSignalAMD, caps.clEnqueueMakeBuffersResidentAMD);
    }

    public static int nclEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWaitSignalAMD;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.check(mem_object);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, mem_object, value, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return AMDBusAddressableMemory.nclEnqueueWaitSignalAMD(command_queue, mem_object, value, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWriteSignalAMD;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.check(mem_object);
        }
        return JNI.callPPJPPI(__functionAddress, command_queue, mem_object, value, offset, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return AMDBusAddressableMemory.nclEnqueueWriteSignalAMD(command_queue, mem_object, value, offset, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueMakeBuffersResidentAMD(long command_queue, int num_mem_objs, long mem_objects, int blocking_make_resident, long bus_addresses, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMakeBuffersResidentAMD;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPPI(__functionAddress, command_queue, num_mem_objs, mem_objects, blocking_make_resident, bus_addresses, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueMakeBuffersResidentAMD(long command_queue, PointerBuffer mem_objects, boolean blocking_make_resident, CLBusAddressAMD.Buffer bus_addresses, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(bus_addresses, mem_objects.remaining());
            Checks.checkSafe(event, 1);
        }
        return AMDBusAddressableMemory.nclEnqueueMakeBuffersResidentAMD(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), blocking_make_resident ? 1 : 0, bus_addresses.address(), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

