/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class CL21 {
    public static final int CL_VERSION_2_1 = 1;
    public static final int CL_PLATFORM_HOST_TIMER_RESOLUTION = 2309;
    public static final int CL_DEVICE_IL_VERSION = 4187;
    public static final int CL_DEVICE_MAX_NUM_SUB_GROUPS = 4188;
    public static final int CL_DEVICE_SUB_GROUP_INDEPENDENT_FORWARD_PROGRESS = 4189;
    public static final int CL_QUEUE_DEVICE_DEFAULT = 4245;
    public static final int CL_UNORM_INT_101010_2 = 4320;
    public static final int CL_PROGRAM_IL = 4457;
    public static final int CL_KERNEL_MAX_NUM_SUB_GROUPS = 4537;
    public static final int CL_KERNEL_COMPILE_NUM_SUB_GROUPS = 4538;
    public static final int CL_KERNEL_MAX_SUB_GROUP_SIZE_FOR_NDRANGE = 8243;
    public static final int CL_KERNEL_SUB_GROUP_COUNT_FOR_NDRANGE = 8244;
    public static final int CL_KERNEL_LOCAL_SIZE_FOR_SUB_GROUP_COUNT = 4536;

    protected CL21() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clSetDefaultDeviceCommandQueue, caps.clGetDeviceAndHostTimer, caps.clGetHostTimer, caps.clCreateProgramWithIL, caps.clCloneKernel, caps.clGetKernelSubGroupInfo, caps.clEnqueueSVMMigrateMem);
    }

    public static int clSetDefaultDeviceCommandQueue(long context, long device, long command_queue) {
        long __functionAddress = CL.getICD().clSetDefaultDeviceCommandQueue;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.check(device);
            Checks.check(command_queue);
        }
        return JNI.callPPPI(__functionAddress, context, device, command_queue);
    }

    public static int nclGetDeviceAndHostTimer(long device, long device_timestamp, long host_timestamp) {
        long __functionAddress = CL.getICD().clGetDeviceAndHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPPI(__functionAddress, device, device_timestamp, host_timestamp);
    }

    public static int clGetDeviceAndHostTimer(long device, LongBuffer device_timestamp, LongBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)device_timestamp, 1);
            Checks.check((Buffer)host_timestamp, 1);
        }
        return CL21.nclGetDeviceAndHostTimer(device, MemoryUtil.memAddress(device_timestamp), MemoryUtil.memAddress(host_timestamp));
    }

    public static int nclGetHostTimer(long device, long host_timestamp) {
        long __functionAddress = CL.getICD().clGetHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPI(__functionAddress, device, host_timestamp);
    }

    public static int clGetHostTimer(long device, LongBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)host_timestamp, 1);
        }
        return CL21.nclGetHostTimer(device, MemoryUtil.memAddress(host_timestamp));
    }

    public static long nclCreateProgramWithIL(long context, long il, long length, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithIL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPPPPP(__functionAddress, context, il, length, errcode_ret);
    }

    public static long clCreateProgramWithIL(long context, ByteBuffer il, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL21.nclCreateProgramWithIL(context, MemoryUtil.memAddress(il), il.remaining(), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCloneKernel(long source_kernel, long errcode_ret) {
        long __functionAddress = CL.getICD().clCloneKernel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(source_kernel);
        }
        return JNI.callPPP(__functionAddress, source_kernel, errcode_ret);
    }

    public static long clCloneKernel(long source_kernel, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL21.nclCloneKernel(source_kernel, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetKernelSubGroupInfo(long kernel, long device, int param_name, long input_value_size, long input_value, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelSubGroupInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
        }
        return JNI.callPPPPPPPI(__functionAddress, kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret);
    }

    public static int clGetKernelSubGroupInfo(long kernel, long device, int param_name, ByteBuffer input_value, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, Checks.remainingSafe(input_value), MemoryUtil.memAddressSafe(input_value), Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelSubGroupInfo(long kernel, long device, int param_name, ByteBuffer input_value, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, Checks.remainingSafe(input_value), MemoryUtil.memAddressSafe(input_value), Checks.remainingSafe(param_value) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueSVMMigrateMem(long command_queue, int num_svm_pointers, long svm_pointers, long sizes, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMigrateMem;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPJPPI(__functionAddress, command_queue, num_svm_pointers, svm_pointers, sizes, flags, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueSVMMigrateMem(long command_queue, PointerBuffer svm_pointers, PointerBuffer sizes, long flags, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(sizes, svm_pointers.remaining());
            Checks.checkSafe(event, 1);
        }
        return CL21.nclEnqueueSVMMigrateMem(command_queue, svm_pointers.remaining(), MemoryUtil.memAddress(svm_pointers), MemoryUtil.memAddressSafe(sizes), flags, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clGetDeviceAndHostTimer(long device, long[] device_timestamp, long[] host_timestamp) {
        long __functionAddress = CL.getICD().clGetDeviceAndHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.check(device_timestamp, 1);
            Checks.check(host_timestamp, 1);
        }
        return JNI.callPPPI(__functionAddress, device, device_timestamp, host_timestamp);
    }

    public static int clGetHostTimer(long device, long[] host_timestamp) {
        long __functionAddress = CL.getICD().clGetHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.check(host_timestamp, 1);
        }
        return JNI.callPPI(__functionAddress, device, host_timestamp);
    }

    public static long clCreateProgramWithIL(long context, ByteBuffer il, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithIL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPP(__functionAddress, context, MemoryUtil.memAddress(il), (long)il.remaining(), errcode_ret);
    }

    public static long clCloneKernel(long source_kernel, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCloneKernel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(source_kernel);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPP(__functionAddress, source_kernel, errcode_ret);
    }
}

