/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLImageFormat
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE_CHANNEL_ORDER;
    public static final int IMAGE_CHANNEL_DATA_TYPE;

    CLImageFormat(long address, ByteBuffer container) {
        super(address, container);
    }

    public CLImageFormat(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CLImageFormat.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int image_channel_order() {
        return CLImageFormat.nimage_channel_order(this.address());
    }

    public int image_channel_data_type() {
        return CLImageFormat.nimage_channel_data_type(this.address());
    }

    public CLImageFormat image_channel_order(int value) {
        CLImageFormat.nimage_channel_order(this.address(), value);
        return this;
    }

    public CLImageFormat image_channel_data_type(int value) {
        CLImageFormat.nimage_channel_data_type(this.address(), value);
        return this;
    }

    public CLImageFormat set(int image_channel_order, int image_channel_data_type) {
        this.image_channel_order(image_channel_order);
        this.image_channel_data_type(image_channel_data_type);
        return this;
    }

    public CLImageFormat set(CLImageFormat src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLImageFormat malloc() {
        return CLImageFormat.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CLImageFormat calloc() {
        return CLImageFormat.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CLImageFormat create() {
        return new CLImageFormat(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CLImageFormat create(long address) {
        return address == 0L ? null : new CLImageFormat(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CLImageFormat.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLImageFormat.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CLImageFormat mallocStack() {
        return CLImageFormat.mallocStack(MemoryStack.stackGet());
    }

    public static CLImageFormat callocStack() {
        return CLImageFormat.callocStack(MemoryStack.stackGet());
    }

    public static CLImageFormat mallocStack(MemoryStack stack) {
        return CLImageFormat.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLImageFormat callocStack(MemoryStack stack) {
        return CLImageFormat.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLImageFormat.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLImageFormat.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLImageFormat.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLImageFormat.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nimage_channel_order(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE_CHANNEL_ORDER);
    }

    public static int nimage_channel_data_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE_CHANNEL_DATA_TYPE);
    }

    public static void nimage_channel_order(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE_CHANNEL_ORDER, value);
    }

    public static void nimage_channel_data_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE_CHANNEL_DATA_TYPE, value);
    }

    static {
        Struct.Layout layout = CLImageFormat.__struct(CLImageFormat.__member(4), CLImageFormat.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE_CHANNEL_ORDER = layout.offsetof(0);
        IMAGE_CHANNEL_DATA_TYPE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLImageFormat, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CLImageFormat newInstance(long address) {
            return new CLImageFormat(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int image_channel_order() {
            return CLImageFormat.nimage_channel_order(this.address());
        }

        public int image_channel_data_type() {
            return CLImageFormat.nimage_channel_data_type(this.address());
        }

        public Buffer image_channel_order(int value) {
            CLImageFormat.nimage_channel_order(this.address(), value);
            return this;
        }

        public Buffer image_channel_data_type(int value) {
            CLImageFormat.nimage_channel_data_type(this.address(), value);
            return this;
        }
    }
}

