/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class INTELSubgroups {
    public static final int CL_KERNEL_MAX_SUB_GROUP_SIZE_FOR_NDRANGE_KHR = 8243;
    public static final int CL_KERNEL_SUB_GROUP_COUNT_FOR_NDRANGE_KHR = 8244;

    protected INTELSubgroups() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clGetKernelSubGroupInfoKHR);
    }

    public static int nclGetKernelSubGroupInfoKHR(long kernel, long device, int param_name, long input_value_size, long input_value, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelSubGroupInfoKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
        }
        return JNI.callPPPPPPPI(__functionAddress, kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret);
    }

    public static int clGetKernelSubGroupInfoKHR(long kernel, long device, int param_name, ByteBuffer input_value, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return INTELSubgroups.nclGetKernelSubGroupInfoKHR(kernel, device, param_name, input_value.remaining(), MemoryUtil.memAddress(input_value), Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelSubGroupInfoKHR(long kernel, long device, int param_name, ByteBuffer input_value, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return INTELSubgroups.nclGetKernelSubGroupInfoKHR(kernel, device, param_name, input_value.remaining(), MemoryUtil.memAddress(input_value), Checks.remainingSafe(param_value) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }
}

