/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class INTELVAAPIMediaSharing {
    public static final int CL_VA_API_DISPLAY_INTEL = 16532;
    public static final int CL_PREFERRED_DEVICES_FOR_VA_API_INTEL = 16533;
    public static final int CL_ALL_DEVICES_FOR_VA_API_INTEL = 16534;
    public static final int CL_CONTEXT_VA_API_DISPLAY_INTEL = 16535;
    public static final int CL_MEM_VA_API_MEDIA_SURFACE_INTEL = 16536;
    public static final int CL_IMAGE_VA_API_PLANE_INTEL = 16537;
    public static final int CL_COMMAND_ACQUIRE_VA_API_MEDIA_SURFACES_INTEL = 16538;
    public static final int CL_COMMAND_RELEASE_VA_API_MEDIA_SURFACES_INTEL = 16539;
    public static final int CL_INVALID_VA_API_MEDIA_ADAPTER_INTEL = -1098;
    public static final int CL_INVALID_VA_API_MEDIA_SURFACE_INTEL = -1099;
    public static final int CL_VA_API_MEDIA_SURFACE_ALREADY_ACQUIRED_INTEL = -1100;
    public static final int CL_VA_API_MEDIA_SURFACE_NOT_ACQUIRED_INTEL = -1101;

    protected INTELVAAPIMediaSharing() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clGetDeviceIDsFromVA_APIMediaAdapterINTEL, caps.clCreateFromVA_APIMediaSurfaceINTEL, caps.clEnqueueAcquireVA_APIMediaSurfacesINTEL, caps.clEnqueueReleaseVA_APIMediaSurfacesINTEL);
    }

    public static int nclGetDeviceIDsFromVA_APIMediaAdapterINTEL(long platform, int media_adapter_type, long media_adapter, int media_adapter_set, int num_entries, long devices, long num_devices) {
        long __functionAddress = CL.getICD().clGetDeviceIDsFromVA_APIMediaAdapterINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(platform);
            Checks.check(media_adapter);
        }
        return JNI.callPPPPI(__functionAddress, platform, media_adapter_type, media_adapter, media_adapter_set, num_entries, devices, num_devices);
    }

    public static int clGetDeviceIDsFromVA_APIMediaAdapterINTEL(long platform, int media_adapter_type, long media_adapter, int media_adapter_set, PointerBuffer devices, IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_devices, 1);
        }
        return INTELVAAPIMediaSharing.nclGetDeviceIDsFromVA_APIMediaAdapterINTEL(platform, media_adapter_type, media_adapter, media_adapter_set, Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddressSafe(num_devices));
    }

    public static long nclCreateFromVA_APIMediaSurfaceINTEL(long context, long flags, long surface, int plane, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromVA_APIMediaSurfaceINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPPP(__functionAddress, context, flags, surface, plane, errcode_ret);
    }

    public static long clCreateFromVA_APIMediaSurfaceINTEL(long context, long flags, IntBuffer surface, int plane, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)surface, 1);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return INTELVAAPIMediaSharing.nclCreateFromVA_APIMediaSurfaceINTEL(context, flags, MemoryUtil.memAddress(surface), plane, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclEnqueueAcquireVA_APIMediaSurfacesINTEL(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueAcquireVA_APIMediaSurfacesINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueAcquireVA_APIMediaSurfacesINTEL(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return INTELVAAPIMediaSharing.nclEnqueueAcquireVA_APIMediaSurfacesINTEL(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueReleaseVA_APIMediaSurfacesINTEL(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReleaseVA_APIMediaSurfacesINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueReleaseVA_APIMediaSurfacesINTEL(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return INTELVAAPIMediaSharing.nclEnqueueReleaseVA_APIMediaSurfacesINTEL(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clGetDeviceIDsFromVA_APIMediaAdapterINTEL(long platform, int media_adapter_type, long media_adapter, int media_adapter_set, PointerBuffer devices, int[] num_devices) {
        long __functionAddress = CL.getICD().clGetDeviceIDsFromVA_APIMediaAdapterINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(platform);
            Checks.check(media_adapter);
            Checks.checkSafe(num_devices, 1);
        }
        return JNI.callPPPPI(__functionAddress, platform, media_adapter_type, media_adapter, media_adapter_set, Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), num_devices);
    }

    public static long clCreateFromVA_APIMediaSurfaceINTEL(long context, long flags, int[] surface, int plane, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromVA_APIMediaSurfaceINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.check(surface, 1);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPP(__functionAddress, context, flags, surface, plane, errcode_ret);
    }
}

