/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHREGLImage {
    public static final int CL_EGL_RESOURCE_NOT_ACQUIRED_KHR = -1092;
    public static final int CL_INVALID_EGL_OBJECT_KHR = -1093;
    public static final int CL_COMMAND_ACQUIRE_EGL_OBJECTS_KHR = 8237;
    public static final int CL_COMMAND_RELEASE_EGL_OBJECTS_KHR = 8238;

    protected KHREGLImage() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clCreateFromEGLImageKHR, caps.clEnqueueAcquireEGLObjectsKHR, caps.clEnqueueReleaseEGLObjectsKHR);
    }

    public static long nclCreateFromEGLImageKHR(long context, long display, long image, long flags, long properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromEGLImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.check(display);
            Checks.check(image);
        }
        return JNI.callPPPJPPP(__functionAddress, context, display, image, flags, properties, errcode_ret);
    }

    public static long clCreateFromEGLImageKHR(long context, long display, long image, long flags, PointerBuffer properties, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return KHREGLImage.nclCreateFromEGLImageKHR(context, display, image, flags, MemoryUtil.memAddressSafe(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclEnqueueAcquireEGLObjectsKHR(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueAcquireEGLObjectsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueAcquireEGLObjectsKHR(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return KHREGLImage.nclEnqueueAcquireEGLObjectsKHR(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueReleaseEGLObjectsKHR(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReleaseEGLObjectsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueReleaseEGLObjectsKHR(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return KHREGLImage.nclEnqueueReleaseEGLObjectsKHR(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clEnqueueReleaseEGLObjectsKHR(long command_queue, long mem_object, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_objects = stack.pointers(mem_object);
            int n = KHREGLImage.nclEnqueueReleaseEGLObjectsKHR(command_queue, 1, MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long clCreateFromEGLImageKHR(long context, long display, long image, long flags, PointerBuffer properties, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromEGLImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.check(display);
            Checks.check(image);
            Checks.checkNTSafe(properties);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPJPPP(__functionAddress, context, display, image, flags, MemoryUtil.memAddressSafe(properties), errcode_ret);
    }
}

