/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBBufferStorage {
    public static final int GL_MAP_PERSISTENT_BIT = 64;
    public static final int GL_MAP_COHERENT_BIT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT = 256;
    public static final int GL_CLIENT_STORAGE_BIT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 16384;

    protected ARBBufferStorage() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions(caps.glBufferStorage, ext.contains("GL_EXT_direct_state_access") ? caps.glNamedBufferStorageEXT : -1L);
    }

    public static native void nglBufferStorage(int var0, long var1, long var3, int var5);

    public static void glBufferStorage(int target, long size, int flags) {
        ARBBufferStorage.nglBufferStorage(target, size, 0L, flags);
    }

    public static void glBufferStorage(int target, ByteBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, ShortBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, IntBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, FloatBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, DoubleBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static native void nglNamedBufferStorageEXT(int var0, long var1, long var3, int var5);

    public static void glNamedBufferStorageEXT(int buffer, long size, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, ByteBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, ShortBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, IntBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, FloatBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, DoubleBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, short[] data, int flags) {
        long __functionAddress = GL.getICD().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 1), data, flags);
    }

    public static void glBufferStorage(int target, int[] data, int flags) {
        long __functionAddress = GL.getICD().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, flags);
    }

    public static void glBufferStorage(int target, float[] data, int flags) {
        long __functionAddress = GL.getICD().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, flags);
    }

    public static void glBufferStorage(int target, double[] data, int flags) {
        long __functionAddress = GL.getICD().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 3), data, flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, short[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 1), data, flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, int[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 2), data, flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, float[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 2), data, flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, double[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 3), data, flags);
    }

    static {
        GL.initialize();
    }
}

