/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBDrawIndirect {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;

    protected ARBDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysIndirect, caps.glDrawElementsIndirect);
    }

    public static native void nglDrawArraysIndirect(int var0, long var1);

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 16);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirect) {
        ARBDrawIndirect.nglDrawArraysIndirect(mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 4);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static native void nglDrawElementsIndirect(int var0, int var1, long var2);

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 20);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirect) {
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 5);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, int[] indirect) {
        long __functionAddress = GL.getICD().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(indirect, 4);
        }
        JNI.callPV(__functionAddress, mode, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, int[] indirect) {
        long __functionAddress = GL.getICD().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(indirect, 5);
        }
        JNI.callPV(__functionAddress, mode, type, indirect);
    }

    static {
        GL.initialize();
    }
}

