/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;

    protected ARBGetProgramBinary() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGetProgramBinary, caps.glProgramBinary, caps.glProgramParameteri);
    }

    public static native void nglGetProgramBinary(int var0, int var1, long var2, long var4, long var6);

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
            Checks.check((Buffer)binaryFormat, 1);
        }
        ARBGetProgramBinary.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static native void nglProgramBinary(int var0, int var1, long var2, int var4);

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        ARBGetProgramBinary.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static native void glProgramParameteri(int var0, int var1, int var2);

    public static void glGetProgramBinary(int program, int[] length, int[] binaryFormat, ByteBuffer binary) {
        long __functionAddress = GL.getICD().glGetProgramBinary;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
            Checks.check(binaryFormat, 1);
        }
        JNI.callPPPV(__functionAddress, program, binary.remaining(), length, binaryFormat, MemoryUtil.memAddress(binary));
    }

    static {
        GL.initialize();
    }
}

