/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBMultiBind {
    protected ARBMultiBind() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBindBuffersBase, caps.glBindBuffersRange, caps.glBindTextures, caps.glBindSamplers, caps.glBindImageTextures, caps.glBindVertexBuffers);
    }

    public static native void nglBindBuffersBase(int var0, int var1, int var2, long var3);

    public static void glBindBuffersBase(int target, int first, IntBuffer buffers) {
        ARBMultiBind.nglBindBuffersBase(target, first, Checks.remainingSafe(buffers), MemoryUtil.memAddressSafe(buffers));
    }

    public static native void nglBindBuffersRange(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glBindBuffersRange(int target, int first, IntBuffer buffers, PointerBuffer offsets, PointerBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.checkSafe(offsets, Checks.remainingSafe(buffers));
            Checks.checkSafe(sizes, Checks.remainingSafe(buffers));
        }
        ARBMultiBind.nglBindBuffersRange(target, first, Checks.remainingSafe(buffers), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static native void nglBindTextures(int var0, int var1, long var2);

    public static void glBindTextures(int first, IntBuffer textures) {
        ARBMultiBind.nglBindTextures(first, Checks.remainingSafe(textures), MemoryUtil.memAddressSafe(textures));
    }

    public static native void nglBindSamplers(int var0, int var1, long var2);

    public static void glBindSamplers(int first, IntBuffer samplers) {
        ARBMultiBind.nglBindSamplers(first, Checks.remainingSafe(samplers), MemoryUtil.memAddressSafe(samplers));
    }

    public static native void nglBindImageTextures(int var0, int var1, long var2);

    public static void glBindImageTextures(int first, IntBuffer textures) {
        ARBMultiBind.nglBindImageTextures(first, Checks.remainingSafe(textures), MemoryUtil.memAddressSafe(textures));
    }

    public static native void nglBindVertexBuffers(int var0, int var1, long var2, long var4, long var6);

    public static void glBindVertexBuffers(int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (Checks.CHECKS) {
            Checks.checkSafe(offsets, Checks.remainingSafe(buffers));
            Checks.checkSafe((Buffer)strides, Checks.remainingSafe(buffers));
        }
        ARBMultiBind.nglBindVertexBuffers(first, Checks.remainingSafe(buffers), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glBindBuffersBase(int target, int first, int[] buffers) {
        long __functionAddress = GL.getICD().glBindBuffersBase;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, first, Checks.lengthSafe(buffers), buffers);
    }

    public static void glBindBuffersRange(int target, int first, int[] buffers, PointerBuffer offsets, PointerBuffer sizes) {
        long __functionAddress = GL.getICD().glBindBuffersRange;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(offsets, Checks.lengthSafe(buffers));
            Checks.checkSafe(sizes, Checks.lengthSafe(buffers));
        }
        JNI.callPPPV(__functionAddress, target, first, Checks.lengthSafe(buffers), buffers, MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void glBindTextures(int first, int[] textures) {
        long __functionAddress = GL.getICD().glBindTextures;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, Checks.lengthSafe(textures), textures);
    }

    public static void glBindSamplers(int first, int[] samplers) {
        long __functionAddress = GL.getICD().glBindSamplers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, Checks.lengthSafe(samplers), samplers);
    }

    public static void glBindImageTextures(int first, int[] textures) {
        long __functionAddress = GL.getICD().glBindImageTextures;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, Checks.lengthSafe(textures), textures);
    }

    public static void glBindVertexBuffers(int first, int[] buffers, PointerBuffer offsets, int[] strides) {
        long __functionAddress = GL.getICD().glBindVertexBuffers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(offsets, Checks.lengthSafe(buffers));
            Checks.checkSafe(strides, Checks.lengthSafe(buffers));
        }
        JNI.callPPPV(__functionAddress, first, Checks.lengthSafe(buffers), buffers, MemoryUtil.memAddressSafe(offsets), strides);
    }

    static {
        GL.initialize();
    }
}

