/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBSamplerObjects {
    public static final int GL_SAMPLER_BINDING = 35097;

    protected ARBSamplerObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGenSamplers, caps.glDeleteSamplers, caps.glIsSampler, caps.glBindSampler, caps.glSamplerParameteri, caps.glSamplerParameterf, caps.glSamplerParameteriv, caps.glSamplerParameterfv, caps.glSamplerParameterIiv, caps.glSamplerParameterIuiv, caps.glGetSamplerParameteriv, caps.glGetSamplerParameterfv, caps.glGetSamplerParameterIiv, caps.glGetSamplerParameterIuiv);
    }

    public static native void nglGenSamplers(int var0, long var1);

    public static void glGenSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenSamplers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.callocInt(1);
            ARBSamplerObjects.nglGenSamplers(1, MemoryUtil.memAddress(samplers));
            int n = samplers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteSamplers(int var0, long var1);

    public static void glDeleteSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteSamplers(int sampler) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.ints(sampler);
            ARBSamplerObjects.nglDeleteSamplers(1, MemoryUtil.memAddress(samplers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsSampler(int var0);

    public static native void glBindSampler(int var0, int var1);

    public static native void glSamplerParameteri(int var0, int var1, int var2);

    public static native void glSamplerParameterf(int var0, int var1, float var2);

    public static native void nglSamplerParameteriv(int var0, int var1, long var2);

    public static void glSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglSamplerParameterfv(int var0, int var1, long var2);

    public static void glSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglSamplerParameterIiv(int var0, int var1, long var2);

    public static void glSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglSamplerParameterIuiv(int var0, int var1, long var2);

    public static void glSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglGetSamplerParameteriv(int var0, int var1, long var2);

    public static void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameteri(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterfv(int var0, int var1, long var2);

    public static void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetSamplerParameterf(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterIiv(int var0, int var1, long var2);

    public static void glGetSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIi(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterIuiv(int var0, int var1, long var2);

    public static void glGetSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIui(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGenSamplers(int[] samplers) {
        long __functionAddress = GL.getICD().glGenSamplers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glDeleteSamplers(int[] samplers) {
        long __functionAddress = GL.getICD().glDeleteSamplers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glSamplerParameteriv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getICD().glSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterfv(int sampler, int pname, float[] params) {
        long __functionAddress = GL.getICD().glSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getICD().glSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getICD().glSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, float[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    static {
        GL.initialize();
    }
}

