/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBVertexArrayObject {
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;

    protected ARBVertexArrayObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBindVertexArray, caps.glDeleteVertexArrays, caps.glGenVertexArrays, caps.glIsVertexArray);
    }

    public static native void glBindVertexArray(int var0);

    public static native void nglDeleteVertexArrays(int var0, long var1);

    public static void glDeleteVertexArrays(IntBuffer arrays) {
        ARBVertexArrayObject.nglDeleteVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteVertexArrays(int array) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.ints(array);
            ARBVertexArrayObject.nglDeleteVertexArrays(1, MemoryUtil.memAddress(arrays));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenVertexArrays(int var0, long var1);

    public static void glGenVertexArrays(IntBuffer arrays) {
        ARBVertexArrayObject.nglGenVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenVertexArrays() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.callocInt(1);
            ARBVertexArrayObject.nglGenVertexArrays(1, MemoryUtil.memAddress(arrays));
            int n = arrays.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsVertexArray(int var0);

    public static void glDeleteVertexArrays(int[] arrays) {
        long __functionAddress = GL.getICD().glDeleteVertexArrays;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, arrays.length, arrays);
    }

    public static void glGenVertexArrays(int[] arrays) {
        long __functionAddress = GL.getICD().glGenVertexArrays;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, arrays.length, arrays);
    }

    static {
        GL.initialize();
    }
}

