/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBVertexAttrib64Bit {
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;

    protected ARBVertexAttrib64Bit() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions(caps.glVertexAttribL1d, caps.glVertexAttribL2d, caps.glVertexAttribL3d, caps.glVertexAttribL4d, caps.glVertexAttribL1dv, caps.glVertexAttribL2dv, caps.glVertexAttribL3dv, caps.glVertexAttribL4dv, caps.glVertexAttribLPointer, caps.glGetVertexAttribLdv, ext.contains("GL_EXT_direct_state_access") ? caps.glVertexArrayVertexAttribLOffsetEXT : -1L);
    }

    public static native void glVertexAttribL1d(int var0, double var1);

    public static native void glVertexAttribL2d(int var0, double var1, double var3);

    public static native void glVertexAttribL3d(int var0, double var1, double var3, double var5);

    public static native void glVertexAttribL4d(int var0, double var1, double var3, double var5, double var7);

    public static native void nglVertexAttribL1dv(int var0, long var1);

    public static void glVertexAttribL1dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 1);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribL2dv(int var0, long var1);

    public static void glVertexAttribL2dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 2);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribL3dv(int var0, long var1);

    public static void glVertexAttribL3dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 3);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribL4dv(int var0, long var1);

    public static void glVertexAttribL4dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribLPointer(int var0, int var1, int var2, int var3, long var4);

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, long pointer) {
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, type, stride, pointer);
    }

    public static void glVertexAttribLPointer(int index, int size, int stride, DoubleBuffer pointer) {
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, 5130, stride, MemoryUtil.memAddress(pointer));
    }

    public static native void nglGetVertexAttribLdv(int var0, int var1, long var2);

    public static void glGetVertexAttribLdv(int index, int pname, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBVertexAttrib64Bit.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static native void glVertexArrayVertexAttribLOffsetEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glVertexAttribL1dv(int index, double[] v) {
        long __functionAddress = GL.getICD().glVertexAttribL1dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 1);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL2dv(int index, double[] v) {
        long __functionAddress = GL.getICD().glVertexAttribL2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 2);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL3dv(int index, double[] v) {
        long __functionAddress = GL.getICD().glVertexAttribL3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 3);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL4dv(int index, double[] v) {
        long __functionAddress = GL.getICD().glVertexAttribL4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glGetVertexAttribLdv(int index, int pname, double[] params) {
        long __functionAddress = GL.getICD().glGetVertexAttribLdv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    static {
        GL.initialize();
    }
}

