/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL15 {
    public static final int GL_FOG_COORD_SRC = 33872;
    public static final int GL_FOG_COORD = 33873;
    public static final int GL_CURRENT_FOG_COORD = 33875;
    public static final int GL_FOG_COORD_ARRAY_TYPE = 33876;
    public static final int GL_FOG_COORD_ARRAY_STRIDE = 33877;
    public static final int GL_FOG_COORD_ARRAY_POINTER = 33878;
    public static final int GL_FOG_COORD_ARRAY = 33879;
    public static final int GL_FOG_COORD_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_SRC0_RGB = 34176;
    public static final int GL_SRC1_RGB = 34177;
    public static final int GL_SRC2_RGB = 34178;
    public static final int GL_SRC0_ALPHA = 34184;
    public static final int GL_SRC1_ALPHA = 34185;
    public static final int GL_SRC2_ALPHA = 34186;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_VERTEX_ARRAY_BUFFER_BINDING = 34966;
    public static final int GL_NORMAL_ARRAY_BUFFER_BINDING = 34967;
    public static final int GL_COLOR_ARRAY_BUFFER_BINDING = 34968;
    public static final int GL_INDEX_ARRAY_BUFFER_BINDING = 34969;
    public static final int GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 34970;
    public static final int GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 34971;
    public static final int GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 34972;
    public static final int GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_WEIGHT_ARRAY_BUFFER_BINDING = 34974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_BUFFER_ACCESS = 35003;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_SAMPLES_PASSED = 35092;
    public static final int GL_QUERY_COUNTER_BITS = 34916;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;

    protected GL15() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBindBuffer, caps.glDeleteBuffers, caps.glGenBuffers, caps.glIsBuffer, caps.glBufferData, caps.glBufferSubData, caps.glGetBufferSubData, caps.glMapBuffer, caps.glUnmapBuffer, caps.glGetBufferParameteriv, caps.glGetBufferPointerv, caps.glGenQueries, caps.glDeleteQueries, caps.glIsQuery, caps.glBeginQuery, caps.glEndQuery, caps.glGetQueryiv, caps.glGetQueryObjectiv, caps.glGetQueryObjectuiv);
    }

    public static native void glBindBuffer(int var0, int var1);

    public static native void nglDeleteBuffers(int var0, long var1);

    public static void glDeleteBuffers(IntBuffer buffers) {
        GL15.nglDeleteBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteBuffers(int buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.ints(buffer);
            GL15.nglDeleteBuffers(1, MemoryUtil.memAddress(buffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenBuffers(int var0, long var1);

    public static void glGenBuffers(IntBuffer buffers) {
        GL15.nglGenBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenBuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.callocInt(1);
            GL15.nglGenBuffers(1, MemoryUtil.memAddress(buffers));
            int n = buffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsBuffer(int var0);

    public static native void nglBufferData(int var0, long var1, long var3, int var5);

    public static void glBufferData(int target, long size, int usage) {
        GL15.nglBufferData(target, size, 0L, usage);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, DoubleBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 3, MemoryUtil.memAddress(data), usage);
    }

    public static native void nglBufferSubData(int var0, long var1, long var3, long var5);

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, DoubleBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static native void nglGetBufferSubData(int var0, long var1, long var3, long var5);

    public static void glGetBufferSubData(int target, long offset, ByteBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, ShortBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, IntBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, FloatBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, DoubleBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static native long nglMapBuffer(int var0, int var1);

    public static ByteBuffer glMapBuffer(int target, int access) {
        long __result = GL15.nglMapBuffer(target, access);
        return MemoryUtil.memByteBuffer(__result, GL15.glGetBufferParameteri(target, 34660));
    }

    public static ByteBuffer glMapBuffer(int target, int access, ByteBuffer old_buffer) {
        long __result = GL15.nglMapBuffer(target, access);
        int length = GL15.glGetBufferParameteri(target, 34660);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapBuffer(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = GL15.nglMapBuffer(target, access);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)length);
    }

    public static native boolean glUnmapBuffer(int var0);

    public static native void nglGetBufferParameteriv(int var0, int var1, long var2);

    public static void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GL15.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetBufferParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetBufferPointerv(int var0, int var1, long var2);

    public static void glGetBufferPointerv(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check(params, 1);
        }
        GL15.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferPointer(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            GL15.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenQueries(int var0, long var1);

    public static void glGenQueries(IntBuffer ids) {
        GL15.nglGenQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenQueries() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GL15.nglGenQueries(1, MemoryUtil.memAddress(ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteQueries(int var0, long var1);

    public static void glDeleteQueries(IntBuffer ids) {
        GL15.nglDeleteQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteQueries(int id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            GL15.nglDeleteQueries(1, MemoryUtil.memAddress(ids));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsQuery(int var0);

    public static native void glBeginQuery(int var0, int var1);

    public static native void glEndQuery(int var0);

    public static native void nglGetQueryiv(int var0, int var1, long var2);

    public static void glGetQueryiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GL15.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryi(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetQueryObjectiv(int var0, int var1, long var2);

    public static void glGetQueryObjectiv(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GL15.nglGetQueryObjectiv(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryObjecti(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetQueryObjectiv(id, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetQueryObjectuiv(int var0, int var1, long var2);

    public static void glGetQueryObjectuiv(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GL15.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryObjectui(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeleteBuffers(int[] buffers) {
        long __functionAddress = GL.getICD().glDeleteBuffers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, buffers.length, buffers);
    }

    public static void glGenBuffers(int[] buffers) {
        long __functionAddress = GL.getICD().glGenBuffers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, buffers.length, buffers);
    }

    public static void glBufferData(int target, short[] data, int usage) {
        long __functionAddress = GL.getICD().glBufferData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 1), data, usage);
    }

    public static void glBufferData(int target, int[] data, int usage) {
        long __functionAddress = GL.getICD().glBufferData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, usage);
    }

    public static void glBufferData(int target, float[] data, int usage) {
        long __functionAddress = GL.getICD().glBufferData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, usage);
    }

    public static void glBufferData(int target, double[] data, int usage) {
        long __functionAddress = GL.getICD().glBufferData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 3), data, usage);
    }

    public static void glBufferSubData(int target, long offset, short[] data) {
        long __functionAddress = GL.getICD().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 1), data);
    }

    public static void glBufferSubData(int target, long offset, int[] data) {
        long __functionAddress = GL.getICD().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 2), data);
    }

    public static void glBufferSubData(int target, long offset, float[] data) {
        long __functionAddress = GL.getICD().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 2), data);
    }

    public static void glBufferSubData(int target, long offset, double[] data) {
        long __functionAddress = GL.getICD().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 3), data);
    }

    public static void glGetBufferSubData(int target, long offset, short[] data) {
        long __functionAddress = GL.getICD().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 1), data);
    }

    public static void glGetBufferSubData(int target, long offset, int[] data) {
        long __functionAddress = GL.getICD().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 2), data);
    }

    public static void glGetBufferSubData(int target, long offset, float[] data) {
        long __functionAddress = GL.getICD().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 2), data);
    }

    public static void glGetBufferSubData(int target, long offset, double[] data) {
        long __functionAddress = GL.getICD().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 3), data);
    }

    public static void glGetBufferParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGenQueries(int[] ids) {
        long __functionAddress = GL.getICD().glGenQueries;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glDeleteQueries(int[] ids) {
        long __functionAddress = GL.getICD().glDeleteQueries;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGetQueryiv(int target, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetQueryiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetQueryObjectiv(int id, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetQueryObjectiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectuiv(int id, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetQueryObjectuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    static {
        GL.initialize();
    }
}

