/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLXEXTImportContext {
    public static final int GLX_SHARE_CONTEXT_EXT = 32778;
    public static final int GLX_VISUAL_ID_EXT = 32779;
    public static final int GLX_SCREEN_EXT = 32780;

    protected GLXEXTImportContext() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLXCapabilities caps) {
        return Checks.checkFunctions(caps.glXGetCurrentDisplayEXT, caps.glXQueryContextInfoEXT, caps.glXGetContextIDEXT, caps.glXImportContextEXT, caps.glXFreeContextEXT);
    }

    public static long glXGetCurrentDisplayEXT() {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetCurrentDisplayEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress);
    }

    public static int nglXQueryContextInfoEXT(long display, long context, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryContextInfoEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(context);
        }
        return JNI.callPPPI(__functionAddress, display, context, attribute, value);
    }

    public static int glXQueryContextInfoEXT(long display, long context, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return GLXEXTImportContext.nglXQueryContextInfoEXT(display, context, attribute, MemoryUtil.memAddress(value));
    }

    public static long glXGetContextIDEXT(long context) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetContextIDEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPP(__functionAddress, context);
    }

    public static long glXImportContextEXT(long display, long contextID) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXImportContextEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
        }
        return JNI.callPPP(__functionAddress, display, contextID);
    }

    public static void glXFreeContextEXT(long display, long context) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXFreeContextEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(context);
        }
        JNI.callPPV(__functionAddress, display, context);
    }

    public static int glXQueryContextInfoEXT(long display, long context, int attribute, int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryContextInfoEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(context);
            Checks.check(value, 1);
        }
        return JNI.callPPPI(__functionAddress, display, context, attribute, value);
    }
}

