/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLXNVSwapGroup {
    protected GLXNVSwapGroup() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLXCapabilities caps) {
        return Checks.checkFunctions(caps.glXJoinSwapGroupNV, caps.glXBindSwapBarrierNV, caps.glXQuerySwapGroupNV, caps.glXQueryMaxSwapGroupsNV, caps.glXQueryFrameCountNV, caps.glXResetFrameCountNV);
    }

    public static boolean glXJoinSwapGroupNV(long display, long drawable, int group) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXJoinSwapGroupNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(drawable);
        }
        return JNI.callPPI(__functionAddress, display, drawable, group) != 0;
    }

    public static boolean glXBindSwapBarrierNV(long display, int group, int barrier) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXBindSwapBarrierNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
        }
        return JNI.callPI(__functionAddress, display, group, barrier) != 0;
    }

    public static int nglXQuerySwapGroupNV(long display, long drawable, long group, long barrier) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(drawable);
        }
        return JNI.callPPPPI(__functionAddress, display, drawable, group, barrier);
    }

    public static boolean glXQuerySwapGroupNV(long display, long drawable, IntBuffer group, IntBuffer barrier) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)group, 1);
            Checks.check((Buffer)barrier, 1);
        }
        return GLXNVSwapGroup.nglXQuerySwapGroupNV(display, drawable, MemoryUtil.memAddress(group), MemoryUtil.memAddress(barrier)) != 0;
    }

    public static int nglXQueryMaxSwapGroupsNV(long display, int screen, long maxGroups, long maxBarriers) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
        }
        return JNI.callPPPI(__functionAddress, display, screen, maxGroups, maxBarriers);
    }

    public static boolean glXQueryMaxSwapGroupsNV(long display, int screen, IntBuffer maxGroups, IntBuffer maxBarriers) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)maxGroups, 1);
            Checks.check((Buffer)maxBarriers, 1);
        }
        return GLXNVSwapGroup.nglXQueryMaxSwapGroupsNV(display, screen, MemoryUtil.memAddress(maxGroups), MemoryUtil.memAddress(maxBarriers)) != 0;
    }

    public static int nglXQueryFrameCountNV(long display, int screen, long count) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
        }
        return JNI.callPPI(__functionAddress, display, screen, count);
    }

    public static boolean glXQueryFrameCountNV(long display, int screen, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)count, 1);
        }
        return GLXNVSwapGroup.nglXQueryFrameCountNV(display, screen, MemoryUtil.memAddress(count)) != 0;
    }

    public static boolean glXResetFrameCountNV(long display, int screen) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXResetFrameCountNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
        }
        return JNI.callPI(__functionAddress, display, screen) != 0;
    }

    public static boolean glXQuerySwapGroupNV(long display, long drawable, int[] group, int[] barrier) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(drawable);
            Checks.check(group, 1);
            Checks.check(barrier, 1);
        }
        return JNI.callPPPPI(__functionAddress, display, drawable, group, barrier) != 0;
    }

    public static boolean glXQueryMaxSwapGroupsNV(long display, int screen, int[] maxGroups, int[] maxBarriers) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(maxGroups, 1);
            Checks.check(maxBarriers, 1);
        }
        return JNI.callPPPI(__functionAddress, display, screen, maxGroups, maxBarriers) != 0;
    }

    public static boolean glXQueryFrameCountNV(long display, int screen, int[] count) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(count, 1);
        }
        return JNI.callPPI(__functionAddress, display, screen, count) != 0;
    }
}

