/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class INTELMapTexture {
    public static final int GL_TEXTURE_MEMORY_LAYOUT_INTEL = 33791;
    public static final int GL_LAYOUT_DEFAULT_INTEL = 0;
    public static final int GL_LAYOUT_LINEAR_INTEL = 1;
    public static final int GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2;

    protected INTELMapTexture() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glSyncTextureINTEL, caps.glUnmapTexture2DINTEL, caps.glMapTexture2DINTEL);
    }

    public static native void glSyncTextureINTEL(int var0);

    public static native void glUnmapTexture2DINTEL(int var0, int var1);

    public static native long nglMapTexture2DINTEL(int var0, int var1, int var2, long var3, long var5);

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, 1);
            Checks.check((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        return MemoryUtil.memByteBuffer(__result, INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, 1);
            Checks.check((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, long length, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, 1);
            Checks.check((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout) {
        long __functionAddress = GL.getICD().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(stride, 1);
            Checks.check(layout, 1);
        }
        long __result = JNI.callPPP(__functionAddress, texture, level, access, stride, layout);
        return MemoryUtil.memByteBuffer(__result, INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout, ByteBuffer old_buffer) {
        long __functionAddress = GL.getICD().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(stride, 1);
            Checks.check(layout, 1);
        }
        long __result = JNI.callPPP(__functionAddress, texture, level, access, stride, layout);
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout, long length, ByteBuffer old_buffer) {
        long __functionAddress = GL.getICD().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(stride, 1);
            Checks.check(layout, 1);
        }
        long __result = JNI.callPPP(__functionAddress, texture, level, access, stride, layout);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)length);
    }

    private static int getStride(IntBuffer stride) {
        return stride.get(stride.position());
    }

    private static int getStride(int[] stride) {
        return stride[0];
    }

    static {
        GL.initialize();
    }
}

