/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVGPUMulticast {
    public static final int GL_PER_GPU_STORAGE_BIT_NV = 2048;
    public static final int GL_MULTICAST_GPUS_NV = 37562;
    public static final int GL_RENDER_GPU_MASK_NV = 38232;
    public static final int GL_PER_GPU_STORAGE_NV = 38216;
    public static final int GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV = 38217;

    protected NVGPUMulticast() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glRenderGpuMaskNV, caps.glMulticastBufferSubDataNV, caps.glMulticastCopyBufferSubDataNV, caps.glMulticastCopyImageSubDataNV, caps.glMulticastBlitFramebufferNV, caps.glMulticastFramebufferSampleLocationsfvNV, caps.glMulticastBarrierNV, caps.glMulticastWaitSyncNV, caps.glMulticastGetQueryObjectivNV, caps.glMulticastGetQueryObjectuivNV, caps.glMulticastGetQueryObjecti64vNV, caps.glMulticastGetQueryObjectui64vNV);
    }

    public static native void glRenderGpuMaskNV(int var0);

    public static native void nglMulticastBufferSubDataNV(int var0, int var1, long var2, long var4, long var6);

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, ByteBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, ShortBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, IntBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, FloatBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, DoubleBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static native void glMulticastCopyBufferSubDataNV(int var0, int var1, int var2, int var3, long var4, long var6, long var8);

    public static native void glMulticastCopyImageSubDataNV(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native void glMulticastBlitFramebufferNV(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public static native void nglMulticastFramebufferSampleLocationsfvNV(int var0, int var1, int var2, int var3, long var4);

    public static void glMulticastFramebufferSampleLocationsfvNV(int gpu, int framebuffer, int start, FloatBuffer v) {
        NVGPUMulticast.nglMulticastFramebufferSampleLocationsfvNV(gpu, framebuffer, start, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void glMulticastBarrierNV();

    public static native void glMulticastWaitSyncNV(int var0, int var1);

    public static native void nglMulticastGetQueryObjectivNV(int var0, int var1, int var2, long var3);

    public static void glMulticastGetQueryObjectivNV(int gpu, int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjectivNV(gpu, id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glMulticastGetQueryObjectiNV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            NVGPUMulticast.nglMulticastGetQueryObjectivNV(gpu, id, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglMulticastGetQueryObjectuivNV(int var0, int var1, int var2, long var3);

    public static void glMulticastGetQueryObjectuivNV(int gpu, int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjectuivNV(gpu, id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glMulticastGetQueryObjectuiNV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            NVGPUMulticast.nglMulticastGetQueryObjectuivNV(gpu, id, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglMulticastGetQueryObjecti64vNV(int var0, int var1, int var2, long var3);

    public static void glMulticastGetQueryObjecti64vNV(int gpu, int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjecti64vNV(gpu, id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glMulticastGetQueryObjecti64NV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVGPUMulticast.nglMulticastGetQueryObjecti64vNV(gpu, id, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglMulticastGetQueryObjectui64vNV(int var0, int var1, int var2, long var3);

    public static void glMulticastGetQueryObjectui64vNV(int gpu, int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjectui64vNV(gpu, id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glMulticastGetQueryObjectui64NV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVGPUMulticast.nglMulticastGetQueryObjectui64vNV(gpu, id, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, short[] data) {
        long __functionAddress = GL.getICD().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, gpuMask, buffer, offset, (long)(data.length << 1), data);
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, int[] data) {
        long __functionAddress = GL.getICD().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, gpuMask, buffer, offset, (long)(data.length << 2), data);
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, float[] data) {
        long __functionAddress = GL.getICD().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, gpuMask, buffer, offset, (long)(data.length << 2), data);
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, double[] data) {
        long __functionAddress = GL.getICD().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, gpuMask, buffer, offset, (long)(data.length << 3), data);
    }

    public static void glMulticastFramebufferSampleLocationsfvNV(int gpu, int framebuffer, int start, float[] v) {
        long __functionAddress = GL.getICD().glMulticastFramebufferSampleLocationsfvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, gpu, framebuffer, start, v.length >> 1, v);
    }

    public static void glMulticastGetQueryObjectivNV(int gpu, int id, int pname, int[] params) {
        long __functionAddress = GL.getICD().glMulticastGetQueryObjectivNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, gpu, id, pname, params);
    }

    public static void glMulticastGetQueryObjectuivNV(int gpu, int id, int pname, int[] params) {
        long __functionAddress = GL.getICD().glMulticastGetQueryObjectuivNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, gpu, id, pname, params);
    }

    public static void glMulticastGetQueryObjecti64vNV(int gpu, int id, int pname, long[] params) {
        long __functionAddress = GL.getICD().glMulticastGetQueryObjecti64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, gpu, id, pname, params);
    }

    public static void glMulticastGetQueryObjectui64vNV(int gpu, int id, int pname, long[] params) {
        long __functionAddress = GL.getICD().glMulticastGetQueryObjectui64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, gpu, id, pname, params);
    }

    static {
        GL.initialize();
    }
}

