/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVShaderBufferLoad {
    public static final int GL_BUFFER_GPU_ADDRESS_NV = 36637;
    public static final int GL_GPU_ADDRESS_NV = 36660;
    public static final int GL_MAX_SHADER_BUFFER_ADDRESS_NV = 36661;

    protected NVShaderBufferLoad() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glMakeBufferResidentNV, caps.glMakeBufferNonResidentNV, caps.glIsBufferResidentNV, caps.glMakeNamedBufferResidentNV, caps.glMakeNamedBufferNonResidentNV, caps.glIsNamedBufferResidentNV, caps.glGetBufferParameterui64vNV, caps.glGetNamedBufferParameterui64vNV, caps.glGetIntegerui64vNV, caps.glUniformui64NV, caps.glUniformui64vNV, caps.glGetUniformui64vNV, caps.glProgramUniformui64NV, caps.glProgramUniformui64vNV);
    }

    public static native void glMakeBufferResidentNV(int var0, int var1);

    public static native void glMakeBufferNonResidentNV(int var0);

    public static native boolean glIsBufferResidentNV(int var0);

    public static native void glMakeNamedBufferResidentNV(int var0, int var1);

    public static native void glMakeNamedBufferNonResidentNV(int var0);

    public static native boolean glIsNamedBufferResidentNV(int var0);

    public static native void nglGetBufferParameterui64vNV(int var0, int var1, long var2);

    public static void glGetBufferParameterui64vNV(int target, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferParameterui64NV(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetNamedBufferParameterui64vNV(int var0, int var1, long var2);

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetNamedBufferParameterui64NV(int buffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetIntegerui64vNV(int var0, long var1);

    public static void glGetIntegerui64vNV(int value, LongBuffer result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)result, 1);
        }
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetIntegerui64NV(int value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer result = stack.callocLong(1);
            NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
            long l = result.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glUniformui64NV(int var0, long var1);

    public static native void nglUniformui64vNV(int var0, int var1, long var2);

    public static void glUniformui64vNV(int location, LongBuffer value) {
        NVShaderBufferLoad.nglUniformui64vNV(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglGetUniformui64vNV(int var0, int var1, long var2);

    public static void glGetUniformui64vNV(int program, int location, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetUniformui64NV(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glProgramUniformui64NV(int var0, int var1, long var2);

    public static native void nglProgramUniformui64vNV(int var0, int var1, int var2, long var3);

    public static void glProgramUniformui64vNV(int program, int location, LongBuffer value) {
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glGetBufferParameterui64vNV(int target, int pname, long[] params) {
        long __functionAddress = GL.getICD().glGetBufferParameterui64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, long[] params) {
        long __functionAddress = GL.getICD().glGetNamedBufferParameterui64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetIntegerui64vNV(int value, long[] result) {
        long __functionAddress = GL.getICD().glGetIntegerui64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(result, 1);
        }
        JNI.callPV(__functionAddress, value, result);
    }

    public static void glUniformui64vNV(int location, long[] value) {
        long __functionAddress = GL.getICD().glUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glGetUniformui64vNV(int program, int location, long[] params) {
        long __functionAddress = GL.getICD().glGetUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glProgramUniformui64vNV(int program, int location, long[] value) {
        long __functionAddress = GL.getICD().glProgramUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    static {
        GL.initialize();
    }
}

