/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLARBPbuffer {
    public static final int WGL_DRAW_TO_PBUFFER_ARB = 8237;
    public static final int WGL_MAX_PBUFFER_PIXELS_ARB = 8238;
    public static final int WGL_MAX_PBUFFER_WIDTH_ARB = 8239;
    public static final int WGL_MAX_PBUFFER_HEIGHT_ARB = 8240;
    public static final int WGL_PBUFFER_LARGEST_ARB = 8243;
    public static final int WGL_PBUFFER_WIDTH_ARB = 8244;
    public static final int WGL_PBUFFER_HEIGHT_ARB = 8245;
    public static final int WGL_PBUFFER_LOST_ARB = 8246;

    protected WGLARBPbuffer() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(WGLCapabilities caps) {
        return Checks.checkFunctions(caps.wglCreatePbufferARB, caps.wglGetPbufferDCARB, caps.wglReleasePbufferDCARB, caps.wglDestroyPbufferARB, caps.wglQueryPbufferARB);
    }

    public static long nwglCreatePbufferARB(long hdc, int pixelFormat, int width, int height, long attribList) {
        long __functionAddress = GL.getCapabilitiesWGL().wglCreatePbufferARB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(hdc);
        }
        return JNI.callPPP(__functionAddress, hdc, pixelFormat, width, height, attribList);
    }

    public static long wglCreatePbufferARB(long hdc, int pixelFormat, int width, int height, IntBuffer attribList) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attribList);
        }
        return WGLARBPbuffer.nwglCreatePbufferARB(hdc, pixelFormat, width, height, MemoryUtil.memAddressSafe(attribList));
    }

    public static long wglGetPbufferDCARB(long pbuffer) {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetPbufferDCARB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pbuffer);
        }
        return JNI.callPP(__functionAddress, pbuffer);
    }

    public static int wglReleasePbufferDCARB(long pbuffer, long hdc) {
        long __functionAddress = GL.getCapabilitiesWGL().wglReleasePbufferDCARB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pbuffer);
            Checks.check(hdc);
        }
        return JNI.callPPI(__functionAddress, pbuffer, hdc);
    }

    public static boolean wglDestroyPbufferARB(long pbuffer) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDestroyPbufferARB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pbuffer);
        }
        return JNI.callPI(__functionAddress, pbuffer) != 0;
    }

    public static int nwglQueryPbufferARB(long pbuffer, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQueryPbufferARB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pbuffer);
        }
        return JNI.callPPI(__functionAddress, pbuffer, attribute, value);
    }

    public static boolean wglQueryPbufferARB(long pbuffer, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return WGLARBPbuffer.nwglQueryPbufferARB(pbuffer, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long wglCreatePbufferARB(long hdc, int pixelFormat, int width, int height, int[] attribList) {
        long __functionAddress = GL.getCapabilitiesWGL().wglCreatePbufferARB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(hdc);
            Checks.checkNTSafe(attribList);
        }
        return JNI.callPPP(__functionAddress, hdc, pixelFormat, width, height, attribList);
    }

    public static boolean wglQueryPbufferARB(long pbuffer, int attribute, int[] value) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQueryPbufferARB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pbuffer);
            Checks.check(value, 1);
        }
        return JNI.callPPI(__functionAddress, pbuffer, attribute, value) != 0;
    }
}

