/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLNVDXInterop {
    public static final int WGL_ACCESS_READ_ONLY_NV = 0;
    public static final int WGL_ACCESS_READ_WRITE_NV = 1;
    public static final int WGL_ACCESS_WRITE_DISCARD_NV = 2;

    protected WGLNVDXInterop() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(WGLCapabilities caps) {
        return Checks.checkFunctions(caps.wglDXSetResourceShareHandleNV, caps.wglDXOpenDeviceNV, caps.wglDXCloseDeviceNV, caps.wglDXRegisterObjectNV, caps.wglDXUnregisterObjectNV, caps.wglDXObjectAccessNV, caps.wglDXLockObjectsNV, caps.wglDXUnlockObjectsNV);
    }

    public static boolean wglDXSetResourceShareHandleNV(long dxObject, long shareHandle) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXSetResourceShareHandleNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dxObject);
            Checks.check(shareHandle);
        }
        return JNI.callPPI(__functionAddress, dxObject, shareHandle) != 0;
    }

    public static long wglDXOpenDeviceNV(long dxDevice) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXOpenDeviceNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dxDevice);
        }
        return JNI.callPP(__functionAddress, dxDevice);
    }

    public static boolean wglDXCloseDeviceNV(long device) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXCloseDeviceNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPI(__functionAddress, device) != 0;
    }

    public static long wglDXRegisterObjectNV(long device, long dxResource, int name, int type, int access) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXRegisterObjectNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.check(dxResource);
        }
        return JNI.callPPP(__functionAddress, device, dxResource, name, type, access);
    }

    public static boolean wglDXUnregisterObjectNV(long device, long object) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXUnregisterObjectNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.check(object);
        }
        return JNI.callPPI(__functionAddress, device, object) != 0;
    }

    public static boolean wglDXObjectAccessNV(long object, int access) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXObjectAccessNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(object);
        }
        return JNI.callPI(__functionAddress, object, access) != 0;
    }

    public static int nwglDXLockObjectsNV(long device, int count, long objects) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXLockObjectsNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPI(__functionAddress, device, count, objects);
    }

    public static boolean wglDXLockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress(objects)) != 0;
    }

    public static int nwglDXUnlockObjectsNV(long device, int count, long objects) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXUnlockObjectsNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPI(__functionAddress, device, count, objects);
    }

    public static boolean wglDXUnlockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress(objects)) != 0;
    }
}

