/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class APPLESync {
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT_APPLE = 37137;
    public static final int GL_OBJECT_TYPE_APPLE = 37138;
    public static final int GL_SYNC_CONDITION_APPLE = 37139;
    public static final int GL_SYNC_STATUS_APPLE = 37140;
    public static final int GL_SYNC_FLAGS_APPLE = 37141;
    public static final int GL_SYNC_FENCE_APPLE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE = 37143;
    public static final int GL_UNSIGNALED_APPLE = 37144;
    public static final int GL_SIGNALED_APPLE = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT_APPLE = 1;
    public static final long GL_TIMEOUT_IGNORED_APPLE = -1L;
    public static final int GL_ALREADY_SIGNALED_APPLE = 37146;
    public static final int GL_TIMEOUT_EXPIRED_APPLE = 37147;
    public static final int GL_CONDITION_SATISFIED_APPLE = 37148;
    public static final int GL_WAIT_FAILED_APPLE = 37149;
    public static final int GL_SYNC_OBJECT_APPLE = 35411;

    protected APPLESync() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glFenceSyncAPPLE, caps.glIsSyncAPPLE, caps.glDeleteSyncAPPLE, caps.glClientWaitSyncAPPLE, caps.glWaitSyncAPPLE, caps.glGetInteger64vAPPLE, caps.glGetSyncivAPPLE);
    }

    public static native long glFenceSyncAPPLE(int var0, int var1);

    public static native boolean nglIsSyncAPPLE(long var0);

    public static boolean glIsSyncAPPLE(long sync) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        return APPLESync.nglIsSyncAPPLE(sync);
    }

    public static native void nglDeleteSyncAPPLE(long var0);

    public static void glDeleteSyncAPPLE(long sync) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        APPLESync.nglDeleteSyncAPPLE(sync);
    }

    public static native int nglClientWaitSyncAPPLE(long var0, int var2, long var3);

    public static int glClientWaitSyncAPPLE(long sync, int flags, long timeout) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        return APPLESync.nglClientWaitSyncAPPLE(sync, flags, timeout);
    }

    public static native void nglWaitSyncAPPLE(long var0, int var2, long var3);

    public static void glWaitSyncAPPLE(long sync, int flags, long timeout) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        APPLESync.nglWaitSyncAPPLE(sync, flags, timeout);
    }

    public static native void nglGetInteger64vAPPLE(int var0, long var1);

    public static void glGetInteger64vAPPLE(int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        APPLESync.nglGetInteger64vAPPLE(pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64APPLE(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            APPLESync.nglGetInteger64vAPPLE(pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSyncivAPPLE(long var0, int var2, int var3, long var4, long var6);

    public static void glGetSyncivAPPLE(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.check(sync);
            Checks.checkSafe((Buffer)length, 1);
        }
        APPLESync.nglGetSyncivAPPLE(sync, pname, values.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSynciAPPLE(long sync, int pname, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.check(sync);
            Checks.checkSafe((Buffer)length, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            APPLESync.nglGetSyncivAPPLE(sync, pname, 1, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetInteger64vAPPLE(int pname, long[] params) {
        long __functionAddress = GLES.getICD().glGetInteger64vAPPLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, pname, params);
    }

    public static void glGetSyncivAPPLE(long sync, int pname, int[] length, int[] values) {
        long __functionAddress = GLES.getICD().glGetSyncivAPPLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPPV(__functionAddress, sync, pname, values.length, length, values);
    }

    static {
        GLES.initialize();
    }
}

