/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiDrawArrays {
    protected EXTMultiDrawArrays() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glMultiDrawArraysEXT, caps.glMultiDrawElementsEXT);
    }

    public static native void nglMultiDrawArraysEXT(int var0, long var1, long var3, int var5);

    public static void glMultiDrawArraysEXT(int mode, IntBuffer first, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)count, first.remaining());
        }
        EXTMultiDrawArrays.nglMultiDrawArraysEXT(mode, MemoryUtil.memAddress(first), MemoryUtil.memAddress(count), first.remaining());
    }

    public static native void nglMultiDrawElementsEXT(int var0, long var1, int var3, long var4, int var6);

    public static void glMultiDrawElementsEXT(int mode, IntBuffer count, int type, PointerBuffer indices) {
        if (Checks.CHECKS) {
            Checks.check(indices, count.remaining());
        }
        EXTMultiDrawArrays.nglMultiDrawElementsEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining());
    }

    public static void glMultiDrawArraysEXT(int mode, int[] first, int[] count) {
        long __functionAddress = GLES.getICD().glMultiDrawArraysEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(count, first.length);
        }
        JNI.callPPV(__functionAddress, mode, first, count, first.length);
    }

    public static void glMultiDrawElementsEXT(int mode, int[] count, int type, PointerBuffer indices) {
        long __functionAddress = GLES.getICD().glMultiDrawElementsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(indices, count.length);
        }
        JNI.callPPV(__functionAddress, mode, count, type, MemoryUtil.memAddress(indices), count.length);
    }

    static {
        GLES.initialize();
    }
}

