/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT_EXT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT_EXT = 2;
    public static final int GL_ALL_SHADER_BITS_EXT = -1;
    public static final int GL_PROGRAM_SEPARABLE_EXT = 33368;
    public static final int GL_ACTIVE_PROGRAM_EXT = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING_EXT = 33370;

    protected EXTSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glActiveShaderProgramEXT, caps.glBindProgramPipelineEXT, caps.glCreateShaderProgramvEXT, caps.glDeleteProgramPipelinesEXT, caps.glGenProgramPipelinesEXT, caps.glGetProgramPipelineInfoLogEXT, caps.glGetProgramPipelineivEXT, caps.glIsProgramPipelineEXT, caps.glProgramParameteriEXT, caps.glProgramUniform1fEXT, caps.glProgramUniform1fvEXT, caps.glProgramUniform1iEXT, caps.glProgramUniform1ivEXT, caps.glProgramUniform2fEXT, caps.glProgramUniform2fvEXT, caps.glProgramUniform2iEXT, caps.glProgramUniform2ivEXT, caps.glProgramUniform3fEXT, caps.glProgramUniform3fvEXT, caps.glProgramUniform3iEXT, caps.glProgramUniform3ivEXT, caps.glProgramUniform4fEXT, caps.glProgramUniform4fvEXT, caps.glProgramUniform4iEXT, caps.glProgramUniform4ivEXT, caps.glProgramUniformMatrix2fvEXT, caps.glProgramUniformMatrix3fvEXT, caps.glProgramUniformMatrix4fvEXT, caps.glUseProgramStagesEXT, caps.glValidateProgramPipelineEXT, caps.glProgramUniform1uiEXT, caps.glProgramUniform2uiEXT, caps.glProgramUniform3uiEXT, caps.glProgramUniform4uiEXT, caps.glProgramUniform1uivEXT, caps.glProgramUniform2uivEXT, caps.glProgramUniform3uivEXT, caps.glProgramUniform4uivEXT, caps.glProgramUniformMatrix2x3fvEXT, caps.glProgramUniformMatrix3x2fvEXT, caps.glProgramUniformMatrix2x4fvEXT, caps.glProgramUniformMatrix4x2fvEXT, caps.glProgramUniformMatrix3x4fvEXT, caps.glProgramUniformMatrix4x3fvEXT);
    }

    public static native void glActiveShaderProgramEXT(int var0, int var1);

    public static native void glBindProgramPipelineEXT(int var0);

    public static native int nglCreateShaderProgramvEXT(int var0, int var1, long var2);

    public static int glCreateShaderProgramvEXT(int type, PointerBuffer strings) {
        return EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramvEXT(int type, CharSequence ... strings) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray(stack, MemoryUtil::memUTF8, strings);
            int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, strings.length, stringsAddress);
            APIUtil.apiArrayFree(stringsAddress, strings.length);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramvEXT(int type, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray(stack, MemoryUtil::memUTF8, string);
            int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, 1, stringsAddress);
            APIUtil.apiArrayFree(stringsAddress, 1);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteProgramPipelinesEXT(int var0, long var1);

    public static void glDeleteProgramPipelinesEXT(IntBuffer pipelines) {
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteProgramPipelinesEXT(int pipeline) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.ints(pipeline);
            EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(1, MemoryUtil.memAddress(pipelines));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenProgramPipelinesEXT(int var0, long var1);

    public static void glGenProgramPipelinesEXT(IntBuffer pipelines) {
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenProgramPipelinesEXT() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.callocInt(1);
            EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(1, MemoryUtil.memAddress(pipelines));
            int n = pipelines.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramPipelineInfoLogEXT(int var0, int var1, long var2, long var4);

    public static void glGetProgramPipelineInfoLogEXT(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramPipelineInfoLogEXT(int pipeline, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetProgramPipelineInfoLogEXT(int pipeline) {
        return EXTSeparateShaderObjects.glGetProgramPipelineInfoLogEXT(pipeline, EXTSeparateShaderObjects.glGetProgramPipelineiEXT(pipeline, 35716));
    }

    public static native void nglGetProgramPipelineivEXT(int var0, int var1, long var2);

    public static void glGetProgramPipelineivEXT(int pipeline, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramPipelineiEXT(int pipeline, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsProgramPipelineEXT(int var0);

    public static native void glProgramParameteriEXT(int var0, int var1, int var2);

    public static native void glProgramUniform1fEXT(int var0, int var1, float var2);

    public static native void nglProgramUniform1fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1fvEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void glProgramUniform1iEXT(int var0, int var1, int var2);

    public static native void nglProgramUniform1ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1ivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void glProgramUniform2fEXT(int var0, int var1, float var2, float var3);

    public static native void nglProgramUniform2fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2fvEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void glProgramUniform2iEXT(int var0, int var1, int var2, int var3);

    public static native void nglProgramUniform2ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2ivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void glProgramUniform3fEXT(int var0, int var1, float var2, float var3, float var4);

    public static native void nglProgramUniform3fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3fvEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void glProgramUniform3iEXT(int var0, int var1, int var2, int var3, int var4);

    public static native void nglProgramUniform3ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3ivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void glProgramUniform4fEXT(int var0, int var1, float var2, float var3, float var4, float var5);

    public static native void nglProgramUniform4fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4fvEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void glProgramUniform4iEXT(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void nglProgramUniform4ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4ivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2fvEXT(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3fvEXT(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4fvEXT(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void glUseProgramStagesEXT(int var0, int var1, int var2);

    public static native void glValidateProgramPipelineEXT(int var0);

    public static native void glProgramUniform1uiEXT(int var0, int var1, int var2);

    public static native void glProgramUniform2uiEXT(int var0, int var1, int var2, int var3);

    public static native void glProgramUniform3uiEXT(int var0, int var1, int var2, int var3, int var4);

    public static native void glProgramUniform4uiEXT(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void nglProgramUniform1uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1uivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2uivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3uivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4uivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x3fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x3fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x2fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x2fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x4fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x4fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x2fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x2fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x4fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x4fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x3fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x3fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void glDeleteProgramPipelinesEXT(int[] pipelines) {
        long __functionAddress = GLES.getICD().glDeleteProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pipelines.length, pipelines);
    }

    public static void glGenProgramPipelinesEXT(int[] pipelines) {
        long __functionAddress = GLES.getICD().glGenProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pipelines.length, pipelines);
    }

    public static void glGetProgramPipelineInfoLogEXT(int pipeline, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GLES.getICD().glGetProgramPipelineInfoLogEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, pipeline, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramPipelineivEXT(int pipeline, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetProgramPipelineivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, pipeline, pname, params);
    }

    public static void glProgramUniform1fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform1fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform1ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform1ivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform2ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform2ivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform3ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform3ivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniform4ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform4ivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniformMatrix2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, transpose, value);
    }

    public static void glProgramUniformMatrix3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 9, transpose, value);
    }

    public static void glProgramUniformMatrix4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 4, transpose, value);
    }

    public static void glProgramUniform1uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform1uivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform2uivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform3uivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform4uivEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix2x3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix3x2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix2x4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix4x2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix3x4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix4x3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    static {
        GLES.initialize();
    }
}

