/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLES30 {
    public static final int GL_READ_BUFFER = 3074;
    public static final int GL_UNPACK_ROW_LENGTH = 3314;
    public static final int GL_UNPACK_SKIP_ROWS = 3315;
    public static final int GL_UNPACK_SKIP_PIXELS = 3316;
    public static final int GL_PACK_ROW_LENGTH = 3330;
    public static final int GL_PACK_SKIP_ROWS = 3331;
    public static final int GL_PACK_SKIP_PIXELS = 3332;
    public static final int GL_COLOR = 6144;
    public static final int GL_DEPTH = 6145;
    public static final int GL_STENCIL = 6146;
    public static final int GL_RED = 6403;
    public static final int GL_RGB8 = 32849;
    public static final int GL_RGBA8 = 32856;
    public static final int GL_RGB10_A2 = 32857;
    public static final int GL_TEXTURE_BINDING_3D = 32874;
    public static final int GL_UNPACK_SKIP_IMAGES = 32877;
    public static final int GL_UNPACK_IMAGE_HEIGHT = 32878;
    public static final int GL_TEXTURE_3D = 32879;
    public static final int GL_TEXTURE_WRAP_R = 32882;
    public static final int GL_MAX_3D_TEXTURE_SIZE = 32883;
    public static final int GL_UNSIGNED_INT_2_10_10_10_REV = 33640;
    public static final int GL_MAX_ELEMENTS_VERTICES = 33000;
    public static final int GL_MAX_ELEMENTS_INDICES = 33001;
    public static final int GL_TEXTURE_MIN_LOD = 33082;
    public static final int GL_TEXTURE_MAX_LOD = 33083;
    public static final int GL_TEXTURE_BASE_LEVEL = 33084;
    public static final int GL_TEXTURE_MAX_LEVEL = 33085;
    public static final int GL_MIN = 32775;
    public static final int GL_MAX = 32776;
    public static final int GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL_MAX_TEXTURE_LOD_BIAS = 34045;
    public static final int GL_TEXTURE_COMPARE_MODE = 34892;
    public static final int GL_TEXTURE_COMPARE_FUNC = 34893;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_PIXEL_PACK_BUFFER = 35051;
    public static final int GL_PIXEL_UNPACK_BUFFER = 35052;
    public static final int GL_PIXEL_PACK_BUFFER_BINDING = 35053;
    public static final int GL_PIXEL_UNPACK_BUFFER_BINDING = 35055;
    public static final int GL_FLOAT_MAT2x3 = 35685;
    public static final int GL_FLOAT_MAT2x4 = 35686;
    public static final int GL_FLOAT_MAT3x2 = 35687;
    public static final int GL_FLOAT_MAT3x4 = 35688;
    public static final int GL_FLOAT_MAT4x2 = 35689;
    public static final int GL_FLOAT_MAT4x3 = 35690;
    public static final int GL_SRGB = 35904;
    public static final int GL_SRGB8 = 35905;
    public static final int GL_SRGB8_ALPHA8 = 35907;
    public static final int GL_COMPARE_REF_TO_TEXTURE = 34894;
    public static final int GL_MAJOR_VERSION = 33307;
    public static final int GL_MINOR_VERSION = 33308;
    public static final int GL_NUM_EXTENSIONS = 33309;
    public static final int GL_RGBA32F = 34836;
    public static final int GL_RGB32F = 34837;
    public static final int GL_RGBA16F = 34842;
    public static final int GL_RGB16F = 34843;
    public static final int GL_VERTEX_ATTRIB_ARRAY_INTEGER = 35069;
    public static final int GL_MAX_ARRAY_TEXTURE_LAYERS = 35071;
    public static final int GL_MIN_PROGRAM_TEXEL_OFFSET = 35076;
    public static final int GL_MAX_PROGRAM_TEXEL_OFFSET = 35077;
    public static final int GL_MAX_VARYING_COMPONENTS = 35659;
    public static final int GL_TEXTURE_2D_ARRAY = 35866;
    public static final int GL_TEXTURE_BINDING_2D_ARRAY = 35869;
    public static final int GL_R11F_G11F_B10F = 35898;
    public static final int GL_UNSIGNED_INT_10F_11F_11F_REV = 35899;
    public static final int GL_RGB9_E5 = 35901;
    public static final int GL_UNSIGNED_INT_5_9_9_9_REV = 35902;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 35958;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 35967;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 35976;
    public static final int GL_RASTERIZER_DISCARD = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 35979;
    public static final int GL_INTERLEAVED_ATTRIBS = 35980;
    public static final int GL_SEPARATE_ATTRIBS = 35981;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 35983;
    public static final int GL_RGBA32UI = 36208;
    public static final int GL_RGB32UI = 36209;
    public static final int GL_RGBA16UI = 36214;
    public static final int GL_RGB16UI = 36215;
    public static final int GL_RGBA8UI = 36220;
    public static final int GL_RGB8UI = 36221;
    public static final int GL_RGBA32I = 36226;
    public static final int GL_RGB32I = 36227;
    public static final int GL_RGBA16I = 36232;
    public static final int GL_RGB16I = 36233;
    public static final int GL_RGBA8I = 36238;
    public static final int GL_RGB8I = 36239;
    public static final int GL_RED_INTEGER = 36244;
    public static final int GL_RGB_INTEGER = 36248;
    public static final int GL_RGBA_INTEGER = 36249;
    public static final int GL_SAMPLER_2D_ARRAY = 36289;
    public static final int GL_SAMPLER_2D_ARRAY_SHADOW = 36292;
    public static final int GL_SAMPLER_CUBE_SHADOW = 36293;
    public static final int GL_UNSIGNED_INT_VEC2 = 36294;
    public static final int GL_UNSIGNED_INT_VEC3 = 36295;
    public static final int GL_UNSIGNED_INT_VEC4 = 36296;
    public static final int GL_INT_SAMPLER_2D = 36298;
    public static final int GL_INT_SAMPLER_3D = 36299;
    public static final int GL_INT_SAMPLER_CUBE = 36300;
    public static final int GL_INT_SAMPLER_2D_ARRAY = 36303;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D = 36306;
    public static final int GL_UNSIGNED_INT_SAMPLER_3D = 36307;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE = 36308;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 36311;
    public static final int GL_BUFFER_ACCESS_FLAGS = 37151;
    public static final int GL_BUFFER_MAP_LENGTH = 37152;
    public static final int GL_BUFFER_MAP_OFFSET = 37153;
    public static final int GL_DEPTH_COMPONENT32F = 36012;
    public static final int GL_DEPTH32F_STENCIL8 = 36013;
    public static final int GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 36269;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 33296;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 33297;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 33298;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 33299;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 33300;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 33301;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 33302;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 33303;
    public static final int GL_FRAMEBUFFER_DEFAULT = 33304;
    public static final int GL_FRAMEBUFFER_UNDEFINED = 33305;
    public static final int GL_DEPTH_STENCIL_ATTACHMENT = 33306;
    public static final int GL_DEPTH_STENCIL = 34041;
    public static final int GL_UNSIGNED_INT_24_8 = 34042;
    public static final int GL_DEPTH24_STENCIL8 = 35056;
    public static final int GL_UNSIGNED_NORMALIZED = 35863;
    public static final int GL_DRAW_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_READ_FRAMEBUFFER = 36008;
    public static final int GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL_READ_FRAMEBUFFER_BINDING = 36010;
    public static final int GL_RENDERBUFFER_SAMPLES = 36011;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;
    public static final int GL_MAX_COLOR_ATTACHMENTS = 36063;
    public static final int GL_COLOR_ATTACHMENT1 = 36065;
    public static final int GL_COLOR_ATTACHMENT2 = 36066;
    public static final int GL_COLOR_ATTACHMENT3 = 36067;
    public static final int GL_COLOR_ATTACHMENT4 = 36068;
    public static final int GL_COLOR_ATTACHMENT5 = 36069;
    public static final int GL_COLOR_ATTACHMENT6 = 36070;
    public static final int GL_COLOR_ATTACHMENT7 = 36071;
    public static final int GL_COLOR_ATTACHMENT8 = 36072;
    public static final int GL_COLOR_ATTACHMENT9 = 36073;
    public static final int GL_COLOR_ATTACHMENT10 = 36074;
    public static final int GL_COLOR_ATTACHMENT11 = 36075;
    public static final int GL_COLOR_ATTACHMENT12 = 36076;
    public static final int GL_COLOR_ATTACHMENT13 = 36077;
    public static final int GL_COLOR_ATTACHMENT14 = 36078;
    public static final int GL_COLOR_ATTACHMENT15 = 36079;
    public static final int GL_COLOR_ATTACHMENT16 = 36080;
    public static final int GL_COLOR_ATTACHMENT17 = 36081;
    public static final int GL_COLOR_ATTACHMENT18 = 36082;
    public static final int GL_COLOR_ATTACHMENT19 = 36083;
    public static final int GL_COLOR_ATTACHMENT20 = 36084;
    public static final int GL_COLOR_ATTACHMENT21 = 36085;
    public static final int GL_COLOR_ATTACHMENT22 = 36086;
    public static final int GL_COLOR_ATTACHMENT23 = 36087;
    public static final int GL_COLOR_ATTACHMENT24 = 36088;
    public static final int GL_COLOR_ATTACHMENT25 = 36089;
    public static final int GL_COLOR_ATTACHMENT26 = 36090;
    public static final int GL_COLOR_ATTACHMENT27 = 36091;
    public static final int GL_COLOR_ATTACHMENT28 = 36092;
    public static final int GL_COLOR_ATTACHMENT29 = 36093;
    public static final int GL_COLOR_ATTACHMENT30 = 36094;
    public static final int GL_COLOR_ATTACHMENT31 = 36095;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
    public static final int GL_MAX_SAMPLES = 36183;
    public static final int GL_HALF_FLOAT = 5131;
    public static final int GL_MAP_READ_BIT = 1;
    public static final int GL_MAP_WRITE_BIT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT = 32;
    public static final int GL_RG = 33319;
    public static final int GL_RG_INTEGER = 33320;
    public static final int GL_R8 = 33321;
    public static final int GL_RG8 = 33323;
    public static final int GL_R16F = 33325;
    public static final int GL_R32F = 33326;
    public static final int GL_RG16F = 33327;
    public static final int GL_RG32F = 33328;
    public static final int GL_R8I = 33329;
    public static final int GL_R8UI = 33330;
    public static final int GL_R16I = 33331;
    public static final int GL_R16UI = 33332;
    public static final int GL_R32I = 33333;
    public static final int GL_R32UI = 33334;
    public static final int GL_RG8I = 33335;
    public static final int GL_RG8UI = 33336;
    public static final int GL_RG16I = 33337;
    public static final int GL_RG16UI = 33338;
    public static final int GL_RG32I = 33339;
    public static final int GL_RG32UI = 33340;
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;
    public static final int GL_R8_SNORM = 36756;
    public static final int GL_RG8_SNORM = 36757;
    public static final int GL_RGB8_SNORM = 36758;
    public static final int GL_RGBA8_SNORM = 36759;
    public static final int GL_SIGNED_NORMALIZED = 36764;
    public static final int GL_PRIMITIVE_RESTART_FIXED_INDEX = 36201;
    public static final int GL_COPY_READ_BUFFER = 36662;
    public static final int GL_COPY_WRITE_BUFFER = 36663;
    public static final int GL_COPY_READ_BUFFER_BINDING = 36662;
    public static final int GL_COPY_WRITE_BUFFER_BINDING = 36663;
    public static final int GL_UNIFORM_BUFFER = 35345;
    public static final int GL_UNIFORM_BUFFER_BINDING = 35368;
    public static final int GL_UNIFORM_BUFFER_START = 35369;
    public static final int GL_UNIFORM_BUFFER_SIZE = 35370;
    public static final int GL_MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public static final int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public static final int GL_MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public static final int GL_MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public static final int GL_MAX_UNIFORM_BLOCK_SIZE = 35376;
    public static final int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public static final int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public static final int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public static final int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 35381;
    public static final int GL_ACTIVE_UNIFORM_BLOCKS = 35382;
    public static final int GL_UNIFORM_TYPE = 35383;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_UNIFORM_BLOCK_INDEX = 35386;
    public static final int GL_UNIFORM_OFFSET = 35387;
    public static final int GL_UNIFORM_ARRAY_STRIDE = 35388;
    public static final int GL_UNIFORM_MATRIX_STRIDE = 35389;
    public static final int GL_UNIFORM_IS_ROW_MAJOR = 35390;
    public static final int GL_UNIFORM_BLOCK_BINDING = 35391;
    public static final int GL_UNIFORM_BLOCK_DATA_SIZE = 35392;
    public static final int GL_UNIFORM_BLOCK_NAME_LENGTH = 35393;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public static final int GL_INVALID_INDEX = -1;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final int GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 35070;
    public static final int GL_ANY_SAMPLES_PASSED = 35887;
    public static final int GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 36202;
    public static final int GL_SAMPLER_BINDING = 35097;
    public static final int GL_RGB10_A2UI = 36975;
    public static final int GL_TEXTURE_SWIZZLE_R = 36418;
    public static final int GL_TEXTURE_SWIZZLE_G = 36419;
    public static final int GL_TEXTURE_SWIZZLE_B = 36420;
    public static final int GL_TEXTURE_SWIZZLE_A = 36421;
    public static final int GL_GREEN = 6404;
    public static final int GL_BLUE = 6405;
    public static final int GL_INT_2_10_10_10_REV = 36255;
    public static final int GL_TRANSFORM_FEEDBACK = 36386;
    public static final int GL_TRANSFORM_FEEDBACK_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BINDING = 36389;
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;
    public static final int GL_COMPRESSED_R11_EAC = 37488;
    public static final int GL_COMPRESSED_SIGNED_R11_EAC = 37489;
    public static final int GL_COMPRESSED_RG11_EAC = 37490;
    public static final int GL_COMPRESSED_SIGNED_RG11_EAC = 37491;
    public static final int GL_COMPRESSED_RGB8_ETC2 = 37492;
    public static final int GL_COMPRESSED_SRGB8_ETC2 = 37493;
    public static final int GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37494;
    public static final int GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37495;
    public static final int GL_COMPRESSED_RGBA8_ETC2_EAC = 37496;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 37497;
    public static final int GL_TEXTURE_IMMUTABLE_FORMAT = 37167;
    public static final int GL_MAX_ELEMENT_INDEX = 36203;
    public static final int GL_NUM_SAMPLE_COUNTS = 37760;
    public static final int GL_TEXTURE_IMMUTABLE_LEVELS = 33503;
    public static final long GL_TIMEOUT_IGNORED = -1L;

    protected GLES30() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glReadBuffer, caps.glDrawRangeElements, caps.glTexImage3D, caps.glTexSubImage3D, caps.glCopyTexSubImage3D, caps.glCompressedTexImage3D, caps.glCompressedTexSubImage3D, caps.glGenQueries, caps.glDeleteQueries, caps.glIsQuery, caps.glBeginQuery, caps.glEndQuery, caps.glGetQueryiv, caps.glGetQueryObjectuiv, caps.glUnmapBuffer, caps.glGetBufferPointerv, caps.glDrawBuffers, caps.glUniformMatrix2x3fv, caps.glUniformMatrix3x2fv, caps.glUniformMatrix2x4fv, caps.glUniformMatrix4x2fv, caps.glUniformMatrix3x4fv, caps.glUniformMatrix4x3fv, caps.glBlitFramebuffer, caps.glRenderbufferStorageMultisample, caps.glFramebufferTextureLayer, caps.glMapBufferRange, caps.glFlushMappedBufferRange, caps.glBindVertexArray, caps.glDeleteVertexArrays, caps.glGenVertexArrays, caps.glIsVertexArray, caps.glGetIntegeri_v, caps.glBeginTransformFeedback, caps.glEndTransformFeedback, caps.glBindBufferRange, caps.glBindBufferBase, caps.glTransformFeedbackVaryings, caps.glGetTransformFeedbackVarying, caps.glVertexAttribIPointer, caps.glGetVertexAttribIiv, caps.glGetVertexAttribIuiv, caps.glVertexAttribI4i, caps.glVertexAttribI4ui, caps.glVertexAttribI4iv, caps.glVertexAttribI4uiv, caps.glGetUniformuiv, caps.glGetFragDataLocation, caps.glUniform1ui, caps.glUniform2ui, caps.glUniform3ui, caps.glUniform4ui, caps.glUniform1uiv, caps.glUniform2uiv, caps.glUniform3uiv, caps.glUniform4uiv, caps.glClearBufferiv, caps.glClearBufferuiv, caps.glClearBufferfv, caps.glClearBufferfi, caps.glGetStringi, caps.glCopyBufferSubData, caps.glGetUniformIndices, caps.glGetActiveUniformsiv, caps.glGetUniformBlockIndex, caps.glGetActiveUniformBlockiv, caps.glGetActiveUniformBlockName, caps.glUniformBlockBinding, caps.glDrawArraysInstanced, caps.glDrawElementsInstanced, caps.glFenceSync, caps.glIsSync, caps.glDeleteSync, caps.glClientWaitSync, caps.glWaitSync, caps.glGetInteger64v, caps.glGetSynciv, caps.glGetInteger64i_v, caps.glGetBufferParameteri64v, caps.glGenSamplers, caps.glDeleteSamplers, caps.glIsSampler, caps.glBindSampler, caps.glSamplerParameteri, caps.glSamplerParameteriv, caps.glSamplerParameterf, caps.glSamplerParameterfv, caps.glGetSamplerParameteriv, caps.glGetSamplerParameterfv, caps.glVertexAttribDivisor, caps.glBindTransformFeedback, caps.glDeleteTransformFeedbacks, caps.glGenTransformFeedbacks, caps.glIsTransformFeedback, caps.glPauseTransformFeedback, caps.glResumeTransformFeedback, caps.glGetProgramBinary, caps.glProgramBinary, caps.glProgramParameteri, caps.glInvalidateFramebuffer, caps.glInvalidateSubFramebuffer, caps.glTexStorage2D, caps.glTexStorage3D, caps.glGetInternalformativ);
    }

    public static native void glReadBuffer(int var0);

    public static native void nglDrawRangeElements(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDrawRangeElements(int mode, int start, int end, int count, int type, long indices) {
        GLES30.nglDrawRangeElements(mode, start, end, count, type, indices);
    }

    public static void glDrawRangeElements(int mode, int start, int end, int type, ByteBuffer indices) {
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, ByteBuffer indices) {
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, ShortBuffer indices) {
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, IntBuffer indices) {
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices));
    }

    public static native void nglTexImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static native void nglTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static native void glCopyTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static native void nglCompressedTexImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        GLES30.nglCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        GLES30.nglCompressedTexImage3D(target, level, internalformat, width, height, depth, border, Checks.remainingSafe(data), MemoryUtil.memAddressSafe(data));
    }

    public static native void nglCompressedTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        GLES30.nglCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        GLES30.nglCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglGenQueries(int var0, long var1);

    public static void glGenQueries(IntBuffer ids) {
        GLES30.nglGenQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenQueries() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GLES30.nglGenQueries(1, MemoryUtil.memAddress(ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteQueries(int var0, long var1);

    public static void glDeleteQueries(IntBuffer ids) {
        GLES30.nglDeleteQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteQueries(int id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            GLES30.nglDeleteQueries(1, MemoryUtil.memAddress(ids));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsQuery(int var0);

    public static native void glBeginQuery(int var0, int var1);

    public static native void glEndQuery(int var0);

    public static native void nglGetQueryiv(int var0, int var1, long var2);

    public static void glGetQueryiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryi(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetQueryObjectuiv(int var0, int var1, long var2);

    public static void glGetQueryObjectuiv(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryObjectui(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glUnmapBuffer(int var0);

    public static native void nglGetBufferPointerv(int var0, int var1, long var2);

    public static void glGetBufferPointerv(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check(params, 1);
        }
        GLES30.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferPointer(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            GLES30.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDrawBuffers(int var0, long var1);

    public static void glDrawBuffers(IntBuffer bufs) {
        GLES30.nglDrawBuffers(bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDrawBuffers(int buf) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer bufs = stack.ints(buf);
            GLES30.nglDrawBuffers(1, MemoryUtil.memAddress(bufs));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglUniformMatrix2x3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2x3fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix2x3fv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3x2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3x2fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix3x2fv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix2x4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2x4fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix2x4fv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4x2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4x2fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix4x2fv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3x4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3x4fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix3x4fv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4x3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4x3fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix4x3fv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void glBlitFramebuffer(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static native void glRenderbufferStorageMultisample(int var0, int var1, int var2, int var3, int var4);

    public static native void glFramebufferTextureLayer(int var0, int var1, int var2, int var3, int var4);

    public static native long nglMapBufferRange(int var0, long var1, long var3, int var5);

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access) {
        long __result = GLES30.nglMapBufferRange(target, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = GLES30.nglMapBufferRange(target, offset, length, access);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)length);
    }

    public static native void glFlushMappedBufferRange(int var0, long var1, long var3);

    public static native void glBindVertexArray(int var0);

    public static native void nglDeleteVertexArrays(int var0, long var1);

    public static void glDeleteVertexArrays(IntBuffer arrays) {
        GLES30.nglDeleteVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteVertexArrays(int array) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.ints(array);
            GLES30.nglDeleteVertexArrays(1, MemoryUtil.memAddress(arrays));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenVertexArrays(int var0, long var1);

    public static void glGenVertexArrays(IntBuffer arrays) {
        GLES30.nglGenVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenVertexArrays() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.callocInt(1);
            GLES30.nglGenVertexArrays(1, MemoryUtil.memAddress(arrays));
            int n = arrays.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsVertexArray(int var0);

    public static native void nglGetIntegeri_v(int var0, int var1, long var2);

    public static void glGetIntegeri_v(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        GLES30.nglGetIntegeri_v(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetIntegeri(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GLES30.nglGetIntegeri_v(target, index, MemoryUtil.memAddress(data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glBeginTransformFeedback(int var0);

    public static native void glEndTransformFeedback();

    public static native void glBindBufferRange(int var0, int var1, int var2, long var3, long var5);

    public static native void glBindBufferBase(int var0, int var1, int var2);

    public static native void nglTransformFeedbackVaryings(int var0, int var1, long var2, int var4);

    public static void glTransformFeedbackVaryings(int program, PointerBuffer varyings, int bufferMode) {
        GLES30.nglTransformFeedbackVaryings(program, varyings.remaining(), MemoryUtil.memAddress(varyings), bufferMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTransformFeedbackVaryings(int program, CharSequence[] varyings, int bufferMode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long varyingsAddress = APIUtil.apiArray(stack, MemoryUtil::memASCII, varyings);
            GLES30.nglTransformFeedbackVaryings(program, varyings.length, varyingsAddress, bufferMode);
            APIUtil.apiArrayFree(varyingsAddress, varyings.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTransformFeedbackVaryings(int program, CharSequence varying, int bufferMode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long varyingsAddress = APIUtil.apiArray(stack, MemoryUtil::memASCII, varying);
            GLES30.nglTransformFeedbackVaryings(program, 1, varyingsAddress, bufferMode);
            APIUtil.apiArrayFree(varyingsAddress, 1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTransformFeedbackVarying(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetTransformFeedbackVarying(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
            Checks.check((Buffer)size, 1);
            Checks.check((Buffer)type, 1);
        }
        GLES30.nglGetTransformFeedbackVarying(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetTransformFeedbackVarying(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, 1);
            Checks.check((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES30.nglGetTransformFeedbackVarying(program, index, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetTransformFeedbackVarying(int program, int index, IntBuffer size, IntBuffer type) {
        return GLES30.glGetTransformFeedbackVarying(program, index, GLES20.glGetProgrami(program, 35958), size, type);
    }

    public static native void nglVertexAttribIPointer(int var0, int var1, int var2, int var3, long var4);

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        GLES30.nglVertexAttribIPointer(index, size, type, stride, pointer);
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ShortBuffer pointer) {
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, IntBuffer pointer) {
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static native void nglGetVertexAttribIiv(int var0, int var1, long var2);

    public static void glGetVertexAttribIiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetVertexAttribIiv(index, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexAttribIi(int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetVertexAttribIiv(index, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetVertexAttribIuiv(int var0, int var1, long var2);

    public static void glGetVertexAttribIuiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetVertexAttribIuiv(index, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexAttribIui(int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetVertexAttribIuiv(index, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glVertexAttribI4i(int var0, int var1, int var2, int var3, int var4);

    public static native void glVertexAttribI4ui(int var0, int var1, int var2, int var3, int var4);

    public static native void nglVertexAttribI4iv(int var0, long var1);

    public static void glVertexAttribI4iv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        GLES30.nglVertexAttribI4iv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribI4uiv(int var0, long var1);

    public static void glVertexAttribI4uiv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        GLES30.nglVertexAttribI4uiv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglGetUniformuiv(int var0, int var1, long var2);

    public static void glGetUniformuiv(int program, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetUniformuiv(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformui(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetUniformuiv(program, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetFragDataLocation(int var0, long var1);

    public static int glGetFragDataLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES30.nglGetFragDataLocation(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFragDataLocation(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GLES30.nglGetFragDataLocation(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glUniform1ui(int var0, int var1);

    public static native void glUniform2ui(int var0, int var1, int var2);

    public static native void glUniform3ui(int var0, int var1, int var2, int var3);

    public static native void glUniform4ui(int var0, int var1, int var2, int var3, int var4);

    public static native void nglUniform1uiv(int var0, int var1, long var2);

    public static void glUniform1uiv(int location, IntBuffer value) {
        GLES30.nglUniform1uiv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglUniform2uiv(int var0, int var1, long var2);

    public static void glUniform2uiv(int location, IntBuffer value) {
        GLES30.nglUniform2uiv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform3uiv(int var0, int var1, long var2);

    public static void glUniform3uiv(int location, IntBuffer value) {
        GLES30.nglUniform3uiv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform4uiv(int var0, int var1, long var2);

    public static void glUniform4uiv(int location, IntBuffer value) {
        GLES30.nglUniform4uiv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglClearBufferiv(int var0, int var1, long var2);

    public static void glClearBufferiv(int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        GLES30.nglClearBufferiv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static native void nglClearBufferuiv(int var0, int var1, long var2);

    public static void glClearBufferuiv(int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        GLES30.nglClearBufferuiv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static native void nglClearBufferfv(int var0, int var1, long var2);

    public static void glClearBufferfv(int buffer, int drawbuffer, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        GLES30.nglClearBufferfv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static native void glClearBufferfi(int var0, int var1, float var2, int var3);

    public static native long nglGetStringi(int var0, int var1);

    public static String glGetStringi(int name, int index) {
        long __result = GLES30.nglGetStringi(name, index);
        return MemoryUtil.memUTF8(__result);
    }

    public static native void glCopyBufferSubData(int var0, int var1, long var2, long var4, long var6);

    public static native void nglGetUniformIndices(int var0, int var1, long var2, long var4);

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)uniformIndices, uniformNames.remaining());
        }
        GLES30.nglGetUniformIndices(program, uniformNames.remaining(), MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    public static native void nglGetActiveUniformsiv(int var0, int var1, long var2, int var4, long var5);

    public static void glGetActiveUniformsiv(int program, IntBuffer uniformIndices, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, uniformIndices.remaining());
        }
        GLES30.nglGetActiveUniformsiv(program, uniformIndices.remaining(), MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    public static native int nglGetUniformBlockIndex(int var0, long var1);

    public static int glGetUniformBlockIndex(int program, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(uniformBlockName);
        }
        return GLES30.nglGetUniformBlockIndex(program, MemoryUtil.memAddress(uniformBlockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer uniformBlockNameEncoded = stack.ASCII(uniformBlockName);
            int n = GLES30.nglGetUniformBlockIndex(program, MemoryUtil.memAddress(uniformBlockNameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveUniformBlockiv(int var0, int var1, int var2, long var3);

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetActiveUniformBlocki(int program, int uniformBlockIndex, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveUniformBlockName(int var0, int var1, int var2, long var3, long var5);

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, IntBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, uniformBlockName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformBlockName = stack.malloc(bufSize);
            GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(uniformBlockName));
            String string = MemoryUtil.memASCII(uniformBlockName, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        return GLES30.glGetActiveUniformBlockName(program, uniformBlockIndex, GLES30.glGetActiveUniformBlocki(program, uniformBlockIndex, 35393));
    }

    public static native void glUniformBlockBinding(int var0, int var1, int var2);

    public static native void glDrawArraysInstanced(int var0, int var1, int var2, int var3);

    public static native void nglDrawElementsInstanced(int var0, int var1, int var2, long var3, int var5);

    public static void glDrawElementsInstanced(int mode, int count, int type, long indices, int instancecount) {
        GLES30.nglDrawElementsInstanced(mode, count, type, indices, instancecount);
    }

    public static void glDrawElementsInstanced(int mode, int type, ByteBuffer indices, int instancecount) {
        GLES30.nglDrawElementsInstanced(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount);
    }

    public static void glDrawElementsInstanced(int mode, ByteBuffer indices, int instancecount) {
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount);
    }

    public static void glDrawElementsInstanced(int mode, ShortBuffer indices, int instancecount) {
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount);
    }

    public static void glDrawElementsInstanced(int mode, IntBuffer indices, int instancecount) {
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount);
    }

    public static native long glFenceSync(int var0, int var1);

    public static native boolean nglIsSync(long var0);

    public static boolean glIsSync(long sync) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        return GLES30.nglIsSync(sync);
    }

    public static native void nglDeleteSync(long var0);

    public static void glDeleteSync(long sync) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        GLES30.nglDeleteSync(sync);
    }

    public static native int nglClientWaitSync(long var0, int var2, long var3);

    public static int glClientWaitSync(long sync, int flags, long timeout) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        return GLES30.nglClientWaitSync(sync, flags, timeout);
    }

    public static native void nglWaitSync(long var0, int var2, long var3);

    public static void glWaitSync(long sync, int flags, long timeout) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        GLES30.nglWaitSync(sync, flags, timeout);
    }

    public static native void nglGetInteger64v(int var0, long var1);

    public static void glGetInteger64v(int pname, LongBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        GLES30.nglGetInteger64v(pname, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer data = stack.callocLong(1);
            GLES30.nglGetInteger64v(pname, MemoryUtil.memAddress(data));
            long l = data.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6);

    public static void glGetSynciv(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.check(sync);
            Checks.checkSafe((Buffer)length, 1);
        }
        GLES30.nglGetSynciv(sync, pname, values.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSynci(long sync, int pname, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.check(sync);
            Checks.checkSafe((Buffer)length, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            GLES30.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetInteger64i_v(int var0, int var1, long var2);

    public static void glGetInteger64i_v(int target, int index, LongBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        GLES30.nglGetInteger64i_v(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64i(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer data = stack.callocLong(1);
            GLES30.nglGetInteger64i_v(target, index, MemoryUtil.memAddress(data));
            long l = data.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetBufferParameteri64v(int var0, int var1, long var2);

    public static void glGetBufferParameteri64v(int target, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferParameteri64(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GLES30.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenSamplers(int var0, long var1);

    public static void glGenSamplers(IntBuffer samplers) {
        GLES30.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenSamplers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.callocInt(1);
            GLES30.nglGenSamplers(1, MemoryUtil.memAddress(samplers));
            int n = samplers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteSamplers(int var0, long var1);

    public static void glDeleteSamplers(IntBuffer samplers) {
        GLES30.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteSamplers(int sampler) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.ints(sampler);
            GLES30.nglDeleteSamplers(1, MemoryUtil.memAddress(samplers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsSampler(int var0);

    public static native void glBindSampler(int var0, int var1);

    public static native void glSamplerParameteri(int var0, int var1, int var2);

    public static native void nglSamplerParameteriv(int var0, int var1, long var2);

    public static void glSamplerParameteriv(int sampler, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, 1);
        }
        GLES30.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(param));
    }

    public static native void glSamplerParameterf(int var0, int var1, float var2);

    public static native void nglSamplerParameterfv(int var0, int var1, long var2);

    public static void glSamplerParameterfv(int sampler, int pname, FloatBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, 1);
        }
        GLES30.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(param));
    }

    public static native void nglGetSamplerParameteriv(int var0, int var1, long var2);

    public static void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameteri(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterfv(int var0, int var1, long var2);

    public static void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GLES30.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetSamplerParameterf(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES30.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glVertexAttribDivisor(int var0, int var1);

    public static native void glBindTransformFeedback(int var0, int var1);

    public static native void nglDeleteTransformFeedbacks(int var0, long var1);

    public static void glDeleteTransformFeedbacks(IntBuffer ids) {
        GLES30.nglDeleteTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTransformFeedbacks(int id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            GLES30.nglDeleteTransformFeedbacks(1, MemoryUtil.memAddress(ids));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenTransformFeedbacks(int var0, long var1);

    public static void glGenTransformFeedbacks(IntBuffer ids) {
        GLES30.nglGenTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenTransformFeedbacks() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GLES30.nglGenTransformFeedbacks(1, MemoryUtil.memAddress(ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean glIsTransformFeedback(int var0);

    public static native void glPauseTransformFeedback();

    public static native void glResumeTransformFeedback();

    public static native void nglGetProgramBinary(int var0, int var1, long var2, long var4, long var6);

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
            Checks.check((Buffer)binaryFormat, 1);
        }
        GLES30.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static native void nglProgramBinary(int var0, int var1, long var2, int var4);

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        GLES30.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static native void glProgramParameteri(int var0, int var1, int var2);

    public static native void nglInvalidateFramebuffer(int var0, int var1, long var2);

    public static void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        GLES30.nglInvalidateFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glInvalidateFramebuffer(int target, int attachment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer attachments = stack.ints(attachment);
            GLES30.nglInvalidateFramebuffer(target, 1, MemoryUtil.memAddress(attachments));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglInvalidateSubFramebuffer(int var0, int var1, long var2, int var4, int var5, int var6, int var7);

    public static void glInvalidateSubFramebuffer(int target, IntBuffer attachments, int x, int y, int width, int height) {
        GLES30.nglInvalidateSubFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glInvalidateSubFramebuffer(int target, int attachment, int x, int y, int width, int height) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer attachments = stack.ints(attachment);
            GLES30.nglInvalidateSubFramebuffer(target, 1, MemoryUtil.memAddress(attachments), x, y, width, height);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glTexStorage2D(int var0, int var1, int var2, int var3, int var4);

    public static native void glTexStorage3D(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void nglGetInternalformativ(int var0, int var1, int var2, int var3, long var4);

    public static void glGetInternalformativ(int target, int internalformat, int pname, IntBuffer params) {
        GLES30.nglGetInternalformativ(target, internalformat, pname, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetInternalformati(int target, int internalformat, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES30.nglGetInternalformativ(target, internalformat, pname, 1, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glGenQueries(int[] ids) {
        long __functionAddress = GLES.getICD().glGenQueries;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glDeleteQueries(int[] ids) {
        long __functionAddress = GLES.getICD().glDeleteQueries;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGetQueryiv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetQueryiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetQueryObjectuiv(int id, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetQueryObjectuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glDrawBuffers(int[] bufs) {
        long __functionAddress = GLES.getICD().glDrawBuffers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, bufs.length, bufs);
    }

    public static void glUniformMatrix2x3fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix2x3fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 6, transpose, value);
    }

    public static void glUniformMatrix3x2fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix3x2fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 6, transpose, value);
    }

    public static void glUniformMatrix2x4fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix2x4fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 3, transpose, value);
    }

    public static void glUniformMatrix4x2fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix4x2fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 3, transpose, value);
    }

    public static void glUniformMatrix3x4fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix3x4fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 12, transpose, value);
    }

    public static void glUniformMatrix4x3fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix4x3fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 12, transpose, value);
    }

    public static void glDeleteVertexArrays(int[] arrays) {
        long __functionAddress = GLES.getICD().glDeleteVertexArrays;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, arrays.length, arrays);
    }

    public static void glGenVertexArrays(int[] arrays) {
        long __functionAddress = GLES.getICD().glGenVertexArrays;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, arrays.length, arrays);
    }

    public static void glGetIntegeri_v(int target, int index, int[] data) {
        long __functionAddress = GLES.getICD().glGetIntegeri_v;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    public static void glGetTransformFeedbackVarying(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GLES.getICD().glGetTransformFeedbackVarying;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
            Checks.check(size, 1);
            Checks.check(type, 1);
        }
        JNI.callPPPPV(__functionAddress, program, index, name.remaining(), length, size, type, MemoryUtil.memAddress(name));
    }

    public static void glGetVertexAttribIiv(int index, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetVertexAttribIiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribIuiv(int index, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetVertexAttribIuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glVertexAttribI4iv(int index, int[] v) {
        long __functionAddress = GLES.getICD().glVertexAttribI4iv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttribI4uiv(int index, int[] v) {
        long __functionAddress = GLES.getICD().glVertexAttribI4uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glGetUniformuiv(int program, int location, int[] params) {
        long __functionAddress = GLES.getICD().glGetUniformuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glUniform1uiv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform1uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2uiv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform2uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3uiv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform3uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4uiv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform4uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glClearBufferiv(int buffer, int drawbuffer, int[] value) {
        long __functionAddress = GLES.getICD().glClearBufferiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(value, 1);
        }
        JNI.callPV(__functionAddress, buffer, drawbuffer, value);
    }

    public static void glClearBufferuiv(int buffer, int drawbuffer, int[] value) {
        long __functionAddress = GLES.getICD().glClearBufferuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(value, 1);
        }
        JNI.callPV(__functionAddress, buffer, drawbuffer, value);
    }

    public static void glClearBufferfv(int buffer, int drawbuffer, float[] value) {
        long __functionAddress = GLES.getICD().glClearBufferfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(value, 1);
        }
        JNI.callPV(__functionAddress, buffer, drawbuffer, value);
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, int[] uniformIndices) {
        long __functionAddress = GLES.getICD().glGetUniformIndices;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(uniformIndices, uniformNames.remaining());
        }
        JNI.callPPV(__functionAddress, program, uniformNames.remaining(), MemoryUtil.memAddress(uniformNames), uniformIndices);
    }

    public static void glGetActiveUniformsiv(int program, int[] uniformIndices, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetActiveUniformsiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, uniformIndices.length);
        }
        JNI.callPPV(__functionAddress, program, uniformIndices.length, uniformIndices, pname, params);
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetActiveUniformBlockiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, program, uniformBlockIndex, pname, params);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int[] length, ByteBuffer uniformBlockName) {
        long __functionAddress = GLES.getICD().glGetActiveUniformBlockName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, uniformBlockIndex, uniformBlockName.remaining(), length, MemoryUtil.memAddress(uniformBlockName));
    }

    public static void glGetInteger64v(int pname, long[] data) {
        long __functionAddress = GLES.getICD().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(__functionAddress, pname, data);
    }

    public static void glGetSynciv(long sync, int pname, int[] length, int[] values) {
        long __functionAddress = GLES.getICD().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPPV(__functionAddress, sync, pname, values.length, length, values);
    }

    public static void glGetInteger64i_v(int target, int index, long[] data) {
        long __functionAddress = GLES.getICD().glGetInteger64i_v;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    public static void glGetBufferParameteri64v(int target, int pname, long[] params) {
        long __functionAddress = GLES.getICD().glGetBufferParameteri64v;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGenSamplers(int[] samplers) {
        long __functionAddress = GLES.getICD().glGenSamplers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glDeleteSamplers(int[] samplers) {
        long __functionAddress = GLES.getICD().glDeleteSamplers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glSamplerParameteriv(int sampler, int pname, int[] param) {
        long __functionAddress = GLES.getICD().glSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(param, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, param);
    }

    public static void glSamplerParameterfv(int sampler, int pname, float[] param) {
        long __functionAddress = GLES.getICD().glSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(param, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, param);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, float[] params) {
        long __functionAddress = GLES.getICD().glGetSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glDeleteTransformFeedbacks(int[] ids) {
        long __functionAddress = GLES.getICD().glDeleteTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGenTransformFeedbacks(int[] ids) {
        long __functionAddress = GLES.getICD().glGenTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGetProgramBinary(int program, int[] length, int[] binaryFormat, ByteBuffer binary) {
        long __functionAddress = GLES.getICD().glGetProgramBinary;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
            Checks.check(binaryFormat, 1);
        }
        JNI.callPPPV(__functionAddress, program, binary.remaining(), length, binaryFormat, MemoryUtil.memAddress(binary));
    }

    public static void glInvalidateFramebuffer(int target, int[] attachments) {
        long __functionAddress = GLES.getICD().glInvalidateFramebuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, attachments.length, attachments);
    }

    public static void glInvalidateSubFramebuffer(int target, int[] attachments, int x, int y, int width, int height) {
        long __functionAddress = GLES.getICD().glInvalidateSubFramebuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, attachments.length, attachments, x, y, width, height);
    }

    public static void glGetInternalformativ(int target, int internalformat, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetInternalformativ;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, internalformat, pname, params.length, params);
    }

    static {
        GLES.initialize();
    }
}

