/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHRRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_KHR = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_KHR = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_KHR = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS_KHR = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_KHR = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_KHR = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_KHR = 33377;
    public static final int GL_CONTEXT_LOST_KHR = 1287;

    protected KHRRobustness() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetGraphicsResetStatusKHR, caps.glReadnPixelsKHR, caps.glGetnUniformfvKHR, caps.glGetnUniformivKHR, caps.glGetnUniformuivKHR);
    }

    public static native int glGetGraphicsResetStatusKHR();

    public static native void nglReadnPixelsKHR(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static native void nglGetnUniformfvKHR(int var0, int var1, int var2, long var3);

    public static void glGetnUniformfvKHR(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformfvKHR(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformfKHR(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformfvKHR(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformivKHR(int var0, int var1, int var2, long var3);

    public static void glGetnUniformivKHR(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformivKHR(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformiKHR(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformivKHR(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformuivKHR(int var0, int var1, int var2, long var3);

    public static void glGetnUniformuivKHR(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformuivKHR(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformuiKHR(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformuivKHR(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getICD().glReadnPixelsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels.length << 1, pixels);
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getICD().glReadnPixelsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels.length << 2, pixels);
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getICD().glReadnPixelsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels.length << 2, pixels);
    }

    public static void glGetnUniformfvKHR(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformfvKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformivKHR(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformivKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformuivKHR(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformuivKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    static {
        GLES.initialize();
    }
}

