/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVViewportArray {
    public static final int GL_MAX_VIEWPORTS_NV = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_NV = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_NV = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 33375;

    protected NVViewportArray() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glViewportArrayvNV, caps.glViewportIndexedfNV, caps.glViewportIndexedfvNV, caps.glScissorArrayvNV, caps.glScissorIndexedNV, caps.glScissorIndexedvNV, caps.glDepthRangeArrayfvNV, caps.glDepthRangeIndexedfNV, caps.glGetFloati_vNV, caps.glEnableiNV, caps.glDisableiNV, caps.glIsEnablediNV);
    }

    public static native void nglViewportArrayvNV(int var0, int var1, long var2);

    public static void glViewportArrayvNV(int first, FloatBuffer v) {
        NVViewportArray.nglViewportArrayvNV(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glViewportIndexedfNV(int var0, float var1, float var2, float var3, float var4);

    public static native void nglViewportIndexedfvNV(int var0, long var1);

    public static void glViewportIndexedfvNV(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        NVViewportArray.nglViewportIndexedfvNV(index, MemoryUtil.memAddress(v));
    }

    public static native void nglScissorArrayvNV(int var0, int var1, long var2);

    public static void glScissorArrayvNV(int first, IntBuffer v) {
        NVViewportArray.nglScissorArrayvNV(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glScissorIndexedNV(int var0, int var1, int var2, int var3, int var4);

    public static native void nglScissorIndexedvNV(int var0, long var1);

    public static void glScissorIndexedvNV(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        NVViewportArray.nglScissorIndexedvNV(index, MemoryUtil.memAddress(v));
    }

    public static native void nglDepthRangeArrayfvNV(int var0, int var1, long var2);

    public static void glDepthRangeArrayfvNV(int first, FloatBuffer v) {
        NVViewportArray.nglDepthRangeArrayfvNV(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void glDepthRangeIndexedfNV(int var0, float var1, float var2);

    public static native void nglGetFloati_vNV(int var0, int var1, long var2);

    public static void glGetFloati_vNV(int target, int index, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloatiNV(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glEnableiNV(int var0, int var1);

    public static native void glDisableiNV(int var0, int var1);

    public static native boolean glIsEnablediNV(int var0, int var1);

    public static void glViewportArrayvNV(int first, float[] v) {
        long __functionAddress = GLES.getICD().glViewportArrayvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 2, v);
    }

    public static void glViewportIndexedfvNV(int index, float[] v) {
        long __functionAddress = GLES.getICD().glViewportIndexedfvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glScissorArrayvNV(int first, int[] v) {
        long __functionAddress = GLES.getICD().glScissorArrayvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 2, v);
    }

    public static void glScissorIndexedvNV(int index, int[] v) {
        long __functionAddress = GLES.getICD().glScissorIndexedvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glDepthRangeArrayfvNV(int first, float[] v) {
        long __functionAddress = GLES.getICD().glDepthRangeArrayfvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 1, v);
    }

    public static void glGetFloati_vNV(int target, int index, float[] data) {
        long __functionAddress = GLES.getICD().glGetFloati_vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    static {
        GLES.initialize();
    }
}

